/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.onlineboard.view;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.AbstractDeviceInfoManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.TextFieldFilter;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceview.devicetable.devicesearch.DeviceSearchModel;
import com.huawei.dc.onlineboard.view.OnlineBoardUpgradeFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.AbstractDocument;

public class DeviceSearchAddDialog
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private Container mContentPane;
    private JLabel mSearchModesLabel;
    private JLabel mSearchTextLabel;
    private TextFieldFilter mSearchTextFilter;
    private JComboBox mSearchModesDropDown;
    private JTextField mSearchTextField;
    private JCheckBox mMatchWholeWordCheckBox;
    private JCheckBox mMatchCaseCheckBox;
    private JButton mFindBtn;
    private JButton mAddBtn;
    private JScrollPane mScrollPane;
    private JTable mDeviceInfoTable;
    private DefaultTableModel mDeviceInfoTableModel;
    private DefaultComboBoxModel mSearchModesModel;
    private ResourceManager mResManager = ResourceManager.getInstance();
    private static final int ONLINE_BOARD_DEVICE_ID_COLUMN = 0;
    private static final int ONLINE_RES_NAME_COLUMN = 1;
    private static final int ONLINE_BOARD_DEVICE_IP_COLUMN = 2;
    private static final int ONLINE_BOARD_DEVICE_TYPE_COLUMN = 3;
    private static final int ONLINE_BOARD_DEVICE_VERSION_COLUMN = 4;
    private static final int UPGRADE_STATUS_COLUMN = 5;
    private Vector mRowData;
    private Vector mAccessRowData;
    private static final int FIND_BY_IP = 1;
    private static final int FIND_BY_NAME = 0;

    public DeviceSearchAddDialog(DCModalDialog parent, DeviceSearchModel oModel) {
        super(parent);
        this.initializeDialog();
        this.initializeContentPane();
        this.createLabels();
        this.createFields();
        this.createTable();
        this.createButtons();
        this.initializeDropdowns(oModel);
        this.initializeKeyEventForEnterBtn();
        this.requestFocusToSearchString();
    }

    public int validateSearchString() {
        String strSearchString = this.mSearchTextField.getText();
        if (null == strSearchString || 0 == strSearchString.length()) {
            return 83;
        }
        return 80;
    }

    protected void showWarningMessageFor(String strErrorMessage) {
        ResourceManager oResManager = ResourceManager.getInstance();
        DCOptionPane.showMessageDialog((Component)((Object)this), oResManager.getResString(strErrorMessage), oResManager.getResString("WARNING"), 2);
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_VIEW_DEVICE_INFORMATION";
    }

    private void setFocusToSearchStringField() {
        this.mSearchTextField.requestFocus();
    }

    private void initializeDialog() {
        this.setSize(700, 500);
        this.setTitle(this.mResManager.getResString("SEARCH_NE_BUTTON_DLG_TIT"));
    }

    private void initializeContentPane() {
        this.mContentPane = this.getContentPane();
        this.mContentPane.setLayout(null);
    }

    private void createLabels() {
        this.initializeLabels();
        this.addLabelsToPane();
        this.alignLabels();
    }

    private void initializeLabels() {
        this.mSearchModesLabel = new JLabel(this.mResManager.getResString("SEARCH_DEVICE_MODE_LABEL"));
        this.mSearchTextLabel = new JLabel(this.mResManager.getResString("SEARCH_DEVICE_SEARCH_TEXT_LABEL"));
    }

    private void alignLabels() {
        this.mSearchModesLabel.setBounds(12, 14, 80, 20);
        this.mSearchTextLabel.setBounds(300, 14, 80, 20);
    }

    private void addLabelsToPane() {
        this.mContentPane.add(this.mSearchModesLabel);
        this.mContentPane.add(this.mSearchTextLabel);
    }

    private void createFields() {
        this.initializeFields();
        this.addFieldsToPane();
        this.alignFields();
    }

    private void initializeFields() {
        this.mSearchModesDropDown = new JComboBox();
        this.mSearchModesDropDown.setName("DeviceView_DeviceSearchDialog_m_oSearchModesDropDown");
        this.mSearchModesDropDown.addItemListener(this.generateItemListenerForMode());
        this.mSearchTextField = new JTextField();
        this.mSearchTextField.setName("DeviceView_DeviceSearchDialog_m_oSearchTextField");
        AbstractDocument ao = (AbstractDocument)this.mSearchTextField.getDocument();
        this.mSearchTextFilter = new TextFieldFilter(64);
        ao.setDocumentFilter(this.mSearchTextFilter);
        this.mMatchWholeWordCheckBox = new JCheckBox(this.mResManager.getResString("SEARCH_DEVICE_MATCH_WHOLE_WORD_ONLY"));
        this.mMatchWholeWordCheckBox.setName("DeviceView_DeviceSearchDialog_m_oMatchWholeWordCheckBox");
        this.mMatchWholeWordCheckBox.setFocusable(false);
        this.mMatchCaseCheckBox = new JCheckBox(this.mResManager.getResString("SEARCH_DEVICE_MATCH_CASE"));
        this.mMatchCaseCheckBox.setName("DeviceView_DeviceSearchDialog_m_oMatchCaseCheckBox");
        this.mMatchCaseCheckBox.setFocusable(false);
    }

    private ItemListener generateItemListenerForMode() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DeviceSearchAddDialog.this.searchModeChanged();
            }
        };
    }

    private void searchModeChanged() {
        if (1 == this.mSearchModesDropDown.getSelectedIndex()) {
            this.setFieldsForIPSearch();
        } else if (0 == this.mSearchModesDropDown.getSelectedIndex()) {
            this.setFieldsForNameSearch();
        }
    }

    private void setFieldsForNameSearch() {
        this.mSearchTextField.setText("");
        this.mMatchWholeWordCheckBox.setEnabled(true);
        this.mMatchCaseCheckBox.setEnabled(true);
        this.mSearchTextFilter.setMaxSize(64);
    }

    private void setFieldsForIPSearch() {
        this.mSearchTextField.setText("");
        this.mMatchWholeWordCheckBox.setSelected(false);
        this.mMatchWholeWordCheckBox.setEnabled(false);
        this.mMatchCaseCheckBox.setSelected(false);
        this.mMatchCaseCheckBox.setEnabled(false);
        this.mSearchTextFilter.setMaxSize(15);
    }

    private void addFieldsToPane() {
        this.mContentPane.add(this.mSearchModesDropDown);
        this.mContentPane.add(this.mSearchTextField);
        this.mContentPane.add(this.mMatchWholeWordCheckBox);
        this.mContentPane.add(this.mMatchCaseCheckBox);
    }

    private void alignFields() {
        this.mSearchModesDropDown.setBounds(110, 14, 170, 22);
        this.mSearchTextField.setBounds(390, 14, 170, 22);
        this.mMatchWholeWordCheckBox.setBounds(12, 48, 160, 20);
        this.mMatchCaseCheckBox.setBounds(192, 48, 120, 20);
    }

    private void createButtons() {
        this.initializeButtons();
        this.addButtonsToPane();
        this.alignButtons();
    }

    private void createTable() {
        ResourceManager oResManager = ResourceManager.getInstance();
        Object[] strColumns = new String[]{"NE_ID", oResManager.getResString("DEVICE_TABLE_HEADER_RESOURCE_NAME"), oResManager.getResString("ONLINE_BOARD_DEVICE_IP"), oResManager.getResString("ONLINE_BOARD_DEVICE_TYPE"), oResManager.getResString("ONLINE_BOARD_DEVICE_VERSION")};
        this.mDeviceInfoTableModel = new DefaultTableModel(strColumns, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.mDeviceInfoTable = new JTable(this.mDeviceInfoTableModel);
        this.mDeviceInfoTable.setName("OnlineBoard_OnlineBoardUpgradeFrame_m_oOnlineBoardInfoTable");
        this.mDeviceInfoTable.getTableHeader().setReorderingAllowed(false);
        this.mDeviceInfoTable.setRowSelectionAllowed(true);
        this.mDeviceInfoTable.setRowHeight(21);
        this.mDeviceInfoTable.getColumnModel().getColumn(1).setMinWidth(80);
        this.mDeviceInfoTable.getColumnModel().getColumn(2).setMinWidth(80);
        this.mDeviceInfoTable.getColumnModel().getColumn(3).setMinWidth(80);
        this.mDeviceInfoTable.getColumnModel().getColumn(4).setMinWidth(80);
        this.mDeviceInfoTable.getColumnModel().getColumn(0).setMaxWidth(0);
        this.mDeviceInfoTable.getColumnModel().getColumn(0).setMinWidth(0);
        this.mDeviceInfoTable.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.mScrollPane = new JScrollPane();
        this.mScrollPane.getViewport().add(this.mDeviceInfoTable);
        this.mContentPane.add(this.mScrollPane);
        this.mScrollPane.setBounds(12, 70, 680, 345);
    }

    private void initializeButtons() {
        this.mFindBtn = new JButton(this.mResManager.getResString("SEARCH_DEVICE_ONLINEBOARD_DIALOG_SEARCH_BUTTON"));
        this.mFindBtn.setText(this.mResManager.getResString("SEARCH_DEVICE_ONLINEBOARD_DIALOG_SEARCH_BUTTON"));
        this.mFindBtn.setName("DeviceView_DeviceSearchAddDialog_m_oFindBtn");
        this.mFindBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceSearchAddDialog.this.performSearch();
            }
        });
        this.m_oCancelBtn.setText(this.mResManager.getResString("CLOSE"));
        this.m_oCancelBtn.setName("OnlineUpgrade_DeviceSearchAddDialog_m_oCloseBtn");
        this.mAddBtn = new JButton(this.mResManager.getResString("ADDDEVICEBUTTON"));
        this.mAddBtn.setText(this.mResManager.getResString("ADDDEVICEBUTTON"));
        this.mAddBtn.setName("OnlineUpgrade_DeviceSearchAddDialog_m_oAddBtn");
        this.mAddBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceSearchAddDialog.this.addDeviceToAccessOnlineBoard();
            }
        });
    }

    private void addButtonsToPane() {
        this.mContentPane.add(this.mFindBtn);
        this.mContentPane.add(this.m_oCancelBtn);
        this.mContentPane.add(this.mAddBtn);
    }

    private void alignButtons() {
        this.mFindBtn.setBounds(580, 14, 80, 22);
        this.mAddBtn.setBounds(480, 425, 80, 22);
        this.m_oCancelBtn.setBounds(580, 425, 80, 22);
    }

    private void initializeDropdowns(DeviceSearchModel oModel) {
        this.populateSearchModesFromModel(oModel);
        this.repaint();
    }

    private void populateSearchModesFromModel(DeviceSearchModel oModel) {
        Vector oDSearchMode = oModel.getSearchModeList();
        this.mSearchModesModel = new DefaultComboBoxModel(oDSearchMode);
        this.mSearchModesDropDown.setModel(this.mSearchModesModel);
    }

    private void performSearch() {
        this.mDeviceInfoTableModel.getDataVector().clear();
        int iStatusCode = this.validateSearchString();
        if (80 != iStatusCode) {
            return;
        }
        AbstractDeviceInfoManager oDeviceInfoMgr = (AbstractDeviceInfoManager)DeviceInfoManagerImpl.getInstance();
        if (this.mSearchModesDropDown.getSelectedIndex() == 1) {
            DeviceInfo deviceInfo = oDeviceInfoMgr.getDeviceByIP(this.mSearchTextField.getText().trim());
            if (deviceInfo == null || !deviceInfo.getDeviceTypeInfo().isBMSDomain()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DeviceSearchAddDialog.this.mDeviceInfoTable.updateUI();
                    }
                });
                return;
            }
            this.addDataToTableModel(deviceInfo);
        }
        if (this.mSearchModesDropDown.getSelectedIndex() == 0) {
            DeviceInfo[] deviceInfoArray = oDeviceInfoMgr.getDevices();
            if (this.mMatchWholeWordCheckBox.isSelected() && this.mMatchCaseCheckBox.isSelected()) {
                for (DeviceInfo deviceInfo : deviceInfoArray) {
                    if (!deviceInfo.getDevName().equals(this.mSearchTextField.getText().trim())) continue;
                    this.addDataToTableModel(deviceInfo);
                }
            } else if (!this.mMatchWholeWordCheckBox.isSelected() && this.mMatchCaseCheckBox.isSelected()) {
                for (DeviceInfo deviceInfo : deviceInfoArray) {
                    if (!deviceInfo.getDevName().contains(this.mSearchTextField.getText().trim())) continue;
                    this.addDataToTableModel(deviceInfo);
                }
            } else if (this.mMatchWholeWordCheckBox.isSelected() && !this.mMatchCaseCheckBox.isSelected()) {
                for (DeviceInfo deviceInfo : deviceInfoArray) {
                    if (!deviceInfo.getDevName().toUpperCase().equals(this.mSearchTextField.getText().trim().toUpperCase())) continue;
                    this.addDataToTableModel(deviceInfo);
                }
            } else if (!this.mMatchWholeWordCheckBox.isSelected() && !this.mMatchCaseCheckBox.isSelected()) {
                for (DeviceInfo deviceInfo : deviceInfoArray) {
                    if (!deviceInfo.getDevName().toUpperCase().contains(this.mSearchTextField.getText().trim().toUpperCase())) continue;
                    this.addDataToTableModel(deviceInfo);
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeviceSearchAddDialog.this.mDeviceInfoTable.updateUI();
            }
        });
    }

    private void addDataToTableModel(DeviceInfo deviceInfo) {
        this.mRowData = new Vector(0);
        this.mRowData.add(deviceInfo.getDevId());
        this.mRowData.add(deviceInfo.getDevName());
        this.mRowData.add(deviceInfo.getDevIPAddress());
        this.mRowData.add(deviceInfo.getDeviceTypeInfo());
        this.mRowData.add(deviceInfo.getDevVersion().getDevVersion());
        this.mDeviceInfoTableModel.addRow(this.mRowData);
    }

    private void addDeviceToAccessOnlineBoard() {
        AbstractDeviceInfoManager oDeviceInfoMgr = (AbstractDeviceInfoManager)DeviceInfoManagerImpl.getInstance();
        JTable onlineAccessBoardInfoTable = OnlineBoardUpgradeFrame.getOnlineBoardUpgradeFrame().getAccessInfoTable();
        DefaultTableModel onlineAccessBoardInfoTableModel = OnlineBoardUpgradeFrame.getOnlineBoardUpgradeFrame().getM_oOnlineAccessBoardInfoTableModel();
        int[] arrSelectedRows = this.mDeviceInfoTable.getSelectedRows();
        int iDevId = -1;
        for (int index = 0; index < arrSelectedRows.length; ++index) {
            iDevId = (Integer)this.mDeviceInfoTable.getValueAt(arrSelectedRows[index], 0);
            int length = onlineAccessBoardInfoTable.getRowCount();
            boolean isExist = false;
            for (int i = 0; i < length; ++i) {
                if ((Integer)onlineAccessBoardInfoTable.getValueAt(i, 0) != iDevId) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            DeviceInfo devInfo = oDeviceInfoMgr.getDevice(iDevId);
            this.mAccessRowData = new Vector(0);
            this.mAccessRowData.add(iDevId);
            this.mAccessRowData.add(devInfo.getDevName());
            this.mAccessRowData.add(devInfo.getDevIPAddress());
            this.mAccessRowData.add(devInfo.getDeviceTypeInfo().getDevTypeName());
            this.mAccessRowData.add(devInfo.getDevVersion().getDevVersion());
            this.mAccessRowData.add(ResourceManager.getInstance().getResString("ONLINE_BOARD_NOT_RUN"));
            onlineAccessBoardInfoTableModel.addRow(this.mAccessRowData);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OnlineBoardUpgradeFrame.getOnlineBoardUpgradeFrame().getAccessInfoTable().updateUI();
            }
        });
    }

    private DeviceTypeInfo getDeviceTypeInfo(int iDeviceTypeId) {
        AbstractDeviceInfoManager oDevInfoManager = (AbstractDeviceInfoManager)DeviceInfoManagerImpl.getInstance();
        DeviceTypeInfo[] oArrDevTypeInfo = oDevInfoManager.getDeviceTypes();
        DeviceTypeInfo oDevTypeInfo = null;
        for (int index = 0; index < oArrDevTypeInfo.length; ++index) {
            if (iDeviceTypeId != oArrDevTypeInfo[index].getDevTypeID()) continue;
            oDevTypeInfo = oArrDevTypeInfo[index];
            break;
        }
        return oDevTypeInfo;
    }

    private void initializeKeyEventForEnterBtn() {
        ActionListener EnterKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeviceSearchAddDialog.this.mFindBtn.doClick();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.rootPane.registerKeyboardAction(EnterKeyHandler, keyStroke, 2);
    }

    private void requestFocusToSearchString() {
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                DeviceSearchAddDialog.this.setFocusToSearchStringField();
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
                DeviceSearchAddDialog.this.setFocusToSearchStringField();
            }
        });
    }
}

