/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.onlineboard.model;

import com.huawei.dc.common.asndatacenter.AsnBoardOperEnum;
import com.huawei.dc.common.asndatacenter.AsnBoardUpgradeInfoLst;
import com.huawei.dc.common.asndatacenter.AsnBoardUpgradeInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnBoardUpgradeReq;
import com.huawei.dc.common.asndatacenter.AsnDCBoardInfo;
import com.huawei.dc.common.asndatacenter.AsnDCBoardList;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceInfo;
import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import com.huawei.dc.common.asndatacenter.AsnDCFrameInfo;
import com.huawei.dc.common.asndatacenter.AsnDCFrameList;
import com.huawei.dc.common.asndatacenter.AsnDCPKGFileTypeEnum;
import com.huawei.dc.common.asndatacenter.AsnDCSubSlotInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSubSlotList;
import com.huawei.dc.common.asndatacenter.AsnOnlineBoardInfo;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.onlineboard.model.BoardInfo;
import com.huawei.dc.onlineboard.model.DCDeviceInfo;
import com.huawei.dc.onlineboard.model.DCFrameInfo;
import com.huawei.dc.onlineboard.model.OnlineBoardInfo;
import com.huawei.dc.onlineboard.model.OnlineBoardUpgradeInfo;
import com.huawei.dc.onlineboard.model.SubSlotInfo;
import java.math.BigInteger;
import java.util.ArrayList;

public class OnlineBoardUtility {
    private static OnlineBoardUtility m_oOnlineBoardUtility = null;

    private OnlineBoardUtility() {
    }

    public static synchronized OnlineBoardUtility getInstance() {
        if (null == m_oOnlineBoardUtility) {
            m_oOnlineBoardUtility = new OnlineBoardUtility();
        }
        return m_oOnlineBoardUtility;
    }

    public AsnBoardUpgradeInfoRsp fillAsnBoardUpgrade(OnlineBoardUpgradeInfo onlineBoardUpgradeInfo, AsnBoardOperEnum oAsnBoardOperType, int iPkgType) {
        AsnBoardUpgradeInfoRsp oAsnBoardUpgradeInfoRsp = new AsnBoardUpgradeInfoRsp();
        AsnDCFrameInfo oAsnDCFrameInfo = null;
        ArrayList oFrameInfoLst = null;
        ArrayList oBoardInfoLst = null;
        BoardInfo oBoardInfo = null;
        AsnDCBoardInfo oAsnBoardInfo = null;
        ArrayList oSubSlotLst = null;
        SubSlotInfo oSubSlotInfo = null;
        AsnDCSubSlotInfo oAsnSubSlotInfo = null;
        DCFrameInfo oFrameInfo = null;
        AsnBoardUpgradeReq m_oAsnBoardUpgradeReq = new AsnBoardUpgradeReq();
        m_oAsnBoardUpgradeReq.enOperType = oAsnBoardOperType;
        oAsnBoardUpgradeInfoRsp.strFileName = onlineBoardUpgradeInfo.getFileName().getBytes();
        oAsnBoardUpgradeInfoRsp.strTargetVersion = onlineBoardUpgradeInfo.getTargetVersion().getBytes();
        oAsnBoardUpgradeInfoRsp.strOperationId = "ABCD".getBytes();
        oAsnBoardUpgradeInfoRsp.ePKGFileType = new AsnDCPKGFileTypeEnum(iPkgType);
        oAsnBoardUpgradeInfoRsp.iOperResult = BigInteger.valueOf(0L);
        oAsnBoardUpgradeInfoRsp.oOnlineBoardInfo.oDCDeviceInfo.iDevId = BigInteger.valueOf(onlineBoardUpgradeInfo.getOnlineBoardInfo().getDCDeviceInfo().getDevId());
        oAsnBoardUpgradeInfoRsp.oOnlineBoardInfo.oDCDeviceInfo.iDevTypeId = BigInteger.valueOf(onlineBoardUpgradeInfo.getOnlineBoardInfo().getDCDeviceInfo().getDevTypeId());
        oAsnBoardUpgradeInfoRsp.oOnlineBoardInfo.oDCDeviceInfo.iDevTypeVersionId = BigInteger.valueOf(onlineBoardUpgradeInfo.getOnlineBoardInfo().getDCDeviceInfo().getDevTypeVersionId());
        oAsnBoardUpgradeInfoRsp.oOnlineBoardInfo.oDCDeviceInfo.oErrorInfo = new AsnDCErrorCodeInfo();
        oAsnBoardUpgradeInfoRsp.oOnlineBoardInfo.oDCDeviceInfo.oErrorInfo.iErrorNo = BigInteger.valueOf(0L);
        oAsnBoardUpgradeInfoRsp.oOnlineBoardInfo.oDCDeviceInfo.iNeID = BigInteger.valueOf(onlineBoardUpgradeInfo.getOnlineBoardInfo().getDCDeviceInfo().getNelId());
        oAsnBoardUpgradeInfoRsp.oOnlineBoardInfo.oDCDeviceInfo.oLastOperationState = onlineBoardUpgradeInfo.getOnlineBoardInfo().getDCDeviceInfo().getLastOperationState();
        oAsnBoardUpgradeInfoRsp.oOnlineBoardInfo.oDCDeviceInfo.strDevIPAddress = onlineBoardUpgradeInfo.getOnlineBoardInfo().getDCDeviceInfo().getDevIPAddress().getBytes();
        oAsnBoardUpgradeInfoRsp.oOnlineBoardInfo.oDCDeviceInfo.strDevName = onlineBoardUpgradeInfo.getOnlineBoardInfo().getDCDeviceInfo().getDevName().getBytes();
        oAsnBoardUpgradeInfoRsp.oOnlineBoardInfo.oDCDeviceInfo.strDevVersion = onlineBoardUpgradeInfo.getOnlineBoardInfo().getDCDeviceInfo().getDevDevVersion().getBytes();
        oAsnBoardUpgradeInfoRsp.oOnlineBoardInfo.oDCDeviceInfo.strDevPatchVersion = "".getBytes();
        oAsnBoardUpgradeInfoRsp.oOnlineBoardInfo.oErrorNo.iErrorNo = BigInteger.valueOf(0L);
        oFrameInfoLst = onlineBoardUpgradeInfo.getOnlineBoardInfo().getFrameInfoLst();
        int iSize = oFrameInfoLst.size();
        for (int iFrameIndex = 0; iFrameIndex < iSize; ++iFrameIndex) {
            oAsnDCFrameInfo = new AsnDCFrameInfo();
            oFrameInfo = (DCFrameInfo)oFrameInfoLst.get(iFrameIndex);
            oAsnDCFrameInfo.iFrameId = BigInteger.valueOf(oFrameInfo.getFrameId());
            oAsnDCFrameInfo.iFrameType = BigInteger.valueOf(oFrameInfo.getFrameType());
            oBoardInfoLst = oFrameInfo.getBoardLst();
            int jSize = oBoardInfoLst.size();
            for (int iBoardIndex = 0; iBoardIndex < jSize; ++iBoardIndex) {
                oAsnBoardInfo = new AsnDCBoardInfo();
                oBoardInfo = (BoardInfo)oBoardInfoLst.get(iBoardIndex);
                oAsnBoardInfo.iSlotId = BigInteger.valueOf(oBoardInfo.getSlotId());
                oAsnBoardInfo.iBoardType = BigInteger.valueOf(oBoardInfo.getBoardType());
                oAsnDCFrameInfo.oBoardList.add((Object)oAsnBoardInfo);
                oSubSlotLst = oBoardInfo.getSlotList();
                if (null == oSubSlotLst || 0 == oSubSlotLst.size()) continue;
                int kSize = oSubSlotLst.size();
                for (int iSubSlotIndex = 0; iSubSlotIndex < kSize; ++iSubSlotIndex) {
                    oAsnSubSlotInfo = new AsnDCSubSlotInfo();
                    oSubSlotInfo = (SubSlotInfo)oSubSlotLst.get(iSubSlotIndex);
                    oAsnSubSlotInfo.iSubSlotId = BigInteger.valueOf(oSubSlotInfo.getSubSlotId());
                    oAsnSubSlotInfo.iSubSlotType = BigInteger.valueOf(oSubSlotInfo.getSubSlotType());
                    if (null != oSubSlotInfo.getBoardVersion()) {
                        oAsnSubSlotInfo.strBoardVersion = oSubSlotInfo.getBoardVersion().getBytes();
                    }
                    if (null != oSubSlotInfo.getSubSlotLabel()) {
                        oAsnSubSlotInfo.strSubSlotLabel = oSubSlotInfo.getSubSlotLabel().getBytes();
                    }
                    oAsnBoardInfo.oSlotList = new AsnDCSubSlotList();
                    oAsnBoardInfo.oSlotList.add((Object)oAsnSubSlotInfo);
                }
            }
            oAsnBoardUpgradeInfoRsp.oOnlineBoardInfo.oAsnFrameList.add((Object)oAsnDCFrameInfo);
        }
        return oAsnBoardUpgradeInfoRsp;
    }

    public ArrayList fillOnlineBoardUpgradeInfo(AsnBoardUpgradeInfoLst oAsnBoardUpgradeInfoLst) {
        int iBoardUpgradeInfoLstSize = oAsnBoardUpgradeInfoLst.size();
        ArrayList<OnlineBoardUpgradeInfo> m_oOnlineBoardUpgradeInfoLst = new ArrayList<OnlineBoardUpgradeInfo>(iBoardUpgradeInfoLstSize);
        OnlineBoardUpgradeInfo oOnlineBoardUpgradeInfo = null;
        AsnBoardUpgradeInfoRsp oAsnBoardUpgradeInfo = null;
        for (int index = 0; index < iBoardUpgradeInfoLstSize; ++index) {
            oOnlineBoardUpgradeInfo = new OnlineBoardUpgradeInfo();
            oAsnBoardUpgradeInfo = (AsnBoardUpgradeInfoRsp)oAsnBoardUpgradeInfoLst.get(index);
            if (null != oAsnBoardUpgradeInfo.strFileName) {
                oOnlineBoardUpgradeInfo.setFileName(new String(oAsnBoardUpgradeInfo.strFileName));
            }
            if (null != oAsnBoardUpgradeInfo.strOperationId) {
                oOnlineBoardUpgradeInfo.setOperationId(new String(oAsnBoardUpgradeInfo.strOperationId));
            }
            oOnlineBoardUpgradeInfo.setIsLast(oAsnBoardUpgradeInfo.bisLast);
            if (null != oAsnBoardUpgradeInfo.strTargetVersion) {
                oOnlineBoardUpgradeInfo.setTargetVersion(new String(oAsnBoardUpgradeInfo.strTargetVersion));
            }
            if (null != oAsnBoardUpgradeInfo.ePKGFileType) {
                oOnlineBoardUpgradeInfo.setPkgFileType(oAsnBoardUpgradeInfo.ePKGFileType.value);
            }
            this.fillOnlineBoardInfo(oAsnBoardUpgradeInfo.oOnlineBoardInfo, oOnlineBoardUpgradeInfo);
            m_oOnlineBoardUpgradeInfoLst.add(oOnlineBoardUpgradeInfo);
        }
        return m_oOnlineBoardUpgradeInfoLst;
    }

    private void fillOnlineBoardInfo(AsnOnlineBoardInfo onlineBoardInfo, OnlineBoardUpgradeInfo onlineBoardUpgradeInfo) {
        OnlineBoardInfo oOnlineBoardInfo = new OnlineBoardInfo();
        this.fillDeviceInfo(onlineBoardInfo.oDCDeviceInfo, oOnlineBoardInfo);
        this.fillFrameLstInfo(onlineBoardInfo.oDCDeviceInfo.iDevId.intValue(), onlineBoardInfo.oAsnFrameList, oOnlineBoardInfo);
        onlineBoardUpgradeInfo.setOnlineBoardInfo(oOnlineBoardInfo);
    }

    private void fillDeviceInfo(AsnDCDeviceInfo deviceInfo, OnlineBoardInfo onlineBoardInfo) {
        DCDeviceInfo oDCDeviceInfo = new DCDeviceInfo();
        if (null != deviceInfo.strDevVersion) {
            oDCDeviceInfo.setDevDevVersion(new String(deviceInfo.strDevVersion));
        }
        if (null != deviceInfo.iDevId) {
            oDCDeviceInfo.setDevId(deviceInfo.iDevId.intValue());
        }
        if (null != deviceInfo.strDevIPAddress) {
            oDCDeviceInfo.setDevIPAddress(new String(deviceInfo.strDevIPAddress));
        }
        if (null != deviceInfo.strDevName) {
            oDCDeviceInfo.setDevName(new String(deviceInfo.strDevName));
        }
        if (null != deviceInfo.iDevTypeId) {
            oDCDeviceInfo.setDevTypeID(deviceInfo.iDevTypeId.intValue());
        }
        if (null != deviceInfo.iDevTypeVersionId) {
            oDCDeviceInfo.setDevTypeVersionID(deviceInfo.iDevTypeVersionId.intValue());
        }
        oDCDeviceInfo.setLastOperationState(deviceInfo.oLastOperationState);
        if (null != deviceInfo.iNeID) {
            oDCDeviceInfo.setNelId(deviceInfo.iNeID.intValue());
        }
        onlineBoardInfo.setDCDeviceInfo(oDCDeviceInfo);
    }

    private void fillFrameLstInfo(int iDevId, AsnDCFrameList oFrameLst, OnlineBoardInfo oOnlineBoardInfo) {
        AsnDCFrameInfo oFrameInfo = null;
        DCFrameInfo oDCFrameInfo = null;
        ArrayList<DCFrameInfo> oFrameInfoLst = new ArrayList<DCFrameInfo>(0);
        for (int index = 0; index < oFrameLst.size(); ++index) {
            oFrameInfo = (AsnDCFrameInfo)oFrameLst.get(index);
            oDCFrameInfo = new DCFrameInfo();
            if (null != oFrameInfo.iFrameId) {
                oDCFrameInfo.setFrameId(oFrameInfo.iFrameId.intValue());
            }
            if (null != oFrameInfo.strFrameLabel) {
                oDCFrameInfo.setFrameLabel(new String(oFrameInfo.strFrameLabel));
            }
            if (null != oFrameInfo.iFrameType) {
                oDCFrameInfo.setFrameType(oFrameInfo.iFrameType.intValue());
            }
            this.fillBoardListInfo(iDevId, oFrameInfo.oBoardList, oDCFrameInfo);
            oFrameInfoLst.add(oDCFrameInfo);
        }
        oOnlineBoardInfo.setFrameInfoLst(oFrameInfoLst);
    }

    private void fillBoardListInfo(int iDevId, AsnDCBoardList oBoardList, DCFrameInfo oFrameInfo) {
        ArrayList<BoardInfo> oBoardInfoLst = new ArrayList<BoardInfo>();
        BoardInfo oBoardInfo = null;
        AsnDCBoardInfo oDCBoardInfo = null;
        DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDevId);
        for (int index = 0; index < oBoardList.size(); ++index) {
            oDCBoardInfo = (AsnDCBoardInfo)oBoardList.get(index);
            oBoardInfo = new BoardInfo();
            if (null != oDCBoardInfo.iBoardType) {
                oBoardInfo.setBoardType(oDCBoardInfo.iBoardType.intValue());
            }
            if (null != oDCBoardInfo.strBoardType) {
                String strDisplayName = new String(oDCBoardInfo.strBoardType);
                strDisplayName = ResourceManager.getInstance().getResString(oDevInfo.getDeviceTypeInfo(), strDisplayName);
                oBoardInfo.setStrBoardType(strDisplayName);
            } else {
                oBoardInfo.setStrBoardType("");
            }
            if (null != oDCBoardInfo.strBoardVersion) {
                oBoardInfo.setBoardVersion(new String(oDCBoardInfo.strBoardVersion));
            }
            if (null != oDCBoardInfo.iSlotId) {
                oBoardInfo.setSlotId(oDCBoardInfo.iSlotId.intValue());
            }
            if (null != oDCBoardInfo.strSlotLabel) {
                oBoardInfo.setSlotLabel(new String(oDCBoardInfo.strSlotLabel));
            }
            if (null != oDCBoardInfo.oSlotList) {
                this.fillSubSlotLstInfo(oDCBoardInfo.oSlotList, oBoardInfo);
            }
            oBoardInfoLst.add(oBoardInfo);
        }
        oFrameInfo.setBoardLst(oBoardInfoLst);
    }

    private void fillSubSlotLstInfo(AsnDCSubSlotList slotList, BoardInfo boardInfo) {
        if (null == slotList) {
            return;
        }
        ArrayList<SubSlotInfo> oSubSlotLst = new ArrayList<SubSlotInfo>();
        SubSlotInfo oSubSlotInfo = null;
        AsnDCSubSlotInfo oAsnSubSlotInfo = null;
        for (int index = 0; index < slotList.size(); ++index) {
            oAsnSubSlotInfo = (AsnDCSubSlotInfo)slotList.get(index);
            oSubSlotInfo = new SubSlotInfo();
            if (null != oAsnSubSlotInfo.strBoardVersion) {
                oSubSlotInfo.setBoardVersion(new String(oAsnSubSlotInfo.strBoardVersion));
            }
            if (null != oAsnSubSlotInfo.iSubSlotId) {
                oSubSlotInfo.setSubSlotId(oAsnSubSlotInfo.iSubSlotId.intValue());
            }
            if (null != oAsnSubSlotInfo.strSubSlotLabel) {
                oSubSlotInfo.setSubSlotLabel(new String(oAsnSubSlotInfo.strSubSlotLabel));
            }
            if (null != oAsnSubSlotInfo.iSubSlotType) {
                oSubSlotInfo.setSubSlotType(oAsnSubSlotInfo.iSubSlotType.intValue());
            }
            oSubSlotLst.add(oSubSlotInfo);
        }
        boardInfo.setSlotList(oSubSlotLst);
    }

    public void setNull() {
        m_oOnlineBoardUtility = null;
    }
}

