/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.onlineboard.controller;

import com.huawei.dc.common.asndatacenter.AsnBoardUpgradeInfoLst;
import com.huawei.dc.common.asndatacenter.AsnBoardUpgradeInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnBoardUpgradeReq;
import com.huawei.dc.common.asndatacenter.AsnDCMultiDeviceErr;
import com.huawei.dc.common.asndatacenter.AsnDCMultiDeviceErrLst;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.asndatacenter.AsnDCSyncReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.controller.AbstractDeviceInfoManager;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.GUIConstants;
import com.huawei.dc.common.util.OperationResultDlg;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.onlineboard.controller.IOnlineBoardManager;
import com.huawei.dc.onlineboard.model.PkgDevInfo;
import com.huawei.dc.onlineboard.view.OnlineBoardUpgradeFrame;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.commustru.fstru.FStruct;

public class OnlineBoardManager
implements IOnlineBoardManager,
IDCObjectDeallocator {
    private static OnlineBoardManager m_oOnlineBoardMgr;
    private BaseCommManager m_oCommManager;
    private HashMap<PkgDevInfo, List<PkgDevInfo>> m_oPkgDevHm = new HashMap();

    private OnlineBoardManager() {
        this.m_oCommManager = DCFrameWorkUtil.getCommManager();
    }

    public static synchronized OnlineBoardManager getInstance() {
        if (null == m_oOnlineBoardMgr) {
            m_oOnlineBoardMgr = new OnlineBoardManager();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oOnlineBoardMgr);
        }
        return m_oOnlineBoardMgr;
    }

    @Override
    public AsnDCOpertionRsp sendUpgradeRequest(AsnBoardUpgradeReq oAsnBoardUpgradeReq) {
        AsnDCOpertionRsp oAsnDCOperationRsp = new AsnDCOpertionRsp();
        int iErrorCode = -1;
        iErrorCode = this.m_oCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43959, 0, 1, GUIConstants.DC_SERVER_ID), (FStruct)oAsnBoardUpgradeReq, (FStruct)oAsnDCOperationRsp);
        if (0 != iErrorCode) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode);
        }
        if (0 != oAsnDCOperationRsp.oErrorInfo.iErrorNo.intValue()) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), oAsnDCOperationRsp.oErrorInfo.iErrorNo.intValue());
            return null;
        }
        this.displayPopupForFailedDevices(oAsnDCOperationRsp.oResultOpt);
        return oAsnDCOperationRsp;
    }

    public AsnDCSyncRsp sendAccessUpgradeRequest(AsnBoardUpgradeReq oAsnBoardUpgradeReq) {
        AsnDCSyncReq oAsnDCSyncReq = new AsnDCSyncReq();
        AsnBoardUpgradeInfoLst oAsnBoardUpgradeInfoRspList = oAsnBoardUpgradeReq.oOnlineBoardInfoLst;
        ArrayList<BigInteger> deviceIdList = new ArrayList<BigInteger>();
        for (AsnBoardUpgradeInfoRsp oOnlineBoardInfoLst : oAsnBoardUpgradeInfoRspList) {
            oAsnDCSyncReq.oDevIDLst.add((Object)oOnlineBoardInfoLst.oOnlineBoardInfo.oDCDeviceInfo.iDevId);
            deviceIdList.add(oOnlineBoardInfoLst.oOnlineBoardInfo.oDCDeviceInfo.iDevId);
        }
        int iReqId = DCFrameWorkUtil.generateRequestId();
        oAsnDCSyncReq.oReqID = BigInteger.valueOf(iReqId);
        OnlineBoardUpgradeFrame.getOnlineBoardUpgradeFrame().getRequestidDevice().put(oAsnDCSyncReq.oReqID, oAsnDCSyncReq);
        AsnDCSyncRsp oAsnDCSyncRsp = new AsnDCSyncRsp();
        int iErrorCode = this.m_oCommManager.sendSyncMsgWithSyncCommand(54046, (FStruct)oAsnDCSyncReq, (FStruct)oAsnDCSyncRsp);
        if (0 != iErrorCode) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode);
            return null;
        }
        if (0 != oAsnDCSyncRsp.oErrorInfo.iErrorNo.intValue()) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), oAsnDCSyncRsp.oErrorInfo.iErrorNo.intValue());
            return null;
        }
        this.changeAccessBoardStatusRuning(deviceIdList);
        return oAsnDCSyncRsp;
    }

    private void changeAccessBoardStatusRuning(List<BigInteger> devIdList) {
        String status = ResourceManager.getInstance().getResString("TASK_STATUS_RUNNING");
        OnlineBoardUpgradeFrame oOnlineBoardUpgradeFrame = OnlineBoardUpgradeFrame.getOnlineBoardUpgradeFrame();
        for (BigInteger devId : devIdList) {
            int rowIndex = oOnlineBoardUpgradeFrame.isAccessResourceExist(devId.intValue());
            if (rowIndex < 0) continue;
            oOnlineBoardUpgradeFrame.getAccessInfoTable().getModel().setValueAt(status, rowIndex, 5);
        }
    }

    private void displayPopupForFailedDevices(AsnDCMultiDeviceErrLst oAsnDCMultiDeviceErrList) {
        StringBuffer strErrorMessage = new StringBuffer(0);
        int iSizeOfList = -1;
        if (null != oAsnDCMultiDeviceErrList) {
            iSizeOfList = oAsnDCMultiDeviceErrList.size();
        }
        if (0 == iSizeOfList) {
            return;
        }
        int iDevId = 0;
        int iErrorNos = 0;
        DeviceInfo oDevInfo = null;
        AbstractDeviceInfoManager oDeviceInfoMgr = (AbstractDeviceInfoManager)DeviceInfoManagerImpl.getInstance();
        for (int index = 0; index < iSizeOfList; ++index) {
            if (null == oAsnDCMultiDeviceErrList) continue;
            AsnDCMultiDeviceErr oAsnDCMultiDeviceErr = (AsnDCMultiDeviceErr)oAsnDCMultiDeviceErrList.elementAt(index);
            iDevId = oAsnDCMultiDeviceErr.iDeviceId.intValue();
            iErrorNos = oAsnDCMultiDeviceErr.oErrorInfo.iErrorNo.intValue();
            oDevInfo = oDeviceInfoMgr.getDevice(iDevId);
            if (null != oDevInfo) {
                strErrorMessage.append(oDevInfo.getDevIPAddress());
                strErrorMessage.append(":");
                strErrorMessage.append(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorNos)));
            }
            strErrorMessage.append("\n");
        }
        OperationResultDlg operationResultDialog = new OperationResultDlg((Component)DCFrameWorkUtil.getMainFrame(), false);
        operationResultDialog.setDisplayInfo(ResourceManager.getInstance().getResString("SAVEINFOPAN_OPERATION_ERROR"), strErrorMessage.toString());
    }

    public AsnBoardUpgradeInfoLst getOnlineBoardInfo() {
        final AsnBoardUpgradeInfoLst oAsnBoardUpgradeInfoLst = new AsnBoardUpgradeInfoLst();
        int iErrorCode = -1;
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = OnlineBoardManager.this.m_oCommManager;
                OnlineBoardManager.this.m_oCommManager;
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43960, 0, 1, GUIConstants.DC_SERVER_ID), null, (FStruct)oAsnBoardUpgradeInfoLst);
                return iErrorCode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && 0 != (iErrorCode = ((Integer)syncCommand.getResult()).intValue())) {
            DCDebugTracer.trace("OnlineBoardManager#getOnlineBoardInfo ErrorCode:" + iErrorCode);
            DCOptionPane.showMessageDialog(DCFrameWorkUtil.getMainFrame(), iErrorCode);
            return null;
        }
        if (null == oAsnBoardUpgradeInfoLst) {
            DCDebugTracer.trace("OnlineBoardManager#getOnlineBoardInfo oAsnBoardUpgradeInfoLst is NULL");
        }
        DCDebugTracer.trace("OnlineBoardManager#getOnlineBoardInfo oAsnBoardUpgradeInfoLst.size is:" + oAsnBoardUpgradeInfoLst.size());
        return oAsnBoardUpgradeInfoLst;
    }

    @Override
    public void setToNULL() {
        m_oOnlineBoardMgr = null;
        this.m_oCommManager = null;
    }

    public HashMap<PkgDevInfo, List<PkgDevInfo>> getPkgDevHm() {
        return this.m_oPkgDevHm;
    }
}

