/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.onlineboard;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnBoardUpgradeInfoLst;
import com.huawei.dc.common.asndatacenter.AsnBoardUpgradeInfoRsp;
import com.huawei.dc.common.asndatacenter.AsnDCMultiDeviceErr;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.asndatacenter.AsnDCT2000DeviceRsp;
import com.huawei.dc.common.asndatacenter.AsnDevInfoList;
import com.huawei.dc.common.asndatacenter.AsnOnlineBoardNtf;
import com.huawei.dc.common.asndatacenter.AsnOnlineBoardNtfLst;
import com.huawei.dc.common.controller.AbstractDCMSGReceiver;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.onlineboard.controller.OnlineBoardManager;
import com.huawei.dc.onlineboard.model.OnlineBoardUtility;
import com.huawei.dc.onlineboard.model.PkgDevInfo;
import com.huawei.dc.onlineboard.view.OnlineBoardUpgradeFrame;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public class DeviceBoardConfigEventReceiver
extends AbstractDCMSGReceiver
implements IDCObjectDeallocator {
    private static final int[] COMMAND_CODES = new int[]{43958, 43970, 54046, 44006, 43952};
    private static DeviceBoardConfigEventReceiver m_oDeviceBoardConfigEventReceiver;
    private BaseCommManager m_oCommManager;
    public static final int SUCCESS = 0;
    public static final int FAILURE = 1;
    public static final int NOTRUN = 2;
    public static final int RUNNING = 3;

    private DeviceBoardConfigEventReceiver() {
        super(COMMAND_CODES);
        this.initializeCommManager();
    }

    public static synchronized DeviceBoardConfigEventReceiver getInstance() {
        if (null == m_oDeviceBoardConfigEventReceiver) {
            m_oDeviceBoardConfigEventReceiver = new DeviceBoardConfigEventReceiver();
            ObjectStore.getInstance().putObjectInstance("DeviceBoardConfigEventReceiver", m_oDeviceBoardConfigEventReceiver);
        }
        return m_oDeviceBoardConfigEventReceiver;
    }

    protected void processMessage(MSGPacketExt oPacketExt) {
        try {
            DCDebugTracer.trace("receive asyn msg cmdCode=" + oPacketExt.mheader.cmdCode);
            this.processAsynMessage(oPacketExt);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void processAsynMessage(MSGPacketExt oPacketExt) {
        byte[] arrReceivedData;
        if (null == oPacketExt) {
            return;
        }
        DCDebugTracer.trace("[BOARDCFG] receive asyn msg cmdCode= " + oPacketExt.mheader.cmdCode);
        if (43958 == oPacketExt.mheader.cmdCode || 44006 == oPacketExt.mheader.cmdCode) {
            byte[] arrReceivedData2 = oPacketExt.getData();
            if (null != arrReceivedData2 && 0 != arrReceivedData2.length) {
                AsnBoardUpgradeInfoLst oAsnBoardUpgradeInfoLst = new AsnBoardUpgradeInfoLst();
                int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnBoardUpgradeInfoLst, arrReceivedData2);
                if (0 == iErrorCode) {
                    try {
                        this.addDeviceBoard(oAsnBoardUpgradeInfoLst);
                    }
                    catch (Exception oException) {
                        DCDebugTracer.trace("DC::DeviceBoardConfigEventReceiver::processAsynMessage()::throw exception::" + oException.getMessage());
                    }
                }
            }
        } else if (43970 == oPacketExt.mheader.cmdCode) {
            byte[] arrReceivedData3 = oPacketExt.getData();
            if (null != arrReceivedData3 && 0 != arrReceivedData3.length) {
                AsnOnlineBoardNtfLst oAsnOnlineBoardNtf = new AsnOnlineBoardNtfLst();
                int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnOnlineBoardNtf, arrReceivedData3);
                if (0 == iErrorCode) {
                    try {
                        this.changeBoardState(oAsnOnlineBoardNtf);
                    }
                    catch (Exception oException) {
                        DCDebugTracer.trace("DC::DeviceBoardConfigEventReceiver::processAsynMessage()::throw exception::" + oException.getMessage());
                    }
                }
            }
        } else if (54046 == oPacketExt.mheader.cmdCode) {
            byte[] arrReceivedData4 = oPacketExt.getData();
            if (null != arrReceivedData4 && 0 != arrReceivedData4.length) {
                AsnDCOpertionRsp oAsnDCOpertionRsp = new AsnDCOpertionRsp();
                int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCOpertionRsp, arrReceivedData4);
                if (0 == iErrorCode) {
                    try {
                        this.changeAccessBoardState(oAsnDCOpertionRsp);
                    }
                    catch (Exception oException) {
                        DCDebugTracer.trace("DC::DeviceBoardConfigEventReceiver::processAsynMessage()::throw exception::" + oException.getMessage());
                    }
                }
            }
        } else if (43952 == oPacketExt.mheader.cmdCode && null != (arrReceivedData = oPacketExt.getData()) && 0 != arrReceivedData.length) {
            AsnDCT2000DeviceRsp asnDCT2000DeviceRsp = new AsnDCT2000DeviceRsp();
            int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)asnDCT2000DeviceRsp, arrReceivedData);
            if (0 == iErrorCode) {
                try {
                    iErrorCode = asnDCT2000DeviceRsp.oErrorInfo.iErrorNo.intValue();
                    if (iErrorCode != 0) {
                        DCDebugTracer.trace("asnDCT2000DeviceRsp.oErrorInfo.iErrorNo:" + iErrorCode);
                        throw new DCException(iErrorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
                    }
                    AsnDevInfoList asnDevInfoList = asnDCT2000DeviceRsp.oDeviceInfoLst;
                    DCDebugTracer.trace("get t2k asyn msg,dev list:" + asnDevInfoList.size());
                    DCDebugTracer.trace("DC::DeviceBoardConfigEventReceiver::processAsynMessage()::asnDevInfoList.size::" + asnDevInfoList.size());
                }
                catch (DCException oException) {
                    DCDebugTracer.trace("DC::DeviceBoardConfigEventReceiver::processAsynMessage()::throw exception::" + oException.getMessage());
                }
            }
        }
    }

    private void addDeviceBoard(AsnBoardUpgradeInfoLst oAsnBoardUpgradeInfoLst) {
        if (null == oAsnBoardUpgradeInfoLst) {
            return;
        }
        AsnBoardUpgradeInfoRsp oAsnBoardUpgradeInfoRsp = null;
        int iBoardUpgradeInfoLstSize = oAsnBoardUpgradeInfoLst.size();
        for (int index = 0; index < iBoardUpgradeInfoLstSize; ++index) {
            oAsnBoardUpgradeInfoRsp = (AsnBoardUpgradeInfoRsp)oAsnBoardUpgradeInfoLst.get(index);
            if (0 == oAsnBoardUpgradeInfoRsp.oOnlineBoardInfo.oErrorNo.iErrorNo.intValue()) continue;
            DCDebugTracer.trace("DeviceBoardConfigEventReceiver.addDeviceBoard " + oAsnBoardUpgradeInfoRsp.oOnlineBoardInfo.oErrorNo.iErrorNo.intValue() + " " + ErrorCodeReader.getInstance().getErrorDesc(oAsnBoardUpgradeInfoRsp.oOnlineBoardInfo.oErrorNo.iErrorNo));
            return;
        }
        ArrayList oBoardUpgradeInfoLst = OnlineBoardUtility.getInstance().fillOnlineBoardUpgradeInfo(oAsnBoardUpgradeInfoLst);
        if (0 == oBoardUpgradeInfoLst.size()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("NO_ONLINE_BOARD_ADDED"), ResourceManager.getInstance().getResString("INFO"), 0);
            return;
        }
        OnlineBoardUpgradeFrame m_oOnlineBoardUpgradeFrame = OnlineBoardUpgradeFrame.getOnlineBoardUpgradeFrame();
        if (null != m_oOnlineBoardUpgradeFrame && m_oOnlineBoardUpgradeFrame.isVisible()) {
            DCDebugTracer.trace("DC::DeviceBoardConfigEventReceiver::show OnlineBoardUpgradeFrame");
            m_oOnlineBoardUpgradeFrame = OnlineBoardUpgradeFrame.getOnlineBoardUpgradeFrame();
            m_oOnlineBoardUpgradeFrame.addRowToTable(oBoardUpgradeInfoLst);
        } else {
            DCDebugTracer.trace("DC::DeviceBoardConfigEventReceiver::new OnlineBoardUpgradeFrame");
            m_oOnlineBoardUpgradeFrame = new OnlineBoardUpgradeFrame(oBoardUpgradeInfoLst);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OnlineBoardUpgradeFrame.getOnlineBoardUpgradeFrame().setVisible(true);
                }
            });
        }
    }

    private void initializeCommManager() {
        this.m_oCommManager = DCFrameWorkUtil.getCommManager();
    }

    @Override
    public void setToNULL() {
        this.closeReceiver();
        this.m_oCommManager = null;
        m_oDeviceBoardConfigEventReceiver = null;
    }

    private void changeBoardState(AsnOnlineBoardNtfLst oAsnOnlineBoardNtfLst) {
        if (null == oAsnOnlineBoardNtfLst) {
            return;
        }
        int listSize = oAsnOnlineBoardNtfLst.size();
        int iDevID = 0;
        int iSlotID = 0;
        int iPkgType = 0;
        int iTaskResult = 0;
        int iTaskStatus = 0;
        String status = null;
        for (int i = 0; i < listSize; ++i) {
            AsnOnlineBoardNtf oAsnOnlineBoardNtf = (AsnOnlineBoardNtf)oAsnOnlineBoardNtfLst.get(i);
            iDevID = oAsnOnlineBoardNtf.iDeviceID.intValue();
            iSlotID = oAsnOnlineBoardNtf.iSlotID.intValue();
            iPkgType = oAsnOnlineBoardNtf.ePKGFileType.value;
            iTaskResult = oAsnOnlineBoardNtf.oTaskResult.value;
            iTaskStatus = oAsnOnlineBoardNtf.oTaskStatus.value;
            status = this.getBoardStatus(iTaskResult, iTaskStatus);
            PkgDevInfo oPkgDevInfo = new PkgDevInfo(iDevID, iSlotID, iPkgType);
            this.changeBoardState(oPkgDevInfo, status);
            if (iPkgType != 1) continue;
            this.changeOthersBoardState(oPkgDevInfo, status, iTaskResult);
        }
    }

    private void changeAccessBoardState(AsnDCOpertionRsp oAsnDCOpertionRsp) {
        String status = "";
        OnlineBoardUpgradeFrame oOnlineBoardUpgradeFrame = OnlineBoardUpgradeFrame.getOnlineBoardUpgradeFrame();
        boolean isFind = this.isFindAccessResource(oAsnDCOpertionRsp);
        if (!isFind) {
            return;
        }
        status = ErrorCodeReader.getInstance().getErrorDesc(((AsnDCMultiDeviceErr)oAsnDCOpertionRsp.oResultOpt.get((int)0)).oErrorInfo.iErrorNo);
        if (null == oOnlineBoardUpgradeFrame) {
            return;
        }
        int deviceId = ((AsnDCMultiDeviceErr)oAsnDCOpertionRsp.oResultOpt.get((int)0)).iDeviceId.intValue();
        int rowIndex = oOnlineBoardUpgradeFrame.isAccessResourceExist(deviceId);
        if (rowIndex < 0) {
            return;
        }
        try {
            oOnlineBoardUpgradeFrame.getAccessInfoTable().getModel().setValueAt(status, rowIndex, 5);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e.getMessage());
        }
    }

    private boolean isFindAccessResource(AsnDCOpertionRsp oAsnDCOpertionRsp) {
        OnlineBoardUpgradeFrame oOnlineBoardUpgradeFrame = OnlineBoardUpgradeFrame.getOnlineBoardUpgradeFrame();
        if (oOnlineBoardUpgradeFrame.getRequestidDevice().isEmpty()) {
            return false;
        }
        BigInteger tempBigInt2 = null;
        for (BigInteger tempBigInt2 : oOnlineBoardUpgradeFrame.getRequestidDevice().keySet()) {
            if (tempBigInt2.intValue() != oAsnDCOpertionRsp.oReqID.intValue()) continue;
            Iterator itInner = oOnlineBoardUpgradeFrame.getRequestidDevice().get((Object)tempBigInt2).oDevIDLst.iterator();
            BigInteger tempBigIntInner = null;
            while (itInner.hasNext()) {
                tempBigIntInner = (BigInteger)itInner.next();
                if (tempBigIntInner.intValue() != ((AsnDCMultiDeviceErr)oAsnDCOpertionRsp.oResultOpt.get((int)0)).iDeviceId.intValue()) continue;
                oOnlineBoardUpgradeFrame.getRequestidDevice().get((Object)tempBigInt2).oDevIDLst.remove((Object)tempBigIntInner);
                if (oOnlineBoardUpgradeFrame.getRequestidDevice().get((Object)tempBigInt2).oDevIDLst.isEmpty()) {
                    oOnlineBoardUpgradeFrame.getRequestidDevice().remove(tempBigInt2);
                }
                return true;
            }
        }
        return false;
    }

    private void changeBoardState(PkgDevInfo oPkgDevInfo, String status) {
        OnlineBoardUpgradeFrame oOnlineBoardUpgradeFrame = OnlineBoardUpgradeFrame.getOnlineBoardUpgradeFrame();
        if (null == oOnlineBoardUpgradeFrame) {
            return;
        }
        int rowIndex = oOnlineBoardUpgradeFrame.isResourceExist(oPkgDevInfo);
        if (rowIndex < 0) {
            return;
        }
        try {
            int devID = oPkgDevInfo.getDevID();
            DeviceTypeInfo devTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfoByDevId(devID);
            if (null == devTypeInfo) {
                DCDebugTracer.trace("isResourceExist#devTypeInfo is null,devid = " + devID);
                return;
            }
            if (devTypeInfo.isBMSDomain()) {
                oOnlineBoardUpgradeFrame.getAccessInfoTable().getModel().setValueAt(status, rowIndex, 5);
            } else {
                oOnlineBoardUpgradeFrame.getInfoTable().getModel().setValueAt(status, rowIndex, 5);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private String getBoardStatus(int iTaskResult, int iTaskStatus) {
        String status = "";
        OnlineBoardUpgradeFrame oOnlineBoardUpgradeFrame = OnlineBoardUpgradeFrame.getOnlineBoardUpgradeFrame();
        if (iTaskStatus == 0) {
            status = oOnlineBoardUpgradeFrame.getOperationStatus(2);
        } else if (iTaskStatus == 1) {
            status = oOnlineBoardUpgradeFrame.getOperationStatus(3);
        } else if (iTaskStatus == 3 && iTaskResult == 0) {
            status = oOnlineBoardUpgradeFrame.getOperationStatus(0);
        } else if (iTaskStatus == 2 && iTaskResult == 1) {
            status = oOnlineBoardUpgradeFrame.getOperationStatus(1);
        }
        return status;
    }

    private void changeOthersBoardState(PkgDevInfo oPkgDevInfo, String status, int iStaskResult) {
        if (null == oPkgDevInfo) {
            return;
        }
        HashMap<PkgDevInfo, List<PkgDevInfo>> oPkgDevHm = OnlineBoardManager.getInstance().getPkgDevHm();
        if (null == oPkgDevHm) {
            return;
        }
        List<PkgDevInfo> corrPkgDevInfoLst = oPkgDevHm.get(oPkgDevInfo);
        if (null == corrPkgDevInfoLst || corrPkgDevInfoLst.size() == 0) {
            return;
        }
        PkgDevInfo oCorrPkgDevInfo = null;
        for (int i = corrPkgDevInfoLst.size() - 1; i >= 0; --i) {
            oCorrPkgDevInfo = corrPkgDevInfoLst.get(i);
            this.changeBoardState(oCorrPkgDevInfo, status);
            if (iStaskResult != 0 && iStaskResult != 1) continue;
            corrPkgDevInfoLst.remove(i);
        }
        if (corrPkgDevInfoLst.size() == 0) {
            oPkgDevHm.remove(oPkgDevInfo);
        }
    }

    public void removeMessageListener() {
        if (null != this.m_oCommManager) {
            for (int iCommandCode : COMMAND_CODES) {
                DCDebugTracer.trace("remove command code is " + iCommandCode);
                this.m_oCommManager.removeMessageListener(iCommandCode, (MSGListener)this);
            }
        }
        DCDebugTracer.trace("remove message listener end...");
    }

    public void addMessageListener() {
        DCDebugTracer.trace("add message listener start...");
        for (int iCommandCode : COMMAND_CODES) {
            DCDebugTracer.trace("add command code is " + iCommandCode);
            this.m_oCommManager.addMessageListener(iCommandCode, (MSGListener)this);
        }
        DCDebugTracer.trace("add message listener end...");
    }
}

