/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.log.util;

import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class LogTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 4872051127495991215L;
    private int topPos = 0;
    private int iTotalNum = 0;
    public static final int MAX_DATA_NUM = 200;
    private boolean bSortType = false;

    public void setSortType(boolean type) {
        this.bSortType = type;
    }

    public int checkDataPos(int startPos, int visibleRowNum) {
        int iStartRow = -1;
        int lastRowCount = startPos + visibleRowNum;
        if (this.bSortType) {
            lastRowCount = startPos = this.getRowCount() - startPos;
            startPos -= visibleRowNum;
        }
        if (lastRowCount > this.topPos + this.getDataCount()) {
            iStartRow = startPos + 200 > this.getRowCount() ? this.getRowCount() - 200 : startPos - 100;
        }
        if (startPos < this.topPos) {
            iStartRow = startPos > 100 ? startPos - 100 : 0;
        }
        if (iStartRow != -1) {
            ++iStartRow;
        }
        return iStartRow;
    }

    public void setTotalRowCount(int total) {
        this.iTotalNum = total;
    }

    public int getTopRowCount() {
        return this.topPos;
    }

    public int getDataCount() {
        if (this.dataVector == null) {
            return 0;
        }
        return this.dataVector.size();
    }

    public void setTopRowCount(int pos) {
        this.topPos = pos;
    }

    @Override
    public int getRowCount() {
        return this.iTotalNum;
    }

    public void setTableData(Vector vctTableData) {
        this.dataVector = vctTableData;
    }

    public LogTableModel(Object[] columnNames, int numRows) {
        super(columnNames, numRows);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.dataVector == null) {
            return "";
        }
        int startPos = this.topPos;
        if (this.bSortType) {
            startPos = this.getRowCount() - this.getDataCount() - this.topPos;
        }
        int dataPos = row - startPos;
        int iDataCount = this.dataVector.size();
        if (dataPos >= 0 && dataPos < iDataCount) {
            Vector data = (Vector)this.dataVector.get(dataPos);
            if (this.bSortType) {
                data = (Vector)this.dataVector.get(iDataCount - dataPos - 1);
            }
            if (data == null) {
                return "";
            }
            return data.get(col);
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void removeData() {
        this.iTotalNum = 0;
        this.bSortType = false;
        this.topPos = 0;
        this.dataVector = null;
        this.fireTableDataChanged();
    }
}

