/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.log.logcollection;

import com.swimap.iview.commstyle.resource.ResourceMng;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class LogCollectionUtil {
    public static final String Tracefile = "client/var/log";
    public static final String Debug = "server/debug";
    public static final String Log = "server/var/logs";
    public static final String About = "client/style/productstyle/conf/about";
    public static final String MDPLOG = "server/var/logs/mrblog";
    public static final String TracefilePath = "client/var";
    public static final String DebugPath = "server";
    public static final String LogPath = "server/var";
    public static final String AboutPath = "client/style/productstyle/conf";
    public static final String DCDBPath = "server/common/dc";
    public static final String NELicDBPath = "server/common/nelic";
    public static final String TracefileFOLDER = "log";
    public static final String DebugFOLDER = "debug";
    public static final String LogFOLDER = "logs";
    public static final String AboutFOLDER = "about";
    public static final String DCDBFOLDER = "DCDB";
    public static final String NELICDBFOLDER = "nelicdb";
    public static final int TRACE_FILE_INT = 0;
    public static final int LOG_INT = 1;
    public static final int ABOUT_INT = 2;
    public static final int DCDB_INT = 3;
    public static final int NELIC_DB_INT = 4;

    public static String getArchivedFolderString(int type) {
        switch (type) {
            case 0: {
                return "tracefile";
            }
            case 1: {
                return TracefileFOLDER;
            }
            case 2: {
                return AboutFOLDER;
            }
            case 3: {
                return "mrblog";
            }
        }
        return "";
    }

    public static void zipFile(String[] fileDirectroyArray, ZipOutputStream zos) throws IOException {
        if (fileDirectroyArray == null) {
            return;
        }
        for (int i = 0; i < fileDirectroyArray.length; ++i) {
            LogCollectionUtil.zipFile(fileDirectroyArray[i], zos, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(String fileDirectroy, ZipOutputStream zos, int type) throws IOException {
        if (null == fileDirectroy || "".equals(fileDirectroy)) {
            return;
        }
        File fd = new File(fileDirectroy);
        String[] fileList = fd.list();
        for (int i = 0; i < fileList.length; ++i) {
            File file = new File(fd, fileList[i]);
            if (file.isDirectory()) {
                LogCollectionUtil.zipFile(file.getPath(), zos, type);
                continue;
            }
            byte[] readBuffer = new byte[2056];
            int bytesin = 0;
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(file);
                ZipEntry anEntry = new ZipEntry(LogCollectionUtil.getArchivedFolderString(type) + File.separator + file.getName());
                zos.putNextEntry(anEntry);
                bytesin = fin.read(readBuffer);
                while (bytesin != -1) {
                    zos.write(readBuffer, 0, bytesin);
                    bytesin = fin.read(readBuffer);
                }
                continue;
            }
            finally {
                if (null != fin) {
                    fin.close();
                }
            }
        }
    }

    public static String getiMapInstallationPath() {
        File oCurrDir = new File(".");
        File oDC_Cli_Lib = new File(oCurrDir.getAbsolutePath());
        File oDC_Cli = oDC_Cli_Lib.getParentFile();
        if (null == oDC_Cli) {
            return "";
        }
        File oIMap = oDC_Cli.getParentFile();
        if (null == oIMap) {
            return "";
        }
        return oIMap.getAbsolutePath();
    }

    public static String generateZipFileName() {
        String pattern = "yyyyMMddHHmmss";
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, ResourceMng.getInstance().getLocale());
        Date today = new Date();
        String output = formatter.format(today);
        return output + "." + "zip";
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return false;
    }

    public static int getFileNumber(String[] fileDirectroyArray) {
        return new Counter().getFileNumber(fileDirectroyArray);
    }

    public static int getFileNumber(String fileDirectroy) {
        return new Counter().getFileNumber(fileDirectroy);
    }

    static class Counter {
        int number = 0;

        Counter(String[] fileDirectoryArray) {
        }

        Counter(String fileDirectoryArray) {
        }

        Counter() {
        }

        public int getFileNumber(String[] fileDirectroyArray) {
            for (int i = 0; i < fileDirectroyArray.length; ++i) {
                this.getFileNumber(fileDirectroyArray[i]);
            }
            return this.number;
        }

        public int getFileNumber(String fileDirectroy) {
            if (null == fileDirectroy || "".equals(fileDirectroy)) {
                return 0;
            }
            File file = new File(fileDirectroy);
            String[] fileList = file.list();
            if (null == fileList) {
                return this.number;
            }
            for (int i = 0; i < fileList.length; ++i) {
                if (new File(fileList[i]).isDirectory()) {
                    this.getFileNumber(fileList[i]);
                    continue;
                }
                ++this.number;
            }
            return this.number;
        }
    }
}

