/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.log.logcollection;

import com.huawei.dc.common.components.DCFilePathTextField;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.log.logcollection.LogCollectionUtil;
import com.swimap.iview.commstyle.resource.ResourceMng;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.Collator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogCollectionImportDialog
extends DCModalDialog {
    private static final long serialVersionUID = -5981455719968809483L;
    private JPanel panel;
    private JLabel importFilePathJLable;
    private DCFilePathTextField importFileTextField;
    private JButton importFilechooseButton;
    public SimpleProgressDlg zipProgressDlg;
    public boolean oMBCancelled = false;
    private static final String IMPORT_COLLECTION_SAVE_PATH_KEY = "IMPORT_COLLECTION_SAVE_PATH_KEY";

    public LogCollectionImportDialog() {
        this.jbinit();
        this.addListener();
        DCHelpManager.getInstance().enableF1HelpKey(this.getRootPane(), this.getCurrentContext());
    }

    public void jbinit() {
        this.setResizable(false);
        this.setSize(new Dimension(460, 130));
        this.setTitle(DCFrameWorkUtil.getLocalizedString("IMPORT_SYSTEM_FILES"));
        this.createComponent();
        this.addComponent();
    }

    public void createComponent() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.importFilePathJLable = new JLabel(DCFrameWorkUtil.getLocalizedString("IMPORT_FILE_PATH_JLABEL"));
        this.importFilePathJLable.setBackground(Color.black);
        this.importFilePathJLable.setPreferredSize(new Dimension(190, 20));
        this.importFileTextField = new DCFilePathTextField();
        this.importFileTextField.setPreferredSize(new Dimension(200, 22));
        String log_save_path = (String)ObjectStore.getInstance().getObjectInstance(IMPORT_COLLECTION_SAVE_PATH_KEY);
        if (null == log_save_path) {
            log_save_path = "";
        }
        this.importFileTextField.setText(log_save_path);
        this.importFilechooseButton = new JButton("...");
        this.importFilechooseButton.setPreferredSize(new Dimension(22, 22));
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oCancelBtn.setText(DCFrameWorkUtil.getLocalizedString("CANCEL_BUTTON"));
        this.m_oOKBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oOKBtn.setText(DCFrameWorkUtil.getLocalizedString("OK_BUTTON"));
        this.m_oOKBtn.setFocusable(true);
        this.m_oCancelBtn.setFocusable(true);
    }

    public void addComponent() {
        this.setLayout(new GridBagLayout());
        this.panel.add((Component)this.importFilePathJLable, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.panel.add((Component)this.importFileTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.importFilechooseButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(4, 0, 0, 10), 0, 0));
        this.getContentPane().add((Component)this.panel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 11, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.m_oOKBtn, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 12, 0, new Insets(5, 0, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.m_oCancelBtn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 10, 10), 0, 0));
    }

    public void addListener() {
        this.importFilechooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnValue;
                File dirSave;
                DCFileChooser oImportFileChooser = new DCFileChooser();
                oImportFileChooser.setTitle(DCFrameWorkUtil.getLocalizedString("SELECT_DIR"));
                oImportFileChooser.setFileSelectionMode(0);
                oImportFileChooser.setControlButtonsAreShown(true);
                oImportFileChooser.setFileFilter(32);
                oImportFileChooser.setAcceptAllFileFilterUsed(false);
                String strDefPath = (String)ObjectStore.getInstance().getObjectInstance(LogCollectionImportDialog.IMPORT_COLLECTION_SAVE_PATH_KEY);
                if (null != strDefPath && (dirSave = new File(strDefPath)).exists()) {
                    oImportFileChooser.setSelectedFile(dirSave);
                }
                if (0 != (returnValue = oImportFileChooser.showDialog((Component)((Object)LogCollectionImportDialog.this), ResourceManager.getInstance().getResString("OK")))) {
                    return;
                }
                LogCollectionImportDialog.this.importFileTextField.setText(oImportFileChooser.getSelectedFile().getAbsolutePath());
                LogCollectionImportDialog.this.importFileTextField.setToolTipText(oImportFileChooser.getSelectedFile().getAbsolutePath());
                ObjectStore.getInstance().putObjectInstance(LogCollectionImportDialog.IMPORT_COLLECTION_SAVE_PATH_KEY, LogCollectionImportDialog.this.importFileTextField.getText());
            }
        });
    }

    @Override
    public void oKButton_ActionPerformed() {
        String importPath = this.importFileTextField.getPath().trim();
        boolean bFileValid = this.isFileAndVersionValid(importPath);
        if (!bFileValid) {
            return;
        }
        this.closeDialog();
        int iConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CONFIRM_IMPORT_COLLECTION_INFO"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
        if (0 != iConfirm) {
            return;
        }
        this.unZipSystemFile();
    }

    public void unZipSystemFile() {
        this.zipProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("IMPORT_SYSTEM_ZIP_FILE"), ResourceManager.getInstance().getResString("IMPORTING_SYSTEM_ZIP_FILE"), false){
            private static final long serialVersionUID = 5567051255579569834L;

            @Override
            protected void initializeBtns() {
                this.initializeCancelBtn();
                this.initializeCloseBtn();
            }

            @Override
            protected void cancelButtonActionPerformed() {
                LogCollectionImportDialog.this.oMBCancelled = true;
            }
        };
        unZipFileThread oThread = new unZipFileThread();
        oThread.start();
        this.zipProgressDlg.setVisible(true);
    }

    public void zipFile(ZipFile zip) throws IOException {
    }

    private boolean isFileAndVersionValid(String sFilePath) {
        int iConfirm;
        boolean bValid = true;
        if (sFilePath.equals("")) {
            DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString(DCFrameWorkUtil.getLocalizedString("PROMPT_SELECT_SYSTEM_ZIP_FILE")), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
            return false;
        }
        String sVersion = LogCollectionImportDialog.getVersionFromZip(sFilePath);
        if ("".equals(sVersion)) {
            DCOptionPane.showMessageDialog((Component)((Object)this), DCFrameWorkUtil.getLocalizedString(DCFrameWorkUtil.getLocalizedString("MSG_LOG_COLLECTION_IMPORT_FILE_INVALID")), DCFrameWorkUtil.getLocalizedString("SYSTEM_INFO_ERROR"), 2);
            return false;
        }
        String sCurrrentDCVersion = this.getCurretnDCVersion();
        if (!Collator.getInstance().equals(sVersion, sCurrrentDCVersion) && (iConfirm = DCOptionPane.showConfirmDialog((Component)((Object)this), ResourceManager.getInstance().getResString("MSG_LOG_COLLECTION_IMPORT_DIFF_VERSION"), ResourceManager.getInstance().getResString("CONFIRM"), 0)) != 0) {
            return false;
        }
        return bValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersionFromZip(String zipname) {
        String sDestValidFileName1 = "about\\DC_package.xml";
        String sDestValidFileName2 = "about/DC_package.xml";
        FileInputStream oFileStream = null;
        ZipInputStream zin = null;
        BufferedReader in = null;
        String sVersion = "";
        try {
            oFileStream = new FileInputStream(zipname);
            zin = new ZipInputStream(oFileStream);
            boolean bVersionFlagFound = false;
            ZipEntry entry = zin.getNextEntry();
            while (null != entry) {
                if (entry.getName().equals(sDestValidFileName1) || entry.getName().equals(sDestValidFileName2)) {
                    in = new BufferedReader(new InputStreamReader(zin));
                    String s = in.readLine();
                    while (s != null) {
                        if (s.indexOf("package_version") > 0) {
                            bVersionFlagFound = true;
                        } else {
                            int iFlag = s.indexOf("value=");
                            if (bVersionFlagFound && iFlag > 0) {
                                int iFlag2 = s.lastIndexOf("\"");
                                sVersion = s.substring(iFlag + 7, iFlag2);
                                break;
                            }
                        }
                        s = in.readLine();
                    }
                    in.close();
                    break;
                }
                zin.closeEntry();
                entry = zin.getNextEntry();
            }
            zin.close();
        }
        catch (IOException e) {
            DCDebugTracer.trace(e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
            if (null != zin) {
                try {
                    zin.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
            if (null != oFileStream) {
                try {
                    oFileStream.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
        return sVersion.trim();
    }

    private String getCurretnDCVersion() {
        String sCurrentVersion = "";
        String strStyledir = ConfigurationInfo.getInstance().getProductStyleDir();
        String strAboutDirectoryName = strStyledir + "conf" + "/" + "about/DC_package.xml";
        String strAboutDirectoryNameBak = strStyledir + "conf" + "/" + "about/DC_package_patch.xml";
        Document oDocument = ConfigurationInfo.getInstance().loadDocumentFromFile(strAboutDirectoryName);
        if (null == oDocument) {
            oDocument = ConfigurationInfo.getInstance().loadDocumentFromFile(strAboutDirectoryNameBak);
        }
        sCurrentVersion = this.getPackageVersion(oDocument);
        return sCurrentVersion;
    }

    private String getPackageVersion(Document oDocument) {
        String strPckVersion = " ";
        NodeList oNodeList = null;
        Node oNode = null;
        String strLanguage = ConfigurationInfo.getInstance().getLocale().getLanguage().toUpperCase(ResourceMng.getInstance().getLocale());
        Element oRootNode = oDocument.getDocumentElement();
        oNodeList = this.getNodeList(oRootNode, "AREADESC");
        oNode = this.getNodebyAttributeValue(oNodeList, "areaname", "Package");
        oNodeList = this.getNodeList((Element)oNode, "DESC");
        oNode = this.getNodebyAttributeValue(oNodeList, "descname", "package_version");
        oNodeList = this.getNodeList((Element)oNode, "PARAS");
        oNode = oNodeList.item(0);
        oNodeList = this.getNodeList((Element)oNode, "PARA");
        oNode = this.getNodebyAttributeValue(oNodeList, "name", "DISPLAYNAME_" + strLanguage);
        strPckVersion = this.getNodeValue(oNode, "value");
        return strPckVersion;
    }

    private String getNodeValue(Node oNode, String strAttributeName) {
        String strNodeValue = " ";
        NamedNodeMap NodeValueMap = oNode.getAttributes();
        Node oNodevalue = NodeValueMap.getNamedItem(strAttributeName);
        strNodeValue = oNodevalue.getNodeValue();
        return strNodeValue;
    }

    private Node getNodebyAttributeValue(NodeList oNodeList, String strAttributeName, String strAttributValue) {
        Node oNode = null;
        for (int index = 0; index < oNodeList.getLength(); ++index) {
            oNode = oNodeList.item(index);
            String strNodeValue = this.getNodeValue(oNode, strAttributeName);
            if (!strNodeValue.equals(strAttributValue)) continue;
            return oNode;
        }
        return null;
    }

    private NodeList getNodeList(Element oElement, String strTagName) {
        NodeList oNodeList = oElement.getElementsByTagName(strTagName);
        return oNodeList;
    }

    @Override
    protected String getCurrentContext() {
        return ResourceManager.getInstance().getResString("HELP_TOPIC_COLLECT_LOG", "helpmapfile");
    }

    class unZipFileThread
    extends Thread {
        unZipFileThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DCDebugTracer.trace("[logCollect] unZipFileThread start");
            ZipFile zip = null;
            String filePath = LogCollectionImportDialog.this.importFileTextField.getPath().trim();
            try {
                zip = new ZipFile(filePath);
                LogCollectionImportDialog.this.zipFile(zip);
                if (!LogCollectionImportDialog.this.oMBCancelled) {
                    LogCollectionImportDialog.this.zipProgressDlg.updateProgress(100);
                    Thread.sleep(500L);
                    LogCollectionImportDialog.this.zipProgressDlg.setVisible(false);
                    LogCollectionImportDialog.this.zipProgressDlg.dispose();
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString(ResourceManager.getInstance().getResString("IMPORT_SYSTEM_FILES_SUCCESS")), ResourceManager.getInstance().getResString("INFO"), 1);
                }
            }
            catch (FileNotFoundException e) {
                LogCollectionImportDialog.this.zipProgressDlg.setVisible(false);
                LogCollectionImportDialog.this.zipProgressDlg.dispose();
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString(ResourceManager.getInstance().getResString("ERROR_MESSAGE_SYSTEM_ZIP_FILE")), ResourceManager.getInstance().getResString("SYSTEM_INFO_ERROR"), 0);
                DCDebugTracer.trace(e);
                LogCollectionUtil.deleteFile(filePath);
            }
            catch (IOException e) {
                LogCollectionImportDialog.this.zipProgressDlg.setVisible(false);
                LogCollectionImportDialog.this.zipProgressDlg.dispose();
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString(ResourceManager.getInstance().getResString("ERROR_MESSAGE_SYSTEM_ZIP_FILE_MEMERY_LACK")), ResourceManager.getInstance().getResString("SYSTEM_INFO_ERROR"), 0);
                DCDebugTracer.trace(e);
                LogCollectionUtil.deleteFile(filePath);
            }
            catch (InterruptedException e) {
                DCDebugTracer.trace(e);
                LogCollectionUtil.deleteFile(filePath);
            }
            finally {
                try {
                    if (zip != null) {
                        zip.close();
                    }
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
            DCDebugTracer.trace("[logCollect] unZipFileThread end..");
        }
    }
}

