/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.log.logcollection;

import com.huawei.dc.common.components.DCDateChooser;
import com.huawei.dc.common.components.DCFilePathTextField;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.log.logcollection.LogCollectionUtil;
import com.swimap.iview.commstyle.resource.ResourceMng;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class LogCollectionDialog
extends DCModalDialog {
    private static final long serialVersionUID = -5891350697029124067L;
    private JPanel panel;
    private JLabel pathJLable;
    private JButton filechooseButton;
    private DCFilePathTextField textField;
    private JCheckBox m_oByTimeChbox;
    private JLabel m_oLabelFrom;
    private JLabel m_oLabelTo;
    private DCDateChooser startTimeTxt;
    private String mStartTime;
    private DCDateChooser endTimeTxt;
    private String mEndTime;
    public static final String SAVE_PATH = "SAVE_PATH_COLLECTION_LOG";
    public static final String TITLE_LOG_COLLECTION_DIALOG = "TITLE_LOG_COLLECTION_DIALOG";
    public static final String OK_BUTTON_NAME = "OK_BUTTON";
    public static final String CANCEL_BUTTON_NAME = "CANCEL_BUTTON";
    public static final String PROMPT_SELECT_DIRECTORY_LOG_ZIP_FILE = "PROMPT_SELECT_DIRECTORY_LOG_ZIP_FILE";
    public SimpleProgressDlg zipProgressDlg;
    public boolean oMBCancelled = false;
    private static final String PORMPT_ZIP_LOG_FILE = "PORMPT_ZIP_LOG_FILE";
    private static final String LOG_COLLECTION_PROGROESS_TITLE = "TITLE_LOG_COLLECTION_DIALOG";
    private static final String DIRECTORY_CHOOSE = "SELECT_DIR";
    private static final String ERROR_MESSAGE_ZIP_LOG_FILE = "ERROR_MESSAGE_ZIP_LOG_FILE";
    private static final String TIME_FROM_JLABEL = "LOG_DETAIL_START_TIME_LBL";
    private static final String TIME_TO_JLABEL = "LOG_DETAIL_END_TIME_LBL";
    private static final String MESSAGE_LOG_COLLECT_SUCCESS = "MESSAGE_LOG_COLLECT_SUCCESS";
    private static final String LOG_FILTER_DIALOG_BY_TIME = "LOG_FILTER_DIALOG_BY_TIME";
    private static final String LOG_COLLECTION_SAVE_PATH_KEY = "LOG_COLLECTION_SAVE_PATH_KEY";
    private static final String ERROR_MESSAGE_ZIP_LOG_FILE_MEMERY_LACK = "ERROR_MESSAGE_ZIP_LOG_FILE_MEMERY_LACK";

    public LogCollectionDialog() {
        this.jbinit();
        this.addListener();
        boolean bByTimeSelected = this.m_oByTimeChbox.isSelected();
        this.m_oLabelFrom.setEnabled(bByTimeSelected);
        this.startTimeTxt.setTimeTextFieldEditable(bByTimeSelected);
        this.startTimeTxt.setEnabled(bByTimeSelected);
        this.m_oLabelTo.setEnabled(bByTimeSelected);
        this.endTimeTxt.setTimeTextFieldEditable(bByTimeSelected);
        this.endTimeTxt.setEnabled(bByTimeSelected);
        DCHelpManager.getInstance().enableF1HelpKey(this.getRootPane(), this.getCurrentContext());
    }

    public void jbinit() {
        this.setResizable(false);
        this.setSize(new Dimension(380, 240));
        this.setTitle(DCFrameWorkUtil.getLocalizedString("TITLE_LOG_COLLECTION_DIALOG"));
        this.createComponent();
        this.addComponent();
    }

    public void createComponent() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.pathJLable = new JLabel(DCFrameWorkUtil.getLocalizedString(SAVE_PATH));
        this.pathJLable.setBackground(Color.black);
        this.pathJLable.setPreferredSize(new Dimension(80, 20));
        this.textField = new DCFilePathTextField();
        this.textField.setPreferredSize(new Dimension(210, 22));
        this.textField.setMinimumSize(new Dimension(210, 22));
        String log_save_path = (String)ObjectStore.getInstance().getObjectInstance(LOG_COLLECTION_SAVE_PATH_KEY);
        if (null == log_save_path) {
            log_save_path = "";
        }
        this.textField.setText(log_save_path);
        this.filechooseButton = new JButton("...");
        this.filechooseButton.setPreferredSize(new Dimension(22, 22));
        this.filechooseButton.setMinimumSize(new Dimension(22, 22));
        this.m_oByTimeChbox = new JCheckBox(DCFrameWorkUtil.getLocalizedString(LOG_FILTER_DIALOG_BY_TIME));
        this.m_oByTimeChbox.setSelected(false);
        this.m_oLabelFrom = new JLabel(DCFrameWorkUtil.getLocalizedString(TIME_FROM_JLABEL));
        this.m_oLabelFrom.setPreferredSize(new Dimension(80, 20));
        this.m_oLabelTo = new JLabel(DCFrameWorkUtil.getLocalizedString(TIME_TO_JLABEL));
        this.m_oLabelTo.setPreferredSize(new Dimension(80, 20));
        this.startTimeTxt = new DCDateChooser(2);
        this.startTimeTxt.setName("From");
        this.startTimeTxt.setPreferredSize(new Dimension(180, 24));
        this.endTimeTxt = new DCDateChooser(2);
        this.endTimeTxt.setName("To");
        this.startTimeTxt.setPreferredSize(new Dimension(180, 24));
        this.m_oCancelBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oCancelBtn.setMinimumSize(new Dimension(80, 20));
        this.m_oOKBtn.setPreferredSize(new Dimension(80, 20));
        this.m_oOKBtn.setMinimumSize(new Dimension(80, 20));
        this.m_oOKBtn.setText(DCFrameWorkUtil.getLocalizedString(OK_BUTTON_NAME));
        this.m_oOKBtn.setFocusable(true);
        this.m_oCancelBtn.setFocusable(true);
        this.m_oCancelBtn.setText(DCFrameWorkUtil.getLocalizedString(CANCEL_BUTTON_NAME));
    }

    public void addComponent() {
        this.setLayout(new GridBagLayout());
        Border border1 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        JPanel oFilePathPanel = new JPanel();
        oFilePathPanel.setLayout(new GridBagLayout());
        oFilePathPanel.setBorder(border1);
        oFilePathPanel.add((Component)this.pathJLable, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(12, 12, 12, 0), 0, 0));
        oFilePathPanel.add((Component)this.textField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(12, 0, 12, 0), 0, 0));
        oFilePathPanel.add((Component)this.filechooseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 12, 12), 0, 0));
        JPanel oTimePanel = new JPanel();
        oTimePanel.setLayout(new GridBagLayout());
        oTimePanel.setBorder(border1);
        oTimePanel.add((Component)this.m_oByTimeChbox, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 11, 2, new Insets(12, 0, 0, 0), 0, 0));
        oTimePanel.add((Component)this.m_oLabelFrom, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        oTimePanel.add((Component)((Object)this.startTimeTxt), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 12, 1, new Insets(5, 12, 0, 12), 0, 0));
        oTimePanel.add((Component)this.m_oLabelTo, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 12, 0), 0, 0));
        oTimePanel.add((Component)((Object)this.endTimeTxt), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 12, 1, new Insets(5, 12, 12, 12), 0, 0));
        this.getContentPane().add((Component)oFilePathPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 11, 2, new Insets(12, 12, 0, 12), 0, 0));
        this.getContentPane().add((Component)oTimePanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 11, 2, new Insets(12, 12, 0, 12), 0, 0));
        this.getContentPane().add((Component)this.m_oOKBtn, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 12, 0, new Insets(12, 0, 12, 0), 0, 0));
        this.getContentPane().add((Component)this.m_oCancelBtn, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 4, 12, 12), 0, 0));
    }

    public void addListener() {
        this.filechooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnValue;
                File dirSave;
                String strPath = ConfigurationInfo.getInstance().getAbsoluteBaseDirectory() + File.separator + "report/";
                File defaultDir = new File(strPath);
                if (!defaultDir.exists()) {
                    try {
                        defaultDir.mkdir();
                    }
                    catch (Exception ex) {
                        DCDebugTracer.trace(ex);
                        return;
                    }
                }
                DCFileChooser oSaveasFileChooser = new DCFileChooser(strPath, false);
                oSaveasFileChooser.setTitle(DCFrameWorkUtil.getLocalizedString(LogCollectionDialog.DIRECTORY_CHOOSE));
                oSaveasFileChooser.setFileSelectionMode(1);
                oSaveasFileChooser.setControlButtonsAreShown(true);
                oSaveasFileChooser.displayPathName();
                String strDefPath = (String)ObjectStore.getInstance().getObjectInstance(LogCollectionDialog.LOG_COLLECTION_SAVE_PATH_KEY);
                if (null != strDefPath && (dirSave = new File(strDefPath)).exists()) {
                    oSaveasFileChooser.setCurrentDirectory(dirSave);
                }
                if (0 != (returnValue = oSaveasFileChooser.showDialog((Component)((Object)LogCollectionDialog.this), ResourceManager.getInstance().getResString("OK")))) {
                    return;
                }
                LogCollectionDialog.this.textField.setText(oSaveasFileChooser.getSelectedFile().getAbsolutePath());
                LogCollectionDialog.this.textField.setToolTipText(oSaveasFileChooser.getSelectedFile().getAbsolutePath());
                ObjectStore.getInstance().putObjectInstance(LogCollectionDialog.LOG_COLLECTION_SAVE_PATH_KEY, LogCollectionDialog.this.textField.getText());
            }
        });
        this.m_oByTimeChbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean bByTimeEnable = LogCollectionDialog.this.m_oByTimeChbox.isSelected();
                LogCollectionDialog.this.m_oLabelFrom.setEnabled(bByTimeEnable);
                LogCollectionDialog.this.startTimeTxt.setTimeTextFieldEditable(bByTimeEnable);
                LogCollectionDialog.this.startTimeTxt.setEnabled(bByTimeEnable);
                LogCollectionDialog.this.m_oLabelTo.setEnabled(bByTimeEnable);
                LogCollectionDialog.this.endTimeTxt.setTimeTextFieldEditable(bByTimeEnable);
                LogCollectionDialog.this.endTimeTxt.setEnabled(bByTimeEnable);
            }
        });
    }

    @Override
    public void oKButton_ActionPerformed() {
        String savePath = this.textField.getText().trim();
        if (savePath.equals("")) {
            DCOptionPane.showMessageDialog((Component)this.getContentPane(), DCFrameWorkUtil.getLocalizedString(DCFrameWorkUtil.getLocalizedString("FILE_PATH_BLANK")), DCFrameWorkUtil.getLocalizedString("WARNING"), 2);
            return;
        }
        if (this.m_oByTimeChbox.isSelected()) {
            Date oStartDate = this.startTimeTxt.getCalendar().getTime();
            Date oEndDate = this.endTimeTxt.getCalendar().getTime();
            String pattern = "yyyy-MM-dd";
            SimpleDateFormat formatter = new SimpleDateFormat(pattern, ResourceMng.getInstance().getLocale());
            this.mStartTime = formatter.format(oStartDate);
            this.mEndTime = formatter.format(oEndDate);
            if (this.mStartTime.compareTo(this.mEndTime) > 0) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_END_TIME_LESS_START_TIME"), ResourceManager.getInstance().getResString("ERROR"), 0);
                return;
            }
        }
        this.closeDialog();
        this.zipLogFile();
    }

    public void zipLogFile() {
        this.zipProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("TITLE_LOG_COLLECTION_DIALOG"), ResourceManager.getInstance().getResString(PORMPT_ZIP_LOG_FILE), false){
            private static final long serialVersionUID = 5095504277014679848L;

            @Override
            protected void initializeBtns() {
                this.initializeCancelBtn();
                this.initializeCloseBtn();
            }

            @Override
            protected void cancelButtonActionPerformed() {
                LogCollectionDialog.this.oMBCancelled = true;
            }
        };
        new zipFileThread().start();
        this.zipProgressDlg.setVisible(true);
    }

    public boolean validateFile(File file, int fileType, String timeFrom, String timeTo) throws IOException {
        String oCreateTime = this.getFileCreateTime(file);
        String oLastModifyTime = this.getFileModifyTime(file);
        if (2 == fileType || 3 == fileType || 4 == fileType) {
            return true;
        }
        if (1 == fileType) {
            String[] sNames = file.getName().split("_");
            int iLength = sNames.length;
            if (iLength < 3) {
                return true;
            }
            String sDate = sNames[iLength - 2];
            if (sDate.length() != 8) {
                return true;
            }
            StringBuffer createTimeByFileName = new StringBuffer();
            createTimeByFileName.append(sDate.substring(0, 4)).append("-").append(sDate.substring(4, 6)).append("-").append(sDate.subSequence(6, 8));
            String createTimeByFileNameStr = createTimeByFileName.toString();
            return (oCreateTime.compareTo(timeTo) <= 0 || createTimeByFileNameStr.compareTo(timeTo) <= 0) && oLastModifyTime.compareTo(timeFrom) >= 0;
        }
        return oCreateTime.compareTo(timeTo) <= 0 && oLastModifyTime.compareTo(timeFrom) >= 0;
    }

    public String getFileCreateTime(File file) throws IOException {
        String filePath = file.getAbsolutePath();
        Process ls_proc = Runtime.getRuntime().exec("cmd.exe /c dir \"" + filePath + "\" /tc");
        BufferedReader in = new BufferedReader(new InputStreamReader(ls_proc.getInputStream()));
        for (int i = 0; i < 5; ++i) {
            in.readLine();
        }
        String stuff = in.readLine();
        String date = "";
        if (null != stuff) {
            StringTokenizer st = new StringTokenizer(stuff);
            date = st.nextToken();
        }
        in.close();
        date = date.replace('/', '-');
        return date;
    }

    public String getFileModifyTime(File file) {
        Long time = file.lastModified();
        Date date = new Date();
        date.setTime(time);
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, ResourceMng.getInstance().getLocale());
        return formatter.format(date);
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_COLLECT_LOG";
    }

    class zipFileThread
    extends Thread {
        private int counter = 0;

        zipFileThread() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void zipFile(String[] fileDirectroyArray, ZipOutputStream zos, int fileNumber) throws IOException {
            DCDebugTracer.trace("[logCollect] zipFile start");
            DCDebugTracer.trace("[logCollect] fileNumber : " + fileNumber);
            if (fileDirectroyArray == null) {
                DCDebugTracer.trace("[logCollect] zipFile end.. fileDirectroyArray is null");
                return;
            }
            for (int i = 0; i < fileDirectroyArray.length && !LogCollectionDialog.this.oMBCancelled; ++i) {
                this.zipFile(fileDirectroyArray[i], zos, i, fileNumber);
            }
            DCDebugTracer.trace("[logCollect] zipFile end..");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zipFile(String fileDirectroy, ZipOutputStream zos, int type, int fileNumber) throws IOException {
            DCDebugTracer.trace("[logCollect] zipFile start");
            DCDebugTracer.trace("[logCollect] fileDirectroy : " + fileDirectroy);
            DCDebugTracer.trace("[logCollect] type : " + type);
            DCDebugTracer.trace("[logCollect] fileNumber : " + fileNumber);
            if (null == fileDirectroy || "".equals(fileDirectroy)) {
                return;
            }
            File fd = new File(fileDirectroy);
            String[] fileList = fd.list();
            if (null == fileList) {
                return;
            }
            DCDebugTracer.trace("[logCollect] file length : " + fileList.length);
            String filePath = null;
            byte[] readBuffer = null;
            FileInputStream fin = null;
            int index = -1;
            int bytesin = 0;
            for (int i = 0; i < fileList.length; ++i) {
                if (LogCollectionDialog.this.oMBCancelled) {
                    LogCollectionDialog.this.zipProgressDlg.updateProgress(100);
                    break;
                }
                File file = new File(fd, fileList[i]);
                if (file.isDirectory()) {
                    this.zipFile(file.getPath(), zos, type, fileNumber);
                    continue;
                }
                if (LogCollectionDialog.this.m_oByTimeChbox.isSelected() && !LogCollectionDialog.this.validateFile(file, type, LogCollectionDialog.this.mStartTime, LogCollectionDialog.this.mEndTime)) continue;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    DCDebugTracer.trace(e);
                }
                filePath = file.getPath();
                index = filePath.indexOf(LogCollectionUtil.getArchivedFolderString(type));
                if (-1 != index) {
                    filePath = filePath.substring(index);
                    DCDebugTracer.trace("[logCollect] filePath : " + filePath);
                } else {
                    filePath = LogCollectionUtil.getArchivedFolderString(type) + File.separator + file.getName();
                    DCDebugTracer.trace("[logCollect] filePath is not correct: " + filePath);
                }
                ZipEntry anEntry = new ZipEntry(filePath);
                zos.putNextEntry(anEntry);
                readBuffer = new byte[0x100000];
                bytesin = 0;
                try {
                    fin = new FileInputStream(file);
                    bytesin = fin.read(readBuffer);
                    while (bytesin != -1) {
                        zos.write(readBuffer, 0, bytesin);
                        bytesin = fin.read(readBuffer);
                    }
                }
                finally {
                    if (null != fin) {
                        fin.close();
                    }
                }
                ++this.counter;
                int percent = this.counter * 100 / fileNumber;
                if (percent >= 100) {
                    percent = 99;
                }
                LogCollectionDialog.this.zipProgressDlg.updateProgress(percent);
            }
            DCDebugTracer.trace("[logCollect] zipFile end..");
        }
    }
}

