/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.log;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCIntegerLst;
import com.huawei.dc.common.asndatacenter.AsnDCLogDeleteReq;
import com.huawei.dc.common.asndatacenter.AsnDCLogFilterCriteriaReq;
import com.huawei.dc.common.asndatacenter.AsnDCLogInfo;
import com.huawei.dc.common.asndatacenter.AsnDCLogInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCLogOperationRsp;
import com.huawei.dc.common.asndatacenter.AsnDCLogViewReq;
import com.huawei.dc.common.asndatacenter.AsnDCLogViewRsp;
import com.huawei.dc.common.asndatacenter.AsnDCSortColumnReq;
import com.huawei.dc.common.asndatacenter.AsnHAFailLogInfoRsp;
import com.huawei.dc.common.controller.AbstractDCMSGReceiver;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.log.ILogManager;
import com.huawei.dc.log.LogFilterCriteria;
import com.huawei.dc.log.LogInfo;
import com.huawei.dc.log.LogInfoPan;
import com.huawei.dc.log.LogOperationResponse;
import com.huawei.dc.security.ISecurityManager;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.math.BigInteger;
import java.util.Calendar;
import net.commustru.fstru.FStruct;

public class LogManagerImpl
extends AbstractDCMSGReceiver
implements ILogManager,
IDCObjectDeallocator {
    BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
    LogInfo[] currentLogs;
    ISecurityManager securityManager = DCFrameWorkUtil.getSecurityManager();
    private boolean m_bIsMsgToBeDisplayed = false;
    private boolean m_bBrowseLogWindowOpen = false;
    private static LogManagerImpl m_oLogManagerImpl;

    private LogManagerImpl() {
        super(new int[]{43837, 44012});
    }

    public static synchronized LogManagerImpl getInstance() {
        if (null == m_oLogManagerImpl) {
            m_oLogManagerImpl = new LogManagerImpl();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oLogManagerImpl);
        }
        return m_oLogManagerImpl;
    }

    @Override
    public void setToNULL() {
        if (null != m_oLogManagerImpl) {
            this.closeReceiver();
            this.commManager = null;
            this.securityManager = null;
            m_oLogManagerImpl = null;
        }
    }

    @Override
    public LogOperationResponse setLogFilterCriteria(int aSortColumn, LogFilterCriteria aFilterCriteria) throws DCException {
        int returnCode;
        final AsnDCLogFilterCriteriaReq asnLogFilterCriteriaReq = new AsnDCLogFilterCriteriaReq();
        asnLogFilterCriteriaReq.iClientId = BigInteger.valueOf(DCFrameWorkUtil.getSecurityManager().getClientId());
        asnLogFilterCriteriaReq.strdeviceTypeName = aFilterCriteria.getDeviceTypeName().getBytes();
        asnLogFilterCriteriaReq.strdeviceTypeVersionName = aFilterCriteria.getDeviceTypeVersionName().getBytes();
        asnLogFilterCriteriaReq.strClientIp = aFilterCriteria.getClientIPAddress().trim().equals("*.*.*.*".trim()) ? "ALL".getBytes() : aFilterCriteria.getClientIPAddress().getBytes();
        asnLogFilterCriteriaReq.strUserName = aFilterCriteria.getUserName().getBytes();
        asnLogFilterCriteriaReq.oDeviceOperationType.value = aFilterCriteria.getOperationType().getCode();
        asnLogFilterCriteriaReq.oResult.value = aFilterCriteria.getOperationResult();
        asnLogFilterCriteriaReq.sortColumnNumber.value = aSortColumn;
        asnLogFilterCriteriaReq.strDeviceName = aFilterCriteria.getDeviceName().getBytes();
        asnLogFilterCriteriaReq.strDeviceIPAddress = aFilterCriteria.getDeviceIPAddress().getBytes();
        Calendar operationStartTime = aFilterCriteria.getOperationStartTime();
        if (null != operationStartTime) {
            Calendar oCalendar = Calendar.getInstance();
            oCalendar.setTime(aFilterCriteria.getOperationStartTime().getTime());
            DCTimeDateUtil.switchToGMTCalendar(oCalendar);
            asnLogFilterCriteriaReq.oStartTime = oCalendar;
            asnLogFilterCriteriaReq.eTheFirstLog.value = 0;
        } else {
            asnLogFilterCriteriaReq.oStartTime = null;
            asnLogFilterCriteriaReq.eTheFirstLog.value = 1;
        }
        Calendar operationEndTime = aFilterCriteria.getOperationEndTime();
        if (null != operationEndTime) {
            Calendar oCalendar = Calendar.getInstance();
            oCalendar = Calendar.getInstance();
            oCalendar.setTime(aFilterCriteria.getOperationEndTime().getTime());
            DCTimeDateUtil.switchToGMTCalendar(oCalendar);
            asnLogFilterCriteriaReq.oEndTime = oCalendar;
            asnLogFilterCriteriaReq.eTheLastLog.value = 0;
        } else {
            asnLogFilterCriteriaReq.oEndTime = null;
            asnLogFilterCriteriaReq.eTheLastLog.value = 2;
        }
        AsnDCIntegerLst oAsnDCDeviceIdLstReq = this.securityManager.getAsnListOfDevices();
        if (null == oAsnDCDeviceIdLstReq) {
            oAsnDCDeviceIdLstReq = new AsnDCIntegerLst();
        }
        asnLogFilterCriteriaReq.oDeviceIdLst = oAsnDCDeviceIdLstReq;
        final AsnDCLogOperationRsp logOperationRsp = new AsnDCLogOperationRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager cfr_ignored_0 = LogManagerImpl.this.commManager;
                int errorcode = LogManagerImpl.this.commManager.sendSyncMsg(BaseCommManager.getMSGHead(43818), (FStruct)asnLogFilterCriteriaReq, (FStruct)logOperationRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && (returnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            throw new DCException(returnCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        int errorcode = logOperationRsp.oErrorInfo.iErrorNo.intValue();
        if (errorcode != 0) {
            throw new DCException(errorcode, ResourceManager.getInstance().getResString("REQUEST_FAIL"));
        }
        LogOperationResponse logOperationRes = new LogOperationResponse();
        if (logOperationRsp.iSelectedRowNumber != null) {
            logOperationRes.setSelectedRow(logOperationRsp.iSelectedRowNumber.intValue());
        } else {
            logOperationRes.setSelectedRow(0);
        }
        logOperationRes.setTotalRows(logOperationRsp.iTotalRowNumber.intValue());
        return logOperationRes;
    }

    @Override
    public LogInfo[] getViewLogInfo(int aStartRow, int anEndRow) throws DCException {
        AsnDCLogViewReq asnLogViewReq = new AsnDCLogViewReq();
        asnLogViewReq.iClientId = BigInteger.valueOf(DCFrameWorkUtil.getSecurityManager().getClientId());
        asnLogViewReq.iStartRowNumber = BigInteger.valueOf(aStartRow);
        asnLogViewReq.iEndRowNumber = BigInteger.valueOf(anEndRow);
        AsnDCLogViewRsp logInfoRsp = new AsnDCLogViewRsp();
        int errorcode = this.commManager.sendSyncMsg(BaseCommManager.getMSGHead(43819), (FStruct)asnLogViewReq, (FStruct)logInfoRsp);
        if (errorcode != 0) {
            throw new DCException(errorcode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        errorcode = logInfoRsp.oErrorInfo.iErrorNo.intValue();
        if (errorcode != 0) {
            throw new DCException(errorcode, ResourceManager.getInstance().getResString("REQUEST_FAIL"));
        }
        AsnDCLogInfoLst asnLogInfoLst = logInfoRsp.oDeviceLogInfoLst;
        int length = asnLogInfoLst.size();
        LogInfo[] logInfoList = new LogInfo[length];
        for (int i = 0; i < length; ++i) {
            logInfoList[i] = LogInfo.getLogInfoFromAsnStr((AsnDCLogInfo)asnLogInfoLst.elementAt(i));
        }
        this.currentLogs = logInfoList;
        return logInfoList;
    }

    public LogInfo[] getLogInfo(int aStartRow, int anEndRow) throws DCException {
        AsnDCLogViewReq asnLogViewReq = new AsnDCLogViewReq();
        asnLogViewReq.iClientId = BigInteger.valueOf(DCFrameWorkUtil.getSecurityManager().getClientId());
        asnLogViewReq.iStartRowNumber = BigInteger.valueOf(aStartRow);
        asnLogViewReq.iEndRowNumber = BigInteger.valueOf(anEndRow);
        AsnDCLogViewRsp logInfoRsp = new AsnDCLogViewRsp();
        int errorcode = this.commManager.sendSyncMsg(BaseCommManager.getMSGHead(43819), (FStruct)asnLogViewReq, (FStruct)logInfoRsp);
        if (errorcode != 0) {
            throw new DCException(errorcode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        errorcode = logInfoRsp.oErrorInfo.iErrorNo.intValue();
        if (errorcode != 0) {
            throw new DCException(errorcode, ResourceManager.getInstance().getResString("REQUEST_FAIL"));
        }
        AsnDCLogInfoLst asnLogInfoLst = logInfoRsp.oDeviceLogInfoLst;
        int length = asnLogInfoLst.size();
        LogInfo[] logInfoList = new LogInfo[length];
        for (int i = 0; i < length; ++i) {
            logInfoList[i] = LogInfo.getLogInfoFromAsnStr((AsnDCLogInfo)asnLogInfoLst.elementAt(i));
        }
        return logInfoList;
    }

    @Override
    public LogOperationResponse setSortColumn(int aSortColumn, int aSelectedRow) throws DCException {
        AsnDCSortColumnReq asnSortColumnReq = new AsnDCSortColumnReq();
        asnSortColumnReq.iClientId = BigInteger.valueOf(DCFrameWorkUtil.getSecurityManager().getClientId());
        asnSortColumnReq.iSelectedRowNum = BigInteger.valueOf(aSelectedRow);
        asnSortColumnReq.sortColumnNumber.value = aSortColumn;
        AsnDCLogOperationRsp logOperationRsp = new AsnDCLogOperationRsp();
        int errorcode = this.commManager.sendSyncMsg(BaseCommManager.getMSGHead(43817), (FStruct)asnSortColumnReq, (FStruct)logOperationRsp);
        if (errorcode != 0) {
            throw new DCException(errorcode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        errorcode = logOperationRsp.oErrorInfo.iErrorNo.intValue();
        if (errorcode != 0) {
            throw new DCException(errorcode, ResourceManager.getInstance().getResString("REQUEST_FAIL"));
        }
        LogOperationResponse logOperationRes = new LogOperationResponse();
        logOperationRes.setSelectedRow(logOperationRsp.iSelectedRowNumber.intValue());
        if (null == logOperationRsp.iTotalRowNumber) {
            throw new DCException(989855748, ResourceManager.getInstance().getResString("REQUEST_FAIL"));
        }
        logOperationRes.setTotalRows(logOperationRsp.iTotalRowNumber.intValue());
        return logOperationRes;
    }

    @Override
    public int deleteLog(int aStartRow, int anEndRow) {
        AsnDCLogDeleteReq asnLogDeleteReq = new AsnDCLogDeleteReq();
        asnLogDeleteReq.iClientId = BigInteger.valueOf(DCFrameWorkUtil.getSecurityManager().getClientId());
        asnLogDeleteReq.iStartRowNumber = BigInteger.valueOf(aStartRow);
        asnLogDeleteReq.iEndRowNumber = BigInteger.valueOf(anEndRow);
        AsnDCLogOperationRsp logOperationRsp = new AsnDCLogOperationRsp();
        int errorcode = this.commManager.sendSyncMsg(BaseCommManager.getMSGHead(43820), (FStruct)asnLogDeleteReq, (FStruct)logOperationRsp);
        if (errorcode != 0) {
            return errorcode;
        }
        return logOperationRsp.oErrorInfo.iErrorNo.intValue();
    }

    @Override
    public LogInfo getLogInfo(int logId) {
        if (this.currentLogs == null || this.currentLogs.length == 0) {
            return null;
        }
        int length = this.currentLogs.length;
        for (int i = 0; i < length; ++i) {
            if (logId != this.currentLogs[i].getLogId()) continue;
            return this.currentLogs[i];
        }
        return null;
    }

    protected void processMessage(MSGPacketExt mSGPacketExt) {
        try {
            DCDebugTracer.trace("receive asyn msg cmdCode=" + mSGPacketExt.mheader.cmdCode);
            if (mSGPacketExt.mheader.cmdCode == 43837 && this.m_bIsMsgToBeDisplayed && this.m_bBrowseLogWindowOpen) {
                this.displayMsgAndRefreshLogView();
            }
            if (mSGPacketExt.mheader.cmdCode == 44012) {
                AsnHAFailLogInfoRsp oAsnHAFailLogInfoRsp = new AsnHAFailLogInfoRsp();
                int iErrorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnHAFailLogInfoRsp, mSGPacketExt.getData());
                if (iErrorcode == 0) {
                    DCFrameWorkUtil.getLogInfoMgmtPanel().getHAPolicyLogInfoPanel().updateLogGUI(oAsnHAFailLogInfoRsp);
                }
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    public void displayMsgAndRefreshLogView() {
        block4: {
            if (!this.m_bIsMsgToBeDisplayed) {
                return;
            }
            try {
                LogInfoPan logInfoPan = DCFrameWorkUtil.getLogInfoMgmtPanel().getM_oLogInfoPanel();
                if (null != logInfoPan && null != logInfoPan.filterCriteriaComBox.toString()) {
                    logInfoPan.filterCriteriaComBoxActionPerformed();
                }
            }
            catch (Exception ex) {
                if (ex.getMessage() == "") break block4;
                DCDebugTracer.trace("DC::LogManagerImpl::displayMsgAndRefreshLogView()::throw exception::" + ex.getMessage());
            }
        }
    }

    @Override
    public void setDisplayStatus(boolean bStatus) {
        this.m_bIsMsgToBeDisplayed = bStatus;
    }

    public void clearLogInfo() {
        this.currentLogs = null;
    }
}

