/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.log;

import com.huawei.dc.common.components.dialog.ReportSaveFileFilter;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.framework.utility.print.tools.TablePrintable;
import com.huawei.dc.common.util.CodeValue;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.log.LogFilterCriteria;
import com.huawei.dc.log.LogInfo;
import com.huawei.dc.log.LogManagerImpl;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.swimap.iview.templates.extendedtable.SortButtonRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.JWindow;
import javax.swing.table.TableCellRenderer;

public class LogInfoPanHelper {
    public static final String STR_ROW = ResourceManager.getInstance().getResString("LOG_INFO_PAN_ROW");
    public static final String STR_COUNT = ResourceManager.getInstance().getResString("LOG_INFO_PAN_COUNT");
    public static final String STR_NUM = ResourceManager.getInstance().getResString("LOG_INFO_PAN_NO");
    public static final String LOG_INFO_ERROR = ResourceManager.getInstance().getResString("ERROR_MESSAGE_TITLE");
    public static final int MAX_DATA_NUM = 200;
    public static final int DEVICE_ID_COLUMN = 1;
    public static final int DEVICE_NAME_COLUMN = 2;
    public static final int DEVICE_IPADDRESS_COLUMN = 3;
    public static final int DETAIL_COLUMN = 10;
    public static final int MAX_ITEM_COUNT = 10;

    public static boolean clickBlockBar(int y, JScrollBar parent) {
        double barHeight = (double)parent.getVisibleRect().height - 2.0 * (double)parent.getVisibleRect().width;
        double tipHeight = 20.0;
        int startY = (int)((double)parent.getValue() * (barHeight -= 20.0) / (double)parent.getMaximum() + (double)parent.getVisibleRect().width);
        int endY = (int)((double)startY + 20.0);
        return y > startY && y < endY;
    }

    public static void showScrollTipWnd(int x, int y, Component parent, JWindow tipWnd) {
        Dimension parentSize = parent.getSize();
        if (y < parentSize.width) {
            y = parentSize.width;
        } else if (y + parentSize.width > parent.getSize().height) {
            y = parent.getSize().height - parentSize.width;
        }
        Point parentPos = parent.getLocationOnScreen();
        tipWnd.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension tipWndSize = tipWnd.getSize();
        int xPos = x + (int)parentPos.getX();
        int yPos = y + (int)parentPos.getY();
        xPos = parentPos.getX() + tipWndSize.getWidth() > screenSize.getWidth() ? (int)(parentPos.getX() - (double)tipWndSize.width) : (int)(parentPos.getX() + (double)parentSize.width);
        tipWnd.setLocation(xPos, yPos);
    }

    public static CodeValue[] createLogHeaders() {
        CodeValue[] headerCodeValue = new CodeValue[14];
        CodeValue logidCodeValue = new CodeValue();
        logidCodeValue.setCode(0);
        logidCodeValue.setValue(ResourceManager.getInstance().getResString("LOG_INFO_TABLE_TITLE_LOG_ID"));
        headerCodeValue[0] = logidCodeValue;
        CodeValue deviceidCodeValue = new CodeValue();
        deviceidCodeValue.setCode(1);
        deviceidCodeValue.setValue(ResourceManager.getInstance().getResString("NE_ID"));
        headerCodeValue[1] = deviceidCodeValue;
        CodeValue devNameCodeValue = new CodeValue();
        devNameCodeValue.setCode(2);
        devNameCodeValue.setValue(ResourceManager.getInstance().getResString("DEVICE_NAME"));
        headerCodeValue[2] = devNameCodeValue;
        CodeValue devIPAddressCodeValue = new CodeValue();
        devIPAddressCodeValue.setCode(3);
        devIPAddressCodeValue.setValue(ResourceManager.getInstance().getResString("LOG_INFO_TABLE_TITLE_DEVICE_IPADDRESS"));
        headerCodeValue[3] = devIPAddressCodeValue;
        CodeValue devTypeCodeValue = new CodeValue();
        devTypeCodeValue.setCode(4);
        devTypeCodeValue.setValue(ResourceManager.getInstance().getResString("LOG_INFO_TABLE_TITLE_DEVICE_TYPE"));
        headerCodeValue[4] = devTypeCodeValue;
        CodeValue devTypeVersionCodeValue = new CodeValue();
        devTypeVersionCodeValue.setCode(5);
        devTypeVersionCodeValue.setValue(ResourceManager.getInstance().getResString("LOG_INFO_TABLE_TITLE_DEVICE_TYPE_VERSION"));
        headerCodeValue[5] = devTypeVersionCodeValue;
        CodeValue userNameCodeValue = new CodeValue();
        userNameCodeValue.setCode(6);
        userNameCodeValue.setValue(ResourceManager.getInstance().getResString("LOG_INFO_TABLE_TITLE_USER_NAME"));
        headerCodeValue[6] = userNameCodeValue;
        CodeValue clientIPAddressCodeValue = new CodeValue();
        clientIPAddressCodeValue.setCode(7);
        clientIPAddressCodeValue.setValue(ResourceManager.getInstance().getResString("LOG_INFO_TABLE_TITLE_CLIENT_IPADDRESS"));
        headerCodeValue[7] = clientIPAddressCodeValue;
        CodeValue operationTypeCodeValue = new CodeValue();
        operationTypeCodeValue.setCode(8);
        operationTypeCodeValue.setValue(ResourceManager.getInstance().getResString("LOG_INFO_TABLE_TITLE_DEVICE_OP_TYPE"));
        headerCodeValue[8] = operationTypeCodeValue;
        CodeValue startTimeCodeValue = new CodeValue();
        startTimeCodeValue.setCode(9);
        startTimeCodeValue.setValue(ResourceManager.getInstance().getResString("LOG_INFO_TABLE_TITLE_DEVICE_START_TIME"));
        headerCodeValue[9] = startTimeCodeValue;
        CodeValue endTimeCodeValue = new CodeValue();
        endTimeCodeValue.setCode(10);
        endTimeCodeValue.setValue(ResourceManager.getInstance().getResString("LOG_INFO_TABLE_TITLE_DEVICE_END_TIME"));
        headerCodeValue[10] = endTimeCodeValue;
        CodeValue resultCodeValue = new CodeValue();
        resultCodeValue.setCode(11);
        resultCodeValue.setValue(ResourceManager.getInstance().getResString("LOG_INFO_TABLE_TITLE_DEVICE_OP_RESULT"));
        headerCodeValue[11] = resultCodeValue;
        CodeValue failureReasonCodeValue = new CodeValue();
        failureReasonCodeValue.setCode(12);
        failureReasonCodeValue.setValue(ResourceManager.getInstance().getResString("LOG_INFO_TABLE_TITLE_FAILURE_REASON"));
        headerCodeValue[12] = failureReasonCodeValue;
        CodeValue operationPathCodeValue = new CodeValue();
        operationPathCodeValue.setCode(0);
        operationPathCodeValue.setValue(ResourceManager.getInstance().getResString("LOG_INFO_TABLE_TITLE_DEVICE_OP_PATH"));
        headerCodeValue[13] = operationPathCodeValue;
        return headerCodeValue;
    }

    public static Vector createRowData(LogInfo logInfo) {
        Vector<String> rowData = new Vector<String>();
        rowData.add(logInfo.getDeviceName());
        rowData.add(logInfo.getDeviceIPAddress());
        rowData.add(logInfo.getDeviceTypeName());
        rowData.add(logInfo.getDeviceTypeVersionName());
        rowData.add(logInfo.getUserName());
        rowData.add(logInfo.getClientIPAddress());
        rowData.add(logInfo.getDisplayableOperationType());
        Calendar oCalendar = Calendar.getInstance();
        oCalendar.setTime(logInfo.getStartTime().getTime());
        DCTimeDateUtil.switchToLocalCalendar(oCalendar);
        rowData.add(DCTimeDateUtil.getLocaleDisplayTime(oCalendar));
        oCalendar = Calendar.getInstance();
        oCalendar.setTime(logInfo.getEndTime().getTime());
        DCTimeDateUtil.switchToLocalCalendar(oCalendar);
        rowData.add(DCTimeDateUtil.getLocaleDisplayTime(oCalendar));
        rowData.add(logInfo.getDisplayableOperationResult());
        rowData.add(logInfo.getDisplayableFailureReason());
        rowData.add(logInfo.getOperationFullPath());
        return rowData;
    }

    public static StringBuilder getTime() {
        Calendar instance = Calendar.getInstance();
        StringBuilder strTime = new StringBuilder("");
        strTime.append(instance.get(1));
        strTime.append(instance.get(2)).append(instance.get(5)).append(instance.get(11)).append(instance.get(12)).append(instance.get(13));
        return strTime;
    }

    public static DCFileChooser createSaveLogFileChooser() {
        DCFileChooser oFileChooserDlg = new DCFileChooser();
        StringBuilder strTime = LogInfoPanHelper.getTime();
        ReportSaveFileFilter oTxtFileFilter = new ReportSaveFileFilter(new String[]{"txt"}, ResourceManager.getInstance().getResString("TEXT_FILE"));
        ReportSaveFileFilter oHtmlFileFilter = new ReportSaveFileFilter(new String[]{"html"}, ResourceManager.getInstance().getResString("HTML_FILE"));
        ReportSaveFileFilter oCsvFileFilter = new ReportSaveFileFilter(new String[]{"csv"}, ResourceManager.getInstance().getResString("EXCEL_FILE"));
        oFileChooserDlg.setFileFilter(oTxtFileFilter);
        oFileChooserDlg.setFileFilter(oHtmlFileFilter);
        oFileChooserDlg.setFileFilter(oCsvFileFilter);
        oFileChooserDlg.setSelectedFile(new File(ResourceManager.getInstance().getResString("LOGININFOPAN_DEFAULT_FILE") + strTime.toString()));
        return oFileChooserDlg;
    }

    public static LogFilterCriteria createDefaultFilterCriteria() {
        LogFilterCriteria filterCriteria = new LogFilterCriteria();
        String deviceTypeName = "ALL";
        String deviceTypeVersionName = "ALL";
        String strIPAddress = "*.*.*.*";
        String strDeviceName = "ALL";
        String strUserName = "ALL";
        String strClientIPAddress = "*.*.*.*";
        int logResultCondition = 2;
        CodeValue allCodeValue = new CodeValue();
        allCodeValue.setCode(51);
        allCodeValue.setValue(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_ALL"));
        filterCriteria.setDeviceTypeName(deviceTypeName);
        filterCriteria.setDeviceTypeVersionName(deviceTypeVersionName);
        filterCriteria.setDeviceName(strDeviceName);
        filterCriteria.setDeviceIPAddress(strIPAddress);
        filterCriteria.setUserName(strUserName);
        filterCriteria.setClientIPAddress(strClientIPAddress);
        filterCriteria.setOperationResult(logResultCondition);
        filterCriteria.setOperationType(allCodeValue);
        Calendar endTime = TaskSyncCommController.getInstance().getCurrentServerTime(true);
        Calendar startTime = (Calendar)CloneUtil.getClone(endTime);
        startTime.set(10, startTime.get(10) - 24);
        filterCriteria.setOperationStartTime(startTime);
        filterCriteria.setIFirstLog(0);
        filterCriteria.setOperationEndTime(endTime);
        filterCriteria.setITheLastLog(0);
        return filterCriteria;
    }

    public static LogFilterCriteria createAllFilterCriteria() {
        LogFilterCriteria filterCriteria = new LogFilterCriteria();
        String deviceTypeName = "ALL";
        String deviceTypeVersionName = "ALL";
        String strIPAddress = "*.*.*.*";
        String strDeviceName = "ALL";
        String strUserName = "ALL";
        String strClientIPAddress = "*.*.*.*";
        int logResultCondition = 2;
        CodeValue allCodeValue = new CodeValue();
        allCodeValue.setCode(51);
        allCodeValue.setValue(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_ALL"));
        filterCriteria.setDeviceTypeName(deviceTypeName);
        filterCriteria.setDeviceTypeVersionName(deviceTypeVersionName);
        filterCriteria.setDeviceName(strDeviceName);
        filterCriteria.setDeviceIPAddress(strIPAddress);
        filterCriteria.setUserName(strUserName);
        filterCriteria.setClientIPAddress(strClientIPAddress);
        filterCriteria.setOperationResult(logResultCondition);
        filterCriteria.setOperationType(allCodeValue);
        filterCriteria.setIFirstLog(1);
        filterCriteria.setOperationStartTime(null);
        filterCriteria.setITheLastLog(2);
        filterCriteria.setOperationEndTime(null);
        return filterCriteria;
    }

    public static TableCellRenderer getTableRenderer() {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int iRow, int iCol) {
                String linkDesc;
                JLabel label = new JLabel();
                String msg = null;
                label.setOpaque(true);
                if (isSelected) {
                    label.setBackground(table.getSelectionBackground());
                    label.setForeground(Color.white);
                } else {
                    label.setBackground(table.getBackground());
                    label.setForeground(table.getForeground());
                }
                if (value instanceof String && value.equals(linkDesc = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(999293081L)))) {
                    msg = "<html><body><font color=blue><a href=''>" + linkDesc + "</a></font></body></html>";
                }
                if (null != value) {
                    if (null != msg) {
                        label.setText(msg);
                    } else {
                        label.setText(value.toString());
                    }
                    label.setToolTipText(value.toString());
                }
                return label;
            }
        };
    }

    public static Vector creteTableRowData(LogInfo logInfo) {
        Vector<Object> singleRowDataVector = new Vector<Object>();
        singleRowDataVector.add(logInfo.getLogId());
        singleRowDataVector.add(logInfo.getDeviceID());
        singleRowDataVector.add(logInfo.getDeviceName());
        singleRowDataVector.add(logInfo.getDeviceIPAddress());
        singleRowDataVector.add(logInfo.getDeviceTypeName());
        singleRowDataVector.add(logInfo.getDeviceTypeVersionName());
        singleRowDataVector.add(logInfo.getUserName());
        singleRowDataVector.add(logInfo.getClientIPAddress());
        singleRowDataVector.add(logInfo.getDisplayableOperationType());
        Calendar oCalendar = Calendar.getInstance();
        oCalendar.setTime(logInfo.getStartTime().getTime());
        DCTimeDateUtil.switchToLocalCalendar(oCalendar);
        singleRowDataVector.add(DCTimeDateUtil.getLocaleDisplayTime(oCalendar));
        oCalendar = Calendar.getInstance();
        oCalendar.setTime(logInfo.getEndTime().getTime());
        DCTimeDateUtil.switchToLocalCalendar(oCalendar);
        singleRowDataVector.add(DCTimeDateUtil.getLocaleDisplayTime(oCalendar));
        singleRowDataVector.add(logInfo.getDisplayableOperationResult());
        singleRowDataVector.add(logInfo.getDisplayableFailureReason());
        singleRowDataVector.add(logInfo.getOperationFullPath());
        return singleRowDataVector;
    }

    public static boolean checkLogCount(int iTotalRows) {
        boolean valid = true;
        if (iTotalRows <= 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("LOG_INFORMATION_EMPTY"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            valid = false;
        } else if (1000 < iTotalRows) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("LOG_INFORMATION_PREVIEW_MAX_ERROR"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            valid = false;
        }
        return valid;
    }

    public static void saveLogToFile(String strFileName, String[] strColumnName, Vector totalDataVec) {
        TablePrintable printable = null;
        String strHeader = ResourceManager.getInstance().getResString("LOG_DETAILS");
        String strUserName = DCFrameWorkUtil.getUserName();
        try {
            printable = new TablePrintable(strHeader, strUserName, " ", strColumnName, totalDataVec, totalDataVec.size(), true, totalDataVec.size());
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
            return;
        }
        String strFileType = null;
        strFileType = strFileName.endsWith(".html") || strFileName.endsWith(".htm") || strFileName.endsWith(".HTML") || strFileName.endsWith(".HTM") ? "html" : (strFileName.endsWith(".csv") || strFileName.endsWith(".CSV") ? "csv" : "txt");
        PrintSupportor.setIsCheckFileNameAndType(false);
        boolean bSaveSuccess = PrintSupportor.saveToFile((Window)DCFrameWorkUtil.getMainFrame(), strFileName, printable, strFileType);
        if (!bSaveSuccess) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_FAILURE"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
        }
    }

    public static void setColumnHeaders(JTable logTable) {
        SortButtonRenderer sortButtonRenderer = new SortButtonRenderer();
        for (int i = 0; i < logTable.getColumnCount(); ++i) {
            logTable.getColumnModel().getColumn(i).setHeaderRenderer((TableCellRenderer)sortButtonRenderer);
        }
    }

    public static void setLogFilter(LogFilterCriteria filterCriteria, JComboBox filterCriteriaComBox) {
        ActionListener[] actionListenerLst;
        LogManagerImpl logManager = LogManagerImpl.getInstance();
        logManager.setDisplayStatus(true);
        boolean isAlreadyExist = false;
        boolean bAllLogFilterExist = false;
        LogFilterCriteria oAllLogFilter = LogInfoPanHelper.createAllFilterCriteria();
        for (int i = 0; i < filterCriteriaComBox.getItemCount(); ++i) {
            LogFilterCriteria logFilter = (LogFilterCriteria)filterCriteriaComBox.getItemAt(i);
            if (null == logFilter) continue;
            if (i == 0 && logFilter.equals(oAllLogFilter)) {
                bAllLogFilterExist = true;
            }
            if (!logFilter.equals(filterCriteria)) continue;
            isAlreadyExist = true;
            break;
        }
        for (ActionListener actionListener : actionListenerLst = filterCriteriaComBox.getActionListeners()) {
            filterCriteriaComBox.removeActionListener(actionListener);
        }
        if (!bAllLogFilterExist) {
            filterCriteriaComBox.addItem(oAllLogFilter);
        }
        if (!isAlreadyExist) {
            if (filterCriteriaComBox.getItemCount() == 10) {
                filterCriteriaComBox.removeItemAt(9);
            }
            filterCriteriaComBox.insertItemAt(filterCriteria, 1);
        }
        for (ActionListener actionListener : actionListenerLst) {
            filterCriteriaComBox.addActionListener(actionListener);
        }
        if (filterCriteriaComBox.getItemCount() >= 1) {
            filterCriteriaComBox.setSelectedItem(filterCriteria);
            filterCriteriaComBox.setToolTipText(filterCriteria.toString());
        }
    }
}

