/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.log;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.PopupMenuManager;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.util.CodeValue;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCTimeDateFormat;
import com.huawei.dc.common.util.ResizeMouseMotionListener;
import com.huawei.dc.common.util.StatusBarManager;
import com.huawei.dc.deviceoperation.deviceconfigchange.DeviceConfigEventReceiver;
import com.huawei.dc.deviceoperation.deviceconfigchange.IDeviceConfigChangeListener;
import com.huawei.dc.file.util.SaveAsFileUtil;
import com.huawei.dc.log.LogDetailDlg;
import com.huawei.dc.log.LogFilterCriteria;
import com.huawei.dc.log.LogFilterDlg;
import com.huawei.dc.log.LogInfo;
import com.huawei.dc.log.LogInfoPanHelper;
import com.huawei.dc.log.LogManagerImpl;
import com.huawei.dc.log.LogOperationResponse;
import com.huawei.dc.log.util.LogShowTipWnd;
import com.huawei.dc.log.util.LogTableModel;
import com.huawei.u2000.component.table.customize.TableCustomizer;
import com.swimap.iview.templates.extendedtable.SortButtonRenderer;
import com.swimap.iview.templates.print.tools.TablePrintable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class LogInfoPan
extends JPanel
implements IDeviceConfigChangeListener {
    private static final long serialVersionUID = 1L;
    private String[] strTableHeader;
    private Vector totalDataVec = new Vector();
    private boolean isObtain = false;
    private boolean isReverse = false;
    private CodeValue[] headerCodeValue;
    private JScrollPane scrPan;
    private JTable logTable;
    private JButton filterBtn;
    public JComboBox filterCriteriaComBox;
    private int totalNoOfRecords = 0;
    protected LogTableModel tableModel;
    protected JScrollBar jResultBar = new JScrollBar();
    private JScrollBar tableScrollBar = null;
    private LogShowTipWnd showTipWnd = null;
    private int scrollPos = -1;
    private boolean bNewData = false;
    private int sortColumn = 0;
    private JPopupMenu logTablePopupMenu = null;
    LogDetailDlg logDetailDlg = null;
    LogFilterDlg filterLogDlg = null;
    boolean m_hasDeleteDeviceLogPrivilege = true;
    boolean operationResult = true;
    public LogInfoPan m_currentPan;
    private ResizeMouseMotionListener m_oResizeMotionListener;
    private SaveAsFileUtil oSaveAsFileUtil = new SaveAsFileUtil();
    private static final int NE_NAME_COL = 0;
    private static final int NE_GATEWAY_COL = 1;
    private static final int TYPE_COL = 2;

    public LogInfoPan() {
        try {
            LogManagerImpl.getInstance();
            this.headerCodeValue = LogInfoPanHelper.createLogHeaders();
            this.m_currentPan = this;
            this.jbInit();
            DeviceConfigEventReceiver.getInstance().resigterForConfigChangeEvent(this);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    public void defaultFilterLogByTime() {
        boolean operationResult = this.setLogFilter(LogInfoPanHelper.createDefaultFilterCriteria());
        DCDebugTracer.trace(" LogInfoPan#defaultFilterLogByTime : " + operationResult);
    }

    private void jbInit() throws Exception {
        this.showTipWnd = new LogShowTipWnd(DCOptionPane.getFrameForComponent(this));
        this.initTable();
        JTableHeader header = this.logTable.getTableHeader();
        this.initTableListener(header);
        this.scrPan = new JScrollPane();
        this.scrPan.setVerticalScrollBarPolicy(21);
        this.initResultBar();
        this.tableScrollBar = this.scrPan.getVerticalScrollBar();
        this.addTableHeaderListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LogInfoPan.this.tableHeadMousePressed(e);
            }
        });
        EtchedBorder border1 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        BorderLayout borderLayout1 = new BorderLayout();
        this.setLayout(borderLayout1);
        JSplitPane logSplitPane = new JSplitPane();
        logSplitPane.setOrientation(0);
        logSplitPane.setDividerSize(1);
        JPanel bottomPan = new JPanel();
        logSplitPane.setRightComponent(bottomPan);
        this.filterCriteriaComBox = new JComboBox();
        this.filterCriteriaComBox.setMaximumRowCount(10);
        this.filterCriteriaComBox.setName("Log_LogInfoPan_filterCriteriaComBox");
        this.filterCriteriaComBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogInfoPan.this.filterCriteriaComBoxActionPerformed();
            }
        });
        JPanel topPan = new JPanel();
        topPan.setBorder(border1);
        GridBagLayout gridBagLayout1 = new GridBagLayout();
        topPan.setLayout(gridBagLayout1);
        this.initFilterBtn();
        this.add((Component)logSplitPane, "Center");
        logSplitPane.add(bottomPan, "bottom", 0);
        logSplitPane.add((Component)topPan, "top");
        logSplitPane.setOneTouchExpandable(false);
        logSplitPane.setRequestFocusEnabled(false);
        logSplitPane.setFocusTraversalKeysEnabled(false);
        logSplitPane.setFocusable(false);
        logSplitPane.setEnabled(false);
        topPan.add((Component)this.filterCriteriaComBox, new GridBagConstraints(0, 0, 1, 2, 1.0, 0.0, 10, 2, new Insets(13, 17, 16, 0), 700, -5));
        topPan.add((Component)this.filterBtn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(-1, 12, 0, 60), 19, -5));
        bottomPan.setLayout(new BorderLayout());
        bottomPan.add((Component)this.scrPan, "Center");
        bottomPan.add((Component)this.jResultBar, "East");
        this.scrPan.getViewport().add((Component)this.logTable, null);
        PopupMenuManager popupMenuManager = PopupMenuManager.getInstance();
        this.logTablePopupMenu = popupMenuManager.load(this, "logtablepopupmenu");
        JMenuItem menuItem = (JMenuItem)popupMenuManager.getMenuItemMap().get("deleteLog");
        this.checkUserPrivileges();
        menuItem.setEnabled(this.m_hasDeleteDeviceLogPrivilege);
        this.logTablePopupMenu.setInvoker(this.logTable);
        popupMenuManager.resetFields();
        this.setName("Componenets_DataCenterMainPanel_m_oLogInfoPanel");
        DCHelpManager.getInstance().enableF1HelpKey(this, "HELP_TOPIC_LOGGING_INFORMATION");
    }

    private void checkUserPrivileges() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            return;
        }
        this.m_hasDeleteDeviceLogPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43820);
    }

    private void initResultBar() {
        this.jResultBar.addMouseListener(this.getResultbarMouseAdaptor());
        this.jResultBar.setMaximum(0);
        this.jResultBar.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                LogInfoPan.this.jResultBar_mouseDragged(e);
            }
        });
    }

    private void initFilterBtn() {
        this.filterBtn = new JButton();
        this.filterBtn.setName("Log_LogInfoPan_filterBtn");
        this.filterBtn.setText(ResourceManager.getInstance().getResString("LOG_INFO_PAN_FILTER_BTN"));
        this.filterBtn.setMnemonic('F');
        this.filterBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogInfoPan.this.browseButtonActionPerformed();
            }
        });
    }

    private void initTableListener(JTableHeader header) {
        this.m_oResizeMotionListener = new ResizeMouseMotionListener(this.m_currentPan, header);
        this.initHeaderListener(this.m_oResizeMotionListener);
        this.logTable.addMouseListener(this.getMouseListener());
        this.logTable.addMouseWheelListener(this.getMouseWheelListener());
        this.logTable.addKeyListener(this.getKeyAdaptor());
    }

    private void initHeaderListener(ResizeMouseMotionListener resizeMotionListener) {
        this.logTable.getTableHeader().addMouseMotionListener(resizeMotionListener);
        this.logTable.getTableHeader().addMouseListener(resizeMotionListener);
        this.logTable.getTableHeader().addMouseListener(this.geLogTableMouseAdapter());
    }

    private MouseAdapter geLogTableMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
    }

    private void initTable() {
        Object[] tableTitles = this.initTableHeader();
        this.tableModel = new LogTableModel(tableTitles, 0);
        this.logTable = new JTable();
        this.logTable.setName("Log_LogInfoPan_logTable");
        this.logTable.setSelectionMode(1);
        this.logTable.setModel(this.tableModel);
        LogInfoPanHelper.setColumnHeaders(this.logTable);
        this.logTable.getTableHeader().setReorderingAllowed(false);
        this.logTable.setRowHeight(20);
        TableCellRenderer tableCellRenderer = LogInfoPanHelper.getTableRenderer();
        for (int i = 0; i < tableTitles.length; ++i) {
            this.logTable.getColumnModel().getColumn(i).setCellRenderer(tableCellRenderer);
        }
        this.logTable.removeColumn(this.logTable.getColumn(this.headerCodeValue[0].getValue()));
        this.logTable.removeColumn(this.logTable.getColumn(this.headerCodeValue[1].getValue()));
        TableCustomizer oTableCustomizer = new TableCustomizer(this.logTable, "conf/dc/loginfo_table.xml");
        TableColumn[] oTableColumns = new TableColumn[3];
        oTableColumns[0] = this.logTable.getColumnModel().getColumn(0);
        oTableColumns[1] = this.logTable.getColumnModel().getColumn(1);
        oTableColumns[2] = this.logTable.getColumnModel().getColumn(2);
        oTableCustomizer.setNotAllowCustomizedColumns(Arrays.asList(oTableColumns));
    }

    private String[] initTableHeader() {
        String[] tableTitles = new String[this.headerCodeValue.length];
        this.strTableHeader = new String[this.headerCodeValue.length - 2];
        for (int i = 0; i < this.headerCodeValue.length; ++i) {
            tableTitles[i] = this.headerCodeValue[i].getValue();
            if (i <= 1) continue;
            this.strTableHeader[i - 2] = this.headerCodeValue[i].getValue();
        }
        return tableTitles;
    }

    private MouseAdapter getResultbarMouseAdaptor() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LogInfoPan.this.jResultBar_mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                LogInfoPan.this.jResultBar_mouseReleased(e);
            }
        };
    }

    private KeyAdapter getKeyAdaptor() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    LogInfoPan.this.deleteLog();
                }
            }
        };
    }

    private MouseWheelListener getMouseWheelListener() {
        return new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int notches = e.getWheelRotation();
                if (notches < 0) {
                    LogInfoPan.this.scrPan.getVerticalScrollBar().setValue(LogInfoPan.this.scrPan.getVerticalScrollBar().getValue() - 20 * e.getScrollAmount());
                } else {
                    LogInfoPan.this.scrPan.getVerticalScrollBar().setValue(LogInfoPan.this.scrPan.getVerticalScrollBar().getValue() + 20 * e.getScrollAmount());
                }
            }
        };
    }

    private MouseAdapter getMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LogInfoPan.this.logTable_mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                LogInfoPan.this.logTable_mousePressed(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                LogInfoPan.this.logTable_mouseClicked(e);
            }
        };
    }

    private void addTableHeaderListener(MouseListener l) {
        this.logTable.getTableHeader().addMouseListener(l);
    }

    private void addTableVertBarListener(AdjustmentListener l) {
        this.tableScrollBar.addAdjustmentListener(l);
    }

    private void addResultVertBarListener(AdjustmentListener l) {
        this.jResultBar.addAdjustmentListener(l);
    }

    private void tableHeadMousePressed(MouseEvent e) {
        if (0 == (0x10 & e.getModifiers())) {
            return;
        }
        int col = this.logTable.getTableHeader().columnAtPoint(e.getPoint());
        TableCellRenderer headRender = this.logTable.getColumnModel().getColumn(col).getHeaderRenderer();
        if (null == headRender) {
            return;
        }
        SortButtonRenderer sortRenderer = (SortButtonRenderer)headRender;
        int sortCol = this.logTable.convertColumnIndexToModel(col);
        if (sortCol != this.sortColumn) {
            int sortPos = this.logTable.getSelectedRow();
            if (sortPos == -1) {
                return;
            }
            if (sortRenderer.getState(this.sortColumn) == 2) {
                sortPos = this.totalNoOfRecords - sortPos - 1;
            }
            this.sortColumn = sortCol;
            int retPos = this.sortData(sortPos + 1);
            sortRenderer.clearSortFlag();
            sortRenderer.setSelectedColumn(this.sortColumn);
            this.tableModel.setSortType(false);
            this.jResultBar.setValue(retPos - 1);
            this.scrollPos = this.jResultBar.getValue();
            this.bNewData = true;
        } else {
            if (this.bNewData) {
                this.bNewData = false;
                this.scrollPos = this.jResultBar.getValue();
            }
            this.scrollPos = this.totalNoOfRecords - this.scrollPos - this.getTableVisibleRowNum();
            int selectedRow = this.logTable.getSelectedRow();
            if (selectedRow == -1) {
                return;
            }
            selectedRow = this.totalNoOfRecords - selectedRow - 1;
            if (sortRenderer.getState(sortCol) == 2) {
                this.tableModel.setSortType(true);
            } else {
                this.tableModel.setSortType(false);
            }
            this.jResultBar.setValue(this.scrollPos);
            this.logTable.setRowSelectionInterval(selectedRow, selectedRow);
        }
        sortRenderer.setPressedColumn(this.sortColumn);
        sortRenderer.setSelectedColumn(this.sortColumn);
        sortRenderer.repaint();
        this.logTable.getTableHeader().repaint();
        this.logTable.repaint();
    }

    private int sortData(int startRow) {
        LogManagerImpl logManager = LogManagerImpl.getInstance();
        int retSelectedPos = 0;
        LogInfo[] logInfoList = null;
        try {
            LogOperationResponse opResponse = logManager.setSortColumn(this.sortColumn, startRow);
            retSelectedPos = opResponse.getSelectedRow();
            this.totalNoOfRecords = opResponse.getTotalRows();
            if (this.totalNoOfRecords == 0) {
                this.tableModel.removeData();
                return 1;
            }
            int viewStartRow = retSelectedPos - 100;
            int viewEndRow = retSelectedPos + 100;
            if (viewStartRow < 1) {
                viewStartRow = 1;
                viewEndRow = viewStartRow + 200;
            }
            if (viewEndRow >= this.totalNoOfRecords) {
                viewEndRow = this.totalNoOfRecords;
            }
            if (retSelectedPos == this.totalNoOfRecords) {
                viewStartRow = this.totalNoOfRecords - 200;
                if (viewStartRow < 1) {
                    viewStartRow = 1;
                }
                viewEndRow = this.totalNoOfRecords;
            }
            if (this.totalNoOfRecords <= 200) {
                viewStartRow = 1;
                viewEndRow = this.totalNoOfRecords;
            }
            if ((logInfoList = logManager.getViewLogInfo(viewStartRow, viewEndRow)).length == 0) {
                DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("LOG_INFO_PAN_SORT_FAILED"), ResourceManager.getInstance().getResString("LOG_INFO_ERROR"), 0);
                return -1;
            }
            this.tableModel.setTopRowCount(viewStartRow - 1);
            this.tableModel.setTotalRowCount(this.totalNoOfRecords);
            this.setTotalNumberOfRecords(this.totalNoOfRecords, false);
            this.populateData(logInfoList);
            this.logTable.setRowSelectionInterval(retSelectedPos - 1, retSelectedPos - 1);
        }
        catch (DCException ex) {
            DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("LOG_INFO_PAN_SORT_FAILED"), ResourceManager.getInstance().getResString("LOG_INFO_ERROR"), 0);
            return -1;
        }
        return retSelectedPos;
    }

    private void jResultBar_mousePressed(MouseEvent e) {
        if (!LogInfoPanHelper.clickBlockBar(e.getY(), this.jResultBar)) {
            return;
        }
        this.showTipWnd.setVisible(true);
        this.showTipWnd.setShowTip(this.getTablePosTip());
        LogInfoPanHelper.showScrollTipWnd(e.getX(), e.getY(), this.jResultBar, this.showTipWnd);
        this.showTipWnd.pack();
    }

    private void jResultBar_mouseDragged(MouseEvent e) {
        if (!this.showTipWnd.isShowing()) {
            return;
        }
        this.showTipWnd.setShowTip(this.getTablePosTip());
        LogInfoPanHelper.showScrollTipWnd(e.getX(), e.getY(), this.jResultBar, this.showTipWnd);
        this.showTipWnd.pack();
    }

    private void jResultBar_mouseReleased(MouseEvent e) {
        this.showTipWnd.setVisible(false);
        int startRowCount = this.jResultBar.getValue();
        this.requestData(startRowCount + 1);
        this.syncPosFromBarToTable();
        this.updateUI();
    }

    private void requestData(int startRowCount) {
        int visibleRow = this.getTableVisibleRowNum();
        int max = this.jResultBar.getMaximum();
        int startRow = this.tableModel.checkDataPos(startRowCount, visibleRow);
        if (startRow > 0 && max > 0) {
            this.getDataFromServer(startRow);
            this.bNewData = true;
        }
    }

    private void getDataFromServer(int startRow) {
        try {
            LogManagerImpl logManager = LogManagerImpl.getInstance();
            LogInfo[] logInfoList = logManager.getViewLogInfo(startRow, startRow + 200);
            if (logInfoList.length == 0) {
                DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("LOG_INFO_PAN_NO_DATA_RECORDS_IN_ASN"), LogInfoPanHelper.LOG_INFO_ERROR, 0);
                return;
            }
            this.tableModel.setTopRowCount(startRow - 1);
            this.populateData(logInfoList);
            this.logTable.setRowSelectionInterval(startRow - 1, startRow - 1);
        }
        catch (DCException ex) {
            DCOptionPane.showMessageDialog((Component)this, ex.getErrorCode(), LogInfoPanHelper.LOG_INFO_ERROR, 0);
            this.jResultBar.setValue(this.tableModel.getTopRowCount());
            DCDebugTracer.trace(ex);
        }
    }

    private String getTablePosTip() {
        StringBuffer strTablePosTip = new StringBuffer();
        int showNum = this.getTableVisibleRowNum();
        int minNum = this.jResultBar.getValue();
        int maxNum = minNum + showNum;
        ++minNum;
        if (maxNum > this.totalNoOfRecords) {
            maxNum = this.totalNoOfRecords;
        }
        strTablePosTip.append(LogInfoPanHelper.STR_NUM).append(minNum).append("~").append(maxNum).append(LogInfoPanHelper.STR_ROW).append(",").append(LogInfoPanHelper.STR_COUNT).append(this.totalNoOfRecords).append(LogInfoPanHelper.STR_ROW);
        return strTablePosTip.toString();
    }

    public int getTableVisibleRowNum() {
        return (this.scrPan.getVisibleRect().height + 4) / this.logTable.getRowHeight();
    }

    public void syncPosFromBarToTable() {
        int oldValue;
        int maxVal;
        int value = this.jResultBar.getValue();
        if ((value *= this.logTable.getRowHeight()) > (maxVal = this.tableScrollBar.getMaximum())) {
            value = maxVal;
        }
        if (value == (oldValue = this.tableScrollBar.getValue())) {
            return;
        }
        this.tableScrollBar.setValue(value);
    }

    private void syncPosFromTableToBar() {
        int oldValue;
        int showNum = this.getTableVisibleRowNum();
        if (this.totalNoOfRecords > showNum) {
            this.jResultBar.setMaximum(this.totalNoOfRecords - showNum + 1);
        } else {
            this.jResultBar.setMaximum(0);
        }
        int value = this.tableScrollBar.getValue();
        int maxVal = this.jResultBar.getMaximum();
        int iTemp = value / this.logTable.getRowHeight();
        if (value > iTemp * this.logTable.getRowHeight()) {
            if ((value /= this.logTable.getRowHeight()) + 1 == maxVal) {
                ++value;
            }
        } else {
            value /= this.logTable.getRowHeight();
        }
        if (value > maxVal) {
            value = maxVal;
        }
        if (value == (oldValue = this.jResultBar.getValue())) {
            return;
        }
        this.jResultBar.setValue(value);
    }

    private void setTotalNumberOfRecords(int totalRecord, boolean bIsFirstTime) {
        this.jResultBar.addAdjustmentListener(null);
        this.tableScrollBar.addAdjustmentListener(null);
        this.jResultBar.setValue(0);
        this.tableScrollBar.setValue(0);
        this.totalNoOfRecords = totalRecord;
        if (bIsFirstTime) {
            this.sortColumn = 0;
        }
        int showNum = this.getTableVisibleRowNum();
        if (totalRecord > 0) {
            if (this.totalNoOfRecords > showNum) {
                this.jResultBar.setMaximum(totalRecord - showNum + 1);
            } else {
                this.jResultBar.setMaximum(0);
            }
        }
        this.tableModel.setSortType(false);
        this.addTableVertBarListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                LogInfoPan.this.jTableVertBar_adjustmentValueChanged(e);
            }
        });
        this.addResultVertBarListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                LogInfoPan.this.jResultVertBar_adjustmentValueChanged(e);
            }
        });
    }

    private void jTableVertBar_adjustmentValueChanged(AdjustmentEvent e) {
        this.syncPosFromTableToBar();
    }

    private void jResultVertBar_adjustmentValueChanged(AdjustmentEvent e) {
        if (this.showTipWnd.isShowing()) {
            return;
        }
        int startRowCount = this.jResultBar.getValue();
        this.requestData(startRowCount);
        this.syncPosFromBarToTable();
        this.logTable.repaint();
        this.logTable.updateUI();
        this.updateUI();
    }

    private void populateData(LogInfo[] logList) {
        if (null == logList) {
            return;
        }
        int noOfLogs = logList.length;
        Vector<Vector> tableData = new Vector<Vector>(noOfLogs);
        for (int i = 0; i < noOfLogs; ++i) {
            tableData.add(LogInfoPanHelper.creteTableRowData(logList[i]));
        }
        this.tableModel.setTableData(tableData);
    }

    private void getData(LogInfo[] logList) {
        if (null == logList) {
            return;
        }
        int noOfLogs = logList.length;
        if (this.isReverse) {
            for (int i = noOfLogs - 1; i >= 0; --i) {
                this.totalDataVec.add(LogInfoPanHelper.createRowData(logList[i]));
            }
        } else {
            for (int i = 0; i < noOfLogs; ++i) {
                this.totalDataVec.add(LogInfoPanHelper.createRowData(logList[i]));
            }
        }
    }

    private void logTable_mousePressed(MouseEvent e) {
        if (0 == (0x10 & e.getModifiers())) {
            int iSelectedRow = this.logTable.rowAtPoint(e.getPoint());
            boolean bSelectRow = true;
            int[] nRows = this.logTable.getSelectedRows();
            if (nRows.length > 1) {
                for (int i = 0; i < nRows.length; ++i) {
                    if (nRows[i] != iSelectedRow) continue;
                    bSelectRow = false;
                    break;
                }
            }
            if (bSelectRow) {
                ListSelectionModel selectionModel = this.logTable.getSelectionModel();
                selectionModel.setSelectionInterval(iSelectedRow, iSelectedRow);
            }
            this.logTablePopupMenu.show(this.logTable, e.getX(), e.getY());
        }
    }

    private void logTable_mouseClicked(MouseEvent e) {
        Point pointCursor;
        int intCol;
        if (null == DCFrameWorkUtil.getStatusBarManager()) {
            StatusBarManager m_statusBarManager = new StatusBarManager(new JPanel());
            m_statusBarManager.setIPAddress(DCFrameWorkUtil.getServerIP());
            DCFrameWorkUtil.setStatusBarManager(m_statusBarManager);
        }
        DCFrameWorkUtil.getStatusBarManager().setComment(ResourceManager.getInstance().getResString("LOG_INFO_PAN_COMMENT"));
        if (e.getClickCount() >= 2) {
            this.showDetailDlg();
        }
        if (e.getClickCount() == 1 && (intCol = this.logTable.columnAtPoint(pointCursor = e.getPoint())) == 10) {
            this.showDetailDlg();
        }
    }

    private void showDetailDlg() {
        int selectedRow = this.logTable.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        int logId = (Integer)this.tableModel.getValueAt(selectedRow, 0);
        LogInfo selectedLog = LogManagerImpl.getInstance().getLogInfo(logId);
        if (this.logDetailDlg == null) {
            this.logDetailDlg = new LogDetailDlg(this);
        }
        if (!this.logDetailDlg.isVisible()) {
            if (selectedRow == 0) {
                if (this.totalNoOfRecords == 1) {
                    this.logDetailDlg.setLogInformation(selectedLog, true, true);
                } else {
                    this.logDetailDlg.setLogInformation(selectedLog, true, false);
                }
            } else if (selectedRow == this.totalNoOfRecords - 1) {
                this.logDetailDlg.setLogInformation(selectedLog, false, true);
            } else {
                this.logDetailDlg.setLogInformation(selectedLog, false, false);
            }
            this.logDetailDlg.setVisible(true);
        }
        this.logDetailDlg = null;
    }

    public void deleteLog() {
        block15: {
            int[] selectedRows = this.logTable.getSelectedRows();
            if (null == selectedRows || 0 == selectedRows.length) {
                return;
            }
            int output = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("LOG_INFO_PAN_CONFIRM_DELETE_LOG"), ResourceManager.getInstance().getResString("CONFIRM"), 0);
            if (output == 0) {
                int resultBar = this.jResultBar.getValue();
                LogManagerImpl logManager = LogManagerImpl.getInstance();
                int opResponse = logManager.deleteLog(selectedRows[0] + 1, selectedRows[selectedRows.length - 1] + 1);
                if (opResponse != 0) {
                    DCOptionPane.showMessageDialog((Component)this, opResponse, ResourceManager.getInstance().getResString("ERROR_MESSAGE_TITLE"), 0);
                    return;
                }
                this.totalNoOfRecords -= selectedRows.length;
                if (this.totalNoOfRecords == 0) {
                    this.tableModel.removeData();
                    return;
                }
                try {
                    LogInfo[] logList;
                    int startRow = selectedRows[0] - 100;
                    int endRow = selectedRows[0] + 100;
                    if (startRow < 1) {
                        startRow = 1;
                        endRow = startRow + 200;
                    }
                    if (endRow >= this.totalNoOfRecords) {
                        endRow = this.totalNoOfRecords;
                    }
                    if (selectedRows[0] == this.totalNoOfRecords) {
                        startRow = this.totalNoOfRecords - 200;
                        if (startRow < 1) {
                            startRow = 1;
                        }
                        endRow = this.totalNoOfRecords;
                    }
                    if (this.totalNoOfRecords <= 200) {
                        startRow = 1;
                        endRow = this.totalNoOfRecords;
                    }
                    if ((logList = logManager.getViewLogInfo(startRow, endRow)).length > 0) {
                        this.tableModel.setTopRowCount(startRow - 1);
                        this.tableModel.setTotalRowCount(this.totalNoOfRecords);
                        this.setTotalNumberOfRecords(this.totalNoOfRecords, true);
                        this.populateData(logList);
                        if (resultBar > 0) {
                            this.jResultBar.setValue(resultBar - selectedRows.length);
                        }
                        if (selectedRows[0] == this.totalNoOfRecords) {
                            this.logTable.setRowSelectionInterval(selectedRows[0] - 1, selectedRows[0] - 1);
                        } else {
                            this.logTable.setRowSelectionInterval(selectedRows[0], selectedRows[0]);
                        }
                        break block15;
                    }
                    DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("LOG_INFO_PAN_NO_RECORD_IN_ASN"), ResourceManager.getInstance().getResString("LOG_INFO_ERROR"), 0);
                    return;
                }
                catch (DCException ex) {
                    DCOptionPane.showMessageDialog((Component)this, ex.getErrorCode(), LogInfoPanHelper.LOG_INFO_ERROR, 0);
                    this.tableModel.removeData();
                }
            }
        }
        this.logTable.updateUI();
    }

    public void browseButtonActionPerformed() {
        this.filterLogDlg = new LogFilterDlg(this);
    }

    public boolean setLogFilter(LogFilterCriteria filterCriteria) {
        LogInfoPanHelper.setLogFilter(filterCriteria, this.filterCriteriaComBox);
        return this.operationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterCriteriaComBoxActionPerformed() {
        block15: {
            this.operationResult = true;
            LogFilterCriteria filterCriteria = (LogFilterCriteria)this.filterCriteriaComBox.getSelectedItem();
            LogManagerImpl logManager = LogManagerImpl.getInstance();
            int tolalNumOfRecords = 0;
            this.tableModel.removeData();
            try {
                LogOperationResponse opResponse = logManager.setLogFilterCriteria(this.sortColumn, filterCriteria);
                tolalNumOfRecords = opResponse.getTotalRows();
            }
            catch (DCException ex) {
                if (this.filterLogDlg != null && this.filterLogDlg.isVisible()) {
                    DCOptionPane.showMessageDialog((Component)((Object)this.filterLogDlg), ex.getErrorCode(), LogInfoPanHelper.LOG_INFO_ERROR, 0);
                } else {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ex.getErrorCode(), LogInfoPanHelper.LOG_INFO_ERROR, 0);
                }
                this.filterCriteriaComBox.setToolTipText(filterCriteria.toString());
                this.operationResult = false;
                return this.operationResult;
            }
            this.filterCriteriaComBox.setToolTipText(filterCriteria.toString());
            try {
                LogInfo[] logList = null;
                logList = tolalNumOfRecords <= 200 ? logManager.getViewLogInfo(1, tolalNumOfRecords) : logManager.getViewLogInfo(1, 200);
                if (logList.length > 0) {
                    LogInfoPanHelper.setColumnHeaders(this.logTable);
                    this.tableModel.setTopRowCount(0);
                    this.populateData(logList);
                    break block15;
                }
                if (this.filterLogDlg != null && this.filterLogDlg.isVisible()) {
                    DCOptionPane.showMessageDialog((Component)((Object)this.filterLogDlg), ResourceManager.getInstance().getResString("LOG_INFO_PAN_NO_DATA_RECORDS_IN_ASN"), LogInfoPanHelper.LOG_INFO_ERROR, 0);
                } else {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("LOG_INFO_PAN_NO_DATA_RECORDS_IN_ASN"), LogInfoPanHelper.LOG_INFO_ERROR, 0);
                }
                boolean bl = this.operationResult = false;
                return bl;
            }
            catch (DCException ex) {
                if (this.filterLogDlg != null && this.filterLogDlg.isVisible()) {
                    DCOptionPane.showMessageDialog((Component)((Object)this.filterLogDlg), ex.getErrorCode(), LogInfoPanHelper.LOG_INFO_ERROR, 0);
                } else {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ex.getErrorCode(), LogInfoPanHelper.LOG_INFO_ERROR, 0);
                }
                this.tableModel.removeData();
                boolean bl = this.operationResult = false;
                return bl;
            }
            finally {
                this.tableModel.setTotalRowCount(tolalNumOfRecords);
                this.tableModel.setTopRowCount(0);
                this.setTotalNumberOfRecords(tolalNumOfRecords, true);
                if (tolalNumOfRecords > 0) {
                    this.logTable.setRowSelectionInterval(0, 0);
                }
                this.logTable.updateUI();
                this.updateUI();
            }
        }
        return this.operationResult;
    }

    public void getPreviousLog() {
        int resultBar;
        int selectedRow = this.logTable.getSelectedRow();
        if (selectedRow < this.totalNoOfRecords - this.getTableVisibleRowNum() && (resultBar = this.jResultBar.getValue()) > 0) {
            this.jResultBar.setValue(resultBar - 1);
        }
        int logId = (Integer)this.tableModel.getValueAt(selectedRow - 1, 0);
        this.logTable.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
        LogInfo selectedLog = LogManagerImpl.getInstance().getLogInfo(logId);
        if (selectedRow == 1) {
            this.logDetailDlg.setLogInformation(selectedLog, true, false);
        } else {
            this.logDetailDlg.setLogInformation(selectedLog, false, false);
        }
    }

    public void getNextLog() {
        int selectedRow = this.logTable.getSelectedRow();
        if (selectedRow > this.getTableVisibleRowNum()) {
            int resultBar = this.jResultBar.getValue();
            if (selectedRow <= this.totalNoOfRecords) {
                this.jResultBar.setValue(resultBar + 1);
            }
        }
        int logId = (Integer)this.tableModel.getValueAt(selectedRow + 1, 0);
        LogInfo selectedLog = LogManagerImpl.getInstance().getLogInfo(logId);
        this.logTable.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
        if (selectedRow == this.totalNoOfRecords - 2) {
            this.logDetailDlg.setLogInformation(selectedLog, false, true);
        } else {
            this.logDetailDlg.setLogInformation(selectedLog, false, false);
        }
    }

    public void setHelpKeyValue(String strHelpKeyValue) {
        DCHelpManager.getInstance().enableF1HelpKey(this, strHelpKeyValue);
    }

    public void saveButtonActionPerformed() {
        if (!LogInfoPanHelper.checkLogCount(this.logTable.getRowCount())) {
            return;
        }
        PrintSupportor.setIsFileSelection(false);
        DCFileChooser oFileChooserDlg = LogInfoPanHelper.createSaveLogFileChooser();
        int iReturnVal = -1;
        iReturnVal = oFileChooserDlg.showDialog(DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("LOGININFOPAN_DEFAULT_FILE"));
        if (iReturnVal == 0) {
            String strFileName = oFileChooserDlg.getFullFileName();
            if (strFileName.endsWith(".html") || strFileName.endsWith(".htm") || strFileName.endsWith(".txt") || strFileName.endsWith(".csv") || strFileName.endsWith(".HTML") || strFileName.endsWith(".HTM") || strFileName.endsWith(".TXT") || strFileName.endsWith(".CSV")) {
                this.saveRecords(strFileName);
            } else {
                DCOptionPane.showMessageDialog((Component)this, ResourceManager.getInstance().getResString("AUTO_UPGRADE_DEVICE_TABLE_FILE_TYPE_NOT_SUPP"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
            }
        }
    }

    private void saveRecords(final String strFileName) {
        if (!this.isObtain) {
            this.getAllDataFromServer();
        }
        int iColumnCount = this.logTable.getColumnCount();
        final String[] strColumnName = new String[iColumnCount];
        for (int i = 0; i < iColumnCount; ++i) {
            strColumnName[i] = this.logTable.getColumnName(i);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogInfoPanHelper.saveLogToFile(strFileName, strColumnName, LogInfoPan.this.totalDataVec);
            }
        });
    }

    private void getAllDataFromServer() {
        block13: {
            try {
                this.totalDataVec.removeAllElements();
                LogManagerImpl logManager = LogManagerImpl.getInstance();
                if (200 < this.totalNoOfRecords) {
                    int m;
                    if (this.isReverse) {
                        for (m = this.totalNoOfRecords; m > 0; m -= 200) {
                            LogInfo[] logList = null;
                            if (m - 200 > 0) {
                                logList = logManager.getViewLogInfo(m - 200, m);
                                this.getData(logList);
                                continue;
                            }
                            logList = logManager.getViewLogInfo(0, m);
                            this.getData(logList);
                        }
                    } else {
                        for (m = 1; m < this.totalNoOfRecords; m += 200) {
                            LogInfo[] logList = null;
                            if (m + 200 < this.totalNoOfRecords) {
                                logList = logManager.getViewLogInfo(m, m + 200 - 1);
                                this.getData(logList);
                                continue;
                            }
                            logList = logManager.getViewLogInfo(m, this.totalNoOfRecords);
                            this.getData(logList);
                        }
                    }
                    this.isObtain = true;
                    break block13;
                }
                int iRowCount = this.logTable.getRowCount();
                int iColumnCount = this.logTable.getModel().getColumnCount() - 2;
                for (int i = 0; i < iRowCount; ++i) {
                    Vector<String> rowData = new Vector<String>();
                    for (int j = 0; j < iColumnCount; ++j) {
                        if (null != this.tableModel.getValueAt(i, j) && !this.tableModel.getValueAt(i, j).toString().trim().equalsIgnoreCase("")) {
                            Object tblObj = this.tableModel.getValueAt(i, j);
                            if (tblObj instanceof String) {
                                rowData.add((String)tblObj);
                                continue;
                            }
                            if (!(tblObj instanceof DCTimeDateFormat)) continue;
                            rowData.add(((DCTimeDateFormat)tblObj).toString());
                            continue;
                        }
                        rowData.add(" ");
                    }
                    this.totalDataVec.add(rowData);
                }
            }
            catch (DCException e) {
                DCDebugTracer.trace(e);
            }
        }
    }

    public void getPreviewPanel() {
        if (!LogInfoPanHelper.checkLogCount(this.logTable.getRowCount())) {
            return;
        }
        if (!this.isObtain) {
            this.getAllDataFromServer();
        }
        int iColumnCount = this.logTable.getColumnCount();
        String[] strColumnName = new String[iColumnCount];
        for (int i = 0; i < iColumnCount; ++i) {
            strColumnName[i] = this.logTable.getColumnName(i);
        }
        TablePrintable printable = null;
        String strHeader = ResourceManager.getInstance().getResString("LOG_DETAILS");
        String strUserName = DCFrameWorkUtil.getUserName();
        try {
            printable = new TablePrintable(strHeader, strUserName, " ", strColumnName, (Collection)this.totalDataVec, this.totalDataVec.size(), false);
        }
        catch (Exception ex) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("PREVIEW_VECTOR_FAILED"), ResourceManager.getInstance().getResString("INFO"), 1);
            return;
        }
        com.swimap.iview.templates.print.PrintSupportor.preview((JFrame)DCFrameWorkUtil.getMainFrame(), (TablePrintable)printable, (int)printable.getPageCount());
    }

    public void printRecords() {
        DCDebugTracer.trace("select data size : " + this.logTable.getSelectedRowCount());
        if (!LogInfoPanHelper.checkLogCount(this.logTable.getSelectedRowCount())) {
            return;
        }
        if (!this.isObtain) {
            this.getAllDataFromServer();
        }
        final Vector oSelData = this.getSelectedLogData();
        int iColumnCount = this.logTable.getColumnCount();
        final String[] strColumnName = new String[iColumnCount];
        for (int i = 0; i < iColumnCount; ++i) {
            strColumnName[i] = this.logTable.getColumnName(i);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TablePrintable printable = null;
                String strHeader = ResourceManager.getInstance().getResString("LOG_DETAILS");
                String strUserName = DCFrameWorkUtil.getUserName();
                printable = new TablePrintable(strHeader, strUserName, " ", strColumnName, (Collection)oSelData, oSelData.size(), false);
                com.swimap.iview.templates.print.PrintSupportor.print((JFrame)DCFrameWorkUtil.getMainFrame(), (TablePrintable)printable, (int)printable.getPageCount());
            }
        });
    }

    private Vector getSelectedData() {
        Vector oSelectedDataVct = new Vector();
        Vector oVectorTmp = new Vector();
        Vector<String> oVector = null;
        int[] iRows = this.logTable.getSelectedRows();
        int iCurRows = this.logTable.getColumnModel().getColumnCount();
        for (int i = 0; i < iRows.length; ++i) {
            oVector = new Vector<String>();
            int length = this.tableModel.getDataVector().size();
            for (int k = 0; k < length && (Integer)(oVectorTmp = this.tableModel.getDataVector().get(k)).get(0) != iRows[i]; ++k) {
                oVectorTmp = null;
            }
            if (null == oVectorTmp) continue;
            int index = 0;
            for (int j = 0; j < iCurRows; ++j) {
                index = this.logTable.getColumnModel().getColumn(j).getModelIndex();
                oVector.add(oVectorTmp.get(index).toString());
            }
            oSelectedDataVct.add(oVector);
        }
        DCDebugTracer.trace("select data size : " + oSelectedDataVct.size());
        return oSelectedDataVct;
    }

    private Vector getSelectedLogData() {
        Vector oSelectedDataVct = new Vector();
        Vector oVector = null;
        int[] iRows = this.logTable.getSelectedRows();
        LogInfo[] logArray = null;
        try {
            logArray = LogManagerImpl.getInstance().getLogInfo(iRows[0] + 1, iRows[iRows.length - 1] + 1);
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        if (null == logArray || logArray.length <= 0) {
            return oSelectedDataVct;
        }
        int iCurRows = this.logTable.getColumnModel().getColumnCount();
        for (int i = 0; i < iRows.length; ++i) {
            oVector = LogInfoPanHelper.creteTableRowData(logArray[i]);
            Vector<String> oVectorTmp = new Vector<String>();
            int index = 0;
            for (int j = 0; j < iCurRows; ++j) {
                index = this.logTable.getColumnModel().getColumn(j).getModelIndex();
                oVectorTmp.add(oVector.get(index).toString());
            }
            oSelectedDataVct.add(oVectorTmp);
        }
        DCDebugTracer.trace("select data size : " + oSelectedDataVct.size());
        return oSelectedDataVct;
    }

    private void handleDeviceDeleteNotification(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        if (null == oDeviceInfoList || 0 == oDeviceInfoList.size()) {
            return;
        }
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        int iNoOfDevicesFromServer = oDeviceInfoList.size();
        for (int i = 0; i < iNoOfDevicesFromServer; ++i) {
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            int iDeleteDeviceId = oAsnDeviceInfo.oDeviceInfo.iDevId.intValue();
            for (int j = this.tableModel.getRowCount() - 1; j >= 0; --j) {
                Object obj = this.tableModel.getValueAt(j, 1);
                if (!(obj instanceof Integer) || iDeleteDeviceId != (Integer)this.tableModel.getValueAt(j, 1)) continue;
                this.tableModel.removeRow(j);
                int iModelRowCount = this.tableModel.getRowCount();
                this.tableModel.setTotalRowCount(--iModelRowCount);
            }
        }
        this.logTable.updateUI();
        this.updateUI();
    }

    private void handleDeviceModifyNotification(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        if (null == oDeviceInfoList || 0 == oDeviceInfoList.size()) {
            return;
        }
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        int iNoOfDevicesFromServer = oDeviceInfoList.size();
        for (int i = 0; i < iNoOfDevicesFromServer; ++i) {
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            int iNewDeviceId = oAsnDeviceInfo.oDeviceInfo.iDevId.intValue();
            String newIPAddress = "";
            if (null != oAsnDeviceInfo.oDeviceInfo.strDevIPAddress) {
                newIPAddress = new String(oAsnDeviceInfo.oDeviceInfo.strDevIPAddress);
            }
            String newDeviceName = "";
            if (null != oAsnDeviceInfo.oDeviceInfo.strDevName) {
                newDeviceName = new String(oAsnDeviceInfo.oDeviceInfo.strDevName);
            }
            int iLogTableRowCount = this.tableModel.getRowCount();
            for (int j = 0; j < iLogTableRowCount; ++j) {
                Object oDevIDObj = this.tableModel.getValueAt(j, 1);
                if (!(oDevIDObj instanceof Integer) || iNewDeviceId != (Integer)oDevIDObj) continue;
                if (0 != Collator.getInstance().compare(newIPAddress, "")) {
                    this.tableModel.setValueAt(newIPAddress, j, 3);
                }
                if (0 == Collator.getInstance().compare(newDeviceName, "")) continue;
                this.tableModel.setValueAt(newDeviceName, j, 2);
            }
        }
        this.logTable.updateUI();
        this.updateUI();
    }

    @Override
    public void handleDeviceConfigNotification(int iEventType, AsnDCDeviceSubmapNtfnInfoLst deviceInfoList) {
        switch (iEventType) {
            case 1: {
                this.handleDeviceDeleteNotification(deviceInfoList);
                break;
            }
            case 2: {
                this.handleDeviceModifyNotification(deviceInfoList);
                break;
            }
        }
    }

    public boolean print() {
        this.printRecords();
        return true;
    }

    public void saveAsLog() {
        ResourceManager oRes = ResourceManager.getInstance();
        String strFileName = this.oSaveAsFileUtil.getSelectFileName(oRes.getResString("LOGININFOPAN_DEFAULT_FILE"));
        if (null != strFileName) {
            this.saveLogInfo(strFileName);
        }
    }

    private void saveLogInfo(final String sFileName) {
        if (!LogInfoPanHelper.checkLogCount(this.logTable.getSelectedRowCount())) {
            return;
        }
        if (!this.isObtain) {
            this.getAllDataFromServer();
        }
        final Vector oDataVct = this.getSelectedLogData();
        int iColumnCount = this.logTable.getColumnCount();
        final String[] sTableHearders = new String[iColumnCount];
        for (int i = 0; i < iColumnCount; ++i) {
            sTableHearders[i] = this.logTable.getColumnName(i);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogInfoPan.this.oSaveAsFileUtil.saveAsInFile(oDataVct, ResourceManager.getInstance().getResString("LOGININFOPAN_DEFAULT_FILE"), sTableHearders, sFileName);
            }
        });
    }

    public void disposePanel() {
        DeviceConfigEventReceiver.getInstance().unResigterForConfigChangeEvent(this);
        this.removeAll();
        LogManagerImpl oLogMgr = LogManagerImpl.getInstance();
        if (null != oLogMgr) {
            oLogMgr.clearLogInfo();
        }
        this.strTableHeader = null;
        if (null != this.m_oResizeMotionListener) {
            this.logTable.getTableHeader().removeMouseListener(this.m_oResizeMotionListener);
            this.logTable.getTableHeader().removeMouseMotionListener(this.m_oResizeMotionListener);
            this.m_oResizeMotionListener = null;
        }
        if (null != this.totalDataVec) {
            this.totalDataVec.clear();
        }
        this.totalDataVec = null;
        this.headerCodeValue = null;
        this.scrPan = null;
        this.logTable = null;
        this.filterBtn = null;
        this.filterCriteriaComBox = null;
        this.tableModel = null;
        this.jResultBar = null;
        this.tableScrollBar = null;
        this.showTipWnd = null;
        if (null != this.logTablePopupMenu) {
            this.logTablePopupMenu.setInvoker(null);
            this.logTablePopupMenu.removeAll();
            this.logTablePopupMenu = null;
        }
        this.logDetailDlg = null;
        this.filterLogDlg = null;
        this.m_currentPan = null;
    }

    public LogFilterCriteria getLogFilter() {
        if (null == this.filterCriteriaComBox || this.filterCriteriaComBox.getItemCount() == 0) {
            return null;
        }
        return (LogFilterCriteria)this.filterCriteriaComBox.getSelectedItem();
    }
}

