/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.log;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.dcmodule.DataCenterModuleManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.log.HAPolicyLogInfoPanel;
import com.huawei.dc.log.LogInfoPan;
import com.swimap.mdi.ExtendedWindow;
import java.awt.GridLayout;
import java.awt.Rectangle;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LogInfoMgmtPanel
extends ExtendedWindow {
    private static final long serialVersionUID = 9214575480127164337L;
    private DataCenterModuleManager m_oDCModuleMgr;
    private static LogInfoPan m_oLogInfoPanel = null;
    private HAPolicyLogInfoPanel m_oHAPolicyLogInfoPanel = null;
    private JTabbedPane m_oTabPane = null;
    private static final int TAB_INDEX_LOG_HA = 1;

    public LogInfoMgmtPanel(DataCenterModuleManager dcModuleMgr) {
        this.m_oDCModuleMgr = dcModuleMgr;
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new GridLayout());
        this.setTitle(ResourceManager.getInstance().getResString("LOG_INFO_PAN"));
        DCFrameWorkUtil.setLogInfoMgmtPanel(this);
        boolean bHAPolicyLogPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(44012);
        if (DCFrameWorkUtil.getIsSingleClient() || !bHAPolicyLogPrivilege) {
            m_oLogInfoPanel = new LogInfoPan();
            this.add(m_oLogInfoPanel, null);
        } else {
            this.m_oTabPane = new JTabbedPane();
            m_oLogInfoPanel = new LogInfoPan();
            this.m_oTabPane.add(ResourceManager.getInstance().getResString("LOG_INFO_PAN"), m_oLogInfoPanel);
            this.m_oHAPolicyLogInfoPanel = new HAPolicyLogInfoPanel();
            this.m_oTabPane.add(ResourceManager.getInstance().getResString("HA_SERVER_FAILURE_INFO_DLG_TITLE"), this.m_oHAPolicyLogInfoPanel);
            this.addComponentAcitonListener();
            ObjectStore.getInstance().putObjectInstance("LogInfoMgmtPanel", (Object)this);
            this.add(this.m_oTabPane, null);
        }
    }

    public LogInfoPan getM_oLogInfoPanel() {
        return m_oLogInfoPanel;
    }

    public HAPolicyLogInfoPanel getHAPolicyLogInfoPanel() {
        return this.m_oHAPolicyLogInfoPanel;
    }

    private void addComponentAcitonListener() {
        this.m_oTabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int iSelIndex = ((JTabbedPane)e.getSource()).getSelectedIndex();
                if (iSelIndex == 1 && !LogInfoMgmtPanel.this.m_oHAPolicyLogInfoPanel.isHaveInitData()) {
                    LogInfoMgmtPanel.this.m_oHAPolicyLogInfoPanel.refreshHAPolicyLog();
                }
            }
        });
    }

    public void defaultFilterLogByTime() {
        if (null != m_oLogInfoPanel) {
            m_oLogInfoPanel.defaultFilterLogByTime();
        }
    }

    public void printRecords() {
        if (null != m_oLogInfoPanel) {
            m_oLogInfoPanel.printRecords();
        }
    }

    public void windowActivated() {
        super.windowActivated();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogInfoMgmtPanel.this.m_oDCModuleMgr.setToolBarIconVisible(true);
            }
        });
        MenuUtil.enableMenuItem(this.m_oDCModuleMgr.getDataCenterMenu(), "browseLog", false);
        DCFrameWorkUtil.getToolBarButton("browseLog").setEnabled(false);
        DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(false);
        this.requestFocus();
    }

    public void windowDeactivated() {
        super.windowDeactivated();
        MenuUtil.enableMenuItem(this.m_oDCModuleMgr.getDataCenterMenu(), "browseLog", true);
        DCFrameWorkUtil.getToolBarButton("browseLog").setEnabled(true);
        DCFrameWorkUtil.getToolBarButton("refreshTree").setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogInfoMgmtPanel.this.m_oDCModuleMgr.setToolBarIconVisible(false);
            }
        });
    }

    public void windowClosed() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogInfoMgmtPanel.this.m_oDCModuleMgr.setToolBarIconVisible(false);
            }
        });
        this.m_oDCModuleMgr.closePanel("LogInfoPanel");
    }

    public void windowOpened() {
        this.m_oDCModuleMgr.openPanel("LogInfoPanel");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogInfoMgmtPanel.this.m_oDCModuleMgr.setToolBarIconVisible(true);
            }
        });
    }

    public Rectangle getWindowBounds() {
        return new Rectangle(0, 0, DCConstants.DC_WINDOW_WIDTH, DCConstants.DC_WINDOW_HEIGHT);
    }

    public void setToNull() {
        if (null != m_oLogInfoPanel) {
            m_oLogInfoPanel.disposePanel();
            m_oLogInfoPanel = null;
        }
    }
}

