/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.log;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCLogInfo;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.OperationDisNameUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.framework.ErrorCodeReader;
import java.math.BigInteger;
import java.text.Collator;
import java.util.Calendar;

public class LogInfo {
    private int logId;
    private int deviceID;
    private String deviceName;
    private String deviceIPAddress;
    private String deviceTypeName;
    private String deviceTypeVersionName;
    private int operationType;
    private Calendar startTime;
    private Calendar endTime;
    private int operationResult;
    private int failureReasonID;
    private String operationFullPath;
    private String userName;
    private String clientIPAddress;
    private String m_strFailureReason = "";
    private String strCustomOperId = "";

    public String getFailureReason() {
        return this.m_strFailureReason;
    }

    public int getLogId() {
        return this.logId;
    }

    public int getDeviceID() {
        return this.deviceID;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getDeviceTypeName() {
        return this.deviceTypeName;
    }

    public String getDeviceTypeVersionName() {
        return this.deviceTypeVersionName;
    }

    public String getDeviceIPAddress() {
        return this.deviceIPAddress;
    }

    public String getDisplayableOperationType() {
        String strOperation = "";
        if (this.operationType > 53) {
            strOperation = ResourceManager.getInstance().getResString("LOG_INFO_UNKNOWN");
        } else {
            switch (this.operationType) {
                case 33: {
                    strOperation = this.getCustomOp();
                    break;
                }
                case -2: {
                    strOperation = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_" + this.operationType);
                    break;
                }
                default: {
                    IDeviceTypeConfigModel oDeviceXMLConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(this.deviceID, true);
                    strOperation = OperationDisNameUtil.getDisplayableOperationType(this.operationType, oDeviceXMLConfigModel);
                    break;
                }
            }
        }
        return strOperation;
    }

    public int getOperationType() {
        return this.operationType;
    }

    private String getCustomOp() {
        DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(this.deviceID);
        String strOperation = ResourceManager.getInstance().getResString(oDevInfo.getDeviceTypeInfo(), this.strCustomOperId);
        return strOperation;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public String getDisplayableFailureReason() {
        String failureReason = null;
        if (this.failureReasonID != 0) {
            switch (this.operationType) {
                case 3: {
                    failureReason = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(this.failureReasonID));
                    break;
                }
                case 7: {
                    failureReason = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(this.failureReasonID));
                    break;
                }
                case 6: 
                case 8: 
                case 9: 
                case 16: {
                    failureReason = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(this.failureReasonID));
                    break;
                }
                case 10: {
                    failureReason = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(this.failureReasonID));
                    break;
                }
                case 15: {
                    failureReason = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(this.failureReasonID));
                    break;
                }
                case -2: {
                    if (StringUtils.isNullOrEmptyStr(this.m_strFailureReason)) {
                        if (74040 == this.failureReasonID) {
                            failureReason = this.getFailureReason();
                            break;
                        }
                        failureReason = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(this.failureReasonID));
                        break;
                    }
                    failureReason = this.m_strFailureReason;
                    break;
                }
                default: {
                    failureReason = 74040 == this.failureReasonID ? this.getFailureReason() : ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(this.failureReasonID));
                }
            }
            if (null == failureReason) {
                failureReason = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(this.failureReasonID));
            }
        } else {
            failureReason = "";
            failureReason = StringUtils.isNullOrEmptyStr(this.m_strFailureReason) ? (74040 == this.failureReasonID ? this.getFailureReason() : ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(this.failureReasonID))) : this.m_strFailureReason;
        }
        this.m_strFailureReason = this.m_strFailureReason.trim();
        Collator oCompare = Collator.getInstance();
        this.parseFailureString();
        if (0 != oCompare.compare(this.m_strFailureReason, "") && 0 != oCompare.compare(failureReason, "") && 0 != oCompare.compare(this.m_strFailureReason, " ") && 999293081 != this.failureReasonID) {
            failureReason = failureReason + '(' + this.m_strFailureReason + ')';
        }
        if (0 == oCompare.compare(failureReason, "")) {
            return this.m_strFailureReason;
        }
        return failureReason;
    }

    private void parseFailureString() {
        if (0 == this.m_strFailureReason.length()) {
            return;
        }
        String strFilePathWithDetails = "";
        if (999293081 != this.failureReasonID) {
            if (this.operationType == 8) {
                String[] arrFilePaths = this.m_strFailureReason.split(";");
                if (null != arrFilePaths) {
                    int iLength = arrFilePaths.length;
                    String strFilePath = null;
                    for (int i = 0; i < iLength; ++i) {
                        String[] arrReason;
                        strFilePath = arrFilePaths[i];
                        if (0 == strFilePath.trim().length() || null == (arrReason = strFilePath.split("-"))) continue;
                        String strResultString = "";
                        boolean isSuccessToParse = true;
                        if (arrReason.length > 1) {
                            try {
                                strResultString = this.getResultString(arrReason[1]);
                            }
                            catch (DCException dce) {
                                isSuccessToParse = false;
                            }
                        } else {
                            isSuccessToParse = false;
                        }
                        if (isSuccessToParse) {
                            strFilePathWithDetails = arrReason[0];
                            strFilePathWithDetails = strFilePathWithDetails + ": " + strResultString;
                        } else {
                            strFilePathWithDetails = strFilePath;
                        }
                        strFilePathWithDetails = strFilePathWithDetails + "\n";
                    }
                }
            } else {
                if (this.operationType == -2) {
                    return;
                }
                this.m_strFailureReason = strFilePathWithDetails;
            }
        }
    }

    private String getResultString(String strReasonId) throws DCException {
        String strResultString = " ";
        int iReasonId = 0;
        try {
            iReasonId = Integer.parseInt(strReasonId);
        }
        catch (Exception e) {
            throw new DCException(e.getMessage());
        }
        switch (iReasonId) {
            case 1: {
                strResultString = ResourceManager.getInstance().getResString("FILES_LOADED_SUCCESSFULLY");
                break;
            }
            case 2: {
                strResultString = ResourceManager.getInstance().getResString("FILES_LOADED_FAILED");
                break;
            }
            case 3: {
                strResultString = ResourceManager.getInstance().getResString("FILES_NOT_LOADED");
                break;
            }
        }
        return strResultString;
    }

    public String getDisplayableOperationResult() {
        String resultStr = "";
        if (this.operationResult == 0) {
            resultStr = ResourceManager.getInstance().getResString("LOG_INFO_FAILURE");
        } else if (this.operationResult == 1) {
            int operId = this.getOperationType();
            resultStr = operId == 18 || operId == 19 || operId == 24 ? ResourceManager.getInstance().getResString("TASK_STATUS_0") : ResourceManager.getInstance().getResString("LOG_INFO_SUCCESSFUL");
        }
        return resultStr;
    }

    public String getOperationFullPath() {
        return this.operationFullPath;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public static LogInfo getLogInfoFromAsnStr(AsnDCLogInfo asnLogInfo) {
        LogInfo logInfo = new LogInfo();
        logInfo.deviceID = asnLogInfo.iDeviceId.intValue();
        logInfo.deviceName = new String(asnLogInfo.strDeviceName);
        logInfo.deviceIPAddress = new String(asnLogInfo.strDeviceIPAddress);
        logInfo.deviceTypeName = new String(asnLogInfo.strDeviceType);
        logInfo.deviceTypeVersionName = new String(asnLogInfo.strDeviceTypeVersion);
        logInfo.userName = new String(asnLogInfo.strUserName);
        logInfo.clientIPAddress = new String(asnLogInfo.strClientIp);
        logInfo.endTime = asnLogInfo.oEndTime;
        logInfo.failureReasonID = asnLogInfo.iReasonId.intValue();
        logInfo.logId = asnLogInfo.iId.intValue();
        logInfo.operationFullPath = new String(asnLogInfo.strFilePath);
        logInfo.operationResult = asnLogInfo.oResult.value;
        logInfo.operationType = asnLogInfo.oDeviceOperationType.value;
        logInfo.startTime = asnLogInfo.oStartTime;
        if (null != asnLogInfo.strCustomOperID) {
            logInfo.strCustomOperId = new String(asnLogInfo.strCustomOperID);
        }
        if (null != asnLogInfo.strFaliureReason) {
            logInfo.m_strFailureReason = new String(asnLogInfo.strFaliureReason);
        }
        logInfo.getDisplayableFailureReason();
        return logInfo;
    }
}

