/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.log;

import com.huawei.dc.common.components.DCDateChooser;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.CodeValue;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCInmDateChooserFormat;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.common.util.DeviceTypeVersionIdCodeValue;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.log.LogFilterCriteria;
import com.huawei.dc.log.LogInfoPan;
import com.huawei.dc.taskmgmt.controller.TaskSyncCommController;
import com.swimap.imap12.util.InmLengthLimitTextField;
import com.swimap.imap12.util.dateChooser.InmDateDocument;
import com.swimap.iview.templates.textfield.ipaddress.IPAddressTextField;
import com.swimap.iview.templates.textfield.ipaddress.InValideIPAddressException;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class LogFilterDlg
extends DCModalDialog {
    private static final long serialVersionUID = 6492736516982223464L;
    JButton okBtn;
    private LogInfoPan logInfoPan;
    private JComboBox oDeviceTypeComBox;
    private JComboBox rangeFromComBox;
    private JComboBox rangeToComBox;
    private IPAddressTextField oDeviceIPAddressTxt;
    private InmLengthLimitTextField oDeviceNameTxt;
    private DCDateChooser startTimeTxt;
    private DCDateChooser endTimeTxt;
    private JRadioButton oDeviceNameRadBtn;
    private JRadioButton oDeviceIPRadBtn;
    private JCheckBox oSuccessChkBox;
    private JCheckBox failureChkBox;
    private JComboBox operationTypeComBox;
    private InmLengthLimitTextField userNameTxt;
    private IPAddressTextField clientIPAddressTxt;
    private JLabel oDeviceTypeLbl;
    private JLabel oAdvanceOptionLbl;
    private JLabel resultField;
    private JLabel userNameLabel;
    private JLabel oClientIPLabel;
    private JLabel toLabel;
    private JLabel formLabel;
    private JLabel operationTypeLbl;

    public LogFilterDlg(LogInfoPan parentFrame) {
        super(DCFrameWorkUtil.getMainFrame(), true);
        try {
            this.logInfoPan = parentFrame;
            this.setResizable(false);
            this.setSize(564, 363);
            this.setTitle(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_TITLE"));
            this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
            this.jbInit();
            this.setAttribute();
            this.populateGUIDefaultValue();
            if (this.oDeviceTypeComBox.getItemCount() == 0) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        this.setDefaultCloseOperation(2);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(null);
        this.okBtn = new JButton();
        this.okBtn.setName("Log_LogFilterDlg_okBtn");
        this.okBtn.setBounds(new Rectangle(383, 304, 80, 21));
        this.okBtn.setText(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OK"));
        this.m_oCancelBtn.setBounds(new Rectangle(467, 304, 80, 21));
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), "HELP_TOPIC_LOGGING_FILTER");
        }
        this.oAdvanceOptionLbl = new JLabel();
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_CANCEL"));
        this.m_oCancelBtn.setName("Log_LogFilterDlg_cancelBtn");
        this.oDeviceTypeComBox = new JComboBox();
        this.oDeviceTypeComBox.setName("Log_LogFilterDlg_oDeviceTypeComBox");
        this.oDeviceTypeComBox.setBounds(new Rectangle(137, 12, 200, 21));
        this.oDeviceTypeComBox.setRenderer(new CustomComboBoxRenderer());
        this.oDeviceTypeLbl = new JLabel();
        this.oDeviceTypeLbl.setText(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_DEVICE_TYPE_LBL"));
        this.oDeviceTypeLbl.setBounds(new Rectangle(12, 12, 78, 20));
        this.oDeviceIPRadBtn = new JRadioButton();
        this.oDeviceIPRadBtn.setName("Log_LogFilterDlg_oDeviceIPRadBtn");
        this.oDeviceIPRadBtn.setText(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_DEVICE_IPADDRESS_LBL"));
        this.oDeviceIPRadBtn.setBounds(new Rectangle(12, 50, 89, 25));
        this.oDeviceNameRadBtn = new JRadioButton();
        this.oDeviceNameRadBtn.setText(ResourceManager.getInstance().getResString("DEVICE_NAME_LABEL"));
        this.oDeviceNameRadBtn.setName("Log_LogFilterDlg_oDeviceNameRadBtn");
        this.oDeviceNameRadBtn.setBounds(new Rectangle(12, 22, 100, 21));
        this.oDeviceIPAddressTxt = new IPAddressTextField();
        this.oDeviceIPAddressTxt.setName("Log_LogFilterDlg_oDeviceIPAddressTxt");
        this.oDeviceIPAddressTxt.setBounds(new Rectangle(121, 52, 140, 20));
        this.oDeviceIPAddressTxt.setBackground(new Color(204, 204, 204));
        this.oDeviceIPAddressTxt.setToolTipText(ResourceManager.getInstance().getResString("LOG_FILTER_EMPTY_IP_TOOLTIP"));
        this.oDeviceNameTxt = new InmLengthLimitTextField(255);
        this.oDeviceNameTxt.setName("Log_LogFilterDlg_oDeviceNameTxt");
        this.oDeviceNameTxt.setBounds(new Rectangle(121, 22, 140, 21));
        this.oDeviceNameTxt.setToolTipText(ResourceManager.getInstance().getResString("WILD_CARDS_SUPPORT_TOOLTIP"));
        this.operationTypeComBox = new JComboBox();
        this.operationTypeComBox.setName("Log_LogFilterDlg_operationTypeComBox");
        this.operationTypeComBox.setBounds(new Rectangle(111, 56, 200, 20));
        this.operationTypeLbl = new JLabel();
        this.operationTypeLbl.setBounds(new Rectangle(12, 56, 98, 20));
        this.operationTypeLbl.setText(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_LBL"));
        DCInmDateChooserFormat oDateFormat = new DCInmDateChooserFormat();
        InmDateDocument.defaultType = oDateFormat.getDateFormat();
        this.rangeFromComBox = new JComboBox();
        this.rangeFromComBox.setName("Log_LogFilterDlg_rangeFromComBox");
        this.rangeFromComBox.setBounds(new Rectangle(111, 88, 200, 24));
        this.rangeToComBox = new JComboBox();
        this.rangeToComBox.setName("Log_LogFilterDlg_rangeToComBox");
        this.rangeToComBox.setBounds(new Rectangle(111, 122, 200, 24));
        this.startTimeTxt = new DCDateChooser();
        this.startTimeTxt.setName("Log_LogFilterDlg_startTimeTxt");
        this.startTimeTxt.setBounds(new Rectangle(315, 88, 215, 24));
        JButton oStartbtn = this.startTimeTxt.getButton();
        oStartbtn.setName("Log_LogFilterDlg_oStartbtn");
        oStartbtn.setToolTipText(ResourceManager.getInstance().getResString("START_TIME_BUTTON_TOOL_TIP"));
        this.formLabel = new JLabel();
        this.formLabel.setBounds(new Rectangle(12, 88, 95, 20));
        this.formLabel.setText(ResourceManager.getInstance().getResString("LOG_FILTER_FROM_LABEL"));
        this.endTimeTxt = new DCDateChooser();
        this.endTimeTxt.setName("Log_LogFilterDlg_endTimeTxt");
        this.endTimeTxt.setBounds(new Rectangle(315, 122, 215, 24));
        JButton oSuspendbtn = this.endTimeTxt.getButton();
        oSuspendbtn.setName("Log_LogFilterDlg_oSuspendbtn");
        oSuspendbtn.setToolTipText(ResourceManager.getInstance().getResString("END_TIME_BUTTON_TOOL_TIP"));
        this.toLabel = new JLabel();
        this.toLabel.setBounds(new Rectangle(12, 122, 60, 20));
        this.toLabel.setText(ResourceManager.getInstance().getResString("LOG_FILTER_TO_LABEL"));
        this.resultField = new JLabel();
        this.resultField.setBounds(new Rectangle(12, 24, 87, 20));
        this.resultField.setText(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_RESULT_FIELD_LBL"));
        this.oSuccessChkBox = new JCheckBox();
        this.oSuccessChkBox.setName("Log_LogFilterDlg_oSuccessChkBox");
        this.oSuccessChkBox.setText(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_SUCCESSFUL_CHK_BOX"));
        this.oSuccessChkBox.setBounds(new Rectangle(111, 24, 90, 20));
        this.failureChkBox = new JCheckBox();
        this.failureChkBox.setName("Log_LogFilterDlg_failureChkBox");
        this.failureChkBox.setText(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_FAILURE_CHK_BOX"));
        this.failureChkBox.setBounds(new Rectangle(266, 24, 90, 20));
        this.userNameLabel = new JLabel();
        this.userNameLabel.setText(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_USER_NAME_TXT"));
        this.userNameLabel.setBounds(new Rectangle(12, 22, 70, 20));
        this.userNameTxt = new InmLengthLimitTextField(20);
        this.userNameTxt.setName("Log_LogFilterDlg_userNameTxt");
        this.userNameTxt.setBounds(new Rectangle(91, 22, 140, 20));
        this.oClientIPLabel = new JLabel();
        this.oClientIPLabel.setText(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_CLIENTIP_TXT"));
        this.oClientIPLabel.setBounds(new Rectangle(12, 52, 79, 20));
        this.clientIPAddressTxt = new IPAddressTextField();
        this.clientIPAddressTxt.setName("Log_LogFilterDlg_clientIPAddressTxt");
        this.clientIPAddressTxt.setBounds(new Rectangle(91, 52, 140, 20));
        this.clientIPAddressTxt.setToolTipText(ResourceManager.getInstance().getResString("LOG_FILTER_EMPTY_IP_TOOLTIP"));
        this.addSubPanels();
        this.initActionListener();
        this.helpDisplay();
    }

    private void addSubPanels() {
        Border border1 = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
        TitledBorder oDevBorder = new TitledBorder(border1, ResourceManager.getInstance().getResString("DEVICE_OPTIONS"));
        TitledBorder oUserBorder = new TitledBorder(border1, ResourceManager.getInstance().getResString("USER_OPTIONS"));
        TitledBorder oOprnBorder = new TitledBorder(BorderFactory.createEtchedBorder(1, Color.white, new Color(148, 145, 140)), ResourceManager.getInstance().getResString("LOG_FILTER_ADVANCE_OPTIONS"));
        JPanel oDevOptionPanel = new JPanel();
        oDevOptionPanel.setBorder(oDevBorder);
        oDevOptionPanel.setBounds(new Rectangle(12, 44, 278, 89));
        oDevOptionPanel.setLayout(null);
        JPanel oUserOptionPanel = new JPanel();
        oUserOptionPanel.setBorder(oUserBorder);
        oUserOptionPanel.setBounds(new Rectangle(299, 44, 247, 89));
        oUserOptionPanel.setLayout(null);
        this.getContentPane().add((Component)this.oDeviceTypeLbl, null);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(oOprnBorder);
        jPanel2.setOpaque(true);
        jPanel2.setBounds(new Rectangle(12, 135, 536, 160));
        jPanel2.setLayout(null);
        this.getContentPane().add((Component)this.oAdvanceOptionLbl, null);
        jPanel2.add((Component)this.resultField, null);
        jPanel2.add((Component)this.oSuccessChkBox, null);
        jPanel2.add((Component)this.failureChkBox, null);
        jPanel2.add((Component)this.operationTypeLbl, null);
        jPanel2.add((Component)this.operationTypeComBox, null);
        jPanel2.add((Component)this.formLabel, null);
        jPanel2.add((Component)this.rangeFromComBox, null);
        jPanel2.add((Component)this.rangeToComBox, null);
        jPanel2.add((Component)((Object)this.startTimeTxt), null);
        jPanel2.add((Component)this.toLabel, null);
        jPanel2.add((Component)((Object)this.endTimeTxt), null);
        oUserOptionPanel.add((Component)this.userNameLabel, null);
        oUserOptionPanel.add((Component)this.userNameTxt, null);
        oUserOptionPanel.add((Component)this.oClientIPLabel, null);
        oUserOptionPanel.add((Component)this.clientIPAddressTxt, null);
        this.getContentPane().add((Component)this.okBtn, null);
        this.getContentPane().add((Component)this.m_oCancelBtn, null);
        this.getContentPane().add((Component)this.oDeviceTypeComBox, null);
        oDevOptionPanel.add((Component)this.oDeviceIPRadBtn, null);
        oDevOptionPanel.add((Component)this.oDeviceNameRadBtn, null);
        oDevOptionPanel.add((Component)this.oDeviceNameTxt, null);
        oDevOptionPanel.add((Component)this.oDeviceIPAddressTxt, null);
        this.getContentPane().add((Component)oDevOptionPanel, null);
        this.getContentPane().add((Component)oUserOptionPanel, null);
        this.getContentPane().add((Component)jPanel2, null);
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.oDeviceNameRadBtn);
        buttonGroup1.add(this.oDeviceIPRadBtn);
        this.rootPane.setDefaultButton(this.okBtn);
    }

    private void initActionListener() {
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogFilterDlg.this.okBtn_actionPerformed();
            }
        });
        this.oDeviceTypeComBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem;
                if (16L == (0x10L & (long)e.getModifiers())) {
                    LogFilterDlg.this.deviceTypeComBoxActionPerformed();
                }
                if (e.getSource() instanceof JComboBox && null != (selectedItem = ((JComboBox)e.getSource()).getSelectedItem())) {
                    LogFilterDlg.this.oDeviceTypeComBox.setToolTipText(selectedItem.toString());
                }
            }
        });
        this.oDeviceIPRadBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogFilterDlg.this.deviceIPRadBtn_itemStateChanged(e);
            }
        });
        this.oDeviceNameRadBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogFilterDlg.this.deviceNameRadBtn_itemStateChanged(e);
            }
        });
        this.operationTypeComBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogFilterDlg.this.operationTypeComBox_itemStateChanged();
            }
        });
        this.rangeFromComBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogFilterDlg.this.rangeFormComBox_itemStateChanged(e);
            }
        });
        this.rangeToComBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LogFilterDlg.this.rangeToComBox_itemStateChanged(e);
            }
        });
    }

    private void setAttribute() {
        DeviceTypeInfo[] deviceTypes = DeviceInfoManagerImpl.getInstance().getExistDeviceTypes();
        if (deviceTypes != null && deviceTypes.length > 0) {
            this.oDeviceTypeComBox.addItem(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_DEFAULT_DEVICE_TYPE"));
            DeviceTypeVersionIdCodeValue deviceTypeCodeValue = null;
            ArrayList<Integer> code = null;
            for (int i = 0; i < deviceTypes.length; ++i) {
                deviceTypeCodeValue = new DeviceTypeVersionIdCodeValue();
                code = new ArrayList<Integer>();
                code.add(deviceTypes[i].getDevTypeID());
                code.add(deviceTypes[i].getDevTypeVersionId());
                deviceTypeCodeValue.setCode(code);
                if (deviceTypes[i].isT2000Domain()) {
                    deviceTypeCodeValue.setValue(deviceTypes[i].getDevTypeName());
                } else {
                    deviceTypeCodeValue.setValue(deviceTypes[i].getDevTypeName() + "(" + deviceTypes[i].getDevTypeVersionName() + ")");
                }
                this.oDeviceTypeComBox.addItem(deviceTypeCodeValue);
            }
        } else {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("NO_DEVICETYPES"), ResourceManager.getInstance().getResString("ERROR"), 0);
            this.okBtn.setEnabled(false);
        }
        this.fillDataToOperTypeCombox();
        this.operationTypeComBox.setSelectedIndex(0);
        this.oSuccessChkBox.setSelected(true);
        this.failureChkBox.setSelected(true);
        this.oDeviceNameRadBtn.setSelected(true);
        CodeValue theFirstLog = new CodeValue();
        theFirstLog.setCode(FormTOEnum.THE_FIRST_LOG.ordinal());
        theFirstLog.setValue(ResourceManager.getInstance().getResString("LOG_FILTER_THE_FIRST_LOG_KEY"));
        this.rangeFromComBox.addItem(theFirstLog);
        CodeValue startTime = new CodeValue();
        startTime.setCode(FormTOEnum.START_TIME.ordinal());
        startTime.setValue(ResourceManager.getInstance().getResString("LOG_FILTER_START_TIME_KEY"));
        this.rangeFromComBox.addItem(startTime);
        this.rangeFromComBox.setSelectedIndex(0);
        CodeValue theLastLog = new CodeValue();
        theLastLog.setCode(FormTOEnum.THE_LAST_LOG.ordinal());
        theLastLog.setValue(ResourceManager.getInstance().getResString("LOG_FILTER_THE_LAST_LOG_KEY"));
        this.rangeToComBox.addItem(theLastLog);
        CodeValue endTime = new CodeValue();
        endTime.setCode(FormTOEnum.END_TIME.ordinal());
        endTime.setValue(ResourceManager.getInstance().getResString("LOG_FILTER_END_TIME_KEY"));
        this.rangeToComBox.addItem(endTime);
        this.rangeToComBox.setSelectedIndex(0);
        Calendar beginTime = TaskSyncCommController.getInstance().getCurrentServerTime(true);
        long beginT = beginTime.getTimeInMillis() - 86400000L;
        beginTime.setTimeInMillis(beginT);
        Calendar curTime = (Calendar)CloneUtil.getClone(beginTime);
        this.startTimeTxt.setCalendar(beginTime);
        this.startTimeTxt.setEnabled(false);
        this.endTimeTxt.setCalendar(curTime);
        this.endTimeTxt.setEnabled(false);
    }

    private void fillDataToOperTypeCombox() {
        CodeValue allCodeValue = new CodeValue();
        allCodeValue.setCode(51);
        allCodeValue.setValue(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_ALL"));
        this.operationTypeComBox.addItem(allCodeValue);
        ArrayList<CodeValue> codeValueLst = new ArrayList<CodeValue>(51);
        for (int i = -2; i < 51; ++i) {
            if (-1 == i || 0 == i || DCFrameWorkUtil.getIsSingleClient() && (4 == i || 11 == i) || 26 == i) continue;
            CodeValue codeValue = new CodeValue();
            codeValue.setCode(i);
            codeValue.setValue(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_" + i));
            codeValueLst.add(codeValue);
        }
        Object[] oCodeValue = codeValueLst.toArray(new CodeValue[0]);
        Arrays.sort(oCodeValue);
        for (Object codeValue : oCodeValue) {
            this.operationTypeComBox.addItem(codeValue);
        }
    }

    private void populateGUIDefaultValue() {
        String sIPAddress;
        String sDevName;
        boolean isDevNameEnable;
        if (null == this.logInfoPan || null == this.logInfoPan.getLogFilter()) {
            return;
        }
        LogFilterCriteria logFilter = this.logInfoPan.getLogFilter();
        String devTypeName = logFilter.getDeviceTypeName();
        String devVerName = logFilter.getDeviceTypeVersionName();
        Object devTypeValue = null;
        DeviceTypeVersionIdCodeValue deviceTypeCodeValue = null;
        for (int i = 0; i < this.oDeviceTypeComBox.getItemCount(); ++i) {
            devTypeValue = this.oDeviceTypeComBox.getItemAt(i);
            if (null == devTypeName) continue;
            if (devTypeValue instanceof String) {
                if (!devTypeName.equals("ALL")) continue;
                this.oDeviceTypeComBox.setSelectedIndex(i);
                break;
            }
            if (!(devTypeValue instanceof DeviceTypeVersionIdCodeValue)) continue;
            deviceTypeCodeValue = devTypeValue;
            ArrayList tempArrayList = deviceTypeCodeValue.getCode();
            int iDeviceTypeId = (Integer)tempArrayList.get(0);
            int iDeviceVersionId = (Integer)tempArrayList.get(1);
            DeviceTypeInfo oDevTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(iDeviceTypeId, iDeviceVersionId);
            String deviceTypeName = oDevTypeInfo.getDevTypeName();
            String deviceTypeVersionName = oDevTypeInfo.getDevTypeVersionName();
            if (!devTypeName.equals(deviceTypeName) || !devVerName.equals(deviceTypeVersionName)) continue;
            this.oDeviceTypeComBox.setSelectedIndex(i);
            break;
        }
        if (!(isDevNameEnable = (sDevName = logFilter.getDeviceName()).equals("ALL"))) {
            this.oDeviceNameRadBtn.setSelected(true);
            this.oDeviceNameTxt.setText(sDevName);
        }
        if (!(sIPAddress = logFilter.getDeviceIPAddress()).equals("*.*.*.*")) {
            this.oDeviceIPRadBtn.setEnabled(true);
            this.oDeviceIPRadBtn.setSelected(true);
            this.oDeviceIPAddressTxt.setEditable(true);
            this.oDeviceIPAddressTxt.setText(sIPAddress);
        }
        String sClientIP = logFilter.getClientIPAddress();
        this.clientIPAddressTxt.setText(sClientIP);
        int iOperResult = logFilter.getOperationResult();
        switch (iOperResult) {
            case 0: {
                this.failureChkBox.setSelected(true);
                this.oSuccessChkBox.setSelected(false);
                break;
            }
            case 1: {
                this.failureChkBox.setSelected(false);
                this.oSuccessChkBox.setSelected(true);
                break;
            }
            case 2: {
                this.failureChkBox.setSelected(true);
                this.oSuccessChkBox.setSelected(true);
                break;
            }
        }
        CodeValue operationType = logFilter.getOperationType();
        for (int i = 0; i < this.operationTypeComBox.getItemCount(); ++i) {
            CodeValue operationCodeValue = (CodeValue)this.operationTypeComBox.getItemAt(i);
            if (!operationCodeValue.equals(operationType)) continue;
            this.operationTypeComBox.setSelectedIndex(i);
            break;
        }
        Calendar startTime = logFilter.getOperationStartTime();
        for (int i = 0; i < this.rangeFromComBox.getItemCount(); ++i) {
            CodeValue codeValue = (CodeValue)this.rangeFromComBox.getItemAt(i);
            if (null != startTime && codeValue.getCode() == FormTOEnum.START_TIME.ordinal()) {
                this.rangeFromComBox.setSelectedIndex(i);
                this.startTimeTxt.setEnabled(true);
                this.startTimeTxt.setCalendar(startTime);
                continue;
            }
            if (null != startTime || codeValue.getCode() != FormTOEnum.THE_FIRST_LOG.ordinal()) continue;
            this.rangeFromComBox.setSelectedIndex(i);
            this.startTimeTxt.setEnabled(false);
        }
        Calendar endTime = logFilter.getOperationEndTime();
        for (int i = 0; i < this.rangeToComBox.getItemCount(); ++i) {
            CodeValue codeValue = (CodeValue)this.rangeToComBox.getItemAt(i);
            if (null != endTime && codeValue.getCode() == FormTOEnum.END_TIME.ordinal()) {
                this.rangeToComBox.setSelectedIndex(i);
                this.endTimeTxt.setEnabled(true);
                this.endTimeTxt.setCalendar(endTime);
                continue;
            }
            if (null != endTime || codeValue.getCode() != FormTOEnum.THE_LAST_LOG.ordinal()) continue;
            this.rangeToComBox.setSelectedIndex(i);
            this.endTimeTxt.setEnabled(false);
        }
    }

    private void deviceTypeComBoxActionPerformed() {
        int iDeviceTypeId = -1;
        int iDevicetYpeVersionId = -1;
        Object oDeviceTypeObj = this.oDeviceTypeComBox.getSelectedItem();
        if (oDeviceTypeObj instanceof String) {
            return;
        }
        if (oDeviceTypeObj instanceof DeviceTypeVersionIdCodeValue) {
            DeviceTypeVersionIdCodeValue oSelectedObj = (DeviceTypeVersionIdCodeValue)oDeviceTypeObj;
            ArrayList arrCodeVal = oSelectedObj.getCode();
            iDeviceTypeId = (Integer)arrCodeVal.get(0);
            iDevicetYpeVersionId = (Integer)arrCodeVal.get(1);
        }
        IDeviceInfoManager oDeviceInfoManagerImpl = DCFrameWorkUtil.getDeviceInfoManager();
        oDeviceInfoManagerImpl.getDevicesByTypeAndVersion(iDeviceTypeId, iDevicetYpeVersionId);
    }

    void okBtn_actionPerformed() {
        String strUserName;
        String strDeviceName;
        if (!this.validateInput()) {
            return;
        }
        DCFrameWorkUtil.waitCursor();
        String deviceTypeName = "";
        String deviceTypeVersionName = "";
        DeviceTypeVersionIdCodeValue deviceTypeCodeValue = null;
        Object objDeviceType = this.oDeviceTypeComBox.getSelectedItem();
        if (objDeviceType instanceof String) {
            deviceTypeName = "ALL";
            deviceTypeVersionName = "ALL";
        } else {
            deviceTypeCodeValue = (DeviceTypeVersionIdCodeValue)objDeviceType;
            ArrayList tempArrayList = deviceTypeCodeValue.getCode();
            int iDeviceTypeId = (Integer)tempArrayList.get(0);
            int iDeviceVersionId = (Integer)tempArrayList.get(1);
            DeviceTypeInfo oDevTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(iDeviceTypeId, iDeviceVersionId);
            deviceTypeName = oDevTypeInfo.getDevTypeName();
            deviceTypeVersionName = oDevTypeInfo.getDevTypeVersionName();
            int index = deviceTypeVersionName.lastIndexOf("_telnet");
            if (0 < index) {
                deviceTypeVersionName = deviceTypeVersionName.substring(0, index);
            }
        }
        String strIPAddress = "";
        try {
            if (this.oDeviceIPRadBtn.isSelected()) {
                strIPAddress = this.oDeviceIPAddressTxt.getTrimedAddress();
            }
        }
        catch (InValideIPAddressException e) {
            DCDebugTracer.trace((Exception)((Object)e));
        }
        if (strIPAddress.length() == 0) {
            strIPAddress = "*.*.*.*";
        }
        if ((strDeviceName = this.oDeviceNameTxt.getText()).length() == 0) {
            strDeviceName = "ALL";
        }
        if ((strUserName = this.userNameTxt.getText()).length() == 0) {
            strUserName = "ALL";
        }
        String strClientIPAddress = "";
        try {
            strClientIPAddress = this.clientIPAddressTxt.getTrimedAddress();
        }
        catch (InValideIPAddressException e) {
            DCDebugTracer.trace((Exception)((Object)e));
        }
        if (strClientIPAddress.length() == 0) {
            strClientIPAddress = "*.*.*.*";
        }
        int logResultCondition = 0;
        if (this.oSuccessChkBox.isSelected()) {
            logResultCondition = 1;
        }
        if (this.failureChkBox.isSelected()) {
            logResultCondition = 0;
        }
        if (this.oSuccessChkBox.isSelected() && this.failureChkBox.isSelected()) {
            logResultCondition = 2;
        }
        if (!this.oSuccessChkBox.isSelected() && !this.failureChkBox.isSelected()) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("RESULT_FIELD_NOT_SELECTED"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        CodeValue operationCodeValue = (CodeValue)this.operationTypeComBox.getSelectedItem();
        LogFilterCriteria filterCriteria = new LogFilterCriteria();
        filterCriteria.setDeviceTypeName(deviceTypeName);
        filterCriteria.setDeviceTypeVersionName(deviceTypeVersionName);
        filterCriteria.setDeviceName(strDeviceName);
        filterCriteria.setDeviceIPAddress(strIPAddress);
        filterCriteria.setUserName(strUserName);
        filterCriteria.setClientIPAddress(strClientIPAddress);
        filterCriteria.setOperationResult(logResultCondition);
        filterCriteria.setOperationType(operationCodeValue);
        if (this.startTimeTxt.isEnabled()) {
            Calendar startTime = this.startTimeTxt.getCalendar(true);
            filterCriteria.setOperationStartTime(startTime);
            filterCriteria.setIFirstLog(0);
        } else {
            filterCriteria.setIFirstLog(1);
            filterCriteria.setOperationStartTime(null);
        }
        if (this.endTimeTxt.isEnabled()) {
            Calendar endTime = this.endTimeTxt.getCalendar(true);
            filterCriteria.setOperationEndTime(endTime);
            filterCriteria.setITheLastLog(0);
        } else {
            filterCriteria.setITheLastLog(2);
            filterCriteria.setOperationEndTime(null);
        }
        boolean operationResult = this.logInfoPan.setLogFilter(filterCriteria);
        DCFrameWorkUtil.defaultCursor();
        if (operationResult) {
            this.dispose();
        }
    }

    private boolean validateInput() {
        String strDeviceName = this.oDeviceNameTxt.getText();
        if (this.oDeviceNameRadBtn.isSelected()) {
            int posstar = strDeviceName.indexOf("*");
            int posampersand = strDeviceName.indexOf("?");
            if (strDeviceName.indexOf("*") != strDeviceName.lastIndexOf("*") || strDeviceName.indexOf("?") != strDeviceName.lastIndexOf("?")) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("SEARCH_DEVICE_DIALOG_ONE_WILD_CHARACTER_ALLOWED"), ResourceManager.getInstance().getResString("ERROR_MESSAGE_TITLE"), 0);
                return false;
            }
            if (-1 != posampersand && -1 != posstar) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("SEARCH_DEVICE_DIALOG_ONE_WILD_CHARACTER_ALLOWED"), ResourceManager.getInstance().getResString("ERROR_MESSAGE_TITLE"), 0);
                return false;
            }
        }
        boolean isStartTimeEnabled = this.startTimeTxt.isEnabled();
        boolean isEndTimeEnabled = this.endTimeTxt.isEnabled();
        Calendar oStartimeCal = Calendar.getInstance();
        oStartimeCal = this.startTimeTxt.getCalendar(true);
        TimeDateFormatUtil.switchGMTCalendar((Calendar)oStartimeCal);
        Calendar oEndTimeCal = Calendar.getInstance();
        oEndTimeCal = this.endTimeTxt.getCalendar(true);
        DCTimeDateUtil.switchToGMTCalendar(oEndTimeCal);
        if (isStartTimeEnabled && isEndTimeEnabled && (oEndTimeCal.equals(oStartimeCal) || oEndTimeCal.before(oStartimeCal))) {
            DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_END_TIME_LESS_START_TIME"), ResourceManager.getInstance().getResString("ERROR"), 0);
            return false;
        }
        return true;
    }

    @Override
    public void cancelButton_ActionPerformed() {
        this.dispose();
    }

    private void deviceIPRadBtn_itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.oDeviceNameTxt.setEditable(false);
            this.oDeviceNameTxt.setText("");
            this.oDeviceNameTxt.setBackground(new Color(204, 204, 204));
            this.oDeviceIPAddressTxt.setEditable(true);
            this.oDeviceIPAddressTxt.setBackground(Color.WHITE);
            this.oDeviceIPAddressTxt.grabFocus();
        } else {
            this.oDeviceIPAddressTxt.clear();
            this.oDeviceIPAddressTxt.setEditable(false);
            this.oDeviceIPAddressTxt.setBackground(new Color(204, 204, 204));
            this.oDeviceNameTxt.setEditable(true);
            this.oDeviceNameTxt.setBackground(Color.WHITE);
            this.oDeviceNameTxt.grabFocus();
        }
    }

    private void deviceNameRadBtn_itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.oDeviceIPAddressTxt.clear();
            this.oDeviceIPAddressTxt.setEditable(false);
            this.oDeviceIPAddressTxt.setBackground(new Color(204, 204, 204));
            this.oDeviceNameTxt.setEditable(true);
            this.oDeviceNameTxt.setBackground(Color.WHITE);
            this.oDeviceNameTxt.grabFocus();
        } else {
            this.oDeviceNameTxt.setEditable(false);
            this.oDeviceNameTxt.setText("");
            this.oDeviceNameTxt.setBackground(new Color(204, 204, 204));
            this.oDeviceIPAddressTxt.setEditable(true);
            this.oDeviceIPAddressTxt.setBackground(Color.WHITE);
            this.oDeviceIPAddressTxt.grabFocus();
        }
    }

    protected void helpDisplay() {
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), "HELP_TOPIC_LOGGING_FILTER");
    }

    private void operationTypeComBox_itemStateChanged() {
        this.userNameTxt.setEditable(true);
        this.clientIPAddressTxt.setEditable(true);
    }

    private void rangeFormComBox_itemStateChanged(ItemEvent e) {
        CodeValue codeValue = (CodeValue)e.getItem();
        if (codeValue.getCode() == FormTOEnum.START_TIME.ordinal()) {
            this.startTimeTxt.setEnabled(true);
        } else {
            this.startTimeTxt.setEnabled(false);
        }
    }

    private void rangeToComBox_itemStateChanged(ItemEvent e) {
        CodeValue codeValue = (CodeValue)e.getItem();
        if (codeValue.getCode() == FormTOEnum.END_TIME.ordinal()) {
            this.endTimeTxt.setEnabled(true);
        } else {
            this.endTimeTxt.setEnabled(false);
        }
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }

    class CustomComboBoxRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 5270131902147424326L;

        CustomComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (index > -1) {
                    if (null != value) {
                        list.setToolTipText(value.toString());
                    }
                } else {
                    list.setToolTipText(null);
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (null != value) {
                list.setToolTipText(value.toString());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    static enum FormTOEnum {
        START_TIME,
        THE_FIRST_LOG,
        END_TIME,
        THE_LAST_LOG;

    }
}

