/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.log;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.CodeValue;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.log.LogInfoPanHelper;
import java.text.Collator;
import java.util.Calendar;

public class LogFilterCriteria {
    private String deviceTypeName = "ALL";
    private String deviceTypeVersionName = "ALL";
    private String deviceName = "ALL";
    private String deviceIPAddress = "*.*.*.*";
    private String userName = "ALL";
    private String clientIPAddress = "*.*.*.*";
    private int iTheFirstLog = 0;
    private int iTheLastLog = 0;
    private CodeValue operationType;
    private int operationResult = 2;
    private Calendar operationStartTime;
    private Calendar operationEndTime;
    private static final String CRITERIA_SEPARATE = "; ";

    public String getDeviceTypeName() {
        return this.deviceTypeName;
    }

    public void setDeviceTypeName(String aDeviceTypeName) {
        this.deviceTypeName = aDeviceTypeName;
    }

    public String getDeviceTypeVersionName() {
        return this.deviceTypeVersionName;
    }

    public void setDeviceTypeVersionName(String aDeviceTypeVersionName) {
        this.deviceTypeVersionName = aDeviceTypeVersionName;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String aDeviceName) {
        this.deviceName = aDeviceName;
    }

    public String getDeviceIPAddress() {
        return this.deviceIPAddress;
    }

    public void setDeviceIPAddress(String aDeviceIPAddress) {
        this.deviceIPAddress = aDeviceIPAddress;
    }

    public CodeValue getOperationType() {
        return this.operationType;
    }

    public void setOperationType(CodeValue aOperationType) {
        this.operationType = aOperationType;
    }

    public int getOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(int aOperationResult) {
        this.operationResult = aOperationResult;
    }

    public Calendar getOperationStartTime() {
        return this.operationStartTime;
    }

    public void setOperationStartTime(Calendar aOperationStartTime) {
        this.operationStartTime = aOperationStartTime;
    }

    public void setUserName(String anUserName) {
        this.userName = anUserName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setClientIPAddress(String aClientIPAddress) {
        this.clientIPAddress = aClientIPAddress;
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public Calendar getOperationEndTime() {
        return this.operationEndTime;
    }

    public void setOperationEndTime(Calendar aOperationEndTime) {
        this.operationEndTime = aOperationEndTime;
    }

    public String toString() {
        LogFilterCriteria oAllFilter = LogInfoPanHelper.createAllFilterCriteria();
        if (this.equals(oAllFilter)) {
            return DCFrameWorkUtil.getLocalizedString("LOG_FILTER_CRITERIA_RESULT_ALL");
        }
        StringBuffer szBuf = new StringBuffer(0);
        this.handleDeviceType(szBuf);
        this.handleDeviceTypeVersion(szBuf);
        this.handleDeviceTypeName(szBuf);
        this.handleDevIPAddres(szBuf);
        this.handleUserName(szBuf);
        this.handleClientIP(szBuf);
        this.handleOpRslt(szBuf);
        this.handleFromTo(szBuf);
        return szBuf.toString();
    }

    private void handleClientIP(StringBuffer szBuf) {
        if (!this.clientIPAddress.equals("*.*.*.*")) {
            String strLabel = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_CLIENTIP_TXT");
            if (-1 != strLabel.indexOf(":")) {
                strLabel = strLabel.substring(0, strLabel.indexOf(":"));
            }
            if (szBuf.length() != 0) {
                szBuf.append(CRITERIA_SEPARATE);
            }
            szBuf.append(strLabel);
            szBuf.append("=");
            szBuf.append(this.clientIPAddress);
        }
    }

    private void handleFromTo(StringBuffer szBuf) {
        String strLabel = ResourceManager.getInstance().getResString("LOG_FILTER_FROM_LABEL");
        if (-1 != strLabel.indexOf(":")) {
            strLabel = strLabel.substring(0, strLabel.indexOf(":"));
        }
        if (szBuf.length() != 0) {
            szBuf.append(CRITERIA_SEPARATE);
        }
        szBuf.append(strLabel);
        szBuf.append("=");
        if (null != this.operationStartTime) {
            szBuf.append(DCTimeDateUtil.getLocaleDisplayTime(this.operationStartTime));
        } else {
            szBuf.append(ResourceManager.getInstance().getResString("LOG_FILTER_THE_FIRST_LOG_KEY"));
        }
        strLabel = ResourceManager.getInstance().getResString("LOG_FILTER_TO_LABEL");
        if (-1 != strLabel.indexOf(":")) {
            strLabel = strLabel.substring(0, strLabel.indexOf(":"));
        }
        if (szBuf.length() != 0) {
            szBuf.append(CRITERIA_SEPARATE);
        }
        szBuf.append(strLabel);
        szBuf.append("=");
        if (null != this.operationEndTime) {
            szBuf.append(DCTimeDateUtil.getLocaleDisplayTime(this.operationEndTime));
        } else {
            szBuf.append(ResourceManager.getInstance().getResString("LOG_FILTER_THE_LAST_LOG_KEY"));
        }
    }

    private void handleOpRslt(StringBuffer szBuf) {
        String strLabel;
        String opResult = "";
        switch (this.operationResult) {
            case 1: {
                opResult = ResourceManager.getInstance().getResString("LOG_FILTER_CRITERIA_RESULT_SUCCESSFUL");
                break;
            }
            case 0: {
                opResult = ResourceManager.getInstance().getResString("LOG_FILTER_CRITERIA_RESULT_FAILURE");
                break;
            }
            default: {
                opResult = ResourceManager.getInstance().getResString("LOG_FILTER_CRITERIA_RESULT_ALL");
            }
        }
        if (!Collator.getInstance().equals(opResult, ResourceManager.getInstance().getResString("LOG_FILTER_CRITERIA_RESULT_ALL"))) {
            strLabel = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_RESULT_FIELD_LBL");
            if (-1 != strLabel.indexOf(":")) {
                strLabel = strLabel.substring(0, strLabel.indexOf(":"));
            }
            if (szBuf.length() != 0) {
                szBuf.append(CRITERIA_SEPARATE);
            }
            szBuf.append(strLabel);
            szBuf.append("=");
            szBuf.append(opResult);
        }
        if (!Collator.getInstance().equals(this.operationType.getValue(), ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_ALL"))) {
            strLabel = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_LBL");
            if (-1 != strLabel.indexOf(":")) {
                strLabel = strLabel.substring(0, strLabel.indexOf(":"));
            }
            if (szBuf.length() != 0) {
                szBuf.append(CRITERIA_SEPARATE);
            }
            szBuf.append(strLabel);
            szBuf.append("=");
            szBuf.append(this.operationType.getValue());
        }
    }

    private void handleUserName(StringBuffer szBuf) {
        if (!this.userName.equals("ALL")) {
            String strLabel = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_USER_NAME_TXT");
            if (-1 != strLabel.indexOf(":")) {
                strLabel = strLabel.substring(0, strLabel.indexOf(":"));
            }
            if (szBuf.length() != 0) {
                szBuf.append(CRITERIA_SEPARATE);
            }
            szBuf.append(strLabel);
            szBuf.append("=");
            szBuf.append(this.userName);
        }
    }

    private void handleDevIPAddres(StringBuffer szBuf) {
        if (!this.deviceIPAddress.equals("*.*.*.*")) {
            String strLabel = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_DEVICE_IPADDRESS_LBL");
            if (-1 != strLabel.indexOf(":")) {
                strLabel = strLabel.substring(0, strLabel.indexOf(":"));
            }
            if (szBuf.length() != 0) {
                szBuf.append(CRITERIA_SEPARATE);
            }
            szBuf.append(strLabel);
            szBuf.append("=");
            szBuf.append(this.deviceIPAddress);
        }
    }

    private void handleDeviceTypeName(StringBuffer szBuf) {
        if (!this.deviceName.equals("ALL")) {
            String strLabel = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_DEVICE_NAME_RAD_BTN");
            if (-1 != strLabel.indexOf(":")) {
                strLabel = strLabel.substring(0, strLabel.indexOf(":"));
            }
            if (szBuf.length() != 0) {
                szBuf.append(CRITERIA_SEPARATE);
            }
            szBuf.append(strLabel);
            szBuf.append("=");
            szBuf.append(this.deviceName);
        }
    }

    private void handleDeviceTypeVersion(StringBuffer szBuf) {
        if (!this.deviceTypeVersionName.equals("ALL")) {
            String strLabel = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_DEVICE_TYPE_VERSION_LBL");
            if (-1 != strLabel.indexOf(":")) {
                strLabel = strLabel.substring(0, strLabel.indexOf(":"));
            }
            if (szBuf.length() != 0) {
                szBuf.append(CRITERIA_SEPARATE);
            }
            szBuf.append(strLabel);
            szBuf.append("=");
            szBuf.append(this.deviceTypeVersionName);
        }
    }

    private void handleDeviceType(StringBuffer szBuf) {
        if (!this.deviceTypeName.equals("ALL")) {
            String strLabel = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_DEVICE_TYPE_LBL");
            if (-1 != strLabel.indexOf(":")) {
                strLabel = strLabel.substring(0, strLabel.indexOf(":"));
            }
            szBuf.append(strLabel);
            szBuf.append("=");
            szBuf.append(this.deviceTypeName);
        }
    }

    public int getIFirstLog() {
        return this.iTheFirstLog;
    }

    public void setIFirstLog(int strTheFirstLog) {
        this.iTheFirstLog = strTheFirstLog;
    }

    public int getITheLastLog() {
        return this.iTheLastLog;
    }

    public void setITheLastLog(int strTheLastLog) {
        this.iTheLastLog = strTheLastLog;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clientIPAddress == null ? 0 : this.clientIPAddress.hashCode());
        result = 31 * result + (this.deviceIPAddress == null ? 0 : this.deviceIPAddress.hashCode());
        result = 31 * result + (this.deviceName == null ? 0 : this.deviceName.hashCode());
        result = 31 * result + (this.deviceTypeName == null ? 0 : this.deviceTypeName.hashCode());
        result = 31 * result + (this.deviceTypeVersionName == null ? 0 : this.deviceTypeVersionName.hashCode());
        result = 31 * result + this.iTheFirstLog;
        result = 31 * result + this.iTheLastLog;
        result = 31 * result + (this.operationEndTime == null ? 0 : this.operationEndTime.hashCode());
        result = 31 * result + this.operationResult;
        result = 31 * result + (this.operationStartTime == null ? 0 : this.operationStartTime.hashCode());
        result = 31 * result + (this.operationType == null ? 0 : this.operationType.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogFilterCriteria other = (LogFilterCriteria)obj;
        if (this.clientIPAddress == null ? other.clientIPAddress != null : !this.clientIPAddress.equals(other.clientIPAddress)) {
            return false;
        }
        if (this.deviceIPAddress == null ? other.deviceIPAddress != null : !this.deviceIPAddress.equals(other.deviceIPAddress)) {
            return false;
        }
        if (this.deviceName == null ? other.deviceName != null : !this.deviceName.equals(other.deviceName)) {
            return false;
        }
        if (this.deviceTypeName == null ? other.deviceTypeName != null : !this.deviceTypeName.equals(other.deviceTypeName)) {
            return false;
        }
        if (this.deviceTypeVersionName == null ? other.deviceTypeVersionName != null : !this.deviceTypeVersionName.equals(other.deviceTypeVersionName)) {
            return false;
        }
        if (this.iTheFirstLog != other.iTheFirstLog) {
            return false;
        }
        if (this.iTheLastLog != other.iTheLastLog) {
            return false;
        }
        if (this.operationEndTime == null ? other.operationEndTime != null : !this.operationEndTime.getTime().toString().equals(other.operationEndTime.getTime().toString())) {
            return false;
        }
        if (this.operationResult != other.operationResult) {
            return false;
        }
        if (this.operationStartTime == null ? other.operationStartTime != null : !this.operationStartTime.getTime().toString().equals(other.operationStartTime.getTime().toString())) {
            return false;
        }
        if (this.operationType == null ? other.operationType != null : !this.operationType.equals(other.operationType)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }
}

