/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.log;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.log.LogInfo;
import com.huawei.dc.log.LogInfoPan;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class LogDetailDlg
extends DCModalDialog {
    private static final long serialVersionUID = -1437192593662975806L;
    private JButton previousBtn;
    private JButton nextBtn;
    private JTextField opPathTxt;
    private JTextField opTypeTxt;
    private JTextField devTypeTxt;
    private JTextField devTypeVersionTxt;
    private JTextField devIPTxt;
    private JTextField resultTxt;
    private JTextField devNameTxt;
    private JTextField endTimeTxt;
    private JTextField startTimeTxt;
    private JTextArea failureReasonTxtArea;
    private LogInfoPan logInfoPan;
    private JTextField userNameTxt;
    private JTextField clientIPAddressTxt;

    public LogDetailDlg(LogInfoPan logInfoPan) {
        super(DCFrameWorkUtil.getMainFrame(), true);
        try {
            this.setSize(513, 453);
            this.setResizable(false);
            this.setTitle(ResourceManager.getInstance().getResString("LOG_DETAIL_DIALOG_TITLE"));
            this.logInfoPan = logInfoPan;
            this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
            this.jbInit();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(null);
        this.previousBtn = new JButton();
        this.previousBtn.setName("Log_LogDetailDlg_previousBtn");
        this.previousBtn.setBounds(new Rectangle(216, 389, 90, 21));
        this.previousBtn.setMnemonic('P');
        this.previousBtn.setText(ResourceManager.getInstance().getResString("LOG_DETAIL_PERVIOUS_BTN"));
        this.previousBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogDetailDlg.this.previousBtn_actionPerformed();
            }
        });
        this.nextBtn = new JButton();
        this.nextBtn.setName("Log_LogDetailDlg_nextBtn");
        this.nextBtn.setBounds(new Rectangle(311, 389, 90, 21));
        this.nextBtn.setMnemonic('N');
        this.nextBtn.setText(ResourceManager.getInstance().getResString("LOG_DETAIL_NEXT_BTN"));
        this.nextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogDetailDlg.this.nextBtn_actionPerformed();
            }
        });
        this.m_oCancelBtn.setName("Log_LogDetailDlg_cancelBtn");
        this.m_oCancelBtn.setBounds(new Rectangle(405, 389, 90, 21));
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("LOG_DETAIL_CLOSE_BTN"));
        JLabel resultLbl = new JLabel();
        resultLbl.setText(ResourceManager.getInstance().getResString("LOG_DETAIL_RESULT_LBL"));
        resultLbl.setBounds(new Rectangle(244, 152, 78, 21));
        JLabel devTypeVersionLbl = new JLabel();
        devTypeVersionLbl.setText(ResourceManager.getInstance().getResString("LOG_DETAIL_DEVICE_TYPE_VERSION_LBL"));
        devTypeVersionLbl.setBounds(new Rectangle(244, 86, 78, 21));
        JLabel startTimeLbl = new JLabel();
        startTimeLbl.setText(ResourceManager.getInstance().getResString("LOG_DETAIL_START_TIME_LBL"));
        startTimeLbl.setBounds(new Rectangle(244, 20, 78, 21));
        this.opPathTxt = new JTextField();
        this.opPathTxt.setName("Log_LogDetailDlg_opPathTxt");
        this.opPathTxt.setEditable(false);
        this.opPathTxt.setBounds(new Rectangle(106, 185, 346, 21));
        JScrollPane failReasonScrPan = new JScrollPane();
        failReasonScrPan.setBounds(new Rectangle(20, 241, 432, 77));
        JLabel devNameLbl = new JLabel();
        devNameLbl.setText(ResourceManager.getInstance().getResString("DEVICE_NAME_LABEL"));
        devNameLbl.setBounds(new Rectangle(20, 20, 84, 21));
        this.opTypeTxt = new JTextField();
        this.opTypeTxt.setName("Log_LogDetailDlg_opTypeTxt");
        this.opTypeTxt.setEditable(false);
        this.opTypeTxt.setBounds(new Rectangle(107, 152, 128, 21));
        JLabel devTypeLbl = new JLabel();
        devTypeLbl.setText(ResourceManager.getInstance().getResString("LOG_DETAIL_DEVICE_TYPE_LBL"));
        devTypeLbl.setBounds(new Rectangle(20, 86, 84, 21));
        this.devTypeTxt = new JTextField();
        this.devTypeTxt.setName("Log_LogDetailDlg_devTypeTxt");
        this.devTypeTxt.setEditable(false);
        this.devTypeTxt.setBounds(new Rectangle(107, 86, 128, 21));
        this.devTypeVersionTxt = new JTextField();
        this.devTypeVersionTxt.setName("Log_LogDetailDlg_devTypeVersionTxt");
        this.devTypeVersionTxt.setEditable(false);
        this.devTypeVersionTxt.setBounds(new Rectangle(328, 86, 130, 21));
        JLabel opTypeLbl = new JLabel();
        opTypeLbl.setOpaque(false);
        opTypeLbl.setRequestFocusEnabled(true);
        opTypeLbl.setText(ResourceManager.getInstance().getResString("LOG_DETAIL_OPERATION_TYPE_LBL"));
        opTypeLbl.setBounds(new Rectangle(20, 152, 84, 21));
        JLabel devIPLbl = new JLabel();
        devIPLbl.setText(ResourceManager.getInstance().getResString("LOG_DETAIL_IP_ADDRESS_LBL"));
        devIPLbl.setBounds(new Rectangle(20, 53, 84, 21));
        this.devIPTxt = new JTextField();
        this.devIPTxt.setName("Log_LogDetailDlg_devIPTxt");
        this.devIPTxt.setEditable(false);
        this.devIPTxt.setBounds(new Rectangle(108, 53, 128, 21));
        JLabel opPathLbl = new JLabel();
        opPathLbl.setText(ResourceManager.getInstance().getResString("LOG_DETAIL_OPERATION_PATH_LBL"));
        opPathLbl.setBounds(new Rectangle(20, 185, 84, 21));
        this.resultTxt = new JTextField();
        this.resultTxt.setName("Log_LogDetailDlg_resultTxt");
        this.resultTxt.setEditable(false);
        this.resultTxt.setBounds(new Rectangle(328, 152, 130, 21));
        this.devNameTxt = new JTextField();
        this.devNameTxt.setName("Log_LogDetailDlg_devNameTxt");
        this.devNameTxt.setEditable(false);
        this.devNameTxt.setBounds(new Rectangle(107, 20, 128, 21));
        this.endTimeTxt = new JTextField();
        this.endTimeTxt.setName("Log_LogDetailDlg_endTimeTxt");
        this.endTimeTxt.setEditable(false);
        this.endTimeTxt.setBounds(new Rectangle(328, 53, 130, 21));
        this.startTimeTxt = new JTextField();
        this.startTimeTxt.setName("Log_LogDetailDlg_startTimeTxt");
        this.startTimeTxt.setEnabled(true);
        this.startTimeTxt.setEditable(false);
        this.startTimeTxt.setCaretPosition(0);
        this.startTimeTxt.setBounds(new Rectangle(328, 20, 130, 21));
        JLabel failureReasonLbl = new JLabel();
        failureReasonLbl.setText(ResourceManager.getInstance().getResString("LOG_DETAIL_FAILURE_REASON_LBL"));
        failureReasonLbl.setBounds(new Rectangle(20, 214, 146, 19));
        JLabel endTimeLbl = new JLabel();
        endTimeLbl.setText(ResourceManager.getInstance().getResString("LOG_DETAIL_END_TIME_LBL"));
        endTimeLbl.setBounds(new Rectangle(244, 53, 78, 21));
        this.failureReasonTxtArea = new JTextArea();
        this.failureReasonTxtArea.setName("Log_LogDetailDlg_failureReasonTxtArea");
        this.failureReasonTxtArea.setEditable(false);
        JPanel logDetailPan = new JPanel();
        logDetailPan.setBorder(null);
        logDetailPan.setBounds(new Rectangle(5, 0, 490, 361));
        logDetailPan.setLayout(null);
        JLabel userNameLbl = new JLabel();
        userNameLbl.setText(ResourceManager.getInstance().getResString("LOG_DETAIL_USER_NAME_LBL"));
        userNameLbl.setBounds(new Rectangle(20, 120, 84, 21));
        this.userNameTxt = new JTextField();
        this.userNameTxt.setName("Log_LogDetailDlg_userNameTxt");
        this.userNameTxt.setEditable(false);
        this.userNameTxt.setBounds(new Rectangle(107, 120, 128, 21));
        JLabel clientIPLbl = new JLabel();
        clientIPLbl.setText(ResourceManager.getInstance().getResString("LOG_DETAIL_CLIENT_IPADDRESS_LBL"));
        clientIPLbl.setBounds(new Rectangle(244, 120, 78, 21));
        this.clientIPAddressTxt = new JTextField();
        this.clientIPAddressTxt.setName("Log_LogDetailDlg_clientIPAddressTxt");
        this.clientIPAddressTxt.setEditable(false);
        this.clientIPAddressTxt.setBounds(new Rectangle(328, 120, 130, 21));
        logDetailPan.add((Component)devNameLbl, null);
        logDetailPan.add((Component)devIPLbl, null);
        logDetailPan.add((Component)devTypeVersionLbl, null);
        logDetailPan.add((Component)this.devIPTxt, null);
        logDetailPan.add((Component)devTypeLbl, null);
        logDetailPan.add((Component)this.devTypeTxt, null);
        logDetailPan.add((Component)startTimeLbl, null);
        logDetailPan.add((Component)this.endTimeTxt, null);
        logDetailPan.add((Component)endTimeLbl, null);
        logDetailPan.add((Component)this.startTimeTxt, null);
        logDetailPan.add((Component)this.devNameTxt, null);
        logDetailPan.add((Component)this.devTypeVersionTxt, null);
        logDetailPan.add((Component)this.opPathTxt, null);
        logDetailPan.add((Component)opTypeLbl, null);
        logDetailPan.add((Component)this.opTypeTxt, null);
        logDetailPan.add((Component)resultLbl, null);
        logDetailPan.add((Component)this.resultTxt, null);
        logDetailPan.add((Component)opPathLbl, null);
        logDetailPan.add((Component)this.userNameTxt, null);
        logDetailPan.add((Component)userNameLbl, null);
        logDetailPan.add((Component)clientIPLbl, null);
        logDetailPan.add((Component)this.clientIPAddressTxt, null);
        logDetailPan.add((Component)failReasonScrPan, null);
        logDetailPan.add((Component)failureReasonLbl, null);
        failReasonScrPan.getViewport().add((Component)this.failureReasonTxtArea, null);
        JTabbedPane mainTabbedPan = new JTabbedPane();
        String strTabPanLabel = ResourceManager.getInstance().getResString("LOG_DETAIL_MAIN_TABBED_TEXT");
        mainTabbedPan.add((Component)logDetailPan, strTabPanLabel);
        mainTabbedPan.setBounds(new Rectangle(12, 12, 481, 365));
        this.getContentPane().add((Component)mainTabbedPan, null);
        this.getContentPane().add((Component)this.m_oCancelBtn, null);
        this.getContentPane().add((Component)this.previousBtn, null);
        this.getContentPane().add((Component)this.nextBtn, null);
        this.rootPane.setDefaultButton(this.m_oCancelBtn);
    }

    public void setLogInformation(LogInfo logInfo, boolean firstRecord, boolean lastRecord) {
        this.devNameTxt.setText(logInfo.getDeviceName());
        this.devNameTxt.setToolTipText(logInfo.getDeviceName());
        this.devIPTxt.setText(logInfo.getDeviceIPAddress());
        this.devIPTxt.setToolTipText(logInfo.getDeviceIPAddress());
        this.devTypeTxt.setText(logInfo.getDeviceTypeName());
        this.devTypeTxt.setToolTipText(logInfo.getDeviceTypeName());
        this.devTypeTxt.setCaretPosition(0);
        this.devTypeVersionTxt.setText(logInfo.getDeviceTypeVersionName());
        this.devTypeVersionTxt.setToolTipText(logInfo.getDeviceTypeVersionName());
        this.devTypeVersionTxt.setCaretPosition(0);
        Calendar oStartTimeCal = Calendar.getInstance();
        oStartTimeCal.setTime(logInfo.getStartTime().getTime());
        DCTimeDateUtil.switchToLocalCalendar(oStartTimeCal);
        String strStartTime = DCTimeDateUtil.getLocaleDisplayTime(oStartTimeCal);
        this.startTimeTxt.setText(strStartTime);
        this.startTimeTxt.setToolTipText(strStartTime);
        this.startTimeTxt.setCaretPosition(0);
        Calendar oEndTimeCal = Calendar.getInstance();
        oEndTimeCal.setTime(logInfo.getEndTime().getTime());
        DCTimeDateUtil.switchToLocalCalendar(oEndTimeCal);
        String strEndTime = DCTimeDateUtil.getLocaleDisplayTime(oEndTimeCal);
        this.endTimeTxt.setText(strEndTime);
        this.endTimeTxt.setToolTipText(strEndTime);
        this.endTimeTxt.setCaretPosition(0);
        this.opTypeTxt.setText(logInfo.getDisplayableOperationType());
        this.opTypeTxt.setToolTipText(logInfo.getDisplayableOperationType());
        this.opPathTxt.setText(logInfo.getOperationFullPath());
        this.opPathTxt.setToolTipText(logInfo.getOperationFullPath());
        this.opPathTxt.setCaretPosition(0);
        this.userNameTxt.setText(logInfo.getUserName());
        this.userNameTxt.setToolTipText(logInfo.getUserName());
        this.clientIPAddressTxt.setText(logInfo.getClientIPAddress());
        this.clientIPAddressTxt.setToolTipText(logInfo.getClientIPAddress());
        this.resultTxt.setText(logInfo.getDisplayableOperationResult());
        this.resultTxt.setToolTipText(logInfo.getDisplayableOperationResult());
        if (logInfo.getOperationType() == -2 && !StringUtils.isNullOrEmptyStr(logInfo.getFailureReason())) {
            this.failureReasonTxtArea.setText(logInfo.getFailureReason());
        } else if (0 != logInfo.getFailureReason().trim().length()) {
            this.failureReasonTxtArea.setText(logInfo.getFailureReason());
        } else {
            this.failureReasonTxtArea.setText(logInfo.getDisplayableFailureReason());
        }
        if (firstRecord) {
            this.previousBtn.setEnabled(false);
        } else {
            this.previousBtn.setEnabled(true);
            this.previousBtn.grabFocus();
        }
        if (lastRecord) {
            this.nextBtn.setEnabled(false);
        } else {
            this.nextBtn.setEnabled(true);
            this.nextBtn.grabFocus();
        }
        this.rootPane.setDefaultButton(this.m_oCancelBtn);
    }

    private void previousBtn_actionPerformed() {
        this.logInfoPan.getPreviousLog();
    }

    private void nextBtn_actionPerformed() {
        this.logInfoPan.getNextLog();
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }
}

