/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.log;

import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCExtendedTable;
import com.huawei.dc.adapter.swimap.iview.templates.extendedtable.DCSortableTableModel;
import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnHAFailLogInfo;
import com.huawei.dc.common.asndatacenter.AsnHAFailLogInfoList;
import com.huawei.dc.common.asndatacenter.AsnHAFailLogInfoRsp;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.framework.ErrorCodeReader;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class HAPolicyLogInfoPanel
extends JPanel {
    private static final long serialVersionUID = 8005261945851854057L;
    private DCExtendedTable m_oTable = null;
    private DCSortableTableModel m_oTableModel = null;
    private JScrollPane m_oScrollPane = null;
    private AsnHAFailLogInfoList m_oAsnHAFailLogInfoList = new AsnHAFailLogInfoList();
    private JButton m_oRefreshBtn = null;
    private boolean m_bHaveInitData = false;

    public HAPolicyLogInfoPanel() {
        this.initGUI();
        this.addComponentActionListener();
        this.enableRefreshBtnStatus(true);
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        this.m_oTableModel = new DCSortableTableModel(this.getColumn(), 0){
            private static final long serialVersionUID = 5190573310313470057L;

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.m_oTable = new DCExtendedTable((SortableTableModel)this.m_oTableModel);
        this.m_oTable.setName("HAPolicyLogInfoPanel_m_oTable");
        this.m_oTable.getTableHeader().setReorderingAllowed(false);
        this.m_oTable.setScrolls(false);
        this.m_oTable.setUpDateSelectedRow(true);
        this.m_oTable.setInvalidedForeground(Color.BLACK);
        this.m_oTable.setColAutoResizeMode(2);
        this.m_oScrollPane = new JScrollPane((Component)this.m_oTable);
        this.m_oScrollPane.setName("HAPolicyLogInfoPanel_m_oScrollPane");
        this.m_oRefreshBtn = new JButton();
        this.m_oRefreshBtn.setText(ResourceManager.getInstance().getResString("ROOT_NODE_POPUP_MENU_ITEM_REFRESH"));
        this.m_oRefreshBtn.setMnemonic('F');
        this.m_oRefreshBtn.setName("HAPolicyLogInfoPanel_m_oRefreshBtn");
        this.m_oRefreshBtn.setPreferredSize(new Dimension(80, 21));
        this.m_oRefreshBtn.setMinimumSize(new Dimension(80, 21));
        this.m_oRefreshBtn.setEnabled(false);
        this.add((Component)this.m_oRefreshBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(12, 12, 0, 12), 0, 0));
        this.add((Component)this.m_oScrollPane, new GridBagConstraints(0, 1, 5, 4, 1.0, 1.0, 10, 1, new Insets(12, 2, 0, 0), 0, 0));
    }

    private void addComponentActionListener() {
        this.m_oRefreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HAPolicyLogInfoPanel.this.refreshHAPolicyLog();
            }
        });
    }

    private void initData() {
        this.m_oTableModel.getDataVector().clear();
        AsnHAFailLogInfoRsp oAsnHAFailLogInfoRsp = null;
        SystemManager sysMgr = new SystemManager();
        try {
            oAsnHAFailLogInfoRsp = sysMgr.getHAFailureInfo();
            int iErrorCode = oAsnHAFailLogInfoRsp.oErrorInfo.iErrorNo.intValue();
            String strMessageType = DCFrameWorkUtil.getLocalizedString("SUGGESTION");
            int iMessageType = 1;
            if (0 != iErrorCode) {
                this.showMessage(iErrorCode, strMessageType, iMessageType);
                return;
            }
        }
        catch (DCException e) {
            DCDebugTracer.trace("faild to get HA policy log info");
        }
    }

    public void updateLogGUI(AsnHAFailLogInfoRsp oAsnHAFailLogInfoRsp) {
        this.m_oAsnHAFailLogInfoList.addAll((Collection)oAsnHAFailLogInfoRsp.oAsnHAFailLogInfoList);
        if (oAsnHAFailLogInfoRsp.beLastInfo) {
            if (!this.fillResultTable(oAsnHAFailLogInfoRsp)) {
                return;
            }
            AsnHAFailLogInfo oAsnHAFailLogInfo = null;
            Vector oDataVct = new Vector();
            Vector<String> oRowData = null;
            int iSize = this.m_oAsnHAFailLogInfoList.size();
            for (int i = 0; i < iSize; ++i) {
                oRowData = new Vector<String>(0);
                oAsnHAFailLogInfo = (AsnHAFailLogInfo)this.m_oAsnHAFailLogInfoList.get(i);
                oRowData.add(oAsnHAFailLogInfo.iRecordID.toString());
                oRowData.add(new String(oAsnHAFailLogInfo.strFilePath));
                oRowData.add(ErrorCodeReader.getInstance().getErrorDesc(oAsnHAFailLogInfo.iErrorCode));
                oDataVct.add(oRowData);
            }
            if (!oDataVct.isEmpty()) {
                this.m_oTableModel.addRows(oDataVct);
            }
            this.updateGUI();
            this.m_oAsnHAFailLogInfoList.clear();
            this.enableRefreshBtnStatus(true);
        }
    }

    public void refreshHAPolicyLog() {
        this.enableRefreshBtnStatus(false);
        this.initData();
        this.setHaveInitData(true);
        this.updateGUI();
    }

    private void updateGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HAPolicyLogInfoPanel.this.m_oTable.updateUI();
                HAPolicyLogInfoPanel.this.m_oScrollPane.updateUI();
            }
        });
    }

    private void enableRefreshBtnStatus(boolean bEnable) {
        if (null != this.m_oRefreshBtn) {
            this.m_oRefreshBtn.setEnabled(bEnable);
        }
    }

    private boolean fillResultTable(AsnHAFailLogInfoRsp oAsnHAFailLogInfoRsp) {
        boolean bShowDlg = true;
        if (null == oAsnHAFailLogInfoRsp) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("LOG_INFO_PAN_NO_RECORD_IN_ASN"), DCFrameWorkUtil.getLocalizedString("INFORMATION"), 1);
            bShowDlg = false;
        } else if (0 != oAsnHAFailLogInfoRsp.oErrorInfo.iErrorNo.intValue()) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), oAsnHAFailLogInfoRsp.oErrorInfo.iErrorNo.intValue());
            bShowDlg = false;
        } else if (null == oAsnHAFailLogInfoRsp.oAsnHAFailLogInfoList || 0 == oAsnHAFailLogInfoRsp.oAsnHAFailLogInfoList.size()) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("LOG_INFO_PAN_NO_RECORD_IN_ASN"), DCFrameWorkUtil.getLocalizedString("INFORMATION"), 1);
            bShowDlg = false;
        } else {
            return true;
        }
        return bShowDlg;
    }

    private String[] getColumn() {
        String[] strColumns = new String[]{DCFrameWorkUtil.getLocalizedString("DEVICE_TABLE_COLUMN_SERIAL_NUMBER"), DCFrameWorkUtil.getLocalizedString("TASK_FILE_PATH"), DCFrameWorkUtil.getLocalizedString("FAILURE_REASON")};
        return strColumns;
    }

    public boolean isHaveInitData() {
        return this.m_bHaveInitData;
    }

    public void setHaveInitData(boolean bHaveInitData) {
        this.m_bHaveInitData = bHaveInitData;
    }

    private void showMessage(int iErrorCode, String strMessageType, int iMessageType) {
        DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, strMessageType, iMessageType);
    }
}

