/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.framework.sftp;

import com.huawei.dc.common.asndatacenter.AsnDCBackUpFileInfo;
import com.huawei.dc.common.asndatacenter.AsnDCFileTransferNotification;
import com.huawei.dc.common.dcmodule.CompareFileFrmTopo;
import com.huawei.dc.common.dcmodule.ViewFileFromTopo;
import com.huawei.dc.common.framework.system.ISystemManager;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.CompareNEFile;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.CompareToFiles;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.SaveBackupFileNotifier;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.ViewFile;
import com.huawei.dc.deviceoperation.DevOpObjectStore;
import com.huawei.dc.framework.ClientFileOperations;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.framework.FTPFileTransmit;
import com.huawei.dc.framework.INotifyTransferProgress;
import com.huawei.dc.framework.IRequest;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.framework.XFtpManager;
import com.huawei.dc.framework.sftp.SftpProgressListener;
import com.huawei.dc.sam.SAMFileTransHandler;
import com.huawei.dc.sam.view.SAMFileInfoImportDlg;
import com.huawei.dc.sam.view.SaveAsSAMFile;
import com.swimap.external.sf.filemanager.FileAttribute;
import com.swimap.external.sf.filemanager.FileManager;
import java.io.File;
import java.math.BigInteger;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class SFtpFileOperation
implements IRequest {
    private FileManager fm = null;
    private FTPFileTransmit oFTPFileTransmit = null;
    private SftpProgressListener m_oProgressListener = null;
    private int m_iOperationType;
    private String m_strSource;
    private String m_strDestination;
    private ISystemManager m_oSystemMgr = new SystemManager();
    private AsnDCFileTransferNotification m_oAsnFileTransRsp;
    private int m_iPriority = 5;
    private static final String INFO_FILE = "DCInfo_";
    private String m_strBackupClientPath = null;
    private int m_iOpRequestId = -1;
    private INotifyTransferProgress m_oNotifyTransferProgress;
    private int SFTP_CONNECT_FAIL = 996147209;

    public SFtpFileOperation(int iOperationType, String e, String strDestination, ClientFileOperations oFileOPerationObj) {
        this.m_iOperationType = iOperationType;
        this.m_strSource = e;
        this.m_strDestination = strDestination;
    }

    public SFtpFileOperation(int iOperationType, AsnDCFileTransferNotification oAsnFileTransResp) {
        this.m_iOperationType = iOperationType;
        this.m_oAsnFileTransRsp = oAsnFileTransResp;
    }

    @Override
    public void setDestination() {
        this.m_strDestination = CompareNEFile.getInstance().getDestinationPath();
    }

    @Override
    public void setSource() {
        this.m_strSource = CompareNEFile.getInstance().getSourcePath();
    }

    private int sftpGetFiles(String strServerPath, String strClientPath) {
        int iErrorCode = 0;
        try {
            FTPFileTransmit oFTPFileTransmit;
            if (strServerPath.startsWith("/")) {
                strServerPath = strServerPath.substring(1);
            }
            File serverFile = new File(strServerPath);
            String sFileName = serverFile.getName();
            File clientFile = new File(strClientPath);
            if (clientFile.isDirectory() && !"".equals(sFileName)) {
                strClientPath = strClientPath + "/" + sFileName;
            }
            if ((iErrorCode = (oFTPFileTransmit = new FTPFileTransmit(this.m_oNotifyTransferProgress, this.fm)).xFtpGetFiles(strServerPath, strClientPath)) != 0) {
                iErrorCode = 989855873;
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace("DC::SftpFileOperation:sftpGetFiles - Exception - strServerPath = " + strServerPath + " strClientPath = " + strClientPath);
            DCDebugTracer.trace(e);
            iErrorCode = 989855873;
            return iErrorCode;
        }
        return iErrorCode;
    }

    @Override
    public int checkIfFileExists(String strServerPath) {
        int iReturnCode = 0;
        int iIndex = strServerPath.lastIndexOf("/");
        String strFileName = strServerPath.substring(iIndex + 1);
        ArrayList oVectorFileLst = new ArrayList();
        try {
            FileAttribute filesInServer;
            int iNosFiles;
            if (strServerPath.startsWith("/")) {
                strServerPath = strServerPath.substring(1);
            }
            if (1 == (iNosFiles = (oVectorFileLst = this.oFTPFileTransmit.getFileLst(filesInServer = this.fm.listRemote(this.m_strSource, false), oVectorFileLst)).size()) && strFileName.equals(oVectorFileLst.get(0))) {
                return iReturnCode;
            }
        }
        catch (Exception e) {
            iReturnCode = 989855873;
        }
        return iReturnCode;
    }

    private int sftpPutFiles(String strClientPath, String strServerPath) {
        File oFilesize;
        int iErrorCode = 0;
        if (2 == this.m_iOperationType && 0L == (oFilesize = new File(strClientPath)).length()) {
            return 996147208;
        }
        try {
            strClientPath = strClientPath.replace('/', File.separatorChar);
            strServerPath = strServerPath.replace('\\', '/');
            if (strServerPath.startsWith("/") || strServerPath.startsWith("" + File.separatorChar)) {
                strServerPath = strServerPath.substring(1);
            }
            FTPFileTransmit oFTPFileTransmit = new FTPFileTransmit(this.m_oNotifyTransferProgress, this.fm);
            oFTPFileTransmit.xFtpPutFiles(strClientPath, strServerPath);
        }
        catch (Exception e) {
            DCDebugTracer.trace("DC::SftpFileOperation:sftpPutFiles - Exception - strServerPath = " + strServerPath + " strClientPath = " + strClientPath);
            DCDebugTracer.trace(e);
            iErrorCode = 989855873;
            return iErrorCode;
        }
        return iErrorCode;
    }

    private void getBackupFiles(int iConnecErrorcode) {
        if (0 == iConnecErrorcode) {
            if (null == this.m_oAsnFileTransRsp.oAsnFilesPathLst || 0 == this.m_oAsnFileTransRsp.oAsnFilesPathLst.size()) {
                this.createNotificationStructure(989855874, 0, 0);
                CompareNEFile.getInstance().setBackupFilePathForNE(null, 989855874);
                return;
            }
            AsnDCBackUpFileInfo oAsnFileInfo = (AsnDCBackUpFileInfo)this.m_oAsnFileTransRsp.oAsnFilesPathLst.get(0);
            String strServerDirPath = new String(oAsnFileInfo.strFileName);
            int iNosFiles = this.m_oAsnFileTransRsp.oAsnFilesPathLst.size();
            String strDestination = strServerDirPath;
            int iIndex = -1;
            int iErrorCode = iConnecErrorcode;
            for (int j = 0; j < 2; ++j) {
                iIndex = strServerDirPath.lastIndexOf("/");
                if (-1 == iIndex) continue;
                strServerDirPath = strServerDirPath.substring(0, iIndex);
            }
            try {
                Integer oDeviceID = this.m_oAsnFileTransRsp.iDeviceID.intValue();
                strDestination = (String)DevOpObjectStore.getInstance().getObjectInstance(oDeviceID);
                strDestination = this.createClientDirectory(strDestination, strServerDirPath, oDeviceID);
                if (0 == strDestination.length()) {
                    this.createNotificationStructure(989855769, iNosFiles, 0);
                    CompareNEFile.getInstance().setBackupFilePathForNE(strDestination, 989855769);
                    return;
                }
            }
            catch (Exception e) {
                DCDebugTracer.trace("DC::SftpFileOperation:getBackupFiles - Exception - strDestination = " + strDestination + " strServerDirPath = " + strServerDirPath);
                DCDebugTracer.trace(e);
                XFtpManager.getInstance().updateHaspMapValue(this.m_oAsnFileTransRsp.iDeviceID.intValue(), this.m_strBackupClientPath, Thread.currentThread().getName());
                this.createNotificationStructure(989855873, 0, 0);
            }
            XFtpManager.getInstance().updateHaspMapValue(this.m_oAsnFileTransRsp.iDeviceID.intValue(), strDestination, Thread.currentThread().getName());
            for (int i = 0; i < iNosFiles; ++i) {
                String strServerFile;
                oAsnFileInfo = (AsnDCBackUpFileInfo)this.m_oAsnFileTransRsp.oAsnFilesPathLst.get(i);
                iErrorCode = this.sftpGetFiles(new String(oAsnFileInfo.strFileName), strDestination);
                this.m_oAsnFileTransRsp.strClientPath = strDestination.getBytes();
                this.createNotificationStructure(iErrorCode, iNosFiles, i + 1);
                if (0 != iErrorCode) {
                    strServerFile = new String(oAsnFileInfo.strFileName);
                    int iIndex2 = strServerFile.lastIndexOf(47);
                    if (-1 != iIndex2) {
                        strServerFile = strServerFile.substring(iIndex2 + 6);
                    }
                    strDestination = strDestination + File.separatorChar + strServerFile;
                    strDestination = strDestination.replace(File.separatorChar, '/');
                    String[] arrBckFile = new String[]{strDestination};
                    ClientFileOperations oFileOperation = new ClientFileOperations();
                    oFileOperation.deleteFilesOnly(arrBckFile);
                    if (5 != this.m_iOperationType || !CompareNEFile.getInstance().checkIfRequestExists(this.m_iOpRequestId)) break;
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException e) {
                        DCDebugTracer.trace(e);
                    }
                    CompareNEFile.getInstance().setBackupFilePathForNE(strDestination, iErrorCode);
                    break;
                }
                if (i != iNosFiles - 1 || 5 != this.m_iOperationType) continue;
                strServerFile = new File(new String(oAsnFileInfo.strFileName)).getName();
                if (!strServerFile.startsWith(INFO_FILE)) {
                    String strCmpDestination = strDestination + File.separatorChar + strServerFile;
                    strCmpDestination = strCmpDestination.replace(File.separatorChar, '/');
                    this.notifyCompareNEModule(iErrorCode, strCmpDestination);
                    continue;
                }
                AsnDCBackUpFileInfo oAsnFirstFileInfo = (AsnDCBackUpFileInfo)this.m_oAsnFileTransRsp.oAsnFilesPathLst.get(0);
                strServerFile = new File(new String(oAsnFirstFileInfo.strFileName)).getName();
                String strCmpDestination = strDestination + File.separatorChar + strServerFile;
                strCmpDestination = strCmpDestination.replace(File.separatorChar, '/');
                this.notifyCompareNEModule(iErrorCode, strCmpDestination);
            }
        } else {
            this.createNotificationStructure(iConnecErrorcode, 0, 0);
            if (5 == this.m_iOperationType && CompareNEFile.getInstance().checkIfRequestExists(this.m_iOpRequestId)) {
                CompareNEFile.getInstance().setBackupFilePathForNE(null, iConnecErrorcode);
            }
        }
    }

    private void notifyCompareNEModule(int iErrorCode, String strCmpDestination) {
        boolean isServerOnSameMachine = CompareNEFile.getInstance().isServerOnSameMachine();
        if (0 == iErrorCode && !isServerOnSameMachine) {
            this.m_strDestination = this.m_strDestination.replace('/', File.separatorChar);
            if (this.m_strSource.charAt(0) == '/') {
                this.m_strSource = this.m_strSource.substring(1);
            }
            if ((iErrorCode = this.checkIfFileExists(this.m_strSource)) == 0) {
                iErrorCode = this.sftpGetFiles(this.m_strSource, this.m_strDestination);
            }
            if (CompareNEFile.getInstance().checkIfRequestExists(this.m_iOpRequestId)) {
                CompareNEFile.getInstance().setBackupFilePathForNE(strCmpDestination, iErrorCode);
            }
        } else {
            CompareNEFile.getInstance().setBackupFilePathForNE(strCmpDestination, iErrorCode);
        }
    }

    private String createClientDirectory(String strSelectedClientPath, String strServerBckPath, int iDevId) {
        if (null == strSelectedClientPath || null == strServerBckPath) {
            return "";
        }
        int iIndex = strServerBckPath.lastIndexOf("/");
        int iLength = strServerBckPath.length();
        if (-1 != iIndex) {
            strServerBckPath = strServerBckPath.substring(iIndex + 1, iLength);
        }
        strServerBckPath = FileUtil.getDirNameForDev(strServerBckPath, iDevId);
        String strDirName = strSelectedClientPath + "/" + strServerBckPath;
        SimpleDateFormat oTimeStampFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date oTimeStampFolder = new Date();
        strDirName = strDirName + "/" + oTimeStampFormat.format(oTimeStampFolder);
        File oCreateDir = new File(strDirName = strDirName.replace('/', File.separatorChar));
        if (!oCreateDir.mkdirs()) {
            return "";
        }
        return strDirName;
    }

    private int fileSizeCheck() {
        Integer oDeviceId = this.m_oAsnFileTransRsp.iDeviceID.intValue();
        Vector oVecSourceFiles = new Vector();
        if (11 == this.m_oAsnFileTransRsp.oDeviceOperationType.value) {
            Object oHashMapObject = DevOpObjectStore.getInstance().getObjectInstance(oDeviceId);
            if (null != oHashMapObject && oHashMapObject instanceof Vector) {
                oVecSourceFiles = (Vector)oHashMapObject;
            } else {
                return -1;
            }
        }
        int iResult = 0;
        int iVecSize = oVecSourceFiles.size();
        Vector<String> oVectorOfFiles = new Vector<String>(2);
        for (int i = 0; i < iVecSize; ++i) {
            File oFileSizeCheck = new File(oVecSourceFiles.get(i).toString());
            if (oFileSizeCheck.isDirectory()) {
                File[] arrFiles = oFileSizeCheck.listFiles();
                if (null != arrFiles) {
                    int iNosFiles = arrFiles.length;
                    for (int j = 0; j < iNosFiles; ++j) {
                        if (!arrFiles[j].isFile() || !arrFiles[j].exists()) continue;
                        oVectorOfFiles.add(arrFiles[j].getAbsolutePath());
                    }
                    DevOpObjectStore.getInstance().putObjectInstance(oDeviceId, oVectorOfFiles);
                }
                if (0 != oVectorOfFiles.size()) continue;
                iResult = -1;
                break;
            }
            if (0L != oFileSizeCheck.length()) continue;
            iResult = -1;
            break;
        }
        return iResult;
    }

    private void createNotificationStructure(int iErrorcode, int iTotalCount, int iCompletedCount) {
        this.createNotificationStructure(iErrorcode, iTotalCount, iCompletedCount, -1);
    }

    private void createNotificationStructure(int iErrorcode, int iTotalCount, int iCompletedCount, int iOperType) {
        XFtpManager oSftpOperationManager = XFtpManager.getInstance();
        this.m_oAsnFileTransRsp.oErrorInfo.iErrorNo = BigInteger.valueOf(iErrorcode);
        this.m_oAsnFileTransRsp.oErrorInfo.strResult = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorcode)).getBytes();
        this.m_oAsnFileTransRsp.iFileCount = BigInteger.valueOf(iTotalCount);
        this.m_oAsnFileTransRsp.iCompletedFile = BigInteger.valueOf(iCompletedCount);
        if (iOperType == 10) {
            this.m_oAsnFileTransRsp.iContentType = BigInteger.valueOf(iOperType);
        }
        oSftpOperationManager.sendFileTransferNotification(this.m_oAsnFileTransRsp);
    }

    public int sftpCopyFolder() {
        int iErrorCode = 0;
        ArrayList oVectorFileLst = new ArrayList();
        try {
            if (this.m_strSource.charAt(0) == '/') {
                this.m_strSource = this.m_strSource.substring(1);
            }
            FileAttribute filesInServer = this.fm.listRemote(this.m_strSource, false);
            oVectorFileLst = this.oFTPFileTransmit.getFileLst(filesInServer, oVectorFileLst);
            int iListOfFiles = oVectorFileLst.size();
            String strFileName = "";
            String strFinalSourcePath = "";
            Collator oCollator = Collator.getInstance();
            for (int i = 0; i < iListOfFiles; ++i) {
                Object oFileNameObj = oVectorFileLst.get(i);
                strFileName = oFileNameObj.toString();
                int iLastIndex = strFileName.lastIndexOf(" ");
                if (oCollator.equals(strFileName = strFileName.substring(iLastIndex + 1), ".") || oCollator.equals(strFileName, "..")) continue;
                strFinalSourcePath = this.m_strSource;
                if (!this.m_strSource.endsWith(strFileName) && !strFileName.startsWith(this.m_strSource)) {
                    strFinalSourcePath = strFinalSourcePath + "/" + strFileName;
                }
                if (0 == (iErrorCode = this.sftpGetFiles(strFinalSourcePath, this.m_strDestination))) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace("DC::SftpFileOperation:sftpCopyFolder - Exception - m_strSource = " + this.m_strSource);
            DCDebugTracer.trace(e);
            iErrorCode = 989855873;
        }
        return iErrorCode;
    }

    private void recoverFrmClientFiles(int iConnecErrorCode, int iOperType) {
        if (0 == iConnecErrorCode) {
            AsnDCBackUpFileInfo oAsnFileInfo = (AsnDCBackUpFileInfo)this.m_oAsnFileTransRsp.oAsnFilesPathLst.get(0);
            String strDestination = new String(oAsnFileInfo.strFileName);
            Vector oSourcePath = new Vector();
            Integer oDeviceId = this.m_oAsnFileTransRsp.iDeviceID.intValue();
            Object oHashMapObject = DevOpObjectStore.getInstance().getObjectInstance(oDeviceId);
            if (null != oHashMapObject && oHashMapObject instanceof Vector) {
                oSourcePath = (Vector)oHashMapObject;
            } else {
                this.createNotificationStructure(989855874, 0, 0, iOperType);
            }
            DevOpObjectStore.getInstance().removeObjectInstance(this.m_oAsnFileTransRsp.iDeviceID.intValue());
            int iErrorCode = iConnecErrorCode;
            XFtpManager.getInstance().updateHaspMapValue(this.m_oAsnFileTransRsp.iDeviceID.intValue(), " ", Thread.currentThread().getName());
            int iNosFiles = oSourcePath.size();
            for (int i = 0; i < iNosFiles; ++i) {
                String sClientFile = oSourcePath.get(i).toString();
                String sFileName = new File(sClientFile).getName();
                iErrorCode = this.sftpPutFiles(oSourcePath.get(i).toString(), strDestination + File.separator + sFileName);
                this.createNotificationStructure(iErrorCode, iNosFiles, i + 1, iOperType);
                if (0 == iErrorCode) {
                    continue;
                }
                break;
            }
        } else {
            this.createNotificationStructure(iConnecErrorCode, 0, 0, iOperType);
        }
    }

    @Override
    public void setPriority(int iPriority) {
        this.m_iPriority = iPriority;
    }

    @Override
    public int getPriority() {
        return this.m_iPriority;
    }

    @Override
    public void setOpRequestId(int iReqId) {
        this.m_iOpRequestId = iReqId;
    }

    @Override
    public void handleThreadException(RuntimeException e) {
        DCDebugTracer.trace("DC::SftpFileOperation:handleThreadException");
        DCDebugTracer.trace(e);
        if (null != this.m_oAsnFileTransRsp) {
            this.m_oAsnFileTransRsp.oErrorInfo.iErrorNo = BigInteger.valueOf(989855873L);
            XFtpManager oSftpOperationManager = XFtpManager.getInstance();
            oSftpOperationManager.sendFileTransferNotification(this.m_oAsnFileTransRsp);
        }
    }

    @Override
    public int createConnect() {
        this.oFTPFileTransmit = new FTPFileTransmit();
        int result = this.oFTPFileTransmit.createConnect();
        this.fm = this.oFTPFileTransmit.getFileManager();
        if (result != 0) {
            return this.SFTP_CONNECT_FAIL;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeFileOperationRequest() {
        DCDebugTracer.trace("[XFtp]executeFileOperationRequest start");
        DCDebugTracer.trace("[XFtp] m_iOperationType " + this.m_iOperationType);
        int iErrorCode = 0;
        try {
            switch (this.m_iOperationType) {
                case 0: {
                    iErrorCode = this.createConnect();
                    this.getBackupFiles(iErrorCode);
                    return;
                }
                case 5: {
                    iErrorCode = this.createConnect();
                    this.getBackupFiles(iErrorCode);
                    return;
                }
                case 2: {
                    iErrorCode = this.fileSizeCheck();
                    if (0 == iErrorCode) {
                        iErrorCode = this.createConnect();
                        this.recoverFrmClientFiles(iErrorCode, 2);
                        return;
                    }
                    this.createNotificationStructure(996147208, 0, 0);
                    return;
                }
                case 10: {
                    iErrorCode = this.fileSizeCheck();
                    if (0 == iErrorCode) {
                        iErrorCode = this.createConnect();
                        this.recoverFrmClientFiles(iErrorCode, 10);
                        return;
                    }
                    this.createNotificationStructure(996147208, 0, 0);
                    return;
                }
                case 9: {
                    iErrorCode = this.fileSizeCheck();
                    if (0 == iErrorCode) {
                        iErrorCode = this.createConnect();
                        this.samImportFromClient(iErrorCode);
                        return;
                    }
                    this.createNotificationStructure(996147208, 0, 0);
                    return;
                }
                case 3: {
                    iErrorCode = this.createConnect();
                    if (0 == iErrorCode) {
                        this.m_strDestination = this.m_strDestination.replace('/', File.separatorChar);
                        iErrorCode = this.checkIfFileExists(this.m_strSource);
                        if (0 == iErrorCode) {
                            iErrorCode = this.sftpGetFiles(this.m_strSource, this.m_strDestination);
                        }
                    }
                    if (!ViewFile.getInstance().checkIfRequestExists(this.m_iOpRequestId)) return;
                    ViewFile.getInstance().notifyFileTransferProgress(iErrorCode);
                    return;
                }
                case 4: {
                    iErrorCode = this.createConnect();
                    if (0 == iErrorCode) {
                        this.m_strDestination = this.m_strDestination.replace('/', File.separatorChar);
                        iErrorCode = this.checkIfFileExists(this.m_strSource);
                        if (0 == iErrorCode) {
                            iErrorCode = this.sftpGetFiles(this.m_strSource, this.m_strDestination);
                            DCDebugTracer.trace("[SFTP]  ftpGetFiles ErrorCode : " + iErrorCode);
                        }
                    }
                    DCDebugTracer.trace("[SFTP]  executeFileOperationRequest : " + this.m_iOpRequestId);
                    if (!CompareToFiles.getInstance().checkIfRequestExists(this.m_iOpRequestId)) return;
                    CompareToFiles.getInstance().notifyFileTransferProgress(iErrorCode);
                    return;
                }
                case 36: {
                    iErrorCode = this.createConnect();
                    if (0 == iErrorCode) {
                        this.m_strDestination = this.m_strDestination.replace('/', File.separatorChar);
                        iErrorCode = this.sftpGetFiles(this.m_strSource, this.m_strDestination);
                    }
                    SaveBackupFileNotifier.getInstance().notifyEvent(iErrorCode);
                    return;
                }
                case 41: {
                    iErrorCode = this.createConnect();
                    if (0 == iErrorCode) {
                        this.m_strDestination = this.m_strDestination.replace('/', File.separatorChar);
                        iErrorCode = this.sftpCopyFolder();
                    }
                    SaveBackupFileNotifier.getInstance().notifyEvent(iErrorCode);
                    return;
                }
                case 39: {
                    iErrorCode = this.createConnect();
                    if (0 == iErrorCode) {
                        this.m_strSource = this.m_strSource.replace(File.separatorChar, '/');
                        this.m_strDestination = this.m_strDestination.replace('/', File.separatorChar);
                        iErrorCode = this.sftpGetFiles(this.m_strSource, this.m_strDestination);
                    }
                    SaveAsSAMFile.getInstance().notifyFileTransferProgress(iErrorCode);
                    return;
                }
                case 40: {
                    if (XFtpManager.getInstance().getTransferCancelled()) {
                        return;
                    }
                    iErrorCode = this.createConnect();
                    if (0 == iErrorCode) {
                        this.m_strDestination = this.m_strDestination.replace('/', File.separatorChar);
                        iErrorCode = this.sftpPutFiles(this.m_strSource, this.m_strDestination);
                    }
                    SAMFileTransHandler.getInstance().notifyFileTransferProgress(iErrorCode);
                    return;
                }
                case 6: {
                    iErrorCode = this.createConnect();
                    if (0 == iErrorCode) {
                        this.m_strDestination = this.m_strDestination.replace('/', File.separatorChar);
                        iErrorCode = this.sftpGetFiles(this.m_strSource, this.m_strDestination);
                    }
                    if (!CompareNEFile.getInstance().checkIfRequestExists(this.m_iOpRequestId)) return;
                    CompareNEFile.getInstance().notifyFileTransferProgress(iErrorCode);
                    return;
                }
                case 7: {
                    iErrorCode = this.createConnect();
                    if (0 == iErrorCode) {
                        this.m_strDestination = this.m_strDestination.replace('/', File.separatorChar);
                        iErrorCode = this.checkIfFileExists(this.m_strSource);
                        if (0 == iErrorCode) {
                            iErrorCode = this.sftpGetFiles(this.m_strSource, this.m_strDestination);
                        }
                    }
                    ViewFileFromTopo.getInstance().notifyAll(iErrorCode, this.m_iOpRequestId);
                    return;
                }
                case 8: {
                    iErrorCode = this.createConnect();
                    if (0 == iErrorCode) {
                        this.m_strDestination = this.m_strDestination.replace('/', File.separatorChar);
                        iErrorCode = this.checkIfFileExists(this.m_strSource);
                        if (0 == iErrorCode) {
                            iErrorCode = this.sftpGetFiles(this.m_strSource, this.m_strDestination);
                        }
                    }
                    CompareFileFrmTopo.getInstance().notifyAll(iErrorCode, this.m_iOpRequestId);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            DCDebugTracer.trace("[SFTP]  SFtpFileOperation Exception");
            DCDebugTracer.trace(e);
            return;
        }
        finally {
            this.closeConnect();
            DCDebugTracer.trace("[SFTP]  closeConnect with OpRequestID: " + this.m_iOpRequestId);
        }
    }

    private void samImportFromClient(int iConnecErrorCode) {
        if (0 == iConnecErrorCode) {
            Vector oSourcePath = new Vector();
            Integer oDeviceId = this.m_oAsnFileTransRsp.iDeviceID.intValue();
            Object oHashMapObject = DevOpObjectStore.getInstance().getObjectInstance(oDeviceId);
            if (null != oHashMapObject && oHashMapObject instanceof Vector) {
                oSourcePath = (Vector)oHashMapObject;
            } else {
                this.createNotificationStructure(989855874, 0, 0);
            }
            DevOpObjectStore.getInstance().removeObjectInstance(this.m_oAsnFileTransRsp.iDeviceID.intValue());
            int iErrorCode = iConnecErrorCode;
            XFtpManager.getInstance().updateHaspMapValue(this.m_oAsnFileTransRsp.iDeviceID.intValue(), " ", Thread.currentThread().getName());
            int iNosFiles = oSourcePath.size();
            SAMFileInfoImportDlg oSAMFileInfoImportDlg = null;
            Object obj = ObjectStore.getInstance().getObjectInstance("SAMFileInfoImportDlg");
            if (null != obj) {
                oSAMFileInfoImportDlg = (SAMFileInfoImportDlg)((Object)obj);
            }
            int iRspCnt = this.m_oAsnFileTransRsp.oAsnFilesPathLst.size();
            for (int i = 0; i < iRspCnt; ++i) {
                AsnDCBackUpFileInfo oAsnFileInfo = (AsnDCBackUpFileInfo)this.m_oAsnFileTransRsp.oAsnFilesPathLst.get(i);
                String strDestination = new String(oAsnFileInfo.strFileName);
                iErrorCode = this.sftpPutFiles(oSourcePath.get(i % iNosFiles).toString(), strDestination);
                if (null != oSAMFileInfoImportDlg) {
                    oSAMFileInfoImportDlg.getSAMFileImportPanel().setFileProgressInfo(iRspCnt, i + 1);
                }
                if (i == iRspCnt - 1) {
                    this.createNotificationStructure(iErrorCode, iRspCnt, i + 1);
                }
                if (0 == iErrorCode && !XFtpManager.getInstance().getTransferCancelled()) continue;
                this.createNotificationStructure(iConnecErrorCode, 0, 0);
                break;
            }
        } else {
            this.createNotificationStructure(iConnecErrorCode, 0, 0);
        }
    }

    @Override
    public void closeConnect() {
        try {
            if (null != this.fm) {
                this.fm.disconnect();
                this.fm = null;
            }
            if (null != this.oFTPFileTransmit) {
                this.oFTPFileTransmit.disconnect();
                this.oFTPFileTransmit = null;
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    @Override
    public void registNotifyTransferProgressObj(INotifyTransferProgress oNotifyTransferProgress) {
        this.m_oNotifyTransferProgress = oNotifyTransferProgress;
    }

    @Override
    public void cancelTransfer() {
        if (null != this.m_oProgressListener) {
            this.m_oProgressListener.cancelTransfer();
        }
    }
}

