/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.framework.ftp;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.framework.INotifyTransferProgress;
import com.huawei.dc.framework.ftp.ICancelTransferListener;
import java.io.File;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;

public class FtpProgressListener
implements CopyStreamListener {
    private long m_lTotalSize;
    private long m_lCurrentProgress;
    private INotifyTransferProgress m_oNotifyObj;
    private ICancelTransferListener m_oCancelTransferListener;

    public FtpProgressListener(String strFilePath, INotifyTransferProgress oNotifyObj) {
        File file = new File(strFilePath);
        this.m_lTotalSize = file.length();
        this.m_oNotifyObj = oNotifyObj;
    }

    public FtpProgressListener(INotifyTransferProgress oNotifyObj) {
        this.m_oNotifyObj = oNotifyObj;
    }

    public void registCancelTransferListener(ICancelTransferListener oCancelTransferListener) {
        this.m_oCancelTransferListener = oCancelTransferListener;
    }

    public void setTotalSize(long lTotalSize) {
        this.m_lTotalSize = lTotalSize;
    }

    public void bytesTransferred(CopyStreamEvent copystreamevent) {
    }

    public void cancelTransfer() {
        if (null != this.m_oCancelTransferListener) {
            this.m_oCancelTransferListener.cancelTransfer();
        } else {
            DCDebugTracer.trace("The m_oCancelTransferListener is null.");
        }
    }

    public void bytesTransferred(long lTotal, int iReadSize, long lBufferSize) {
        long lCurrentProgress;
        if (0L < this.m_lTotalSize && this.m_lCurrentProgress != (lCurrentProgress = lTotal * 100L / this.m_lTotalSize)) {
            this.m_lCurrentProgress = lCurrentProgress;
            if (null != this.m_oNotifyObj) {
                this.m_oNotifyObj.notifyProgress((int)this.m_lCurrentProgress);
            }
        }
    }
}

