/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.framework.ftp;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.IOStreamClose;
import com.huawei.dc.framework.ftp.FtpProgressListener;
import com.huawei.dc.framework.ftp.XFtpInputStream;
import com.huawei.dc.framework.ftp.XFtpOutputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.net.io.FromNetASCIIInputStream;
import org.apache.commons.net.io.ToNetASCIIOutputStream;
import org.apache.commons.net.io.Util;

public class DCFTPClient
extends FTPClient {
    private int m_iFileType = 0;

    private boolean storeFileWithListener(int command, String remote, String local, FtpProgressListener oProgressListener) throws IOException {
        Socket oSocket = this._openDataConnection_(command, remote);
        if (null == oSocket) {
            DCDebugTracer.trace("DCFTPClient#storeFileWithListener open socket failed.");
            return false;
        }
        BufferedOutputStream oFileOut = new BufferedOutputStream(oSocket.getOutputStream(), this.getBufferSize());
        if (this.m_iFileType == 0) {
            oFileOut = new ToNetASCIIOutputStream((OutputStream)oFileOut);
        }
        XFtpInputStream oFileInput = null;
        try {
            oFileInput = new XFtpInputStream(local);
            oProgressListener.registCancelTransferListener(oFileInput);
            Util.copyStream((InputStream)oFileInput, (OutputStream)oFileOut, (int)102400, (long)-1L, (CopyStreamListener)oProgressListener, (boolean)false);
        }
        catch (IOException e) {
            try {
                oSocket.close();
            }
            catch (IOException f) {
                DCDebugTracer.trace("DCFTPClient#storeFileWithListener closed socket failed.");
                DCDebugTracer.trace(f);
            }
            throw e;
        }
        finally {
            DCDebugTracer.trace("FtpFileOperation:storeFileWithListener closed socket End ");
            IOStreamClose.close(oFileInput);
            IOStreamClose.close(oFileOut);
            if (null != oSocket && oSocket.isConnected()) {
                oSocket.close();
            }
        }
        return this.completePendingCommand();
    }

    public boolean storeFile(String strSrcPath, String strDstPath, FtpProgressListener oProgressListener) throws IOException {
        return this.storeFileWithListener(14, strDstPath, strSrcPath, oProgressListener);
    }

    private boolean retrieveFileWithListener(String remote, String local, FtpProgressListener oProgressListener) throws IOException {
        Socket oSocket = this._openDataConnection_(13, remote);
        if (null == oSocket) {
            return false;
        }
        XFtpOutputStream oSocketInput = new XFtpOutputStream(oSocket.getInputStream(), this.getBufferSize());
        oProgressListener.registCancelTransferListener(oSocketInput);
        if (this.m_iFileType == 0) {
            oSocketInput = new FromNetASCIIInputStream((InputStream)oSocketInput);
        }
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(local);
            Util.copyStream((InputStream)oSocketInput, (OutputStream)fout, (int)102400, (long)-1L, (CopyStreamListener)oProgressListener, (boolean)false);
        }
        catch (IOException e) {
            try {
                try {
                    oSocket.close();
                }
                catch (IOException f) {
                    DCDebugTracer.trace("DCFTPClient#retrieveFileWithListener closed socket failed.");
                    DCDebugTracer.trace(f);
                }
                throw e;
            }
            catch (Throwable throwable) {
                IOStreamClose.close(fout);
                throw throwable;
            }
        }
        IOStreamClose.close(fout);
        oSocket.close();
        return this.completePendingCommand();
    }

    public boolean retrieveFile(String strSrcPath, String strDstPath, FtpProgressListener oProgressListener) throws IOException {
        FTPFile[] files = this.listFiles(strSrcPath);
        if (0 < files.length && null != oProgressListener) {
            oProgressListener.setTotalSize(files[0].getSize());
        }
        return this.retrieveFileWithListener(strSrcPath, strDstPath, oProgressListener);
    }

    public boolean setFileType(int fileType) throws IOException {
        this.m_iFileType = fileType;
        return super.setFileType(fileType);
    }
}

