/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.framework;

import com.huawei.dc.common.asndatacenter.AsnDCFileTransferNotification;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.devicemanagement.deviceview.deviceinfo.backupinfo.CompareNEFile;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.framework.INotifyTransferProgress;
import com.huawei.dc.framework.IRequest;
import com.huawei.dc.framework.StClientFileTransInfo;
import com.huawei.dc.framework.ThreadPool;
import com.huawei.dc.framework.XFtpFileOperationFactory;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.communicate.MSGReceiver;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Vector;
import net.commustru.fstru.FStruct;

public class XFtpManager
extends MSGReceiver
implements IDCObjectDeallocator {
    private BaseCommManager m_oCommManager = DCFrameWorkUtil.getCommManager();
    private TIntObjectHashMap m_oDevIdReqIDMap = new TIntObjectHashMap();
    private int m_iCurrentSftpOperations = 0;
    private TIntObjectHashMap m_oDevClientInfoMap = new TIntObjectHashMap();
    private int m_iOpReqId = -1;
    private static XFtpManager m_oSftpManager = null;
    private ArrayList m_oMessageListener = new ArrayList(8);
    private boolean m_bTransferCancelled = false;
    private INotifyTransferProgress m_oNotifyTransferProgress;
    private int requestIdForRecover = -1;

    public void setRequestIdForRecover(int requestIdForRecover) {
        this.requestIdForRecover = requestIdForRecover;
    }

    private XFtpManager() {
    }

    public static synchronized XFtpManager getInstance() {
        if (null == m_oSftpManager) {
            m_oSftpManager = new XFtpManager();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oSftpManager);
        }
        return m_oSftpManager;
    }

    @Override
    public void setToNULL() {
        if (null != m_oSftpManager) {
            while (this.m_oMessageListener.size() > 0) {
                this.unregisterForNotification((Integer)this.m_oMessageListener.get(0));
            }
            if (null != this.m_oDevIdReqIDMap) {
                this.m_oDevIdReqIDMap.clear();
            }
            if (null != this.m_oDevClientInfoMap) {
                this.m_oDevClientInfoMap.clear();
            }
            this.close();
            this.m_oDevClientInfoMap = null;
            this.m_oDevIdReqIDMap = null;
            this.m_oCommManager = null;
            m_oSftpManager = null;
        }
    }

    protected void processMessage(MSGPacketExt oPacketExt) {
        DCDebugTracer.trace("receive asyn msg cmdCode=" + oPacketExt.mheader.cmdCode);
        try {
            this.processAyncMessage(oPacketExt);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    private void processAyncMessage(MSGPacketExt oPacketExt) {
        AsnDCFileTransferNotification oAsnFileTransRsp;
        int iErrorCode;
        if (43867 == oPacketExt.mheader.cmdCode && 0 == (iErrorCode = this.m_oCommManager.decodeAsn1Data((FStruct)(oAsnFileTransRsp = new AsnDCFileTransferNotification()), oPacketExt.getData()))) {
            if (null != oAsnFileTransRsp && 0 == oAsnFileTransRsp.oErrorInfo.iErrorNo.intValue()) {
                this.handleSuccess(oAsnFileTransRsp);
            } else {
                this.handleFailure(oAsnFileTransRsp);
            }
        }
    }

    private void handleSuccess(AsnDCFileTransferNotification oAsnFileTransRsp) {
        IRequest oFileOpRqst = null;
        switch (oAsnFileTransRsp.oDeviceOperationType.value) {
            case 4: {
                this.handleBackup(oAsnFileTransRsp);
                break;
            }
            case 11: {
                if (this.requestIdForRecover != oAsnFileTransRsp.oReqID.intValue()) {
                    DCDebugTracer.trace("requestIdForRecover is not the same now exit : " + this.requestIdForRecover);
                    return;
                }
                oFileOpRqst = XFtpFileOperationFactory.createXFtpFileOperation(2, oAsnFileTransRsp);
                ThreadPool.getInstance().addRequest(oFileOpRqst);
                break;
            }
            case 42: {
                oFileOpRqst = XFtpFileOperationFactory.createXFtpFileOperation(10, oAsnFileTransRsp);
                ThreadPool.getInstance().addRequest(oFileOpRqst);
                break;
            }
            case 26: {
                oFileOpRqst = XFtpFileOperationFactory.createXFtpFileOperation(9, oAsnFileTransRsp);
                ThreadPool.getInstance().addRequest(oFileOpRqst);
                break;
            }
        }
        if (null != oFileOpRqst) {
            oFileOpRqst.registNotifyTransferProgressObj(this.m_oNotifyTransferProgress);
        }
    }

    private void handleFailure(AsnDCFileTransferNotification oAsnFileTransRsp) {
        if (null == oAsnFileTransRsp) {
            oAsnFileTransRsp = new AsnDCFileTransferNotification();
            oAsnFileTransRsp.oErrorInfo.iErrorNo = BigInteger.valueOf(989855758L);
            oAsnFileTransRsp.oReqID = BigInteger.valueOf(0L);
            this.sendFileTransferNotification(oAsnFileTransRsp);
        } else if (4 == oAsnFileTransRsp.oDeviceOperationType.value) {
            int iOperationType = this.setOperationType(oAsnFileTransRsp);
            if (5 == iOperationType && CompareNEFile.getInstance().checkIfRequestExists(this.m_iOpReqId)) {
                CompareNEFile.getInstance().setBackupFilePathForNE(null, oAsnFileTransRsp.oErrorInfo.iErrorNo.intValue());
            }
        } else {
            this.sendFileTransferNotification(oAsnFileTransRsp);
        }
    }

    private void handleBackup(AsnDCFileTransferNotification oAsnFileTransRsp) {
        int iOperationType = this.setOperationType(oAsnFileTransRsp);
        IRequest oFileOpRqst = XFtpFileOperationFactory.createXFtpFileOperation(iOperationType, oAsnFileTransRsp);
        oFileOpRqst.setDestination();
        oFileOpRqst.setSource();
        if (5 == iOperationType) {
            if (CompareNEFile.getInstance().checkIfRequestExists(this.m_iOpReqId)) {
                ThreadPool.getInstance().addRequest(oFileOpRqst);
            } else {
                oAsnFileTransRsp.oErrorInfo.iErrorNo = BigInteger.valueOf(989855881L);
                oAsnFileTransRsp.oErrorInfo.strResult = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(989855881L)).getBytes();
                this.sendFileTransferNotification(oAsnFileTransRsp);
            }
            oFileOpRqst.setPriority(10);
            oFileOpRqst.setOpRequestId(this.m_iOpReqId);
        } else {
            ThreadPool.getInstance().addRequest(oFileOpRqst);
        }
    }

    public synchronized void incrementSftpOPerationCount(int iDeviceId, StClientFileTransInfo oClientObj) {
        this.m_oDevClientInfoMap.put(Integer.valueOf(iDeviceId).intValue(), (Object)oClientObj);
        ++this.m_iCurrentSftpOperations;
    }

    public synchronized void decrementSftpOPerationCount(int iDeviceId) {
        if (this.m_oDevClientInfoMap.containsKey(Integer.valueOf(iDeviceId).intValue())) {
            --this.m_iCurrentSftpOperations;
            this.m_oDevClientInfoMap.remove(Integer.valueOf(iDeviceId).intValue());
        }
    }

    public synchronized void updateHaspMapValue(int iDeviceId, String strBackupPath, String strThreadName) {
        StClientFileTransInfo oClientInfoObj = (StClientFileTransInfo)this.m_oDevClientInfoMap.get(Integer.valueOf(iDeviceId).intValue());
        if (null != oClientInfoObj) {
            oClientInfoObj.m_strBackupPath = strBackupPath;
            oClientInfoObj.m_strThreadName = strThreadName;
            this.m_oDevClientInfoMap.put(Integer.valueOf(iDeviceId).intValue(), (Object)oClientInfoObj);
        }
    }

    public int getSftpOPerationCount() {
        return this.m_iCurrentSftpOperations;
    }

    public TIntObjectHashMap getDeviceClientInfoMap() {
        return this.m_oDevClientInfoMap;
    }

    public void timeout(int iCmdCode, Character ocmdHandle) {
    }

    public void clientOpCleanUp() {
        if (0 < this.getSftpOPerationCount()) {
            TIntObjectHashMap oDeviceClientInfoMap = this.getDeviceClientInfoMap();
            Object[] oIterator = oDeviceClientInfoMap.getValues();
            Vector<String> oBackupPaths = new Vector<String>();
            for (int i = 0; i < oIterator.length; ++i) {
                StClientFileTransInfo oClientInfoObj;
                Object oClientObj = oIterator[i];
                if (!(oClientObj instanceof StClientFileTransInfo) || null == (oClientInfoObj = (StClientFileTransInfo)oClientObj) || 0 == Collator.getInstance().compare(oClientInfoObj.m_strBackupPath, "") || null == oBackupPaths) continue;
                oBackupPaths.add(oClientInfoObj.m_strBackupPath);
            }
            if (null != oBackupPaths && 0 != oBackupPaths.size()) {
                String[] strBackupPaths = new String[oBackupPaths.size()];
                oBackupPaths.toArray(strBackupPaths);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.deleteBackupFolders(oBackupPaths);
            }
        }
    }

    public void deleteBackupFolders(Vector oBackupFolderPaths) {
        int iSize = oBackupFolderPaths.size();
        for (int i = 0; i < iSize; ++i) {
            String strPath = (String)oBackupFolderPaths.get(i);
            File oFolderObj = new File(strPath = strPath.replace('\\', '/'));
            String[] strBackupFiles = oFolderObj.list();
            if (null == strBackupFiles) continue;
            int iNosFiles = strBackupFiles.length;
            for (int j = 0; j < iNosFiles; ++j) {
                File oFileObj = new File(strPath + "/" + strBackupFiles[j]);
                if (oFileObj.delete()) continue;
                DCDebugTracer.trace("DC::" + this.getClass() + ".deleteBackupFolders(fail to delete " + oFileObj + ")");
            }
        }
    }

    public void sendFileTransferNotification(AsnDCFileTransferNotification oAsnFileTransRsp) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_oCommManager.sendAsyncMsg(BaseCommManager.getMSGHead(43867), (FStruct)oAsnFileTransRsp, null);
    }

    public void registerForNotification(int iCmdCode) {
        this.m_oCommManager.addMessageListener(iCmdCode, (MSGListener)this);
        this.m_oMessageListener.add(iCmdCode);
    }

    public void unregisterForNotification(int iCmdCode) {
        this.m_oCommManager.removeMessageListener(iCmdCode, (MSGListener)this);
        this.m_oMessageListener.remove((Object)iCmdCode);
    }

    private int setOperationType(AsnDCFileTransferNotification oAsnFileTransRsp) {
        int iOperationType = 0;
        if (0 < this.m_oDevIdReqIDMap.size() && this.m_oDevIdReqIDMap.containsKey(oAsnFileTransRsp.iDeviceID.intValue())) {
            iOperationType = 5;
            this.m_iOpReqId = ((BigInteger)this.m_oDevIdReqIDMap.get(oAsnFileTransRsp.iDeviceID.intValue())).intValue();
            this.m_oDevIdReqIDMap.remove(oAsnFileTransRsp.iDeviceID.intValue());
        }
        return iOperationType;
    }

    public void setDeviceIdHashMap(int iDeviceId, int iReqId) {
        this.m_oDevIdReqIDMap.put(BigInteger.valueOf(iDeviceId).intValue(), (Object)BigInteger.valueOf(iReqId));
    }

    public void setTransferCancelled(boolean bFlag) {
        this.m_bTransferCancelled = bFlag;
    }

    public boolean getTransferCancelled() {
        return this.m_bTransferCancelled;
    }

    public void setNotifyProgressObj(INotifyTransferProgress oNotifyTransferProgress) {
        this.m_oNotifyTransferProgress = oNotifyTransferProgress;
    }
}

