/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.framework;

import com.huawei.dc.common.asndatacenter.AsnDCFileTransferNotification;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.framework.ClientFileOperations;
import com.huawei.dc.framework.IRequest;
import com.huawei.dc.framework.ftp.FtpFileOperation;
import com.huawei.dc.framework.sftp.SFtpFileOperation;
import com.swimap.external.ftpconf.FTPSetting;

public class XFtpFileOperationFactory {
    public static IRequest createXFtpFileOperation(int iOperationType, String e, String strDestination, ClientFileOperations oFileOPerationObj) {
        DCDebugTracer.trace("[XFtp] createXFtpFileOperation start");
        DCDebugTracer.trace("[XFtp]  iOperationType : " + iOperationType);
        DCDebugTracer.trace("[XFtp]  e : " + e);
        DCDebugTracer.trace("[XFtp]  strDestination : " + strDestination);
        int xFtpType = XFtpFileOperationFactory.getXFtpType();
        IRequest iRequest = null;
        DCDebugTracer.trace("[XFtp]  xftp Type : " + xFtpType);
        switch (xFtpType) {
            case 1: {
                iRequest = new FtpFileOperation(iOperationType, e, strDestination, oFileOPerationObj);
                break;
            }
            case 2: {
                iRequest = new SFtpFileOperation(iOperationType, e, strDestination, oFileOPerationObj);
                break;
            }
            default: {
                iRequest = new SFtpFileOperation(iOperationType, e, strDestination, oFileOPerationObj);
            }
        }
        DCDebugTracer.trace("[XFtp] createXFtpFileOperation end");
        return iRequest;
    }

    public static IRequest createXFtpFileOperation(int iOperationType, AsnDCFileTransferNotification oAsnFileTransResp) {
        DCDebugTracer.trace("[XFtp] createXFtpFileOperation start");
        DCDebugTracer.trace("[XFtp]  iOperationType : " + iOperationType);
        int xFtpType = XFtpFileOperationFactory.getXFtpType();
        IRequest iRequest = null;
        DCDebugTracer.trace("[XFtp]  xftp Type : " + xFtpType);
        switch (xFtpType) {
            case 1: {
                iRequest = new FtpFileOperation(iOperationType, oAsnFileTransResp);
                break;
            }
            case 2: {
                iRequest = new SFtpFileOperation(iOperationType, oAsnFileTransResp);
                break;
            }
            default: {
                iRequest = new SFtpFileOperation(iOperationType, oAsnFileTransResp);
            }
        }
        DCDebugTracer.trace("[XFtp] createXFtpFileOperation end");
        return iRequest;
    }

    public static int getXFtpType() {
        int xFtpType = 1;
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            xFtpType = FTPSetting.getFileTransferSetting().getMode();
            if (xFtpType == 1) {
                xFtpType = 2;
            } else if (xFtpType == 0) {
                xFtpType = 1;
            }
        } else {
            SystemManager sysMgr = new SystemManager();
            xFtpType = sysMgr.getServerFileTransfersProtocol();
        }
        return xFtpType;
    }
}

