/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.framework;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.framework.IRequest;
import com.huawei.dc.framework.ThreadRqstComparator;
import java.util.Collections;
import java.util.LinkedList;

public class ThreadPool
implements IDCObjectDeallocator {
    private TaskThread[] m_oThreadsArr = null;
    private static ThreadPool m_oThreadPool = null;
    private final LinkedList m_oRequestList = new LinkedList();

    private ThreadPool() {
        int iNoOfThreads = -1;
        int THREAD_POOL_SIZE = 4;
        try {
            String strNosOfthreads = ResourceManager.getInstance().getResString("NO_OF_THREADS_IN_POOL", "config");
            iNoOfThreads = Integer.parseInt(strNosOfthreads.trim());
            if (0 >= iNoOfThreads) {
                iNoOfThreads = 4;
            }
        }
        catch (Exception e) {
            iNoOfThreads = 4;
        }
        this.m_oThreadsArr = new TaskThread[iNoOfThreads];
        for (int i = 0; i < this.m_oThreadsArr.length; ++i) {
            this.m_oThreadsArr[i] = new TaskThread();
            this.m_oThreadsArr[i].setName(Integer.toString(i));
        }
    }

    public static synchronized ThreadPool getInstance() {
        if (null == m_oThreadPool) {
            m_oThreadPool = new ThreadPool();
            for (int i = 0; i < ThreadPool.m_oThreadPool.m_oThreadsArr.length; ++i) {
                ThreadPool.m_oThreadPool.m_oThreadsArr[i].start();
            }
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oThreadPool);
        }
        return m_oThreadPool;
    }

    @Override
    public void setToNULL() {
        if (null != m_oThreadPool) {
            int iThreadArrLength = this.m_oThreadsArr.length;
            for (int i = 0; i < iThreadArrLength; ++i) {
                if (null == this.m_oThreadsArr[i] || !this.m_oThreadsArr[i].isAlive()) continue;
                try {
                    this.m_oThreadsArr[i].interrupt();
                    this.m_oThreadsArr[i] = null;
                    continue;
                }
                catch (Exception e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
        m_oThreadPool = null;
    }

    public synchronized void addRequest(IRequest oFileOperationReqst) {
        ThreadRqstComparator oRqstComparator = new ThreadRqstComparator();
        this.m_oRequestList.add(oFileOperationReqst);
        Collections.sort(this.m_oRequestList, oRqstComparator);
        this.notifyAll();
    }

    public synchronized IRequest getRequestFromList() {
        try {
            while (!this.m_oRequestList.iterator().hasNext()) {
                this.wait(DCConstants.DEFAULT_WAIT_TIME);
            }
            Object oLstObject = this.m_oRequestList.iterator().next();
            if (null == oLstObject) {
                return null;
            }
            IRequest oRequestFromLst = null;
            if (oLstObject instanceof IRequest) {
                oRequestFromLst = (IRequest)oLstObject;
                this.m_oRequestList.remove(oRequestFromLst);
            }
            return oRequestFromLst;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public void stopSingleThread(String strThreadName) {
        int iNosThreads = this.m_oThreadsArr.length;
        for (int i = 0; i < iNosThreads; ++i) {
            if (null == this.m_oThreadsArr[i] || !strThreadName.equals(this.m_oThreadsArr[i].getName())) continue;
            this.m_oThreadsArr[i].interrupt();
            break;
        }
    }

    private class TaskThread
    extends Thread {
        private TaskThread() {
        }

        @Override
        public void run() {
            IRequest oRequestFromLst = null;
            try {
                do {
                    if (null == (oRequestFromLst = ThreadPool.this.getRequestFromList())) continue;
                    oRequestFromLst.executeFileOperationRequest();
                } while (null != oRequestFromLst || null != m_oThreadPool);
            }
            catch (RuntimeException e) {
                oRequestFromLst.handleThreadException(e);
            }
        }
    }
}

