/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.framework;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.configuration.system.FTSInfo;
import com.huawei.dc.configuration.system.IPConfigInfo;
import com.huawei.dc.framework.INotifyTransferProgress;
import com.huawei.dc.framework.XFtpFileOperationFactory;
import com.swimap.encryptv3.DCDynamicEncryptServiceUtil;
import com.swimap.external.sf.filemanager.DefaultProgress;
import com.swimap.external.sf.filemanager.FileAttribute;
import com.swimap.external.sf.filemanager.FileManager;
import com.swimap.external.sf.filemanager.FileManagerFactory;
import com.swimap.external.sf.filemanager.FileManagerMetaInfo;
import com.swimap.external.sf.filemanager.Progress;
import com.swimap.iview.framework.util.FrameworkUtilities;
import java.util.ArrayList;
import java.util.List;

public class FTPFileTransmit {
    private FTPFileTransmit oFTPFileTransmit = null;
    private int SUCCESSFUL = 0;
    private int FAIL = 1;
    private Progress oProgress = null;
    private FileManager xftpFileManager = null;
    INotifyTransferProgress m_oNotifyTransferProgress = null;
    private Thread thread = null;
    private Runnable runnable = null;

    public FTPFileTransmit(INotifyTransferProgress oNotifyTransferProgress, FileManager oFileManager) {
        this.m_oNotifyTransferProgress = oNotifyTransferProgress;
        this.xftpFileManager = oFileManager;
    }

    public FTPFileTransmit() {
        this.oFTPFileTransmit = this;
    }

    public FTPFileTransmit getInstance() {
        if (null == this.oFTPFileTransmit) {
            this.oFTPFileTransmit = new FTPFileTransmit();
        }
        return this.oFTPFileTransmit;
    }

    public int createConnect() {
        int result = this.SUCCESSFUL;
        SystemManager sytemManager = new SystemManager();
        FTSInfo ftsInfo = sytemManager.getFTSInfo();
        if (!DCFrameWorkUtil.getIsSingleClient()) {
            if (null != ftsInfo && null != ftsInfo.getServerIP() && ftsInfo.getServerIP().length() > 0) {
                FileManagerMetaInfo fileManagerMetaInfo = new FileManagerMetaInfo();
                FileManagerMetaInfo.MetaInfo meta = fileManagerMetaInfo.getDefaultServer();
                if (!ftsInfo.getFTPUserName().equals(meta.user)) {
                    this.xftpFileManager = this.getXftpFileManager(ftsInfo, ftsInfo.getServerIP());
                } else {
                    this.xftpFileManager = FileManagerFactory.createFileManager((String)meta.type);
                    this.xftpFileManager.connect(ftsInfo.getServerIP(), meta.port, meta.user, meta.getPassword());
                }
            } else {
                this.xftpFileManager = FileManagerFactory.defaultFileManager();
            }
        } else {
            String strServerIP = this.getServerIP(sytemManager);
            DCDebugTracer.trace("[XFtp]FtpFileOperation:createConnect ServerIP:" + strServerIP);
            this.xftpFileManager = this.getXftpFileManager(ftsInfo, strServerIP);
        }
        if (this.xftpFileManager == null) {
            DCDebugTracer.trace("[XFtp]FtpFileOperation:createConnect->fm is NULL");
            return this.FAIL;
        }
        try {
            result = this.xftpFileManager.connect();
        }
        catch (Exception e) {
            DCDebugTracer.trace("[XFtp]FtpFileOperation:createConnect result->" + e);
        }
        if (this.SUCCESSFUL != result) {
            DCDebugTracer.trace("[XFtp]FtpFileOperation:createConnect result->" + result);
            return this.FAIL;
        }
        return result;
    }

    private String getServerIP(SystemManager sytemManager) {
        ArrayList oIPList = null;
        String strServerIP = null;
        try {
            oIPList = sytemManager.getIPConfigInfo();
            IPConfigInfo oIPConfigInfo = (IPConfigInfo)oIPList.get(0);
            strServerIP = oIPConfigInfo.getStrServerIPAddress();
        }
        catch (DCException e) {
            DCDebugTracer.trace(e);
        }
        return strServerIP;
    }

    private FileManager getXftpFileManager(FTSInfo ftsInfo, String strServerIP) {
        char[] chPwd = "".toCharArray();
        if (XFtpFileOperationFactory.getXFtpType() == 1) {
            chPwd = DCDynamicEncryptServiceUtil.getInstance().getDecryptPassword(ftsInfo.getFTPPassword());
            this.xftpFileManager = FileManagerFactory.createFileManager((String)"FTP");
            this.xftpFileManager.connect(strServerIP, "21", ftsInfo.getFTPUserName(), String.valueOf(chPwd));
        } else if (XFtpFileOperationFactory.getXFtpType() == 2) {
            chPwd = DCDynamicEncryptServiceUtil.getInstance().getDecryptPassword(ftsInfo.getSFTPPassword());
            this.xftpFileManager = FileManagerFactory.createFileManager((String)"SFTP");
            this.xftpFileManager.connect(strServerIP, "22", ftsInfo.getFTPUserName(), String.valueOf(chPwd));
        }
        StringUtils.clearCharCipher(chPwd);
        return this.xftpFileManager;
    }

    public void disconnect() {
        if (null != this.xftpFileManager) {
            this.xftpFileManager.disconnect();
            this.xftpFileManager = null;
        }
        if (null != this.oFTPFileTransmit) {
            this.oFTPFileTransmit = null;
        }
    }

    public FileManager getFileManager() {
        if (null == this.xftpFileManager) {
            this.createConnect();
        }
        return this.xftpFileManager;
    }

    public int xFtpPutFiles(String strClientPath, String strServerPath) {
        this.startUpdateProgressBar();
        int result = this.xftpFileManager.upload(strClientPath, strServerPath, this.oProgress);
        this.stopUpdateProgressBar();
        if (this.SUCCESSFUL != result) {
            DCDebugTracer.trace("[XFtp]xFtpPutFiles fail->" + strClientPath);
        }
        return result;
    }

    public int xFtpGetFiles(String strServerPath, String strClientPath) {
        this.startUpdateProgressBar();
        int result = this.xftpFileManager.download(strServerPath, strClientPath, this.oProgress);
        this.stopUpdateProgressBar();
        if (this.SUCCESSFUL != result) {
            DCDebugTracer.trace("[XFtp]xFtpGetFiles fail->" + strClientPath);
        }
        return result;
    }

    private void startUpdateProgressBar() {
        this.oProgress = new DefaultProgress(FrameworkUtilities.getMainFrame(), "download", "downloading", null);
        this.runnable = new Runnable(){

            @Override
            public void run() {
                while (null != FTPFileTransmit.this.oProgress && FTPFileTransmit.this.oProgress.getProgress() < 100) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        DCDebugTracer.trace("[XFtp]startUpdateProgressBar sleep Exception" + e);
                    }
                    if (null == FTPFileTransmit.this.m_oNotifyTransferProgress) continue;
                    FTPFileTransmit.this.m_oNotifyTransferProgress.notifyProgress(FTPFileTransmit.this.oProgress.getProgress());
                }
                if (null != FTPFileTransmit.this.m_oNotifyTransferProgress) {
                    FTPFileTransmit.this.m_oNotifyTransferProgress.notifyProgress(FTPFileTransmit.this.oProgress.getProgress());
                }
            }
        };
        this.thread = new Thread(this.runnable);
        this.thread.setName("startUpdateProgressBar");
        this.thread.start();
    }

    private void stopUpdateProgressBar() {
        try {
            this.thread.join(50L);
        }
        catch (InterruptedException e) {
            DCDebugTracer.trace("[XFtp]stopUpdateProgressBar join Exception" + e);
        }
    }

    private ArrayList addFileLst(FileAttribute filesInServer, ArrayList files) {
        if (filesInServer.isDirectory()) {
            List filesInServerlist = filesInServer.getChildren();
            for (int i = 0; i < filesInServerlist.size(); ++i) {
                this.getFileLst((FileAttribute)filesInServerlist.get(i), files);
            }
        } else {
            files.add(filesInServer.getName());
            return files;
        }
        return files;
    }

    public ArrayList getFileLst(FileAttribute filesInServer, ArrayList files) {
        if (null != filesInServer) {
            this.addFileLst(filesInServer, files);
        }
        return files;
    }
}

