/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.framework;

import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.framework.ObjectStore;
import com.swimap.external.sm.adapter.message.EmfSecurityInterface;
import com.swimap.iview.commstyle.resource.ResourceMng;
import gnu.trove.TIntObjectHashMap;
import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ErrorCodeReader
implements IDCObjectDeallocator {
    private TIntObjectHashMap m_oErrorDescHashMap = new TIntObjectHashMap();
    private static ErrorCodeReader m_oInstance = null;
    private static final String OPERATION_SUCCESSFUL = ResourceManager.getInstance().getResString("OPERATION_SUCCESSFUL");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ErrorCodeReader() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            DocumentBuilderFactory oDocumentBuilderFactory = null;
            DocumentBuilder oDocumentBuilder = null;
            try {
                oDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
                oDocumentBuilder = oDocumentBuilderFactory.newDocumentBuilder();
                this.loadErrorCodeDescFiles(oDocumentBuilder);
            }
            catch (ParserConfigurationException e) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("CONFIG_ERROR"), ResourceManager.getInstance().getResString("ERROR"), 0);
            }
            finally {
                oDocumentBuilderFactory = null;
                oDocumentBuilder = null;
            }
        }
    }

    public static synchronized ErrorCodeReader getInstance() {
        if (m_oInstance == null) {
            m_oInstance = new ErrorCodeReader();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oInstance);
        }
        return m_oInstance;
    }

    @Override
    public void setToNULL() {
        if (null != this.m_oErrorDescHashMap) {
            this.m_oErrorDescHashMap.clear();
            this.m_oErrorDescHashMap = null;
        }
        m_oInstance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadErrorCodeDescFiles(DocumentBuilder oDocumentBuilder) {
        String strParamValue = null;
        Locale oLocale = ConfigurationInfo.getInstance().getLocale();
        String strErrNo = null;
        String strLangDir = null;
        strLangDir = oLocale.getLanguage() + "_" + oLocale.getCountry();
        FileFilter oFileFilter = new FileFilter(){

            @Override
            public final boolean accept(File oFilePath) {
                if (oFilePath.isFile()) {
                    String strFileName = oFilePath.getName();
                    return strFileName.toLowerCase(ResourceMng.getInstance().getLocale()).endsWith(".xml");
                }
                return oFilePath.isDirectory();
            }
        };
        String strDefaultStyledir = ConfigurationInfo.getInstance().getProductStyleDir();
        String strAboutDirectoryName = strDefaultStyledir + "locale" + File.separatorChar + "" + strLangDir + File.separatorChar + "errorcode";
        File oAboutDirectory = new File(strAboutDirectoryName);
        File[] arrayOfXmlFiles = oAboutDirectory.listFiles(oFileFilter);
        Document oDocument = null;
        Element oRootNode = null;
        NodeList oRootNodeList = null;
        int iLength = 0;
        Node oDescNode = null;
        NodeList oParametersList = null;
        Node oParametersNode = null;
        NodeList oParamNameValueList = null;
        int iParaNameValueLength = 0;
        Node oParameter = null;
        NamedNodeMap oParaMap = null;
        if (null != arrayOfXmlFiles) {
            int iXmlFileListLength = arrayOfXmlFiles.length;
            for (int i = 0; i < iXmlFileListLength; ++i) {
                try {
                    oDocument = oDocumentBuilder.parse(arrayOfXmlFiles[i]);
                }
                catch (IOException e) {
                    oDocument = null;
                    continue;
                }
                catch (SAXException e) {
                    oDocument = null;
                    continue;
                }
                oRootNode = oDocument.getDocumentElement();
                oRootNode.normalize();
                oRootNodeList = oRootNode.getElementsByTagName("DESC");
                iLength = oRootNodeList.getLength();
                for (int j = 0; j < iLength; ++j) {
                    oDescNode = oRootNodeList.item(j);
                    oParametersList = ((Element)oDescNode).getElementsByTagName("PARAS");
                    oParametersNode = oParametersList.item(0);
                    oParamNameValueList = ((Element)oParametersNode).getElementsByTagName("PARA");
                    iParaNameValueLength = oParamNameValueList.getLength();
                    for (int k = 0; k < iParaNameValueLength; ++k) {
                        oParameter = oParamNameValueList.item(k);
                        oParaMap = oParameter.getAttributes();
                        strErrNo = oParaMap.getNamedItem("name").getNodeValue();
                        strParamValue = null == oParaMap.getNamedItem("value") ? strErrNo : oParaMap.getNamedItem("value").getNodeValue();
                        try {
                            Long lError = new Long(strErrNo);
                            Integer oInt = lError.intValue();
                            this.m_oErrorDescHashMap.put(oInt.intValue(), (Object)strParamValue);
                            continue;
                        }
                        catch (Exception ex) {
                            continue;
                        }
                        finally {
                            oParameter = null;
                            oParaMap = null;
                        }
                    }
                    oDescNode = null;
                }
                oRootNode = null;
                oRootNodeList = null;
                oDescNode = null;
                oParametersList = null;
                oParametersNode = null;
                oParamNameValueList = null;
                oParameter = null;
                oParaMap = null;
                oDocument = null;
            }
        }
    }

    public String getErrorDesc(BigInteger oErrorCode) {
        if (null == oErrorCode) {
            return "";
        }
        if (0 == oErrorCode.intValue()) {
            return OPERATION_SUCCESSFUL;
        }
        Integer oInError = oErrorCode.intValue();
        DCDebugTracer.trace("getErrorDesc#oErrorCode:" + oErrorCode);
        if (DCFrameWorkUtil.getIsSingleClient()) {
            StringBuffer strErrorCodeDesc = new StringBuffer();
            switch (oInError) {
                case -4: {
                    strErrorCodeDesc.append(ResourceManager.getInstance().getResString("SERVER_NOT_REACHABLE_MESSAGE"));
                    return strErrorCodeDesc.toString();
                }
                case -3: {
                    strErrorCodeDesc.append(ResourceManager.getInstance().getResString("Error_Code_-3"));
                    return strErrorCodeDesc.toString();
                }
                case -1: {
                    strErrorCodeDesc.append(ResourceManager.getInstance().getResString("Error_Code_-1"));
                    return strErrorCodeDesc.toString();
                }
                case 106: {
                    strErrorCodeDesc.append(ResourceManager.getInstance().getResString("Error_Code_106"));
                    return strErrorCodeDesc.toString();
                }
            }
            Object oErrorInfo = this.m_oErrorDescHashMap.get(oInError.intValue());
            if (null == oErrorInfo) {
                strErrorCodeDesc.append(oInError);
            } else {
                strErrorCodeDesc.append((String)oErrorInfo);
            }
            DCDebugTracer.trace("getErrorDesc#strErrorCodeDesc:" + strErrorCodeDesc);
            return strErrorCodeDesc.toString();
        }
        Object oErrorInfo = this.m_oErrorDescHashMap.get(oInError.intValue());
        if (null == oErrorInfo) {
            String strErrCode = oErrorCode.toString();
            Object obj = ObjectStore.getInstance().getObjectInstance("securityinterface");
            String sErrorInfo = ((EmfSecurityInterface)obj).getErrorInfo(strErrCode);
            if (sErrorInfo.equals(oErrorCode.toString())) {
                DCDebugTracer.trace("the error code (" + strErrCode + ") can't be parsed.");
            }
            this.m_oErrorDescHashMap.put(oInError.intValue(), (Object)sErrorInfo);
            DCDebugTracer.trace("getErrorDesc#sErrorInfo:" + sErrorInfo);
            return sErrorInfo;
        }
        if (oInError.toString().equals(oErrorInfo.toString())) {
            DCDebugTracer.trace("the error code (" + oInError.toString() + ") can't be parsed from map.");
        }
        DCDebugTracer.trace("getErrorDesc#oErrorInfo:" + oErrorInfo);
        return (String)oErrorInfo;
    }

    public String getSuccessInfo() {
        return OPERATION_SUCCESSFUL;
    }
}

