/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.framework;

import com.huawei.dc.common.asndatacenter.AsnDCManualBackupInfo;
import com.huawei.dc.common.asndatacenter.AsnDCManualBackupReq;
import com.huawei.dc.common.asndatacenter.AsnDCMultiDeviceErr;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.deviceoperation.DeviceOperationManagerImpl;
import com.huawei.dc.framework.INotifyTransferProgress;
import com.huawei.dc.framework.IRequest;
import com.huawei.dc.framework.ThreadPool;
import com.huawei.dc.framework.XFtpFileOperationFactory;
import com.huawei.dc.framework.XFtpManager;
import com.huawei.dc.sam.view.SAMFileInfoImportPanel;
import java.io.File;
import java.math.BigInteger;

public class ClientFileOperations {
    private static final String INFO_FILE = "DCInfo_";

    public void deleteFilesOnly(String[] strFilePathArr) {
        int iNosFiles = strFilePathArr.length;
        File oDelFile = null;
        for (int i = 0; i < iNosFiles; ++i) {
            int index = strFilePathArr[i].lastIndexOf("/");
            String strFileName = INFO_FILE + strFilePathArr[i].substring(index + 1);
            String strInfoFile = strFilePathArr[i].substring(0, index) + "/" + strFileName;
            oDelFile = new File(strInfoFile);
            if (!oDelFile.exists()) continue;
            if (oDelFile.delete()) {
                DCDebugTracer.trace("delete file success : " + strInfoFile);
                continue;
            }
            DCDebugTracer.trace("delete file failed : " + strInfoFile);
        }
    }

    public void getFileFromServer(String strSourcePath, String strDestiPath, int iOpReqID, int iOperationType) {
        DCDebugTracer.trace("[FTP]  getFileFromServer : " + iOpReqID);
        DCDebugTracer.trace("[FTP]  strSourcePath : " + strSourcePath);
        DCDebugTracer.trace("[FTP]  strDestiPath : " + strDestiPath);
        strSourcePath = FileUtil.getUnifyPath(strSourcePath);
        strDestiPath = FileUtil.getUnifyPath(strDestiPath);
        IRequest oGetFileRequest = XFtpFileOperationFactory.createXFtpFileOperation(iOperationType, strSourcePath, strDestiPath, this);
        oGetFileRequest.setPriority(10);
        oGetFileRequest.setOpRequestId(iOpReqID);
        ThreadPool.getInstance().addRequest(oGetFileRequest);
    }

    public void getFileForSaveas(String strSourcePath, String strDestiPath, int iOpReqID) {
        IRequest oGetFileRequest = XFtpFileOperationFactory.createXFtpFileOperation(36, strSourcePath, strDestiPath, this);
        oGetFileRequest.setPriority(10);
        oGetFileRequest.setOpRequestId(iOpReqID);
        ThreadPool.getInstance().addRequest(oGetFileRequest);
    }

    public void getFileForSaveasFolder(String strDestinationPath, String strSourcePath, int iOpReqID) {
        IRequest oGetFileRequest = XFtpFileOperationFactory.createXFtpFileOperation(41, strSourcePath, strDestinationPath, this);
        oGetFileRequest.setPriority(10);
        oGetFileRequest.setOpRequestId(iOpReqID);
        ThreadPool.getInstance().addRequest(oGetFileRequest);
    }

    public IRequest getFileForSAMSaveas(String strSourcePath, String strDestiPath, int iOpReqID, INotifyTransferProgress oNotifyTransferProgressObj) {
        IRequest oGetFileRequest = XFtpFileOperationFactory.createXFtpFileOperation(39, strSourcePath, strDestiPath, this);
        oGetFileRequest.setPriority(10);
        oGetFileRequest.setOpRequestId(iOpReqID);
        oGetFileRequest.registNotifyTransferProgressObj(oNotifyTransferProgressObj);
        ThreadPool.getInstance().addRequest(oGetFileRequest);
        return oGetFileRequest;
    }

    public void putFilesForSAMWholeVersion(String strSourcePath, String strDestiPath, int iOpReqID, SAMFileInfoImportPanel oSAMFileInfoImportPanel) {
        strSourcePath = strSourcePath.replace('/', File.separatorChar);
        if ((strDestiPath = strDestiPath.replace('\\', '/')).startsWith("/")) {
            strDestiPath = strDestiPath.substring(1);
        }
        IRequest oGetFileRequest = XFtpFileOperationFactory.createXFtpFileOperation(40, strSourcePath, strDestiPath, this);
        oGetFileRequest.setPriority(10);
        oGetFileRequest.setOpRequestId(iOpReqID);
        oGetFileRequest.registNotifyTransferProgressObj(oSAMFileInfoImportPanel);
        ThreadPool.getInstance().addRequest(oGetFileRequest);
    }

    public int getNEFileForCmp(int iDeviceId, int iContentType, int iOpReqID) {
        int iErrorcode = 0;
        AsnDCManualBackupInfo asnDcManualBackupInfo = new AsnDCManualBackupInfo();
        AsnDCManualBackupReq asnBackupToClient = new AsnDCManualBackupReq();
        AsnDCOpertionRsp oAsnOpertionRsp = new AsnDCOpertionRsp();
        DeviceOperationManagerImpl oDeviceOperationMgr = (DeviceOperationManagerImpl)DCFrameWorkUtil.getDeviceOperationManager();
        asnDcManualBackupInfo.iDeviceID = BigInteger.valueOf(iDeviceId);
        asnDcManualBackupInfo.bSaveBeforeBackup = false;
        asnDcManualBackupInfo.iContentType = BigInteger.valueOf(iContentType);
        asnBackupToClient.strServerName = "".getBytes();
        asnBackupToClient.oManualBackupInfo.add((Object)asnDcManualBackupInfo);
        oAsnOpertionRsp = oDeviceOperationMgr.manualBackup(asnBackupToClient, 1);
        if (null == oAsnOpertionRsp) {
            iErrorcode = -1;
        } else {
            iErrorcode = oAsnOpertionRsp.oErrorInfo.iErrorNo.intValue();
            if (0 == iErrorcode) {
                if (null != oAsnOpertionRsp.oResultOpt && 0 != oAsnOpertionRsp.oResultOpt.size()) {
                    AsnDCMultiDeviceErr asnDeviceErr = (AsnDCMultiDeviceErr)oAsnOpertionRsp.oResultOpt.get(0);
                    iErrorcode = asnDeviceErr.oErrorInfo.iErrorNo.intValue();
                } else {
                    XFtpManager oSftpmanager = XFtpManager.getInstance();
                    oSftpmanager.setDeviceIdHashMap(iDeviceId, iOpReqID);
                }
            }
        }
        return iErrorcode;
    }

    public int getNEFileForStdAloneCmp(int iDeviceId, int iContentType, int iOpReqID) {
        int iErrorcode = 0;
        AsnDCManualBackupInfo asnDcManualBackupInfo = new AsnDCManualBackupInfo();
        AsnDCManualBackupReq asnBackupToServer = new AsnDCManualBackupReq();
        AsnDCOpertionRsp oAsnOpertionRsp = new AsnDCOpertionRsp();
        DeviceOperationManagerImpl oDeviceOperationMgr = (DeviceOperationManagerImpl)DCFrameWorkUtil.getDeviceOperationManager();
        asnDcManualBackupInfo.iDeviceID = BigInteger.valueOf(iDeviceId);
        asnDcManualBackupInfo.bSaveBeforeBackup = false;
        asnDcManualBackupInfo.iContentType = BigInteger.valueOf(iContentType);
        asnBackupToServer.strServerName = "".getBytes();
        asnBackupToServer.oManualBackupInfo.add((Object)asnDcManualBackupInfo);
        oAsnOpertionRsp = oDeviceOperationMgr.manualBackup(asnBackupToServer, 0);
        if (null == oAsnOpertionRsp) {
            iErrorcode = -1;
        } else {
            iErrorcode = oAsnOpertionRsp.oErrorInfo.iErrorNo.intValue();
            if (0 == iErrorcode) {
                if (null != oAsnOpertionRsp.oResultOpt && 0 != oAsnOpertionRsp.oResultOpt.size()) {
                    AsnDCMultiDeviceErr asnDeviceErr = (AsnDCMultiDeviceErr)oAsnOpertionRsp.oResultOpt.get(0);
                    iErrorcode = asnDeviceErr.oErrorInfo.iErrorNo.intValue();
                } else {
                    XFtpManager oSftpmanager = XFtpManager.getInstance();
                    oSftpmanager.setDeviceIdHashMap(iDeviceId, iOpReqID);
                }
            }
        }
        return iErrorcode;
    }
}

