/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.file.util;

import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCSaveFileChooser;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.policy.controller.PolicyUtil;
import com.huawei.dc.security.LoginInfo;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.tools.TablePrintable;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JFrame;

public class SaveAsFileUtil {
    final ResourceManager ORES = ResourceManager.getInstance();
    private SimpleProgressDlg m_oGettingDevtProgressDlg = null;
    private SaveAsFileUtil oSaveAsFileUtil = this;
    private DCSaveFileChooser oFileChooserDlg = null;

    public SaveAsFileUtil getInstance() {
        if (null == this.oSaveAsFileUtil) {
            this.oSaveAsFileUtil = new SaveAsFileUtil();
        }
        return this.oSaveAsFileUtil;
    }

    public DCSaveFileChooser getSaveFileChoose(String strTitle) {
        DCSaveFileChooser oFileChooserDlg = null;
        oFileChooserDlg = new DCSaveFileChooser();
        String strTime = PolicyUtil.getTime("yyyyMMddHHmmss");
        oFileChooserDlg.setFileFilter(7);
        oFileChooserDlg.setAcceptAllFileFilterUsed(false);
        oFileChooserDlg.setEncodingEnabled(false);
        strTitle = FileUtil.getFileName(strTitle);
        oFileChooserDlg.setSelectedFile(new File(strTitle + strTime));
        return oFileChooserDlg;
    }

    public String getSelectFileName(String strTitle) {
        this.oFileChooserDlg = this.getSaveFileChoose(strTitle);
        int iReturnVal = this.oFileChooserDlg.showSaveDialog(DCFrameWorkUtil.getMainFrame());
        String strFileName = null;
        if (iReturnVal == 0) {
            strFileName = this.oFileChooserDlg.getFullFileName();
            if (strFileName.endsWith(".html") || strFileName.endsWith(".htm") || strFileName.endsWith(".txt") || strFileName.endsWith(".csv") || strFileName.endsWith(".HTML") || strFileName.endsWith(".HTM") || strFileName.endsWith(".TXT") || strFileName.endsWith(".CSV")) {
                return strFileName;
            }
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), this.ORES.getResString("SAVE_FILE_TYPE_NOT_SUPP"), this.ORES.getResString("ERROR_MESSAGE"), 0);
            return null;
        }
        return strFileName;
    }

    public void saveAsInFile(Vector oDataVct, String strHeaderName, String[] sTableHearders, String sFileName) {
        TablePrintable printable = null;
        String strHeader = strHeaderName;
        LoginInfo loginInfo = DCFrameWorkUtil.getSecurityManager().getLoginInfo();
        String strUserName = loginInfo.getUserName();
        try {
            printable = new TablePrintable(strHeader, strUserName, " ", sTableHearders, (Collection)oDataVct, oDataVct.size(), true);
        }
        catch (Exception ex) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_VECTOR_FAILED"), ResourceManager.getInstance().getResString("INFO"), 1);
            return;
        }
        String strFileType = null;
        strFileType = sFileName.endsWith(".html") || sFileName.endsWith(".htm") || sFileName.endsWith(".HTML") || sFileName.endsWith(".HTM") ? "html" : (sFileName.endsWith(".csv") || sFileName.endsWith(".CSV") ? "csv" : "txt");
        String userEncoding = (String)DCSaveFileChooser.ENCODING_KEY_VALUE_MAP.get(this.oFileChooserDlg.getUserEncoding());
        if (null == userEncoding || userEncoding.length() == 0) {
            userEncoding = FileUtil.getSystemEncoding();
        }
        boolean bSaveSuccess = PrintSupportor.saveToFile((JFrame)DCFrameWorkUtil.getMainFrame(), (String)sFileName, (TablePrintable)printable, (String)strFileType, (String)userEncoding);
        this.showProgressDialog(printable);
        if (!bSaveSuccess || printable.getSaveState().equals("save unsuccessfully")) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SAVE_FAILURE"), ResourceManager.getInstance().getResString("ERROR_MESSAGE"), 0);
        } else if (printable.getSaveState().equals("save in one file")) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FILE_EXPORT_SUCCESSFULLY"), ResourceManager.getInstance().getResString("SUGGESTION"), 1);
        }
    }

    private void showProgressDialog(final TablePrintable printable) {
        this.closeProgressDlg();
        this.initProgressDlg();
        boolean bSaving = printable.getSaveState().equals("saving") || !printable.isOver();
        DCDebugTracer.trace("SaveAsFileUtil#showProgressDialo bSaving:" + bSaving);
        if (bSaving) {
            Thread oProgress = new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean bSaving = printable.getSaveState().equals("saving") || !printable.isOver();
                    try {
                        for (int i = 0; i < 300 && bSaving; ++i) {
                            Thread.sleep(100L);
                            boolean bl = bSaving = printable.getSaveState().equals("saving") || !printable.isOver();
                            if (bSaving) continue;
                            DCDebugTracer.trace("SaveAsFileUtil#showProgressDialo closeProgressDlg In Thread.");
                            Thread.sleep(400L);
                            SaveAsFileUtil.this.closeProgressDlg();
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        DCDebugTracer.trace(e);
                    }
                    SaveAsFileUtil.this.closeProgressDlg();
                }
            });
            oProgress.setName("Export List Progress");
            oProgress.start();
            if (!this.m_oGettingDevtProgressDlg.isVisible()) {
                this.m_oGettingDevtProgressDlg.setVisible(true);
            }
        }
        this.closeProgressDlg();
    }

    private void closeProgressDlg() {
        DCDebugTracer.trace("SaveAsFileUtil#showProgressDialo closeProgressDlg.");
        if (null != this.m_oGettingDevtProgressDlg) {
            this.m_oGettingDevtProgressDlg.dispose();
        }
    }

    private void initProgressDlg() {
        this.m_oGettingDevtProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("EXPORT_LIST_BTN_TOOLTIP"), true, ResourceManager.getInstance().getResString("EXPORT_LIST_BTN_TOOLTIP_ING")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancelRollBtnActionPerformed() {
                if (null == SaveAsFileUtil.this.m_oGettingDevtProgressDlg) {
                    return;
                }
                SaveAsFileUtil.this.m_oGettingDevtProgressDlg.dispose();
                this.doCleanUp();
            }
        };
        this.m_oGettingDevtProgressDlg.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
    }
}

