/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.deviceoperation.util;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.framework.ErrorCodeReader;
import java.awt.Color;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.Collator;

public class OperationStatus
implements Serializable,
Comparable<OperationStatus> {
    private static final long serialVersionUID = -3700759713344299665L;
    private boolean isProgress = false;
    private boolean isInitialize = false;
    private int iProgress = 0;
    private int operationType = -1;
    private int iFailureReason = -1;
    private int iOperationResultStatus = -1;
    private String failureReason = "";
    private String m_strOperationName = "";
    private Color operationStausColor;
    private static final Color TASK_STATE_NOT_RUN_COLOR = Color.BLACK;
    private static final Color TASK_STATE_FAILURE_COLOR = new Color(196, 48, 45);
    private static final Color TASK_STATE_SUCCESS_COLOR = new Color(74, 181, 80);
    private static final Color TASK_STATE_OVERTIME_COLOR = new Color(0, 0, 255);
    private int iTaskID = -1;
    private String strOprationID = "";
    private long firstOpenClientTime = System.nanoTime();

    public OperationStatus() {
        this.failureReason = ResourceManager.getInstance().getResString("NO_MANUAL_OPERATION");
    }

    public void setIsProgress(boolean isProgress) {
        this.isProgress = isProgress;
        if (!isProgress) {
            this.iTaskID = -1;
        }
    }

    public boolean getIsProgress() {
        return this.isProgress;
    }

    public void setOperationType(int operationType) {
        this.operationType = operationType;
        switch (operationType) {
            case 3: {
                this.strOprationID = "Backup";
                break;
            }
            case 42: {
                this.strOprationID = "Cam";
                break;
            }
            case 10: {
                this.strOprationID = "Recover";
                break;
            }
            default: {
                this.strOprationID = "";
            }
        }
        this.setOperationName(ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_" + operationType));
    }

    public int getOperationType() {
        return this.operationType;
    }

    public void setProgress(int value) {
        if (value > 100) {
            value = 100;
        } else if (value < 0) {
            value = 0;
        }
        this.iProgress = value;
    }

    public int getProgress() {
        return this.iProgress;
    }

    public void setIsInitialize(boolean isInitialize) {
        this.isInitialize = isInitialize;
    }

    public void setFailureReason(String failureReson) {
        this.failureReason = failureReson;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public String toString() {
        if (-1 == this.operationType && (null == this.m_strOperationName || this.m_strOperationName.trim().length() == 0 || Collator.getInstance().equals(ResourceManager.getInstance().getResString("NO_MANUAL_OPERATION"), this.m_strOperationName))) {
            return ResourceManager.getInstance().getResString("NO_MANUAL_OPERATION");
        }
        String strOperationType = this.m_strOperationName;
        if (null == strOperationType) {
            strOperationType = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_" + this.operationType);
        }
        String strErrorMsg = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(this.iFailureReason));
        if (this.isProgress) {
            this.setIOperationResultStatus(3);
            if (997195801 == this.iFailureReason) {
                return ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(997195801L)) + " : " + this.iProgress + "%";
            }
            return strOperationType + " : " + this.iProgress + "%";
        }
        if (this.isInitialize) {
            this.setOperationStausColor(TASK_STATE_NOT_RUN_COLOR);
            return this.failureReason;
        }
        String strFailureReason = strOperationType + " : " + strErrorMsg;
        if (0 == this.iOperationResultStatus || this.iFailureReason == 0 || this.iFailureReason == 989859196) {
            strFailureReason = DCCommonUtil.getSucessStr(strOperationType, strErrorMsg);
        } else if (this.iFailureReason == 989855882) {
            this.setOperationStausColor(TASK_STATE_NOT_RUN_COLOR);
        } else if (989859230 == this.iFailureReason) {
            strFailureReason = DCCommonUtil.getFailureStr(strOperationType, this.iFailureReason);
        } else if (1 == this.iOperationResultStatus || this.iFailureReason != 0) {
            strFailureReason = DCCommonUtil.getFailureStr(strOperationType, this.iFailureReason);
        } else {
            this.setOperationStausColor(TASK_STATE_NOT_RUN_COLOR);
        }
        return strFailureReason;
    }

    public String getToolTipText() {
        if (-1 == this.operationType && (null == this.m_strOperationName || this.m_strOperationName.trim().length() == 0 || Collator.getInstance().equals(ResourceManager.getInstance().getResString("NO_MANUAL_OPERATION"), this.m_strOperationName))) {
            return ResourceManager.getInstance().getResString("NO_MANUAL_OPERATION");
        }
        String strOperationType = this.m_strOperationName;
        if (null == strOperationType) {
            strOperationType = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_" + this.operationType);
        }
        String strErrorMsg = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(this.iFailureReason));
        if (this.isProgress) {
            return strOperationType + " : " + this.iProgress + "%";
        }
        if (this.isInitialize) {
            return this.failureReason;
        }
        return strOperationType + " : " + strErrorMsg;
    }

    public String getOperationName() {
        return this.m_strOperationName;
    }

    public void setOperationName(String strOperationName) {
        this.m_strOperationName = strOperationName;
    }

    public int getIFailureReason() {
        return this.iFailureReason;
    }

    public void setIFailureReason(int failureReason) {
        this.iFailureReason = failureReason;
    }

    public void setTaskID(int iTaskID) {
        this.iTaskID = iTaskID;
    }

    public int getTaskID() {
        return this.iTaskID;
    }

    public void setOperationId(String strOperId) {
        this.strOprationID = strOperId;
    }

    public String getOperationId() {
        return this.strOprationID;
    }

    public Color getOperationStausColor() {
        return this.operationStausColor;
    }

    public void setOperationStausColor(Color operationStausColor) {
        this.operationStausColor = operationStausColor;
    }

    public int getIOperationResultStatus() {
        return this.iOperationResultStatus;
    }

    public void setIOperationResultStatus(int operationResultStatus) {
        this.iOperationResultStatus = operationResultStatus;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperationStatus other = (OperationStatus)obj;
        return !(this.toString() == null ? other.toString() != null : !this.toString().equals(other.toString()));
    }

    @Override
    public int compareTo(OperationStatus opeStatus) {
        if (opeStatus == null) {
            return 1;
        }
        return Collator.getInstance().compare(this.toString(), opeStatus.toString());
    }
}

