/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.deviceoperation.deviceconfigchange;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.asndatacenter.AsnDCDevChangeNotify;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import com.huawei.dc.common.controller.AbstractDCMSGReceiver;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.MethodUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceview.devicetable.DeviceTableManager;
import com.huawei.dc.deviceoperation.deviceconfigchange.IDeviceConfigChangeListener;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.standalone.event.StandAloneEvent;
import com.huawei.dc.standalone.event.StandAloneNotifier;
import com.huawei.dc.standalone.view.RouterDevInfoPanel;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.commustru.fstru.FStruct;

public class DeviceConfigEventReceiver
extends AbstractDCMSGReceiver
implements IDCObjectDeallocator {
    private long firstOpenClientTime = System.nanoTime();
    private HashSet m_RegisteredPanelClassSet = new HashSet();
    private static DeviceConfigEventReceiver m_oDevConfListenerInstance;
    private IDeviceInfoManager m_oDevManager;

    private DeviceConfigEventReceiver() {
        super(43853);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstOpenClientTime ^ this.firstOpenClientTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceConfigEventReceiver other = (DeviceConfigEventReceiver)obj;
        return this.firstOpenClientTime == other.firstOpenClientTime;
    }

    public static synchronized DeviceConfigEventReceiver getInstance() {
        if (null == m_oDevConfListenerInstance) {
            m_oDevConfListenerInstance = new DeviceConfigEventReceiver();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oDevConfListenerInstance);
            DCFrameWorkUtil.getCommManager().addMessageListener(43853, (MSGListener)m_oDevConfListenerInstance);
            ObjectStore.getInstance().putObjectInstance("DeviceConfigEventReceiver", m_oDevConfListenerInstance);
        }
        return m_oDevConfListenerInstance;
    }

    @Override
    public void setToNULL() {
        if (null != m_oDevConfListenerInstance) {
            BaseCommManager oCommManager = DCFrameWorkUtil.getCommManager();
            if (null != oCommManager) {
                oCommManager.removeMessageListener(43853, (MSGListener)m_oDevConfListenerInstance);
            }
            Object[] array = this.m_RegisteredPanelClassSet.toArray();
            for (int i = 0; i < array.length; ++i) {
                this.unResigterForConfigChangeEvent((IDeviceConfigChangeListener)array[i]);
            }
            this.m_RegisteredPanelClassSet.clear();
            this.closeReceiver();
            m_oDevConfListenerInstance = null;
        }
    }

    public void resigterForConfigChangeEvent(IDeviceConfigChangeListener oDevChagelistener) {
        if (null == oDevChagelistener) {
            return;
        }
        this.m_RegisteredPanelClassSet.add(oDevChagelistener);
    }

    public void processMessage(MSGPacketExt oPacketExt) {
        try {
            byte[] arrReceivedData = oPacketExt.getData();
            if (null != arrReceivedData && 0 != arrReceivedData.length) {
                AsnDCDevChangeNotify oAsnDevChangeNtfn = new AsnDCDevChangeNotify();
                BaseCommManager oCommManager = DCFrameWorkUtil.getCommManager();
                if (null == oCommManager) {
                    return;
                }
                int iErrorCode = oCommManager.decodeAsn1Data((FStruct)oAsnDevChangeNtfn, arrReceivedData);
                if (0 == iErrorCode) {
                    try {
                        this.processNotification(oAsnDevChangeNtfn.enNotifyType.value, oAsnDevChangeNtfn.oDeviceInfoLst);
                    }
                    catch (Exception e) {
                        DCDebugTracer.trace(e);
                    }
                }
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processNotification(int iEventType, AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) throws Exception {
        DCDebugTracer.trace("DeviceConfigEventReceiver::processNotification->iEventType :" + iEventType);
        if (null == oDeviceInfoList) {
            DCDebugTracer.trace("DeviceConfigEventReceiver::processNotification->oDeviceInfoList is null");
            return;
        }
        this.m_oDevManager = DCFrameWorkUtil.getDeviceInfoManager();
        if (null == this.m_oDevManager) {
            DCDebugTracer.trace("DeviceConfigEventReceiver::processNotification->m_oDevManager is null");
            return;
        }
        AsnDCDeviceSubmapNtfnInfoLst oFilterDeviceInfoList = this.filterDevLst(iEventType, oDeviceInfoList);
        if (0 == oFilterDeviceInfoList.size()) {
            DCDebugTracer.trace("DeviceConfigEventReceiver::processNotification->add failed");
            this.handleDevChangeForSta(iEventType, oDeviceInfoList);
            return;
        }
        if (0 == iEventType) {
            this.ignoreInvalidDevices(oFilterDeviceInfoList);
        }
        if (0 == oFilterDeviceInfoList.size()) {
            DCDebugTracer.trace("DC:: DeviceConfigEventReceiver::processNotification->oFilterDeviceInfoList.size= 0");
            this.handleDevChangeForSta(iEventType, oDeviceInfoList);
            return;
        }
        if (1 != iEventType && 4 != iEventType) {
            ((IDeviceConfigChangeListener)((Object)this.m_oDevManager)).handleDeviceConfigNotification(iEventType, oFilterDeviceInfoList);
        }
        Set oSyncSet = Collections.synchronizedSet(new HashSet(this.m_RegisteredPanelClassSet));
        IDeviceConfigChangeListener oTableMgrListener = null;
        IDeviceConfigChangeListener oRouterDevPnlListener = null;
        Class[] methodSignal = new Class[]{Integer.TYPE, AsnDCDeviceSubmapNtfnInfoLst.class};
        Set set = oSyncSet;
        synchronized (set) {
            DCDebugTracer.trace("DC:: DeviceConfigEventReceiver::processNotification->oSyncSet::begin");
            Iterator oSetItr = oSyncSet.iterator();
            while (oSetItr.hasNext()) {
                DCDebugTracer.trace("DC:: DeviceConfigEventReceiver::processNotification->while::begin");
                IDeviceConfigChangeListener listener = (IDeviceConfigChangeListener)oSetItr.next();
                if (null == listener) continue;
                if (1 == iEventType || 4 == iEventType || 0 == iEventType || 3 == iEventType) {
                    if (listener instanceof DeviceTableManager) {
                        oTableMgrListener = listener;
                        continue;
                    }
                    if (listener instanceof RouterDevInfoPanel) {
                        oRouterDevPnlListener = listener;
                        continue;
                    }
                }
                if (DCFrameWorkUtil.getIsSingleClient() && 1 == iEventType && null == DCFrameWorkUtil.getRouterDevInfoPanel()) continue;
                MethodUtil.excMethodNoException(listener, methodSignal, "handleDeviceConfigNotification", iEventType, oFilterDeviceInfoList);
            }
            MethodUtil.excMethodNoException(oRouterDevPnlListener, methodSignal, "handleDeviceConfigNotification", iEventType, oFilterDeviceInfoList);
            MethodUtil.excMethodNoException(oTableMgrListener, methodSignal, "handleDeviceConfigNotification", iEventType, oFilterDeviceInfoList);
        }
        if (1 == iEventType || 4 == iEventType) {
            ((IDeviceConfigChangeListener)((Object)this.m_oDevManager)).handleDeviceConfigNotification(iEventType, oFilterDeviceInfoList);
        }
        this.handleDevChangeForSta(iEventType, oDeviceInfoList);
    }

    private AsnDCDeviceSubmapNtfnInfoLst filterDevLst(int iEventType, AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        if (!DCFrameWorkUtil.getIsSingleClient() || 0 != iEventType && 1 != iEventType) {
            return oDeviceInfoList;
        }
        AsnDCDeviceSubmapNtfnInfoLst oAsnDCDeviceSubmapNtfnInfoLst = new AsnDCDeviceSubmapNtfnInfoLst();
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceSubmapInfo = null;
        AsnDCDeviceInfo oAsnDCDeviceInfo = null;
        AsnDCErrorCodeInfo oErrorInfo = null;
        int iDeviceCount = oDeviceInfoList.size();
        for (int i = 0; i < iDeviceCount; ++i) {
            oAsnDeviceSubmapInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            oAsnDCDeviceInfo = oAsnDeviceSubmapInfo.oDeviceInfo;
            if (null == oAsnDCDeviceInfo) {
                DCDebugTracer.trace("AsnDCDeviceSubmapNtfnInfoLst#filterDevLst=>oAsnDCDeviceInfo is null ");
                continue;
            }
            oErrorInfo = oAsnDCDeviceInfo.oErrorInfo;
            if (null != oErrorInfo && null != oErrorInfo.iErrorNo && oErrorInfo.iErrorNo.intValue() != 0) {
                DCDebugTracer.trace("DeviceConfigEventReceiver#filterDevLst dev error , " + oAsnDCDeviceInfo.iDevId + oErrorInfo.iErrorNo.intValue());
                continue;
            }
            oAsnDCDeviceSubmapNtfnInfoLst.add((Object)oAsnDeviceSubmapInfo);
        }
        return oAsnDCDeviceSubmapNtfnInfoLst;
    }

    private void handleDevChangeForSta(int iEventType, AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        if (!DCFrameWorkUtil.getIsSingleClient() || 1 != iEventType && 0 != iEventType) {
            return;
        }
        int iNoOfDevicesFromServer = oDeviceInfoList.size();
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceSubmapInfo = null;
        AsnDCDeviceInfo oAsnDevInfo = null;
        for (int i = 0; i < iNoOfDevicesFromServer; ++i) {
            oAsnDeviceSubmapInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            if (null == oAsnDeviceSubmapInfo || null == (oAsnDevInfo = oAsnDeviceSubmapInfo.oDeviceInfo)) continue;
            StandAloneEvent oStaEvent = this.getEventObjectForNotification(oAsnDevInfo, iEventType);
            DCDebugTracer.trace("DeviceConfigEventReceiver#handleDevChangeForSta" + oStaEvent.getResource().getDeviceID() + " ErrorCode " + oStaEvent.getErrorCode() + " iEventType " + iEventType);
            StandAloneNotifier.getInstance().notifyStandAloneEvent(oStaEvent);
        }
    }

    private StandAloneEvent getEventObjectForNotification(AsnDCDeviceInfo oAsnDeviceInfo, int iEventType) {
        StandAloneEvent oEvent = new StandAloneEvent(iEventType);
        Resource oRes = new Resource();
        oRes.setDevTypeId(oAsnDeviceInfo.iDevTypeId.intValue());
        oRes.setDevVersionID(oAsnDeviceInfo.iDevTypeVersionId.intValue());
        if (null != oAsnDeviceInfo.iDevId) {
            oRes.setDeviceID(oAsnDeviceInfo.iDevId.intValue());
        }
        oRes.setDeviceIP(new String(oAsnDeviceInfo.strDevIPAddress));
        String oDevName = new String(oAsnDeviceInfo.strDevName);
        if (StringUtils.isNullOrEmptyStr(oDevName) && null != oAsnDeviceInfo.iNeID) {
            oDevName = String.valueOf(oAsnDeviceInfo.iNeID.intValue());
        }
        if (StringUtils.isNullOrEmptyStr(oDevName)) {
            oDevName = oRes.getDeviceIP();
        }
        oRes.setDeviceName(oDevName);
        oEvent.setResource(oRes);
        if (null != oAsnDeviceInfo.oErrorInfo) {
            oEvent.setErrorCode(oAsnDeviceInfo.oErrorInfo.iErrorNo.intValue());
        } else {
            oEvent.setErrorCode(0);
        }
        return oEvent;
    }

    private void ignoreInvalidDevices(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        int iDeviceCount = oDeviceInfoList.size();
        if (0 == iDeviceCount) {
            return;
        }
        for (int i = iDeviceCount - 1; i >= 0; --i) {
            DeviceTypeInfo oDeviceType;
            AsnDCDeviceSubmapNtfnInfo oDeviceNtfnInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            if (null == oDeviceNtfnInfo.oDeviceInfo) {
                DCDebugTracer.trace("DeviceConfigEventReceiver#ignoreInvalidDevices oDeviceInfo is null");
                continue;
            }
            AsnDCDeviceInfo oDeviceInfo = oDeviceNtfnInfo.oDeviceInfo;
            if (DCConstants.UNKNOW_TYPE_ID == oDeviceInfo.iDevTypeId.intValue() && DCConstants.UNKNOW_TYPE_ID == oDeviceInfo.iDevTypeVersionId.intValue() || null != (oDeviceType = this.m_oDevManager.getDeviceTypeInfo(oDeviceInfo.iDevTypeId.intValue(), oDeviceInfo.iDevTypeVersionId.intValue()))) continue;
            oDeviceInfoList.remove((Object)oDeviceNtfnInfo);
        }
    }

    public void unResigterForConfigChangeEvent(IDeviceConfigChangeListener oDevChagelistener) {
        if (null != oDevChagelistener && this.m_RegisteredPanelClassSet.contains(oDevChagelistener)) {
            this.m_RegisteredPanelClassSet.remove(oDevChagelistener);
        }
    }
}

