/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.deviceoperation;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.recover.RecoverOperation;
import javax.swing.table.AbstractTableModel;

public class RecoverTableModel
extends AbstractTableModel {
    private String[] m_oRecoverTableColumns = null;
    private static final int m_iDeviceId = 0;
    private static final int m_iDevicename = 1;
    private static final int m_iDeviceip = 2;
    private static final int m_iContentType = 3;
    private static final int m_iDeviceBoard = 4;
    private static final int m_iDeviceFilename = 5;
    private static final int m_iDeviceReboot = 6;
    private static final int m_iDeliverToBoardReboot = 7;
    private static final int IS_DISABLE = 2;
    public Object[][] values = null;
    private boolean m_isContentTypeRequired = false;
    private boolean m_isBoardTypeRequired = false;
    private boolean m_isRebootRequired = false;
    private boolean m_isFileNameRequired = false;
    private boolean m_isDeliverToBoardReboot = false;
    private static final int MAX_COLUMN_LENGTH = 8;

    public RecoverTableModel(RecoverOperation oRecoverOperation, String[] oColumnNames) {
        this.m_oRecoverTableColumns = oColumnNames;
        DeviceInfo[] arrDeviceInfo = oRecoverOperation.getSelectedRowDevId();
        this.m_isBoardTypeRequired = oRecoverOperation.getConfigParam().isBoardRequired();
        this.m_isRebootRequired = oRecoverOperation.getConfigParam().isActivationRequired();
        this.m_isFileNameRequired = oRecoverOperation.getConfigParam().isFileNameRequired();
        this.m_isDeliverToBoardReboot = oRecoverOperation.getConfigParam().isDeliverToBoardRebootReuqired();
        this.m_isContentTypeRequired = oRecoverOperation.getConfigParam().isRecoverContentTypeRequired();
        this.values = new Object[arrDeviceInfo.length][8];
        this.populateData(arrDeviceInfo);
    }

    private void populateData(DeviceInfo[] arrDeviceInformation) {
        int iNosDevs = arrDeviceInformation.length;
        for (int i = 0; i < iNosDevs; ++i) {
            DeviceInfo oDeviceInfo = arrDeviceInformation[i];
            for (int j = 0; j < this.m_oRecoverTableColumns.length; ++j) {
                this.updateDataInModel(i, j, oDeviceInfo);
            }
        }
    }

    private void updateDataInModel(int i, int j, DeviceInfo oDeviceInfo) {
        if (0 == j) {
            this.values[i][j] = oDeviceInfo.getDevId();
        } else if (1 == j) {
            this.values[i][j] = oDeviceInfo.getDevName();
        } else if (2 == j) {
            this.values[i][j] = oDeviceInfo.getDevIPAddress();
        } else if (3 == j) {
            this.values[i][j] = "";
        } else if (4 == j) {
            this.values[i][j] = ResourceManager.getInstance().getResString("LOAD_PROGRAM_MAIN_BOARD");
        } else if (5 == j) {
            this.values[i][j] = "";
        } else if (6 == j) {
            this.values[i][j] = Boolean.FALSE;
        } else if (7 == j && this.m_isDeliverToBoardReboot) {
            this.values[i][j] = 2;
        }
        this.setValueToProgressColumn(i);
    }

    private void setValueToProgressColumn(int iRow) {
        if (this.m_isFileNameRequired && this.m_isBoardTypeRequired && this.m_isRebootRequired && this.m_isContentTypeRequired) {
            this.values[iRow][7] = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_-1");
        } else if (!(this.m_isFileNameRequired || this.m_isBoardTypeRequired || this.m_isRebootRequired || this.m_isContentTypeRequired)) {
            this.values[iRow][3] = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_-1");
        } else if (this.m_isFileNameRequired && !this.m_isBoardTypeRequired && !this.m_isRebootRequired || this.m_isBoardTypeRequired && !this.m_isFileNameRequired && !this.m_isRebootRequired || this.m_isRebootRequired && !this.m_isBoardTypeRequired && !this.m_isFileNameRequired) {
            this.values[iRow][4] = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_-1");
        } else if (!this.m_isFileNameRequired && !this.m_isBoardTypeRequired && this.m_isRebootRequired && this.m_isContentTypeRequired || !this.m_isBoardTypeRequired && !this.m_isFileNameRequired && this.m_isRebootRequired && this.m_isContentTypeRequired || !this.m_isRebootRequired && !this.m_isBoardTypeRequired && this.m_isFileNameRequired && this.m_isContentTypeRequired) {
            this.values[iRow][5] = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_-1");
        } else if (!this.m_isFileNameRequired && this.m_isBoardTypeRequired && this.m_isRebootRequired && this.m_isContentTypeRequired || !this.m_isBoardTypeRequired && this.m_isFileNameRequired && this.m_isRebootRequired && this.m_isContentTypeRequired || !this.m_isRebootRequired && this.m_isBoardTypeRequired && this.m_isFileNameRequired && this.m_isContentTypeRequired) {
            this.values[iRow][6] = ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_-1");
        }
    }

    @Override
    public int getRowCount() {
        return this.values.length;
    }

    @Override
    public int getColumnCount() {
        return this.m_oRecoverTableColumns.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.values[row][column];
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        this.values[row][column] = aValue;
        this.fireTableCellUpdated(row, column);
    }

    @Override
    public String getColumnName(int column) {
        return this.m_oRecoverTableColumns[column];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 6 || column == 5 || column == 3 || column == 4 || column == 7;
    }

    public void setColumnNames(String[] columnNames) {
        this.m_oRecoverTableColumns = columnNames;
    }
}

