/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.deviceoperation;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCRecoveryFileLstRsp;
import com.huawei.dc.common.asndatacenter.AsnDCSyncReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.controller.AbstractDCMSGReceiver;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.recover.IUpdateRecoverFile;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverGroupTablePanel;
import com.huawei.dc.devicemanagement.deviceoperation.recoverdb.RecoverTablePanel;
import com.huawei.dc.framework.ErrorCodeReader;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.util.SyncCommand;
import gnu.trove.TIntObjectHashMap;
import java.awt.Component;
import java.math.BigInteger;
import javax.swing.JComponent;
import net.commustru.fstru.FStruct;

public class RecoverInfoManager
extends AbstractDCMSGReceiver
implements IDCObjectDeallocator {
    private static RecoverInfoManager m_oRecoverManager = null;
    private IUpdateRecoverFile m_oNotifyObj = null;
    private JComponent m_oComponent = null;
    private BaseCommManager m_oCommManager = DCFrameWorkUtil.getCommManager();
    private TIntObjectHashMap<DeviceInfo> m_oDevIdDevInfoHashMap;
    private Object m_oSyncObj;

    public static synchronized RecoverInfoManager getInstance() {
        if (null == m_oRecoverManager) {
            m_oRecoverManager = new RecoverInfoManager();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oRecoverManager);
        }
        return m_oRecoverManager;
    }

    @Override
    public void setToNULL() {
        this.closeReceiver();
        this.m_oCommManager = null;
        this.m_oNotifyObj = null;
        m_oRecoverManager = null;
    }

    private RecoverInfoManager() {
        super(43821);
    }

    public int openRecoverDialog(int iReqId, DeviceInfo[] arrDeviceInfo) {
        this.updateHashMap(arrDeviceInfo);
        final AsnDCSyncReq oReq = new AsnDCSyncReq();
        final AsnDCSyncRsp oRsp = new AsnDCSyncRsp();
        oReq.oReqID = BigInteger.valueOf(iReqId);
        int iLength = arrDeviceInfo.length;
        for (int i = 0; i < iLength; ++i) {
            oReq.oDevIDLst.add((Object)BigInteger.valueOf(arrDeviceInfo[i].getDevId()));
        }
        int returnCode = 0;
        final BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = commManager.sendSyncMsg(BaseCommManager.getMSGHead(43821), (FStruct)oReq, (FStruct)oRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null) {
            returnCode = (Integer)syncCommand.getResult();
        }
        if (0 == returnCode) {
            returnCode = oRsp.oErrorInfo.iErrorNo.intValue();
        }
        return returnCode;
    }

    private void updateHashMap(DeviceInfo[] arrDeviceInfo) {
        int iNosDevices = arrDeviceInfo.length;
        this.m_oDevIdDevInfoHashMap = new TIntObjectHashMap(8);
        for (int i = 0; i < iNosDevices; ++i) {
            DeviceInfo oDevInfo = arrDeviceInfo[i];
            this.m_oDevIdDevInfoHashMap.put(oDevInfo.getDevId(), (Object)oDevInfo);
        }
    }

    public void setNotifyObj(IUpdateRecoverFile oNotifyObj, Object oSyncObj) {
        this.m_oNotifyObj = oNotifyObj;
        this.m_oSyncObj = oSyncObj;
    }

    public void setComponentForResponse(JComponent oComp, Object oSyncObj) {
        this.m_oNotifyObj = null;
        this.m_oSyncObj = oSyncObj;
        this.m_oComponent = oComp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessage(MSGPacketExt packetExt) {
        block17: {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                DCDebugTracer.trace("sleep got error.");
            }
            try {
                DCDebugTracer.trace("receive asyn msg cmdCode=" + packetExt.mheader.cmdCode);
                if (packetExt.mheader.cmdCode != 43821) break block17;
                AsnDCRecoveryFileLstRsp asnDCRecoveryFileLstRsp = new AsnDCRecoveryFileLstRsp();
                int errorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)asnDCRecoveryFileLstRsp, packetExt.getData());
                if (0 != errorcode) break block17;
                if (null == this.m_oNotifyObj) {
                    if (this.m_oComponent instanceof RecoverGroupTablePanel) {
                        DeviceInfo oDevInfo = (DeviceInfo)this.m_oDevIdDevInfoHashMap.get(asnDCRecoveryFileLstRsp.iDevId.intValue());
                        if (asnDCRecoveryFileLstRsp.oErrorInfo.iErrorNo.intValue() == 0) {
                            ((RecoverGroupTablePanel)this.m_oComponent).addFilesToFilePathMap(asnDCRecoveryFileLstRsp.strTimeOrFileNameLst, asnDCRecoveryFileLstRsp.iDevId.intValue());
                        }
                        Object object = this.m_oSyncObj;
                        synchronized (object) {
                            ((RecoverGroupTablePanel)this.m_oComponent).updateProgressValue(asnDCRecoveryFileLstRsp.oProgressInfo.iPercentageProgress.intValue(), oDevInfo.getDevName(), ErrorCodeReader.getInstance().getErrorDesc(asnDCRecoveryFileLstRsp.oErrorInfo.iErrorNo));
                            break block17;
                        }
                    }
                    if (!(this.m_oComponent instanceof RecoverTablePanel)) break block17;
                    DeviceInfo oDevInfo = (DeviceInfo)this.m_oDevIdDevInfoHashMap.get(asnDCRecoveryFileLstRsp.iDevId.intValue());
                    if (asnDCRecoveryFileLstRsp.oErrorInfo.iErrorNo.intValue() == 0) {
                        ((RecoverTablePanel)this.m_oComponent).addFilesToFilePathMap(asnDCRecoveryFileLstRsp.strTimeOrFileNameLst, asnDCRecoveryFileLstRsp.iDevId.intValue());
                    }
                    Object object = this.m_oSyncObj;
                    synchronized (object) {
                        ((RecoverTablePanel)this.m_oComponent).updateProgressValue(asnDCRecoveryFileLstRsp.oProgressInfo.iPercentageProgress.intValue(), oDevInfo.getDevName(), ErrorCodeReader.getInstance().getErrorDesc(asnDCRecoveryFileLstRsp.oErrorInfo.iErrorNo));
                        break block17;
                    }
                }
                if (!(this.m_oNotifyObj instanceof IUpdateRecoverFile)) break block17;
                this.m_oNotifyObj.addFileForDev(asnDCRecoveryFileLstRsp.iDevId.intValue(), asnDCRecoveryFileLstRsp.strTimeOrFileNameLst);
                DeviceInfo oDevInfo = (DeviceInfo)this.m_oDevIdDevInfoHashMap.get(asnDCRecoveryFileLstRsp.iDevId.intValue());
                Object object = this.m_oSyncObj;
                synchronized (object) {
                    this.m_oNotifyObj.updateProgressValue(asnDCRecoveryFileLstRsp.oProgressInfo.iPercentageProgress.intValue(), oDevInfo.getDevName());
                }
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
            }
        }
    }

    public void recoverDlgListener() throws DCException {
    }

    @Override
    public void timeout(int int0, Character character) {
    }

    public void timeout(char arg0, Character arg1) {
    }
}

