/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.deviceoperation;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnCustomOpInfo;
import com.huawei.dc.common.asndatacenter.AsnCustomOpInfoLst;
import com.huawei.dc.common.asndatacenter.AsnCustomOpPara;
import com.huawei.dc.common.asndatacenter.AsnCustomOpParaLst;
import com.huawei.dc.common.asndatacenter.AsnCustomOpReq;
import com.huawei.dc.common.asndatacenter.AsnCustomOpRsp;
import com.huawei.dc.common.asndatacenter.AsnDCCancelOperation;
import com.huawei.dc.common.asndatacenter.AsnDCCancelOperationReq;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceBoardNotification;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceProgressNotify;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceProgressNotifyLst;
import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import com.huawei.dc.common.asndatacenter.AsnDCIntegerLst;
import com.huawei.dc.common.asndatacenter.AsnDCManualBackupReq;
import com.huawei.dc.common.asndatacenter.AsnDCManualRecoverInfo;
import com.huawei.dc.common.asndatacenter.AsnDCManualRecoverReqeust;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.asndatacenter.AsnDCProgressNotify;
import com.huawei.dc.common.asndatacenter.AsnDCRollBackOperationInfo;
import com.huawei.dc.common.asndatacenter.AsnDCRollBackOperationInfoLst;
import com.huawei.dc.common.asndatacenter.AsnDCSetAutoLoadPolicyNtf;
import com.huawei.dc.common.asndatacenter.AsnDCSyncReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.asndatacenter.AsnManualSaveInfo;
import com.huawei.dc.common.asndatacenter.AsnManualSaveInfoLst;
import com.huawei.dc.common.asndatacenter.AsnManualSaveReq;
import com.huawei.dc.common.asndatacenter.AsnRollbackInfo;
import com.huawei.dc.common.asndatacenter.AsnRollbackInfoLst;
import com.huawei.dc.common.asndatacenter.AsnRollbackReq;
import com.huawei.dc.common.asndatacenter.AsnTaskResource;
import com.huawei.dc.common.controller.AbstractDCMSGReceiver;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.GUIConstants;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.deviceoperation.controller.DeviceOperationProgressController;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.CustomOperationEngine;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.CustomOperationEvent;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.DeviceInfoImp;
import com.huawei.dc.devicemanagement.deviceoperation.customoperation.IOperationPara;
import com.huawei.dc.devicemanagement.event.DeviceInfoEvent;
import com.huawei.dc.devicemanagement.event.DeviceInfoNotifier;
import com.huawei.dc.deviceoperation.IDeviceOperationManager;
import com.huawei.dc.deviceoperation.IProgressCBDialog;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.framework.ObjectStore;
import com.huawei.dc.framework.XFtpManager;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.awt.Cursor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public class DeviceOperationManagerImpl
extends AbstractDCMSGReceiver
implements IDeviceOperationManager,
IDCObjectDeallocator {
    private Object callBackObj;
    private byte[] syncObj = new byte[0];
    private BaseCommManager commManager;
    private static DeviceOperationManagerImpl m_oDeviceOperationManagerImpl;
    private List m_oListenerList;

    private DeviceOperationManagerImpl() {
        super(43831);
        DCDebugTracer.trace("create obj DeviceOperationManagerImpl : " + System.currentTimeMillis());
        this.commManager = DCFrameWorkUtil.getCommManager();
        this.m_oListenerList = new ArrayList(0);
        DCDebugTracer.trace("create obj DeviceOperationManagerImpl success ");
    }

    public static synchronized IDeviceOperationManager getInstance() {
        if (null == m_oDeviceOperationManagerImpl) {
            m_oDeviceOperationManagerImpl = new DeviceOperationManagerImpl();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oDeviceOperationManagerImpl);
            ObjectStore.getInstance().putObjectInstance("DeviceOperationManager", m_oDeviceOperationManagerImpl);
        }
        return m_oDeviceOperationManagerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setToNULL() {
        if (null != this.m_oListenerList) {
            int iListenerCount = this.m_oListenerList.size();
            for (int i = iListenerCount - 1; i >= 0; --i) {
                this.unRegisterNotification(this.m_oListenerList.get(i));
            }
            this.m_oListenerList = null;
        }
        if (null == m_oDeviceOperationManagerImpl) return;
        try {
            byte[] iListenerCount = this.syncObj;
            synchronized (this.syncObj) {
                this.syncObj.notifyAll();
                // ** MonitorExit[iListenerCount] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            return;
        }
        {
            this.closeReceiver();
            this.syncObj = null;
            this.commManager = null;
            ObjectStore.getInstance().removeObjectInstance("DeviceOperationManager");
            m_oDeviceOperationManagerImpl = null;
            return;
        }
    }

    @Override
    public AsnDCOpertionRsp manualBackup(AsnDCManualBackupReq asnDCManualBackupReq, int iOptionType) {
        AsnDCOpertionRsp dcOpertionRsp = new AsnDCOpertionRsp();
        int iErrorcode = 0;
        if (0 == iOptionType) {
            iErrorcode = this.commManager.sendSyncMsg(BaseCommManager.getMSGHead(43823, 1, 4, GUIConstants.DC_SERVER_ID), (FStruct)asnDCManualBackupReq, (FStruct)dcOpertionRsp);
        } else {
            XFtpManager oSftpMangr = XFtpManager.getInstance();
            oSftpMangr.registerForNotification(43867);
            iErrorcode = this.commManager.sendSyncMsg(BaseCommManager.getMSGHead(43866), (FStruct)asnDCManualBackupReq, (FStruct)dcOpertionRsp);
        }
        if (iErrorcode != 0) {
            DCFrameWorkUtil.setCursor(DCFrameWorkUtil.getMainFrame(), Cursor.getDefaultCursor());
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorcode, ResourceManager.getInstance().getResString("ERROR"), 0);
            return null;
        }
        return dcOpertionRsp;
    }

    @Override
    public AsnDCOpertionRsp save(AsnManualSaveInfo[] oArrAsnManualSaveInfo) {
        AsnManualSaveReq oAsnManualSaveReq = new AsnManualSaveReq();
        oAsnManualSaveReq.oManualSaveInfoLst = new AsnManualSaveInfoLst();
        int iUserId = DCFrameWorkUtil.getUserId();
        AsnDCOpertionRsp oAsnDCOperationRsp = new AsnDCOpertionRsp();
        for (int index = 0; index < oArrAsnManualSaveInfo.length; ++index) {
            oAsnManualSaveReq.oManualSaveInfoLst.add((Object)oArrAsnManualSaveInfo[index]);
            oAsnManualSaveReq.iUserId = BigInteger.valueOf(iUserId);
        }
        int errorcode = this.commManager.sendSyncMsg(BaseCommManager.getMSGHead(43836, 1, 4, GUIConstants.DC_SERVER_ID), (FStruct)oAsnManualSaveReq, (FStruct)oAsnDCOperationRsp);
        if (errorcode != 0) {
            DCFrameWorkUtil.setCursor(DCFrameWorkUtil.getMainFrame(), Cursor.getDefaultCursor());
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), errorcode, ResourceManager.getInstance().getResString("ERROR"), 0);
            return null;
        }
        return oAsnDCOperationRsp;
    }

    public void processMessage(MSGPacketExt packetExt) {
        if (null == this.commManager) {
            return;
        }
        try {
            this.processMessagePacket(packetExt);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    public void processMessagePacket(MSGPacketExt packetExt) {
        DCDebugTracer.trace("DC::DeviceOperationManagerImpl#processMessagePacket cmdcode : " + packetExt.mheader.cmdCode);
        switch (packetExt.mheader.cmdCode) {
            case 43831: {
                this.processProgressNotification(packetExt);
                break;
            }
            case 43974: {
                this.processAutoLoadResponse(packetExt);
                break;
            }
            case 43978: {
                this.handleCancelOperationResponse(packetExt);
                break;
            }
            default: {
                DCDebugTracer.trace("DC::DeviceOperationManagerImpl#processMessagePacket bad value ");
            }
        }
        DCDebugTracer.trace("DC::DeviceOperationManagerImpl#processMessagePacket end.. ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processProgressNotification(MSGPacketExt packetExt) {
        AsnDCDeviceProgressNotify progressNotification2 = new AsnDCDeviceProgressNotify();
        AsnDCDeviceProgressNotifyLst progressNotificationLst = new AsnDCDeviceProgressNotifyLst();
        AsnDCProgressNotify mmlProgressNotification = new AsnDCProgressNotify();
        this.checkDeviceProcessListener();
        byte[] byArray = this.syncObj;
        synchronized (this.syncObj) {
            this.syncObj.notifyAll();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            int errorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)progressNotification2, packetExt.getData(), false);
            if (0 == errorcode) {
                this.updateDeviceProgress(progressNotification2);
            } else if (0 == DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)progressNotificationLst, packetExt.getData(), false)) {
                for (AsnDCDeviceProgressNotify progressNotification2 : progressNotificationLst) {
                    this.updateDeviceProgress(progressNotification2);
                }
            } else if (0 == DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)mmlProgressNotification, packetExt.getData(), false)) {
                DCDebugTracer.trace("errorcode != 0 is mml notification");
                int deviceId = mmlProgressNotification.iDeviceId.intValue();
                if (null != mmlProgressNotification.iFailureReasonOpt) {
                    this.updateDeviceProgress(deviceId, -1, mmlProgressNotification, mmlProgressNotification.iFailureReasonOpt.intValue(), null);
                } else if (null != mmlProgressNotification.iPercentageProgress) {
                    this.updateDeviceProgress(deviceId, mmlProgressNotification.iPercentageProgress.intValue(), mmlProgressNotification, -1, null);
                    if (this.callBackObj != null) {
                        ((IProgressCBDialog)this.callBackObj).updateDeviceProgress(deviceId, mmlProgressNotification.iPercentageProgress.intValue(), mmlProgressNotification, -1, null);
                    }
                }
            } else {
                DCDebugTracer.traceError("[DEVOPMGR] unknown asyn message");
            }
            return;
        }
    }

    private void updateDeviceProgress(AsnDCDeviceProgressNotify progressNotification) {
        int deviceId = progressNotification.oDeviceInfo.iDeviceId.intValue();
        if (null != progressNotification.oDeviceResult) {
            AsnDCErrorCodeInfo errorCode = progressNotification.oDeviceResult.oErrorInfo;
            int iFailureReason = errorCode.iErrorNo.intValue();
            String strErrMsg = null;
            if (989855767 == errorCode.iErrorNo.intValue() && null != progressNotification.oDeviceResult.iFailureReasonOpt) {
                iFailureReason = progressNotification.oDeviceResult.iFailureReasonOpt.intValue();
            }
            if (null != errorCode.strResult) {
                strErrMsg = new String(errorCode.strResult);
            }
            this.updateDeviceProgress(deviceId, -1, progressNotification, iFailureReason, strErrMsg);
            if (strErrMsg == null) {
                strErrMsg = "";
            }
            DCDebugTracer.trace("DC::DeviceOperationManagerImpl:ok:43831|deviceId:" + deviceId + "|iFailureReason:" + iFailureReason + "|strErrMsg:" + strErrMsg);
        } else {
            int percenatgeProgress = progressNotification.iDeviceProgress.intValue();
            this.updateDeviceProgress(deviceId, percenatgeProgress, progressNotification, -1, null);
            DCDebugTracer.trace("DeviceOperationManagerImpl:error:43831|deviceId:" + deviceId + "|percenatgeProgress:" + percenatgeProgress);
        }
    }

    private void checkDeviceProcessListener() {
        DeviceOperationProgressController m_oInstance = DeviceOperationProgressController.getInstance();
        if (null != m_oInstance && null != this.m_oListenerList && !this.m_oListenerList.contains(m_oInstance)) {
            DCDebugTracer.trace("DC:: registerNotification " + m_oInstance.toString());
            this.m_oListenerList.add(m_oInstance);
        }
    }

    private void handleCancelOperationResponse(MSGPacketExt packetExt) {
        final AsnDCDeviceBoardNotification oAsnDCDeviceBoardNotification = new AsnDCDeviceBoardNotification();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCDeviceBoardNotification, packetExt.getData());
        if (0 != iErrorCode) {
            DCDebugTracer.trace("DC::DeviceOperationManagerImpl#handleCancelOperationResponse errorcode : " + iErrorCode);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != DCFrameWorkUtil.getDeviceTablePanel()) {
                    DCFrameWorkUtil.getDeviceTablePanel().setCancelOperationProgress(oAsnDCDeviceBoardNotification);
                }
            }
        });
    }

    @Override
    public AsnDCOpertionRsp activationDataBase(AsnDCManualRecoverReqeust asnDCManualActivationDataBaseReqeust) {
        AsnDCOpertionRsp operationRsp = new AsnDCOpertionRsp();
        int iErrorCode = 0;
        iErrorCode = this.commManager.sendSyncMsg(BaseCommManager.getMSGHead(43947, 1, 4, GUIConstants.DC_SERVER_ID), (FStruct)asnDCManualActivationDataBaseReqeust, (FStruct)operationRsp);
        if (iErrorCode != 0) {
            DCFrameWorkUtil.setCursor(DCFrameWorkUtil.getMainFrame(), Cursor.getDefaultCursor());
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, ResourceManager.getInstance().getResString("ERROR"), 0);
            return null;
        }
        return operationRsp;
    }

    @Override
    public AsnDCOpertionRsp recover(AsnDCManualRecoverReqeust asnDCManualRecoverReqeust, int iOptionType) {
        AsnDCOpertionRsp operationRsp = new AsnDCOpertionRsp();
        int iErrorCode = 0;
        if (0 == iOptionType) {
            int cmdCode = 43824;
            AsnDCManualRecoverInfo loadScript = (AsnDCManualRecoverInfo)asnDCManualRecoverReqeust.oAsnDCManualRecoverList.get(0);
            if (loadScript.iContentType == BigInteger.valueOf(10L)) {
                cmdCode = 44067;
            }
            iErrorCode = this.commManager.sendSyncMsg(BaseCommManager.getMSGHead(cmdCode, 1, 4, GUIConstants.DC_SERVER_ID), (FStruct)asnDCManualRecoverReqeust, (FStruct)operationRsp);
        } else {
            XFtpManager oSftpMangr = XFtpManager.getInstance();
            oSftpMangr.registerForNotification(43867);
            asnDCManualRecoverReqeust.oReqID = BigInteger.valueOf(DCFrameWorkUtil.generateRequestId());
            DCDebugTracer.trace("requestIdForRecover is  : " + asnDCManualRecoverReqeust.oReqID);
            iErrorCode = this.commManager.sendSyncMsg(BaseCommManager.getMSGHead(43868), (FStruct)asnDCManualRecoverReqeust, (FStruct)operationRsp);
            if (null != operationRsp.oErrorInfo.iErrorNo && 0 == operationRsp.oErrorInfo.iErrorNo.intValue()) {
                oSftpMangr.setRequestIdForRecover(asnDCManualRecoverReqeust.oReqID.intValue());
            }
        }
        if (iErrorCode != 0) {
            DCFrameWorkUtil.setCursor(DCFrameWorkUtil.getMainFrame(), Cursor.getDefaultCursor());
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, ResourceManager.getInstance().getResString("ERROR"), 0);
            return null;
        }
        return operationRsp;
    }

    @Override
    public void registerNotification(Object callBackObj) {
        if (null != this.m_oListenerList) {
            DCDebugTracer.trace("DC:: DeviceOperationManagerImpl#registerNotification" + this.m_oListenerList.toString());
        }
        if (null != callBackObj && null != this.m_oListenerList) {
            DCDebugTracer.trace("DC:: registerNotification " + callBackObj.toString());
            if (this.m_oListenerList.contains(callBackObj)) {
                this.m_oListenerList.remove(callBackObj);
            }
            this.m_oListenerList.add(callBackObj);
        }
    }

    @Override
    public void unRegisterNotification(Object callBackObj) {
        if (null == callBackObj || null == this.m_oListenerList) {
            return;
        }
        DCDebugTracer.trace("DC:: DeviceOperationManagerImpl#unRegisterNotification" + this.m_oListenerList.toString());
        if (this.m_oListenerList.contains(callBackObj)) {
            DCDebugTracer.trace("DC:: unRegisterNotification " + callBackObj.toString());
            this.m_oListenerList.remove(callBackObj);
        }
    }

    private void updateDeviceProgress(int iDeviceId, int iProgressPercentage, AsnDCDeviceProgressNotify progressNotification, int iFailureReason, String strErrMsg) {
        int iCount = this.m_oListenerList.size();
        DCDebugTracer.trace("DC::DeviceOperationManagerImpl#m_oListenerList : " + iCount);
        for (int index = 0; index < iCount; ++index) {
            Object oListener = this.m_oListenerList.get(index);
            if (null == oListener || !(oListener instanceof IProgressCBDialog)) continue;
            IProgressCBDialog oProgressListener = (IProgressCBDialog)oListener;
            if (33 == progressNotification.enDevOperType.value) {
                CustomOperationEvent oCustomEvent = new CustomOperationEvent();
                oCustomEvent.setDeviceInfo(new DeviceInfoImp[]{this.getDeviceInfoImpl(progressNotification.oDeviceInfo.iDeviceId.intValue())});
                if (null != progressNotification.oDeviceResult) {
                    if (iProgressPercentage == -1 && iFailureReason != 0) {
                        oCustomEvent.setResult(null);
                        oCustomEvent.setiFailureReason(iFailureReason);
                    } else {
                        oCustomEvent.setResult(progressNotification.oDeviceResult.strFailureReasonDetailInfo);
                        oCustomEvent.setiFailureReason(-1);
                    }
                    if (null != progressNotification.strCustomOpId) {
                        oCustomEvent.setOperationID(new String(progressNotification.strCustomOpId));
                    }
                    CustomOperationEngine.getInstance().notifyMessage(oCustomEvent);
                }
            }
            oProgressListener.updateDeviceProgress(iDeviceId, iProgressPercentage, progressNotification, iFailureReason, strErrMsg);
        }
    }

    private DeviceInfoImp getDeviceInfoImpl(int iDeviceID) {
        DeviceInfo oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDeviceID);
        if (null == oDeviceInfo) {
            return null;
        }
        DeviceInfoImp oDeviceInfoImp = new DeviceInfoImp();
        oDeviceInfoImp.setDevVersion(oDeviceInfo.getDevVersion().getDevVersion());
        oDeviceInfoImp.setDevID(oDeviceInfo.getDevId());
        oDeviceInfoImp.setDevIPAddress(oDeviceInfo.getDevIPAddress());
        oDeviceInfoImp.setDevName(oDeviceInfo.getDevName());
        oDeviceInfoImp.setDevTypeID(oDeviceInfo.getDeviceTypeInfo().getDevTypeID());
        oDeviceInfoImp.setDevTypeName(oDeviceInfo.getDeviceTypeInfo().getDevTypeName());
        oDeviceInfoImp.setDevTypeVersionID(oDeviceInfo.getDevTypeVersionId());
        return oDeviceInfoImp;
    }

    private void updateDeviceProgress(int iDeviceId, int iProgressPercentage, AsnDCProgressNotify progressNotification, int iFailureReason, String strErrMsg) {
        int iCount = this.m_oListenerList.size();
        for (int index = 0; index < iCount; ++index) {
            Object oListener = this.m_oListenerList.get(index);
            if (null == oListener || !(oListener instanceof IProgressCBDialog)) continue;
            IProgressCBDialog oProgressListener = (IProgressCBDialog)oListener;
            oProgressListener.updateDeviceProgress(iDeviceId, iProgressPercentage, progressNotification, iFailureReason, strErrMsg);
        }
    }

    @Override
    public int deleteDataBase(DeviceInfo[] arrDeviceInfos) {
        AsnDCIntegerLst oAsnDeviceIDList = new AsnDCIntegerLst();
        int iNumOfDevices = arrDeviceInfos.length;
        for (int index = 0; index < iNumOfDevices; ++index) {
            oAsnDeviceIDList.add((Object)BigInteger.valueOf(arrDeviceInfos[index].getDevId()));
        }
        int iErrorCode = this.commManager.sendAsyncMsg(BaseCommManager.getMSGHead(43944, 1, 4, GUIConstants.DC_SERVER_ID), (FStruct)oAsnDeviceIDList, this);
        return iErrorCode;
    }

    @Override
    public int initializeDataBase(DeviceInfo[] arrDeviceInfos) {
        AsnDCIntegerLst oAsnDeviceIDList = new AsnDCIntegerLst();
        int iNumOfDevices = arrDeviceInfos.length;
        for (int index = 0; index < iNumOfDevices; ++index) {
            oAsnDeviceIDList.add((Object)BigInteger.valueOf(arrDeviceInfos[index].getDevId()));
        }
        int iErrorCode = this.commManager.sendAsyncMsg(BaseCommManager.getMSGHead(54041, 1, 4, GUIConstants.DC_SERVER_ID), (FStruct)oAsnDeviceIDList, this);
        return iErrorCode;
    }

    @Override
    public int activateDataBase(int[] devIds) {
        return 0;
    }

    @Override
    public int rollbackDataBase(DeviceInfo[] arrDeviceInfo) {
        AsnDCRollBackOperationInfoLst rollbackOperLst = new AsnDCRollBackOperationInfoLst();
        int length = arrDeviceInfo.length;
        AsnDCRollBackOperationInfo rollbackOprInfo = null;
        for (int i = 0; i < length; ++i) {
            rollbackOprInfo = new AsnDCRollBackOperationInfo();
            rollbackOprInfo.iDevId = new BigInteger(String.valueOf(arrDeviceInfo[i].getDevId()));
            rollbackOprInfo.iContentType = new BigInteger(String.valueOf(6));
            rollbackOperLst.add((Object)rollbackOprInfo);
        }
        int iErrorCode = this.commManager.sendAsyncMsg(BaseCommManager.getMSGHead(43945, 1, 4, GUIConstants.DC_SERVER_ID), (FStruct)rollbackOperLst, this);
        return iErrorCode;
    }

    @Override
    public int copyDataBase(DeviceInfo[] arrSelectedDevInfo) {
        AsnDCIntegerLst oAsnDeviceIDList = new AsnDCIntegerLst();
        int iNumOfDevices = arrSelectedDevInfo.length;
        for (int index = 0; index < iNumOfDevices; ++index) {
            oAsnDeviceIDList.add((Object)BigInteger.valueOf(arrSelectedDevInfo[index].getDevId()));
        }
        int iErrorCode = this.commManager.sendAsyncMsg(BaseCommManager.getMSGHead(44039, 1, 4, GUIConstants.DC_SERVER_ID), (FStruct)oAsnDeviceIDList, this);
        return iErrorCode;
    }

    @Override
    public int rollBackPatch(DeviceInfo[] arrSelectedDevInfo) {
        AsnDCIntegerLst oAsnDeviceIDList = new AsnDCIntegerLst();
        int iNumOfDevices = arrSelectedDevInfo.length;
        for (int index = 0; index < iNumOfDevices; ++index) {
            oAsnDeviceIDList.add((Object)BigInteger.valueOf(arrSelectedDevInfo[index].getDevId()));
        }
        int iErrorCode = this.commManager.sendAsyncMsg(BaseCommManager.getMSGHead(43870, 1, 4, GUIConstants.DC_SERVER_ID), (FStruct)oAsnDeviceIDList, this);
        return iErrorCode;
    }

    @Override
    public String executeCustomOperation(String strOpId, IOperationPara[] operationParas) {
        return this.doCustomOperation(strOpId, operationParas, 43941);
    }

    private String doCustomOperation(String strOpId, IOperationPara[] operationParas, final int iCommandCode) {
        final AsnCustomOpRsp oAsnCustomOpRsp = new AsnCustomOpRsp();
        final AsnCustomOpReq oAsnCustomOpReq = new AsnCustomOpReq();
        int iErrorCode = -1;
        oAsnCustomOpReq.iUserId = BigInteger.valueOf(DCFrameWorkUtil.getUserId());
        oAsnCustomOpReq.strOperationId = strOpId.getBytes();
        AsnCustomOpInfoLst oAsnCustomOpInfoLst = new AsnCustomOpInfoLst();
        AsnTaskResource oAsnTaskResource = null;
        IOperationPara.CustomPara[] oCustomParas = null;
        AsnCustomOpPara oAsnCustomOpPara = null;
        for (int i = 0; i < operationParas.length; ++i) {
            AsnCustomOpInfo oAsnCustomOpInfo = new AsnCustomOpInfo();
            oAsnTaskResource = new AsnTaskResource();
            oAsnTaskResource.iDeviceId = BigInteger.valueOf(operationParas[i].getDeviceID());
            oAsnCustomOpInfo.oTaskResource = oAsnTaskResource;
            oCustomParas = operationParas[i].getCustomParas();
            oAsnCustomOpInfo.oCustomOpParaLst = new AsnCustomOpParaLst();
            int iSize = 0;
            if (null != oCustomParas) {
                iSize = oCustomParas.length;
            }
            for (int j = 0; j < iSize; ++j) {
                oAsnCustomOpPara = new AsnCustomOpPara();
                if (null != oCustomParas) {
                    oAsnCustomOpPara.strParaID = oCustomParas[j].strParaID.getBytes();
                    oAsnCustomOpPara.strParameterValue = oCustomParas[j].paraValue;
                }
                oAsnCustomOpInfo.oCustomOpParaLst.add((Object)oAsnCustomOpPara);
            }
            oAsnCustomOpInfoLst.add((Object)oAsnCustomOpInfo);
        }
        oAsnCustomOpReq.oCustomOpInfoLst = oAsnCustomOpInfoLst;
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DeviceOperationManagerImpl.this.commManager;
                DeviceOperationManagerImpl.this.commManager;
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(iCommandCode, 1, 4, GUIConstants.DC_SERVER_ID), (FStruct)oAsnCustomOpReq, (FStruct)oAsnCustomOpRsp);
                return iErrorCode;
            }
        };
        DCFrameWorkUtil.setCursor(DCFrameWorkUtil.getMainFrame(), Cursor.getPredefinedCursor(3));
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (null != syncCommand.getResult()) {
            iErrorCode = (Integer)syncCommand.getResult();
        }
        DCFrameWorkUtil.setCursor(DCFrameWorkUtil.getMainFrame(), Cursor.getDefaultCursor());
        if (iErrorCode == 0) {
            iErrorCode = oAsnCustomOpRsp.oErrorInfo.iErrorNo.intValue();
        }
        return ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode));
    }

    @Override
    public String cancelCustomOperation(String strOpId, IOperationPara[] operationParas) {
        return this.doCustomOperation(strOpId, operationParas, 43939);
    }

    public static IDeviceOperationManager getInstanceObject() {
        return m_oDeviceOperationManagerImpl;
    }

    @Override
    public void setAutoLoadPolicy(int iReqId, int[] arrDeviceIds) throws DCException {
        final AsnDCSyncReq oAsnDCSetAutoLoadPolicyReq = new AsnDCSyncReq();
        final AsnDCSyncRsp oRsp = new AsnDCSyncRsp();
        oAsnDCSetAutoLoadPolicyReq.oReqID = BigInteger.valueOf(iReqId);
        for (int i = 0; i < arrDeviceIds.length; ++i) {
            oAsnDCSetAutoLoadPolicyReq.oDevIDLst.add((Object)BigInteger.valueOf(arrDeviceIds[i]));
        }
        this.commManager.addMessageListener(43974, (MSGListener)this);
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DeviceOperationManagerImpl.this.commManager;
                DeviceOperationManagerImpl.this.commManager;
                int iErrorCode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43974), (FStruct)oAsnDCSetAutoLoadPolicyReq, (FStruct)oRsp);
                return iErrorCode;
            }
        };
        DCFrameWorkUtil.setCursor(DCFrameWorkUtil.getMainFrame(), Cursor.getPredefinedCursor(3));
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        int iErrorCode = 0;
        if (null != syncCommand.getResult()) {
            iErrorCode = (Integer)syncCommand.getResult();
        }
        DCFrameWorkUtil.setCursor(DCFrameWorkUtil.getMainFrame(), Cursor.getDefaultCursor());
        if (iErrorCode == 0) {
            iErrorCode = oRsp.oErrorInfo.iErrorNo.intValue();
        }
        if (iErrorCode != 0) {
            this.commManager.removeMessageListener(43974, (MSGListener)this);
            throw new DCException(ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)));
        }
    }

    private synchronized void processAutoLoadResponse(MSGPacketExt oPacket) {
        AsnDCSetAutoLoadPolicyNtf oAsnDCSetAutoLoadPolicyNtf = new AsnDCSetAutoLoadPolicyNtf();
        int errorcode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnDCSetAutoLoadPolicyNtf, oPacket.getData());
        if (0 != errorcode) {
            return;
        }
        DeviceInfoEvent oEvent = new DeviceInfoEvent(oAsnDCSetAutoLoadPolicyNtf.enStatus, 4);
        oEvent.setDeviceID(oAsnDCSetAutoLoadPolicyNtf.iDevId.intValue());
        oEvent.setErrorCode(oAsnDCSetAutoLoadPolicyNtf.oErrorInfo.iErrorNo.intValue());
        oEvent.setFinal(oAsnDCSetAutoLoadPolicyNtf.bIsFinal);
        oEvent.setRequestId(oAsnDCSetAutoLoadPolicyNtf.oProgressInfo.oReqID.intValue());
        oEvent.setProgress(oAsnDCSetAutoLoadPolicyNtf.oProgressInfo.iPercentageProgress.intValue());
        DeviceInfoNotifier.getInstance().notifyEvent(oEvent);
    }

    @Override
    public void cancelOperation(int iReqId, HashMap<Integer, String> devIdAndOprIdMap) throws DCException {
        int returnCode;
        final AsnDCCancelOperationReq asnDCCancelReq = new AsnDCCancelOperationReq();
        final AsnDCSyncRsp oRsp = new AsnDCSyncRsp();
        asnDCCancelReq.oReqID = BigInteger.valueOf(iReqId);
        Iterator<Map.Entry<Integer, String>> oDevIdAndOprIdItr = devIdAndOprIdMap.entrySet().iterator();
        Map.Entry<Integer, String> oDevIdAndOprIdEntry = null;
        while (oDevIdAndOprIdItr.hasNext()) {
            oDevIdAndOprIdEntry = oDevIdAndOprIdItr.next();
            AsnDCCancelOperation ashCancelOperation = new AsnDCCancelOperation();
            Integer devId = oDevIdAndOprIdEntry.getKey();
            ashCancelOperation.iDeviceID = new BigInteger(devId.toString());
            ashCancelOperation.strOperationId = oDevIdAndOprIdEntry.getValue().getBytes();
            asnDCCancelReq.oCancelOperationLst.add((Object)ashCancelOperation);
        }
        this.commManager.addMessageListener(43978, (MSGListener)this);
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                BaseCommManager baseCommManager = DeviceOperationManagerImpl.this.commManager;
                DeviceOperationManagerImpl.this.commManager;
                int errorcode = baseCommManager.sendSyncMsg(BaseCommManager.getMSGHead(43978), (FStruct)asnDCCancelReq, (FStruct)oRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && (returnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            this.commManager.removeMessageListener(43829, (MSGListener)this);
            this.commManager.removeMessageListener(43978, (MSGListener)this);
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SEND_FAIL"), ResourceManager.getInstance().getResString("ERROR"), 0);
            throw new DCException(returnCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(returnCode)));
        }
        if (0 != oRsp.oErrorInfo.iErrorNo.intValue()) {
            this.commManager.removeMessageListener(43829, (MSGListener)this);
            this.commManager.removeMessageListener(43978, (MSGListener)this);
            int errorCode = oRsp.oErrorInfo.iErrorNo.intValue();
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), errorCode, ResourceManager.getInstance().getResString("ERROR"), 0);
            throw new DCException(errorCode, ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(errorCode)));
        }
    }

    @Override
    public AsnDCOpertionRsp rollbackSoftware(DeviceInfo[] arrSelectedDevInfo) {
        AsnRollbackReq rollbackSoftwareReq = new AsnRollbackReq();
        rollbackSoftwareReq.oAutoRollbackInfoLst = new AsnRollbackInfoLst();
        rollbackSoftwareReq.iUserId = BigInteger.valueOf(DCFrameWorkUtil.getSecurityManager().getUserId());
        AsnDCOpertionRsp rollbackSoftwareRsp = new AsnDCOpertionRsp();
        for (int i = 0; i < arrSelectedDevInfo.length; ++i) {
            AsnRollbackInfo rollbackInfo = new AsnRollbackInfo();
            rollbackInfo.iDeviceID = BigInteger.valueOf(arrSelectedDevInfo[i].getDevId());
            rollbackSoftwareReq.oAutoRollbackInfoLst.add((Object)rollbackInfo);
        }
        int errorcode = this.commManager.sendSyncMsg(BaseCommManager.getMSGHead(44023, 1, 4, GUIConstants.DC_SERVER_ID), (FStruct)rollbackSoftwareReq, (FStruct)rollbackSoftwareRsp);
        if (errorcode != 0) {
            DCFrameWorkUtil.setCursor(DCFrameWorkUtil.getMainFrame(), Cursor.getDefaultCursor());
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), errorcode, ResourceManager.getInstance().getResString("ERROR"), 0);
            return null;
        }
        return rollbackSoftwareRsp;
    }
}

