/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.patchmanagement.view.patchtable;

import com.huawei.dc.common.components.deviceselection.table.DCDefaultTableRenderer;
import com.huawei.dc.common.components.table.renderer.ProgressInfoTableCellRenderer;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpForErrCodeUtil;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.patchmanagement.controller.IPatchSyncCommController;
import com.huawei.dc.devicemanagement.patchmanagement.controller.PatchAsyncCommController;
import com.huawei.dc.devicemanagement.patchmanagement.controller.PatchSyncCommController;
import com.huawei.dc.devicemanagement.patchmanagement.model.IPatch;
import com.huawei.dc.devicemanagement.patchmanagement.model.PatchDataModel;
import com.huawei.dc.devicemanagement.patchmanagement.model.PatchProgressInfo;
import com.huawei.dc.devicemanagement.patchmanagement.view.patchtable.PatchManagementPopupMenuManager;
import com.huawei.dc.devicemanagement.patchmanagement.view.patchtable.PatchTableModel;
import com.huawei.dc.taskmgmt.view.createtask.ViewCommandResultDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;

public class PatchTablePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable m_oPatchTable;
    private PatchTableModel m_oPatchTableModel;
    private JScrollPane m_oScrollPane;
    private PatchManagementPopupMenuManager m_oPopupMenuManager;
    private ResourceManager m_oResourceManager = ResourceManager.getInstance();
    private IPatchSyncCommController c_oPatchSyncCommController = PatchSyncCommController.getInstance();

    public PatchTablePanel() {
        this.createPatchTable();
        this.m_oScrollPane = new JScrollPane(this.m_oPatchTable);
        this.setLayout(new GridLayout());
        this.add(this.m_oScrollPane);
    }

    private void createPatchTable() {
        this.m_oPatchTableModel = new PatchTableModel();
        this.m_oPatchTable = new JTable(this.m_oPatchTableModel);
        this.m_oPatchTable.setName("PatchManagement_PatchTablePanel_m_oPatchTable");
        this.m_oPatchTable.setOpaque(false);
        this.m_oPatchTable.setRowHeight(21);
        this.m_oPopupMenuManager = new PatchManagementPopupMenuManager(this);
        this.initializeTableHeader();
        this.initializeMouseAdapters();
        this.initializeTableCellRenderer();
        this.initializeDeleteKeyEventHandler();
    }

    private void initializeTableHeader() {
        JTableHeader oTableHeader = this.m_oPatchTable.getTableHeader();
        oTableHeader.setReorderingAllowed(false);
        oTableHeader.setPreferredSize(new Dimension(this.m_oPatchTable.getSize().width, 21));
        oTableHeader.addMouseMotionListener(this.getToolTipRendererForHeader());
    }

    private MouseMotionAdapter getToolTipRendererForHeader() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int oColNum = PatchTablePanel.this.m_oPatchTable.getColumnModel().getColumnIndexAtX(e.getX());
                if (oColNum > -1) {
                    PatchTablePanel.this.m_oPatchTable.getTableHeader().setToolTipText(PatchTablePanel.this.m_oPatchTable.getColumnName(oColNum));
                }
            }
        };
    }

    private void initializeMouseAdapters() {
        this.m_oPatchTable.getTableHeader().addMouseListener(this.generateMouseAdapterForTableHeader());
        this.m_oPatchTable.addMouseListener(this.generateMouseAdapterForTable());
        this.m_oPatchTable.addMouseMotionListener(this.generateMouseMotionAdapter());
        this.addMouseListener(this.generateMouseAdapterForTable());
    }

    private MouseAdapter generateMouseAdapterForTableHeader() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PatchTablePanel.this.patchTableHeader_MousePressed(e);
            }
        };
    }

    private MouseAdapter generateMouseAdapterForTable() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent oMouseEvent) {
                PatchTablePanel.this.patchTable_MousePressed(oMouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent oMouseEvent) {
                PatchTablePanel.this.patchTable_MousePressed(oMouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Cursor cur = new Cursor(0);
                DCFrameWorkUtil.setCursor(PatchTablePanel.this.getParent(), cur);
            }
        };
    }

    private MouseMotionAdapter generateMouseMotionAdapter() {
        return new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent oMouseEvent) {
                Point oPoint = oMouseEvent.getPoint();
                if (PatchTablePanel.this.m_oPatchTable.columnAtPoint(oPoint) == 11) {
                    Object oValue = PatchTablePanel.this.m_oPatchTable.getValueAt(PatchTablePanel.this.m_oPatchTable.rowAtPoint(oPoint), 11);
                    if (oValue instanceof PatchProgressInfo) {
                        PatchProgressInfo oProgressInfo = (PatchProgressInfo)oValue;
                        if (1 != oProgressInfo.getState() && DCHelpForErrCodeUtil.isShowHyperlink(oProgressInfo.getResult())) {
                            Cursor cur = new Cursor(12);
                            DCFrameWorkUtil.setCursor(PatchTablePanel.this.getParent(), cur);
                        } else {
                            Cursor cur = new Cursor(0);
                            DCFrameWorkUtil.setCursor(PatchTablePanel.this.getParent(), cur);
                        }
                    } else {
                        Cursor cur = new Cursor(0);
                        DCFrameWorkUtil.setCursor(PatchTablePanel.this.getParent(), cur);
                    }
                } else {
                    Cursor cur = new Cursor(0);
                    DCFrameWorkUtil.setCursor(PatchTablePanel.this.getParent(), cur);
                }
            }
        };
    }

    private void patchTableHeader_MousePressed(MouseEvent strE) {
    }

    private void patchTable_MousePressed(MouseEvent oMouseEvent) {
        int iSelectedRow = this.m_oPatchTable.rowAtPoint(oMouseEvent.getPoint());
        boolean bIsClickedRowSelected = false;
        int[] nRows = this.m_oPatchTable.getSelectedRows();
        if (nRows.length > 0) {
            if (nRows.length > 1) {
                for (int i = 0; i < nRows.length; ++i) {
                    if (nRows[i] != iSelectedRow) continue;
                    bIsClickedRowSelected = true;
                    break;
                }
            }
            if (!bIsClickedRowSelected && 0 != (4 & oMouseEvent.getModifiers())) {
                ListSelectionModel selectionModel = this.m_oPatchTable.getSelectionModel();
                selectionModel.setSelectionInterval(iSelectedRow, iSelectedRow);
            }
            if (0 != (0x10 & oMouseEvent.getModifiers())) {
                int iColumn = this.m_oPatchTable.columnAtPoint(oMouseEvent.getPoint());
                if (iColumn != 11) {
                    return;
                }
                Object oValue = this.m_oPatchTable.getValueAt(iSelectedRow, iColumn);
                if (oValue instanceof PatchProgressInfo) {
                    PatchProgressInfo oProgressInfo = (PatchProgressInfo)oValue;
                    if (1 == oProgressInfo.getState()) {
                        return;
                    }
                    if (999293081 == oProgressInfo.getResult()) {
                        ViewCommandResultDialog dialog = new ViewCommandResultDialog(oProgressInfo.getFailureReason());
                        dialog.setTitle(DCFrameWorkUtil.getLocalizedString("OPERATION_RESULT"));
                        dialog.getContentTextArea().setLineWrap(true);
                        dialog.setVisible(true);
                    } else {
                        DCHelpForErrCodeUtil.showHelp(this, oProgressInfo.getResult());
                    }
                }
            }
            if (0 != (4 & oMouseEvent.getModifiers())) {
                if (this.isSPCPatch()) {
                    return;
                }
                this.showPopupMenu(oMouseEvent);
            }
        }
    }

    private boolean isSPCPatch() {
        int[] nRows = this.m_oPatchTable.getSelectedRows();
        if (nRows.length > 0) {
            for (int i = 0; i < nRows.length; ++i) {
                String strVersion;
                Pattern oPattern;
                Matcher oMatcher;
                IPatch oPatch = this.getPatchAtRow(nRows[i]);
                DeviceTypeInfo devInfo = DeviceInfoManagerImpl.getInstance().getDevice(oPatch.getResource().getDeviceID()).getDeviceTypeInfo();
                if (!devInfo.isBMSDomain() || null == oPatch.getName() || oPatch.getName().length() < 6 || !(oMatcher = (oPattern = Pattern.compile("SPC[\\p{Alpha}\\p{Digit}]00")).matcher((strVersion = oPatch.getName().substring(oPatch.getName().length() - 6, oPatch.getName().length())).toUpperCase())).matches()) continue;
                return true;
            }
        }
        return false;
    }

    protected void showPopupMenu(MouseEvent oMouseEvent) {
        JPopupMenu oPopupMenu = this.m_oPopupMenuManager.load();
        oPopupMenu.show(this.m_oPatchTable, oMouseEvent.getX(), oMouseEvent.getY());
    }

    private void initializeTableCellRenderer() {
        DCDefaultTableRenderer oRenderer = new DCDefaultTableRenderer();
        int iColumnCount = this.m_oPatchTableModel.getColumnCount();
        for (int i = 0; i < iColumnCount; ++i) {
            this.m_oPatchTable.getColumnModel().getColumn(i).setCellRenderer(oRenderer);
        }
        this.m_oPatchTable.getColumnModel().getColumn(11).setCellRenderer(new ProgressInfoTableCellRenderer());
    }

    private void initializeDeleteKeyEventHandler() {
        ActionListener oDeleteKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PatchTablePanel.this.isPatchOperationSupported("DeletePatch")) {
                    PatchTablePanel.this.deletePatch();
                }
            }
        };
        KeyStroke oDeleteKeyStroke = KeyStroke.getKeyStroke(127, 0);
        this.m_oPatchTable.registerKeyboardAction(oDeleteKeyHandler, oDeleteKeyStroke, 0);
    }

    public JTable getPatchInfoTable() {
        return this.m_oPatchTable;
    }

    public void addPatchToTable(IPatch oPatch) {
        this.m_oPatchTableModel.addPatch(oPatch);
        this.m_oPatchTable.updateUI();
        if (this.m_oPatchTableModel.getRowCount() > 0) {
            this.m_oPatchTable.setRowSelectionInterval(0, 0);
        }
    }

    public void deletePatches(List oPatchList) {
        if (null == oPatchList) {
            return;
        }
        int iFirstSelectedRow = -1;
        int[] arrSelectedRows = this.m_oPatchTable.getSelectedRows();
        if (null != arrSelectedRows && 0 < arrSelectedRows.length) {
            iFirstSelectedRow = arrSelectedRows[0];
        }
        int iPatchCount = oPatchList.size();
        for (int i = 0; i < iPatchCount; ++i) {
            IPatch oPatch = (IPatch)oPatchList.get(i);
            this.m_oPatchTableModel.removePatch(oPatch);
        }
        if (0 < this.m_oPatchTable.getRowCount() && -1 != iFirstSelectedRow) {
            if (iFirstSelectedRow + 1 <= this.m_oPatchTable.getRowCount()) {
                this.m_oPatchTable.setRowSelectionInterval(iFirstSelectedRow, iFirstSelectedRow);
            } else {
                this.m_oPatchTable.setRowSelectionInterval(0, 0);
            }
        }
    }

    public boolean isSelectOneLine() {
        int[] arrSelectedRows = this.m_oPatchTable.getSelectedRows();
        return null != arrSelectedRows && 1 == arrSelectedRows.length;
    }

    public DeviceInfo getSelectDevInfo() {
        DeviceInfo oDeviceInfo = null;
        int[] arrSelectedRows = this.m_oPatchTable.getSelectedRows();
        if (null != arrSelectedRows && 1 == arrSelectedRows.length) {
            IPatch oPatch = this.m_oPatchTableModel.getPatchAtRow(arrSelectedRows[0]);
            oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(oPatch.getResource().getDeviceID());
        }
        return oDeviceInfo;
    }

    public void refreshPathes(IPatch patchInfo) {
        if (null == patchInfo) {
            return;
        }
        IPatch patch = null;
        for (int i = 0; i < this.m_oPatchTableModel.getDataVector().size(); ++i) {
            patch = (IPatch)((Object)this.m_oPatchTableModel.getDataVector().get(i));
            if (null == patch || !patch.getResource().equals(patchInfo.getResource()) || patch.getPatchId() != patchInfo.getPatchId()) continue;
            patch.setPatchSate(patchInfo.getPatchState());
            patch.setProgressInfo(patchInfo.getProgressInfo());
        }
    }

    public void clearTableData() {
        this.m_oPatchTableModel.clearPatches();
    }

    public void cleanUp() {
        this.m_oPopupMenuManager.cleanUp();
        this.c_oPatchSyncCommController = null;
        this.m_oPatchTableModel = null;
        this.m_oPatchTable = null;
        this.m_oPopupMenuManager = null;
    }

    public void refreshTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PatchTablePanel.this.m_oPatchTable.updateUI();
            }
        });
    }

    public IPatch getPatchAtRow(int iRow) {
        return this.m_oPatchTableModel.getPatchAtRow(iRow);
    }

    public void activatePatch() {
        int iPatchOperation = 10;
        List oSelectedPatches = this.getSelectedPatchList();
        boolean bContinue = this.confirmPatchOperation(10, this.m_oResourceManager.getResString("PATCH_OPERATION_CONFIRM_TITLE"), this.m_oResourceManager.getResString("ACTIVATE_PATCH_CONFIRM_MSG"), oSelectedPatches);
        if (bContinue) {
            this.doPatchOperation(10, oSelectedPatches);
        }
    }

    public void deactivatePatch() {
        int iPatchOperation = 14;
        List oSelectedPatches = this.getSelectedPatchList();
        boolean bContinue = this.confirmPatchOperation(14, this.m_oResourceManager.getResString("PATCH_OPERATION_CONFIRM_TITLE"), this.m_oResourceManager.getResString("DEACTIVATE_PATCH_CONFIRM_MSG"), oSelectedPatches);
        if (bContinue) {
            this.doPatchOperation(14, oSelectedPatches);
        }
    }

    public void confirmPatch() {
        int iPatchOperation = 11;
        List oSelectedPatches = this.getSelectedPatchList();
        boolean bContinue = this.confirmPatchOperation(11, this.m_oResourceManager.getResString("PATCH_OPERATION_CONFIRM_TITLE"), this.m_oResourceManager.getResString("PATCH_CONFIRM_PROMPT"), oSelectedPatches);
        if (bContinue) {
            this.doPatchOperation(11, oSelectedPatches);
        }
    }

    public void getIPNePatchDetailInfo() {
        PatchAsyncCommController.getInstance().getIPNePatchDetailInfo(this.getSelectedResId());
    }

    public void deletePatch() {
        int iPatchOperation = 15;
        List oSelectedPatches_tmp = this.getSelectedPatchList();
        ArrayList oSelectedPatches = new ArrayList(0);
        int iSize = oSelectedPatches_tmp.size();
        for (int index = 0; index < iSize; ++index) {
            oSelectedPatches.add(oSelectedPatches_tmp.get(iSize - 1 - index));
        }
        boolean bContinue = this.confirmPatchOperation(15, this.m_oResourceManager.getResString("PATCH_OPERATION_CONFIRM_TITLE"), this.m_oResourceManager.getResString("DELETE_PATCH_CONFIRM_MSG"), oSelectedPatches);
        if (bContinue) {
            this.doPatchOperation(15, oSelectedPatches);
        }
    }

    private void doPatchOperation(int iPatchOperationID, List oSelectedPatches) {
        if (0 == oSelectedPatches.size()) {
            return;
        }
        int iErrorCode = this.c_oPatchSyncCommController.doPatchOperation(iPatchOperationID, oSelectedPatches);
        if (0 != iErrorCode) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), iErrorCode, ResourceManager.getInstance().getResString("ERROR"), 0);
            return;
        }
        this.updateStatusForSelectedPatches(oSelectedPatches);
    }

    protected boolean confirmPatchOperation(int iPatchOperation, String strConfirmationTitle, String strConfirmationMessage, List oSelectedPatches) {
        int iConfirmOption = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), strConfirmationMessage, strConfirmationTitle, 0);
        if (0 != iConfirmOption) {
            return false;
        }
        this.confirmRebootIfRequired(iPatchOperation, oSelectedPatches, strConfirmationTitle);
        return true;
    }

    private void updateStatusForSelectedPatches(List oSelectedPatches) {
        DCDebugTracer.trace("PatchTablePanel#updateStatusForSelectedPatches start : " + System.currentTimeMillis());
        int length = oSelectedPatches.size();
        for (int i = 0; i < length; ++i) {
            IPatch oPatch = (IPatch)oSelectedPatches.get(i);
            oPatch.getProgressInfo().setState(1);
            oPatch.getProgressInfo().setProgress(0);
        }
        this.refreshTable();
        DCDebugTracer.trace("PatchTablePanel#updateStatusForSelectedPatches end.. : " + System.currentTimeMillis());
    }

    private List getSelectedPatchList() {
        ArrayList<IPatch> oPatchList = new ArrayList<IPatch>(0);
        int[] arrSelectedRows = this.m_oPatchTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return oPatchList;
        }
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            oPatchList.add(this.m_oPatchTableModel.getPatchAtRow(arrSelectedRows[i]));
        }
        return oPatchList;
    }

    private int getSelectedResId() {
        int devId = Integer.MIN_VALUE;
        int[] arrSelectedRows = this.m_oPatchTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return Integer.MIN_VALUE;
        }
        IPatch patch = this.m_oPatchTableModel.getPatchAtRow(arrSelectedRows[0]);
        return patch.getResource().getDeviceID();
    }

    private void confirmRebootIfRequired(int iPatchOperation, List oSelectedPatches, String strConfirmationTitle) {
        int iColdPatchConfirm;
        int iSelectedPatchCount = oSelectedPatches.size();
        ArrayList<IPatch> oColdPatchList = new ArrayList<IPatch>(0);
        boolean bIsAnyActiveColdPatch = false;
        boolean bIsAnyConfirmedColdPatch = false;
        boolean bIsAnyToBeActiveColdPatch = false;
        block5: for (int i = 0; i < iSelectedPatchCount; ++i) {
            IPatch oPatch = (IPatch)oSelectedPatches.get(i);
            if (2 != oPatch.getType() && 3 != oPatch.getType()) continue;
            oColdPatchList.add(oPatch);
            switch (oPatch.getPatchState()) {
                case 2: {
                    bIsAnyActiveColdPatch = true;
                    continue block5;
                }
                case 3: {
                    bIsAnyConfirmedColdPatch = true;
                    continue block5;
                }
                case 4: {
                    bIsAnyToBeActiveColdPatch = true;
                    continue block5;
                }
            }
        }
        if (0 >= oColdPatchList.size()) {
            return;
        }
        boolean bIsRebootRequired = false;
        if (10 == iPatchOperation) {
            bIsRebootRequired = true;
        } else if (11 == iPatchOperation) {
            if (bIsAnyToBeActiveColdPatch) {
                bIsRebootRequired = true;
            }
        } else if (15 == iPatchOperation && (bIsAnyActiveColdPatch || bIsAnyConfirmedColdPatch)) {
            bIsRebootRequired = true;
        }
        if (bIsRebootRequired && 0 != (iColdPatchConfirm = DCOptionPane.showConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), this.m_oResourceManager.getResString("PATCH_OPERATION_CONFIRM_FOR_COLD_PATCHES"), strConfirmationTitle, 0))) {
            bIsRebootRequired = false;
        }
        int iColdPatchesCount = oColdPatchList.size();
        for (int i = 0; i < iColdPatchesCount; ++i) {
            IPatch oPatch = (IPatch)oColdPatchList.get(i);
            oPatch.setIsRebootRequired(bIsRebootRequired);
        }
    }

    private boolean isPatchOperationSupported(String strOperationID) {
        if (null == strOperationID || "".equals(strOperationID.trim())) {
            return false;
        }
        DeviceTypeInfo oDeviceTypeInfo = PatchDataModel.getInstance().getDeviceType();
        if (null == oDeviceTypeInfo) {
            return false;
        }
        int[] iDeviceIdLst = PatchDataModel.getInstance().getDeviceIdLst();
        IDeviceTypeConfigModel oDeviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceTypeInfo, iDeviceIdLst);
        List oSupportedOperations = this.m_oPopupMenuManager.getAllSupportedMenuOperations(oDeviceTypeConfigModel);
        if (null == oSupportedOperations || 0 == oSupportedOperations.size()) {
            return false;
        }
        int iOperationCount = oSupportedOperations.size();
        for (int i = 0; i < iOperationCount; ++i) {
            String strSuppOperationID = (String)oSupportedOperations.get(i);
            if (!strOperationID.equals(strSuppOperationID)) continue;
            return true;
        }
        return false;
    }
}

