/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.patchmanagement.view.patchtable;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.devicemanagement.patchmanagement.model.IPatch;
import com.huawei.dc.taskmgmt.model.Resource;
import javax.swing.table.DefaultTableModel;

public class PatchTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] PATCH_TABLE_HEADER_NAMES = new String[]{ResourceManager.getInstance().getResString("RESOURCE_NAME"), ResourceManager.getInstance().getResString("DEVICE_TABLE_HEADER_RESOURCE_IP"), ResourceManager.getInstance().getResString("PATCH_TABLE_COLUMN_RESOURCE_ID"), ResourceManager.getInstance().getResString("PATCH_TABLE_COLUMN_BOARD_TYPE"), ResourceManager.getInstance().getResString("PATCH_TABLE_COLUMN_PATCH_NAME"), ResourceManager.getInstance().getResString("PATCH_TABLE_COLUMN_PATCH_TYPE"), ResourceManager.getInstance().getResString("PATCH_TABLE_COLUMN_PATCH_RELY_ON"), ResourceManager.getInstance().getResString("PATCH_TABLE_COLUMN_PATCH_RELIED_ON"), ResourceManager.getInstance().getResString("PATCH_TABLE_COLUMN_PATCH_VERSION"), ResourceManager.getInstance().getResString("PATCH_TABLE_COLUMN_PATCH_DESCRIPTION"), ResourceManager.getInstance().getResString("PATCH_TABLE_COLUMN_PATCH_STATE"), ResourceManager.getInstance().getResString("PATCH_TABLE_COLUMN_PATCH_STATUS")};
    public static final int DEVICE_NAME_COLUMN = 0;
    public static final int DEVICE_IP_COLUMN = 1;
    public static final int RESOURCE_ID_COLUMN = 2;
    public static final int BOARD_TYPE_COLUMN = 3;
    public static final int PATCH_NAME_COLUMN = 4;
    public static final int PATCH_TYPE_COLUMN = 5;
    public static final int PATCH_RELY_ON_COLUMN = 6;
    public static final int PATCH_RELIED_ON_COLUMN = 7;
    public static final int PATCH_VERSION_COLUMN = 8;
    public static final int PATCH_DESCRIPTION_COLUMN = 9;
    public static final int PATCH_STATE_COLUMN = 10;
    public static final int PATCH_STATUS_COLUMN = 11;

    public PatchTableModel() {
        super(PATCH_TABLE_HEADER_NAMES, 0);
    }

    @Override
    public Object getValueAt(int iRow, int iColumn) {
        if (0 > iRow) {
            return "";
        }
        Object oRowData = this.dataVector.elementAt(iRow);
        if (null == oRowData || !(oRowData instanceof IPatch)) {
            return "";
        }
        IPatch oPatch = (IPatch)oRowData;
        switch (iColumn) {
            case 0: {
                return oPatch.getResource().getDeviceName();
            }
            case 1: {
                return oPatch.getResource().getDeviceIP();
            }
            case 2: {
                return this.getResourceIDForPatch(oPatch);
            }
            case 3: {
                return oPatch.getResource().getBoardTypeName();
            }
            case 4: {
                return oPatch.getName();
            }
            case 5: {
                return ResourceManager.getInstance().getResString("PATCH_TYPE_" + oPatch.getType());
            }
            case 6: {
                return oPatch.getRelyOn();
            }
            case 7: {
                return oPatch.getReliedOn();
            }
            case 8: {
                return oPatch.getVersion();
            }
            case 9: {
                return oPatch.getDescription();
            }
            case 10: {
                return ResourceManager.getInstance().getResString("PATCH_TYPE_STATE_" + oPatch.getPatchState());
            }
            case 11: {
                return oPatch.getProgressInfo();
            }
        }
        return "";
    }

    private String getResourceIDForPatch(IPatch oPatch) {
        StringBuffer strResourceID = new StringBuffer(0);
        strResourceID.append("");
        Resource oResource = oPatch.getResource();
        if (-1 != oResource.getFrameId()) {
            strResourceID.append(oResource.getFrameId());
        }
        if (-1 != oResource.getSlotId()) {
            strResourceID.append('_').append(oResource.getSlotId());
        }
        return strResourceID.toString();
    }

    public void addPatch(IPatch oPatch) {
        if (null != oPatch && !this.dataVector.contains(oPatch)) {
            this.dataVector.addElement(oPatch);
        }
    }

    public void removePatch(IPatch oPatch) {
        if (null != oPatch && this.dataVector.contains(oPatch)) {
            this.dataVector.removeElement(oPatch);
        }
    }

    public IPatch getPatchAtRow(int iRow) {
        return (IPatch)this.dataVector.elementAt(iRow);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void clearPatches() {
        this.dataVector.clear();
    }
}

