/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.patchmanagement.view.patchtable;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.PopupMenuManager;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.common.util.MenuUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IPatchOperation;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IPatchConfig;
import com.huawei.dc.devicemanagement.patchmanagement.model.IPatch;
import com.huawei.dc.devicemanagement.patchmanagement.model.PatchDataModel;
import com.huawei.dc.devicemanagement.patchmanagement.view.patchtable.PatchTablePanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public class PatchManagementPopupMenuManager {
    public static final String IP_PATCH_DETAIL = "PatchDetail";
    private HashMap m_oPatchMenuItemMap;
    private JPopupMenu m_oPatchInfoPopupMenu;
    private PatchTablePanel m_oPatchTablePanel;
    private boolean m_patchMgrPrivilege = true;
    private boolean m_DelPatchMgrPrivilege = true;

    public PatchManagementPopupMenuManager(PatchTablePanel oPatchTablePanel) {
        this.m_oPatchTablePanel = oPatchTablePanel;
        this.checkUserPrivileges();
        this.generateMenuFromXML();
    }

    public void checkUserPrivileges() {
        if (DCFrameWorkUtil.getIsSingleClient()) {
            return;
        }
        this.m_patchMgrPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43834);
        this.m_DelPatchMgrPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(43835);
    }

    private void generateMenuFromXML() {
        PopupMenuManager oPopupMenuManager = PopupMenuManager.getInstance();
        this.m_oPatchInfoPopupMenu = oPopupMenuManager.load(this.m_oPatchTablePanel, "patchmanagementtablepopupmenu");
        this.m_oPatchMenuItemMap = oPopupMenuManager.getMenuItemMap();
    }

    private void enableAllMenuItems(boolean bFlag) {
        for (String strMenuItemID : this.m_oPatchMenuItemMap.keySet()) {
            JMenuItem oMenuItem = this.getMenuItemForID(strMenuItemID);
            if (null == oMenuItem) continue;
            oMenuItem.setEnabled(bFlag && this.m_patchMgrPrivilege);
        }
    }

    private JMenuItem getMenuItemForID(String strMenuItemID) {
        return (JMenuItem)this.m_oPatchMenuItemMap.get(strMenuItemID);
    }

    public JPopupMenu load() {
        this.enableAllMenuItems(false);
        DeviceTypeInfo oDeviceTypeInfo = PatchDataModel.getInstance().getDeviceType();
        if (null == oDeviceTypeInfo) {
            return this.m_oPatchInfoPopupMenu;
        }
        int[] iDeviceIdLst = PatchDataModel.getInstance().getDeviceIdLst();
        IDeviceTypeConfigModel oDeviceTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceTypeInfo, iDeviceIdLst);
        this.enableSupportedOperations(oDeviceTypeConfigModel);
        this.handleMenuItemPatchDetail(oDeviceTypeInfo);
        return this.m_oPatchInfoPopupMenu;
    }

    private void handleMenuItemPatchDetail(DeviceTypeInfo oDeviceTypeInfo) {
        JMenuItem oJMenuItem = this.getMenuItemForID(IP_PATCH_DETAIL);
        if (oDeviceTypeInfo.isDMSDomain()) {
            MenuUtil.visibleMenuItem(oJMenuItem, true);
            if (this.m_oPatchTablePanel.isSelectOneLine()) {
                DeviceInfo oDeviceInfo = this.m_oPatchTablePanel.getSelectDevInfo();
                if (DeviceInfoUtil.isClusterNE(oDeviceInfo)) {
                    MenuUtil.enableMenuItem((Component)oJMenuItem, false);
                } else {
                    MenuUtil.enableMenuItem((Component)oJMenuItem, true);
                }
            } else {
                MenuUtil.enableMenuItem((Component)oJMenuItem, false);
            }
        } else {
            MenuUtil.visibleMenuItem(oJMenuItem, false);
        }
    }

    private void enableSupportedOperations(IDeviceTypeConfigModel oDeviceTypeConfigModel) {
        List arrSupportedMenuItems = this.getAllSupportedMenuOperations(oDeviceTypeConfigModel);
        int iMenuItemCount = arrSupportedMenuItems.size();
        for (int i = 0; i < iMenuItemCount; ++i) {
            String menuIdStr = (String)arrSupportedMenuItems.get(i);
            JMenuItem oMenuItem = this.getMenuItemForID(menuIdStr);
            if (null == oMenuItem) continue;
            if ("DeletePatch".equals(menuIdStr)) {
                oMenuItem.setEnabled(this.m_DelPatchMgrPrivilege);
                continue;
            }
            oMenuItem.setEnabled(this.m_patchMgrPrivilege);
        }
    }

    public List getAllSupportedMenuOperations(IDeviceTypeConfigModel oDeviceTypeConfigModel) {
        ArrayList arrSupportedMenuItems = new ArrayList(0);
        JTable oPatchInfoTable = this.m_oPatchTablePanel.getPatchInfoTable();
        int[] arrSelectedRows = oPatchInfoTable.getSelectedRows();
        if (null == arrSelectedRows || 0 == arrSelectedRows.length) {
            return arrSupportedMenuItems;
        }
        boolean bIsAnyHotPatchSelected = false;
        boolean bIsAnyColdPatchSelected = false;
        ArrayList<IPatch> oSelectedPatchList = new ArrayList<IPatch>(arrSelectedRows.length);
        for (int i = 0; i < arrSelectedRows.length; ++i) {
            IPatch oPatch = this.m_oPatchTablePanel.getPatchAtRow(arrSelectedRows[i]);
            oSelectedPatchList.add(oPatch);
            if (0 == oPatch.getType() || 1 == oPatch.getType()) {
                bIsAnyHotPatchSelected = true;
            } else {
                bIsAnyColdPatchSelected = true;
            }
            if (oPatch.getProgressInfo().getProgress() <= -1) continue;
            return arrSupportedMenuItems;
        }
        arrSupportedMenuItems = new ArrayList(this.getSupportedMenuItemIDs(oDeviceTypeConfigModel, bIsAnyHotPatchSelected, bIsAnyColdPatchSelected));
        ArrayList arrSupportedOperationIDs = new ArrayList(this.getSupportedOperationIDs(oDeviceTypeConfigModel, oSelectedPatchList));
        arrSupportedMenuItems.retainAll(arrSupportedOperationIDs);
        return arrSupportedMenuItems;
    }

    private List getSupportedMenuItemIDs(IDeviceTypeConfigModel oDeviceTypeConfigModel, boolean bIsAnyHotPatchSelected, boolean bIsAnyColdPatchSelected) {
        String[] arrMenuItems;
        if (null == oDeviceTypeConfigModel || !bIsAnyHotPatchSelected && !bIsAnyColdPatchSelected) {
            return new ArrayList(0);
        }
        List<String> oMenuItemList = null;
        if (bIsAnyHotPatchSelected) {
            arrMenuItems = oDeviceTypeConfigModel.getViewConfiguration().getViewConfiguration(1);
            oMenuItemList = Arrays.asList(arrMenuItems);
        }
        if (bIsAnyColdPatchSelected) {
            arrMenuItems = oDeviceTypeConfigModel.getViewConfiguration().getViewConfiguration(2);
            if (null == oMenuItemList) {
                oMenuItemList = Arrays.asList(arrMenuItems);
            } else {
                oMenuItemList.retainAll(Arrays.asList(arrMenuItems));
            }
        }
        return oMenuItemList;
    }

    private List getSupportedOperationIDs(IDeviceTypeConfigModel oDeviceTypeConfigModel, List oPatchList) {
        int iPatchCount = oPatchList.size();
        IPatch oPatch = (IPatch)oPatchList.get(0);
        List oSupportedOperationIDs = this.getOperationIDListForPatch(oDeviceTypeConfigModel, oPatch.getType(), oPatch.getPatchState());
        for (int i = 1; i < iPatchCount; ++i) {
            oPatch = (IPatch)oPatchList.get(i);
            oSupportedOperationIDs.retainAll(this.getOperationIDListForPatch(oDeviceTypeConfigModel, oPatch.getType(), oPatch.getPatchState()));
        }
        return oSupportedOperationIDs;
    }

    private List getOperationIDListForPatch(IDeviceTypeConfigModel oDeviceTypeConfigModel, int iPatchType, int iPatchState) {
        IPatchConfig oPatchConfig = oDeviceTypeConfigModel.getPatchConfiguration();
        ArrayList oOperationList = null;
        switch (iPatchType) {
            case 0: 
            case 1: {
                oOperationList = oPatchConfig.getHotPatchSuppState(iPatchState);
                break;
            }
            case 2: 
            case 3: {
                oOperationList = oPatchConfig.getColdPatchSuppState(iPatchState);
                break;
            }
            default: {
                oOperationList = new ArrayList(0);
            }
        }
        if (null == oOperationList || 0 == oOperationList.size()) {
            return new ArrayList(0);
        }
        int iOperationCount = oOperationList.size();
        ArrayList<String> oOperationIDList = new ArrayList<String>(iOperationCount);
        for (int i = 0; i < iOperationCount; ++i) {
            IPatchOperation oOperation = (IPatchOperation)oOperationList.get(i);
            oOperationIDList.add(oOperation.getOperationIdString());
        }
        return oOperationIDList;
    }

    public void cleanUp() {
        this.m_oPatchMenuItemMap.clear();
        this.m_oPatchMenuItemMap = null;
        this.m_oPatchInfoPopupMenu = null;
        this.m_oPatchTablePanel = null;
    }
}

