/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.patchmanagement.view.filterpatch;

import com.huawei.dc.common.components.devicetreepanel.DeviceTreePanel;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.BoardNodeInfo;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.controller.BoardTypeManager;
import com.huawei.dc.devicemanagement.patchmanagement.model.IPatch;
import com.huawei.dc.devicemanagement.patchmanagement.model.PatchFilterCriteria;
import com.huawei.dc.devicemanagement.patchmanagement.util.PatchDataModelUtil;
import com.huawei.dc.devicemanagement.patchmanagement.view.filterpatch.FilterDialog;
import com.huawei.dc.devicemanagement.patchmanagement.view.patchtable.PatchTablePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class PatchFilterBasePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel m_oFilterLabel;
    private JComboBox m_oFilterHistoryDropdown;
    private JButton m_oFilterButton;
    private boolean m_bProcessFilter;
    private ResourceManager m_oResManager = ResourceManager.getInstance();
    private PatchTablePanel m_oPatchTablePanel;
    private DeviceTreePanel m_oDeviceTreePanel;
    private static final int FILTER_HISTORY_MAX_SIZE = 10;
    private static final char FILTER_BUTTON_MNEMONIC = 'l';

    public PatchFilterBasePanel(PatchTablePanel oTablePanel, DeviceTreePanel oDeviceTreePanel) {
        this.m_oPatchTablePanel = oTablePanel;
        this.m_oDeviceTreePanel = oDeviceTreePanel;
        this.jInit();
        this.m_bProcessFilter = true;
    }

    private void jInit() {
        this.initializeFields();
        this.addFieldsToPanel();
        this.initalizeListenersForFields();
    }

    private void initializeFields() {
        this.m_oFilterLabel = new JLabel(this.m_oResManager.getResString("PATCH_TABLE_PANEL_FILTER_LABEL") + ":");
        this.m_oFilterHistoryDropdown = new JComboBox();
        this.m_oFilterHistoryDropdown.setName("PatchManagement_PatchFilterBasePanel_m_oFilterHistoryDropdown");
        this.m_oFilterHistoryDropdown.setFocusable(false);
        this.m_oFilterHistoryDropdown.setRenderer(new CustomComboBoxRenderer());
        this.m_oFilterHistoryDropdown.setMaximumRowCount(10);
        this.m_oFilterButton = new JButton(this.m_oResManager.getResString("LOG_INFO_PAN_FILTER_BTN"));
        this.m_oFilterButton.setName("PatchManagement_PatchFilterBasePanel_m_oFilterButton");
        this.m_oFilterButton.setMnemonic('F');
    }

    private void addFieldsToPanel() {
        GridBagLayout oGrid = new GridBagLayout();
        this.setLayout(oGrid);
        GridBagConstraints oConstraints = new GridBagConstraints();
        oConstraints.fill = 2;
        oConstraints.insets = new Insets(8, 12, 4, 1);
        oConstraints.anchor = 17;
        oConstraints.ipady = -4;
        oConstraints.gridwidth = 2;
        oConstraints.gridheight = 1;
        oConstraints.gridx = 0;
        oConstraints.gridy = 0;
        oConstraints.weightx = 0.0;
        this.add((Component)this.m_oFilterLabel, oConstraints);
        oConstraints.insets = new Insets(8, 12, 4, 2);
        oConstraints.gridwidth = -2;
        oConstraints.gridheight = 1;
        oConstraints.gridx = 2;
        oConstraints.gridy = 0;
        oConstraints.weightx = 0.25;
        this.add((Component)this.m_oFilterHistoryDropdown, oConstraints);
        oConstraints.anchor = 13;
        oConstraints.insets = new Insets(8, 12, 8, 12);
        oConstraints.gridwidth = 2;
        oConstraints.gridheight = 1;
        oConstraints.gridx = 3;
        oConstraints.weightx = 0.0;
        oConstraints.gridy = 0;
        this.add((Component)this.m_oFilterButton, oConstraints);
    }

    private void initalizeListenersForFields() {
        this.m_oFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PatchFilterBasePanel.this.openFilterDialog();
            }
        });
        this.m_oFilterHistoryDropdown.addItemListener(this.generateActionListenerForFilterHistory());
    }

    public void updateFilterHistoryModel(PatchFilterCriteria oCriteria) {
        int iModelSize = this.m_oFilterHistoryDropdown.getItemCount();
        if (10 == iModelSize) {
            this.m_oFilterHistoryDropdown.removeItemAt(iModelSize - 1);
        }
        this.m_bProcessFilter = false;
        if (this.isCriteriaAlreadyPresentInModel(oCriteria)) {
            this.m_bProcessFilter = true;
            return;
        }
        boolean iStartIndex = true;
        this.m_oFilterHistoryDropdown.insertItemAt(oCriteria, 1);
        this.m_oFilterHistoryDropdown.setSelectedItem(oCriteria);
        this.m_bProcessFilter = true;
    }

    private boolean isCriteriaAlreadyPresentInModel(PatchFilterCriteria oCriteria) {
        int iModelSize = this.m_oFilterHistoryDropdown.getItemCount();
        PatchFilterCriteria oExistingCriteria = null;
        for (int i = 0; i < iModelSize; ++i) {
            oExistingCriteria = (PatchFilterCriteria)this.m_oFilterHistoryDropdown.getItemAt(i);
            if (null == oExistingCriteria) continue;
            if (oCriteria.equals(oExistingCriteria)) {
                return true;
            }
            if (!oCriteria.toString().equals(oExistingCriteria.toString())) continue;
            return true;
        }
        return false;
    }

    private void openFilterDialog() {
        FilterDialog oFilterDialog = new FilterDialog(this);
        oFilterDialog.setVisible(true);
    }

    private ItemListener generateActionListenerForFilterHistory() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PatchFilterBasePanel.this.filterFromHistory();
            }
        };
    }

    private void filterFromHistory() {
        if (!this.m_bProcessFilter) {
            return;
        }
        if (0 == this.m_oFilterHistoryDropdown.getItemCount()) {
            return;
        }
        PatchFilterCriteria oCriteria = (PatchFilterCriteria)this.m_oFilterHistoryDropdown.getSelectedItem();
        this.filterPatches(oCriteria);
    }

    public void filterPatches(PatchFilterCriteria oCriteria) {
        this.m_oPatchTablePanel.clearTableData();
        this.m_oPatchTablePanel.updateUI();
        List oFilteredPatches = PatchDataModelUtil.filterPatchesForCriteria(oCriteria);
        this.updateFilterHistoryModel(oCriteria);
        if (null == oFilteredPatches || 0 == oFilteredPatches.size()) {
            return;
        }
        int iPatchCount = oFilteredPatches.size();
        for (int i = 0; i < iPatchCount; ++i) {
            IPatch oPatch = (IPatch)oFilteredPatches.get(i);
            this.m_oPatchTablePanel.addPatchToTable(oPatch);
        }
    }

    public void enableComponents(boolean bFlag) {
        if (!bFlag) {
            this.m_oFilterHistoryDropdown.removeAllItems();
        }
        this.m_oFilterLabel.setEnabled(bFlag);
        this.m_oFilterButton.setEnabled(bFlag);
        this.m_oFilterHistoryDropdown.setEnabled(bFlag);
    }

    public void cleanUp() {
        this.m_oDeviceTreePanel = null;
        this.m_oResManager = null;
        this.m_oPatchTablePanel = null;
        this.m_oFilterHistoryDropdown.removeAll();
        this.m_oFilterHistoryDropdown = null;
    }

    private void createBoardTypeLst(DeviceTypeInfo oDevType, Hashtable oBoardTypesTable, List oBoardNodeInfoList) {
        if (null == oBoardTypesTable) {
            return;
        }
        Set oKeyset = oBoardTypesTable.keySet();
        String[] arrBoardTypes = oKeyset.toArray(new String[0]);
        int noOfBoardTypes = arrBoardTypes.length;
        String strBoardTypeName = null;
        Integer oBoardTypeId = null;
        BoardNodeInfo oNodeInfo = null;
        for (int j = 0; j < noOfBoardTypes; ++j) {
            oBoardTypeId = Integer.valueOf(arrBoardTypes[j]);
            int iBoardTypeCode = oBoardTypeId;
            strBoardTypeName = BoardTypeManager.getInstance().getBoardTypeDescription(oDevType.getDevTypeName(), oDevType.getDevTypeVersionName(), iBoardTypeCode);
            oNodeInfo = new BoardNodeInfo();
            oNodeInfo.setBoardType(iBoardTypeCode);
            oNodeInfo.setBoardTypeName(strBoardTypeName);
            oNodeInfo.setSelected(true);
            if (oBoardNodeInfoList.contains(oNodeInfo)) continue;
            oBoardNodeInfoList.add(oNodeInfo);
        }
    }

    private void setAllFilter(DeviceTypeInfo oDevType) {
        int FILTER_OPTION_ALL = -1;
        PatchFilterCriteria oCriteria = new PatchFilterCriteria();
        oCriteria.setType(-1);
        oCriteria.setState(-1);
        oCriteria.setPatchIDCriteria(-1);
        ArrayList oBoardNodeInfoList = new ArrayList();
        if (null != oDevType) {
            Hashtable oBoardTypesTable = BoardTypeManager.getInstance().getBoardTypes(oDevType.getDevTypeName(), oDevType.getDevTypeVersionName());
            this.createBoardTypeLst(oDevType, oBoardTypesTable, oBoardNodeInfoList);
        }
        oCriteria.setBoardTypes(oBoardNodeInfoList);
        oCriteria.setIsAll(true);
        boolean isSelected = false;
        if (null != oDevType) {
            isSelected = true;
        }
        try {
            if (!this.isCriteriaAlreadyPresentInModel(oCriteria)) {
                this.m_oFilterHistoryDropdown.insertItemAt(oCriteria, 0);
            }
            if (isSelected) {
                this.m_oFilterHistoryDropdown.setSelectedIndex(0);
                this.filterPatches((PatchFilterCriteria)this.m_oFilterHistoryDropdown.getItemAt(0));
            }
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }

    public void updateSelectedDevType(DeviceTypeInfo oDevType) {
        this.setAllFilter(oDevType);
    }

    class CustomComboBoxRenderer
    extends BasicComboBoxRenderer {
        CustomComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String strValue = "";
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (index > -1) {
                    if (null != value) {
                        strValue = StringUtils.getHtmlString(value.toString());
                        list.setToolTipText(strValue);
                    }
                } else {
                    list.setToolTipText(null);
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (null != value) {
                strValue = StringUtils.getHtmlString(value.toString());
                list.setToolTipText(strValue);
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

