/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.patchmanagement.view.filterpatch;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.devicemanagement.patchmanagement.model.PatchFilterCriteria;
import com.huawei.dc.devicemanagement.patchmanagement.view.filterpatch.FilterCriteriaPanel;
import com.huawei.dc.devicemanagement.patchmanagement.view.filterpatch.PatchFilterBasePanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class FilterDialog
extends DCModalDialog {
    private static final long serialVersionUID = 1L;
    private ResourceManager oResManager;
    private FilterCriteriaPanel m_oFilterPanel;
    private PatchFilterBasePanel m_oPatchFilterPanel;

    public FilterDialog(PatchFilterBasePanel oPatchFilterPanel) {
        this.m_oPatchFilterPanel = oPatchFilterPanel;
        this.initDialog();
    }

    private void initDialog() {
        this.oResManager = ResourceManager.getInstance();
        this.initializeDialog();
        this.addButtons();
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private void addButtons() {
        this.m_oCancelBtn.setText(this.oResManager.getResString("CANCEL_BTN"));
        this.m_oCancelBtn.setName("PatchManagement_FilterDialog_m_oCancelBtn");
        this.m_oOKBtn.setText(this.oResManager.getResString("OK_BTN"));
        this.m_oOKBtn.setName("PatchManagement_FilterDialog_m_oOKBtn");
        this.m_oOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent strE) {
                FilterDialog.this.okBtnActionPerformed();
            }
        });
        if (this.m_oFilterPanel.getBoardTreePanel() != null) {
            this.m_oCancelBtn.setBounds(400, 301, 80, 20);
            this.m_oOKBtn.setBounds(313, 301, 80, 20);
        } else {
            this.m_oCancelBtn.setBounds(196, 198, 80, 20);
            this.m_oOKBtn.setBounds(109, 198, 80, 20);
        }
        this.getContentPane().add(this.m_oOKBtn);
        this.getContentPane().add(this.m_oCancelBtn);
    }

    private void initializeDialog() {
        this.setResizable(false);
        this.setSize(498, 365);
        this.setTitle(this.oResManager.getResString("PATCH_FILTER_DLG_TITLE"));
        this.getContentPane().setLayout(null);
        this.m_oFilterPanel = new FilterCriteriaPanel();
        if (this.m_oFilterPanel.getBoardTreePanel() == null) {
            this.setSize(this.getWidth() / 2 + 46, this.getHeight() / 2 + 75);
        }
        this.getContentPane().add(this.m_oFilterPanel);
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_FILTER_PATCH_CONTEXT";
    }

    private void okBtnActionPerformed() {
        PatchFilterCriteria oCriteria = this.m_oFilterPanel.getFilterCriteria();
        if (null == oCriteria) {
            return;
        }
        this.m_oPatchFilterPanel.filterPatches(oCriteria);
        this.closeDialog();
    }
}

