/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.patchmanagement.view.filterpatch;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.CodeValue;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.DeviceModelAdapter;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IPatchConfig;
import com.huawei.dc.devicemanagement.patchmanagement.model.PatchDataModel;
import com.huawei.dc.devicemanagement.patchmanagement.model.PatchFilterCriteria;
import com.huawei.dc.devicemanagement.patchmanagement.view.filterpatch.BoardTreePanel;
import com.huawei.dc.taskmgmt.model.Resource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class FilterCriteriaPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BoardTreePanel m_oBoardTreePanel;
    private JLabel m_oPatchTypeLabel;
    private JLabel m_oPatchStateLabel;
    private ResourceManager oResManager;
    private ComboBoxWithToolTip m_oPatchTypeDropDown;
    private DefaultComboBoxModel m_oPatchTypeDropDownModel;
    private ComboBoxWithToolTip m_oPatchStateDropDown;
    private DefaultComboBoxModel m_oPatchStateDropDownModel;
    private JRadioButton m_oMaxPatchIdRadioBtn;
    private JRadioButton m_oMinPatchIdRadioBtn;
    private JRadioButton m_oAllIdRadioBtn;
    private ButtonGroup m_oIdBtnGroup;
    private static final char MAX_RADIO_BUTTON_MNEMONIC = 'm';
    private static final char MIN_RADIO_BUTTON_MNEMONIC = 'i';
    private static final char ALL_RADIO_BUTTON_MNEMONIC = 'a';
    private IDeviceTypeConfigModel m_oDevTypeConfigModel;
    public static final int FILTER_OPTION_ALL = -1;

    public FilterCriteriaPanel() {
        this.jbInit();
    }

    private void jbInit() {
        this.initializeDeviceTypeConfigModel();
        this.oResManager = ResourceManager.getInstance();
        this.initPanel();
        this.initPanelComponents();
        this.addComponents();
    }

    private void initializeDeviceTypeConfigModel() {
        List oResourceList = PatchDataModel.getInstance().getSelectedResources();
        if (null != oResourceList && 0 != oResourceList.size()) {
            Resource oResource = (Resource)oResourceList.get(0);
            DeviceTypeInfo oDeviceType = DeviceModelAdapter.getDeviceTypeForResource(oResource);
            int[] iDeviceIdLst = new int[]{oResource.getDeviceID()};
            this.m_oDevTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceType, iDeviceIdLst);
        }
    }

    private void initPanelComponents() {
        this.initBoardTreePanel();
        this.initPatchLabel();
        this.initPatchDropDown();
        this.m_oPatchTypeDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FilterCriteriaPanel.this.populatePatchStateDropDown();
            }
        });
        this.initPatchIdRadioButton();
        this.initIdButtonGroup();
    }

    private void initPatchLabel() {
        this.m_oPatchTypeLabel = new JLabel(this.oResManager.getResString("PATCH_STATE_TYPE"));
        this.m_oPatchStateLabel = new JLabel(this.oResManager.getResString("PATCH_STATE_LABEL"));
        if (this.m_oBoardTreePanel != null) {
            this.m_oPatchStateLabel.setBounds(231, 45, 80, 20);
            this.m_oPatchTypeLabel.setBounds(231, 12, 80, 20);
        } else {
            this.m_oPatchStateLabel.setBounds(21, 45, 80, 20);
            this.m_oPatchTypeLabel.setBounds(21, 12, 80, 20);
        }
    }

    private void initPatchDropDown() {
        this.initPatchTypeDropDownModel();
        this.m_oPatchTypeDropDown = new ComboBoxWithToolTip((ComboBoxModel)this.m_oPatchTypeDropDownModel);
        this.m_oPatchTypeDropDown.setName("PatchManagement_FilterCriteriaPanel_m_oPatchTypeDropDown");
        if (this.m_oBoardTreePanel != null) {
            this.m_oPatchTypeDropDown.setBounds(306, 12, 150, 21);
        } else {
            this.m_oPatchTypeDropDown.setBounds(96, 12, 150, 21);
        }
        this.m_oPatchTypeDropDown.setFocusable(false);
        this.m_oPatchStateDropDownModel = new DefaultComboBoxModel();
        this.m_oPatchStateDropDownModel.removeAllElements();
        this.m_oPatchStateDropDown = new ComboBoxWithToolTip();
        this.m_oPatchStateDropDown.setName("PatchManagement_FilterCriteriaPanel_m_oPatchStateDropDown");
        this.m_oPatchStateDropDown.setModel(this.m_oPatchStateDropDownModel);
        this.populatePatchStateDropDown();
        if (this.m_oBoardTreePanel != null) {
            this.m_oPatchStateDropDown.setBounds(306, 45, 150, 21);
        } else {
            this.m_oPatchStateDropDown.setBounds(96, 45, 150, 21);
        }
        this.m_oPatchStateDropDown.setFocusable(false);
    }

    private void initPatchTypeDropDownModel() {
        this.m_oPatchTypeDropDownModel = new DefaultComboBoxModel();
        IPatchConfig oPatchConfig = this.getPatchConfig();
        List oPatchTypeList = oPatchConfig.getPatchTypeList();
        if (null == oPatchTypeList || 0 == oPatchTypeList.size()) {
            return;
        }
        CodeValue oCodeValue = null;
        String strValue = null;
        int iPatchTypeListSize = oPatchTypeList.size();
        strValue = this.oResManager.getResString("PATCH_FILTER_OPTION_ALL");
        oCodeValue = new CodeValue(-1, strValue);
        this.m_oPatchTypeDropDownModel.addElement(oCodeValue);
        for (int index = 0; index < iPatchTypeListSize; ++index) {
            int iPatchType = (Integer)oPatchTypeList.get(index);
            if (iPatchType == 0) {
                strValue = this.oResManager.getResString("PATCH_TYPE_" + iPatchType);
                oCodeValue = new CodeValue(iPatchType, strValue);
                this.m_oPatchTypeDropDownModel.addElement(oCodeValue);
                strValue = this.oResManager.getResString("PATCH_TYPE_1");
                oCodeValue = new CodeValue(1, strValue);
                this.m_oPatchTypeDropDownModel.addElement(oCodeValue);
                continue;
            }
            if (iPatchType != 2) continue;
            strValue = this.oResManager.getResString("PATCH_TYPE_" + iPatchType);
            oCodeValue = new CodeValue(iPatchType, strValue);
            this.m_oPatchTypeDropDownModel.addElement(oCodeValue);
            strValue = this.oResManager.getResString("PATCH_TYPE_3");
            oCodeValue = new CodeValue(3, strValue);
            this.m_oPatchTypeDropDownModel.addElement(oCodeValue);
        }
    }

    protected IPatchConfig getPatchConfig() {
        return this.m_oDevTypeConfigModel.getPatchConfiguration();
    }

    protected void populatePatchStateDropDown() {
        this.m_oPatchStateDropDownModel.removeAllElements();
        CodeValue oCodeValue = (CodeValue)this.m_oPatchTypeDropDown.getSelectedItem();
        int iCode = oCodeValue.getCode();
        switch (iCode) {
            case 0: 
            case 1: {
                this.populateHotPatchStateDropDownForList();
                break;
            }
            case 2: 
            case 3: {
                this.populatePatchColdStateDropDownForList();
                break;
            }
            case -1: {
                this.populatePatchAllStateDropDownForList();
                break;
            }
            default: {
                return;
            }
        }
    }

    private void populatePatchAllStateDropDownForList() {
        CodeValue oCodeValue = null;
        String strValue = this.oResManager.getResString("PATCH_FILTER_OPTION_ALL");
        oCodeValue = new CodeValue(-1, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
        strValue = this.oResManager.getResString("PATCH_TYPE_STATE_1");
        oCodeValue = new CodeValue(1, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
        strValue = this.oResManager.getResString("PATCH_TYPE_STATE_2");
        oCodeValue = new CodeValue(2, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
        strValue = this.oResManager.getResString("PATCH_TYPE_STATE_4");
        oCodeValue = new CodeValue(4, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
        strValue = this.oResManager.getResString("PATCH_TYPE_STATE_3");
        oCodeValue = new CodeValue(3, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
        strValue = this.oResManager.getResString("PATCH_TYPE_STATE_5");
        oCodeValue = new CodeValue(5, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
        strValue = this.oResManager.getResString("PATCH_TYPE_STATE_6");
        oCodeValue = new CodeValue(6, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
    }

    private void populatePatchColdStateDropDownForList() {
        CodeValue oCodeValue = null;
        String strValue = this.oResManager.getResString("PATCH_FILTER_OPTION_ALL");
        oCodeValue = new CodeValue(-1, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
        strValue = this.oResManager.getResString("PATCH_TYPE_STATE_1");
        oCodeValue = new CodeValue(1, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
        strValue = this.oResManager.getResString("PATCH_TYPE_STATE_2");
        oCodeValue = new CodeValue(2, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
        strValue = this.oResManager.getResString("PATCH_TYPE_STATE_4");
        oCodeValue = new CodeValue(4, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
        strValue = this.oResManager.getResString("PATCH_TYPE_STATE_3");
        oCodeValue = new CodeValue(3, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
        strValue = this.oResManager.getResString("PATCH_TYPE_STATE_5");
        oCodeValue = new CodeValue(5, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
        strValue = this.oResManager.getResString("PATCH_TYPE_STATE_6");
        oCodeValue = new CodeValue(6, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
    }

    private void populateHotPatchStateDropDownForList() {
        CodeValue oCodeValue = null;
        String strValue = this.oResManager.getResString("PATCH_FILTER_OPTION_ALL");
        oCodeValue = new CodeValue(-1, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
        strValue = this.oResManager.getResString("PATCH_TYPE_STATE_1");
        oCodeValue = new CodeValue(1, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
        strValue = this.oResManager.getResString("PATCH_TYPE_STATE_2");
        oCodeValue = new CodeValue(2, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
        strValue = this.oResManager.getResString("PATCH_TYPE_STATE_3");
        oCodeValue = new CodeValue(3, strValue);
        this.m_oPatchStateDropDownModel.addElement(oCodeValue);
    }

    private void initPatchIdRadioButton() {
        this.initializePatchIdRadioBtns();
        this.alignPatchIdRadioBtns();
        this.setMnemonicsForRadioBtns();
        this.setFocusableStatus();
        this.m_oAllIdRadioBtn.setSelected(true);
    }

    private void setFocusableStatus() {
        this.m_oMaxPatchIdRadioBtn.setFocusable(false);
        this.m_oMinPatchIdRadioBtn.setFocusable(false);
        this.m_oAllIdRadioBtn.setFocusable(false);
    }

    private void setMnemonicsForRadioBtns() {
        this.m_oMaxPatchIdRadioBtn.setMnemonic('m');
        this.m_oMinPatchIdRadioBtn.setMnemonic('i');
        this.m_oAllIdRadioBtn.setMnemonic('a');
    }

    private void alignPatchIdRadioBtns() {
        if (this.m_oBoardTreePanel != null) {
            this.m_oMaxPatchIdRadioBtn.setBounds(231, 78, 150, 20);
            this.m_oMinPatchIdRadioBtn.setBounds(231, 110, 150, 20);
            this.m_oAllIdRadioBtn.setBounds(231, 142, 150, 20);
        } else {
            this.m_oMaxPatchIdRadioBtn.setBounds(21, 78, 150, 20);
            this.m_oMinPatchIdRadioBtn.setBounds(21, 110, 150, 20);
            this.m_oAllIdRadioBtn.setBounds(21, 142, 150, 20);
        }
    }

    private void initializePatchIdRadioBtns() {
        this.m_oMaxPatchIdRadioBtn = new JRadioButton(this.oResManager.getResString("MAXIMUM_PATCH_ID"));
        this.m_oMaxPatchIdRadioBtn.setName("PatchManagement_FilterCriteriaPanel_m_oMaxPatchIdRadioBtn");
        this.m_oMinPatchIdRadioBtn = new JRadioButton(this.oResManager.getResString("MINIMUM_PATCH_ID"));
        this.m_oMinPatchIdRadioBtn.setName("PatchManagement_FilterCriteriaPanel_m_oMinPatchIdRadioBtn");
        this.m_oAllIdRadioBtn = new JRadioButton(this.oResManager.getResString("ALL_ID"));
        this.m_oAllIdRadioBtn.setName("PatchManagement_FilterCriteriaPanel_m_oAllIdRadioBtn");
    }

    private void initIdButtonGroup() {
        this.m_oIdBtnGroup = new ButtonGroup();
        this.m_oIdBtnGroup.add(this.m_oAllIdRadioBtn);
        this.m_oIdBtnGroup.add(this.m_oMaxPatchIdRadioBtn);
        this.m_oIdBtnGroup.add(this.m_oMinPatchIdRadioBtn);
    }

    private void initPanel() {
        this.setLayout(null);
        this.setBounds(12, 12, 470, 277);
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    private void addComponents() {
        if (this.m_oBoardTreePanel != null) {
            this.add(this.m_oBoardTreePanel);
        } else {
            this.resize(this.getWidth() / 2 + 30, this.getHeight() / 2 + 35);
        }
        this.add(this.m_oPatchTypeLabel);
        this.add(this.m_oPatchTypeDropDown);
        this.add(this.m_oPatchStateLabel);
        this.add(this.m_oPatchStateDropDown);
        this.add(this.m_oMaxPatchIdRadioBtn);
        this.add(this.m_oMinPatchIdRadioBtn);
        this.add(this.m_oAllIdRadioBtn);
    }

    private void initBoardTreePanel() {
        this.m_oBoardTreePanel = new BoardTreePanel();
        if (this.m_oBoardTreePanel.getPatchTree().getRowCount() > 1) {
            JLabel oTreeTitleLabel = new JLabel(ResourceManager.getInstance().getResString("BOARD_TREE"));
            oTreeTitleLabel.setBounds(12, 2, 90, 20);
            this.add(oTreeTitleLabel);
            this.m_oBoardTreePanel.setBounds(10, 20, 210, 247);
        } else {
            this.m_oBoardTreePanel = null;
        }
    }

    public PatchFilterCriteria getFilterCriteria() {
        PatchFilterCriteria oCriteria = new PatchFilterCriteria();
        CodeValue oCodeValue = (CodeValue)this.m_oPatchTypeDropDown.getSelectedItem();
        int iType = oCodeValue.getCode();
        oCriteria.setType(iType);
        oCodeValue = (CodeValue)this.m_oPatchStateDropDown.getSelectedItem();
        int iState = oCodeValue.getCode();
        oCriteria.setState(iState);
        int iRadioBtnId = this.getSelectedRadioBtnId();
        oCriteria.setPatchIDCriteria(iRadioBtnId);
        List oBoardNodeInfoList = new ArrayList();
        if (this.m_oBoardTreePanel != null && (null == (oBoardNodeInfoList = this.m_oBoardTreePanel.getSelectedBoardNodeInfo()) || 0 == oBoardNodeInfoList.size())) {
            DCOptionPane.showMessageDialog((Component)this, this.oResManager.getResString("NO_BOARD_TYPE_SELECTED"), this.oResManager.getResString("SYSTEM_INFO_ERROR"), 0);
            return null;
        }
        oCriteria.setBoardTypes(oBoardNodeInfoList);
        return oCriteria;
    }

    private int getSelectedRadioBtnId() {
        ButtonModel oBtnModel = this.m_oIdBtnGroup.getSelection();
        if (oBtnModel == this.m_oMinPatchIdRadioBtn.getModel()) {
            return 1;
        }
        if (oBtnModel == this.m_oMaxPatchIdRadioBtn.getModel()) {
            return 0;
        }
        return -1;
    }

    public BoardTreePanel getBoardTreePanel() {
        return this.m_oBoardTreePanel;
    }
}

