/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.patchmanagement.view.filterpatch;

import com.huawei.dc.common.components.tree.editor.DCSelectableTreeEditor;
import com.huawei.dc.common.components.tree.renderer.DCSelectableTreeRenderer;
import com.huawei.dc.common.tree.BoardNodeInfo;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.controller.BoardTypeManager;
import com.huawei.dc.devicemanagement.controller.IBoardTypeManager;
import com.huawei.dc.devicemanagement.patchmanagement.model.PatchDataModel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BoardTreePanel
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private DeviceTypeInfo m_oDeviceTypeInfo;
    private JTree m_oPatchTree;
    private DefaultMutableTreeNode m_oRoot;
    private IBoardTypeManager m_oBoardTypeManager;

    public BoardTreePanel() {
        this.initPanel();
        this.initDeviceType();
        this.initBoardTypeManager();
        this.initPatchTree();
    }

    private void initBoardTypeManager() {
        this.m_oBoardTypeManager = BoardTypeManager.getInstance();
    }

    private void initPanel() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setFocusable(true);
    }

    private void initDeviceType() {
        this.m_oDeviceTypeInfo = PatchDataModel.getInstance().getDeviceType();
    }

    private void initPatchTree() {
        this.m_oPatchTree = new JTree();
        this.m_oPatchTree.setName("PatchManagement_BoardTreePanel_m_oPatchTree");
        this.setTreeRoot();
        this.populatePatchTree();
        this.expandPathOfTree();
        this.m_oPatchTree.setEditable(true);
        this.m_oPatchTree.setCellEditor(new DCSelectableTreeEditor(this.m_oPatchTree));
        this.m_oPatchTree.setCellRenderer(new DCSelectableTreeRenderer(this.m_oPatchTree));
        this.getViewport().add(this.m_oPatchTree);
    }

    private void expandPathOfTree() {
        TreePath oTreePath;
        if (null != this.m_oPatchTree && !this.m_oPatchTree.isExpanded(oTreePath = this.m_oPatchTree.getPathForRow(0))) {
            this.m_oPatchTree.expandPath(oTreePath);
        }
    }

    private void populatePatchTree() {
        List oBoardNodeInfoList = this.getBoardNodeInfoList();
        if (null == oBoardNodeInfoList || 0 == oBoardNodeInfoList.size()) {
            return;
        }
        DefaultMutableTreeNode oTreeNode = null;
        int iBoardTypeCount = oBoardNodeInfoList.size();
        for (int index = 0; index < iBoardTypeCount; ++index) {
            oTreeNode = new DefaultMutableTreeNode(oBoardNodeInfoList.get(index));
            this.m_oRoot.add(oTreeNode);
        }
    }

    private void setTreeRoot() {
        this.m_oRoot = new DefaultMutableTreeNode(new TreeNodeInfo(this.m_oDeviceTypeInfo));
        DefaultTreeModel oTreeModel = (DefaultTreeModel)this.m_oPatchTree.getModel();
        oTreeModel.setRoot(this.m_oRoot);
        this.m_oPatchTree.setSelectionRow(0);
    }

    private List getBoardNodeInfoList() {
        ArrayList oBoardNodeInfoList = new ArrayList(0);
        Hashtable oBoardTypesTable = this.m_oBoardTypeManager.getBoardTypes(this.m_oDeviceTypeInfo.getDevTypeName(), this.m_oDeviceTypeInfo.getDevTypeVersionName());
        if (null != oBoardTypesTable && oBoardTypesTable.size() > 0) {
            this.createBoardTypeTree(oBoardTypesTable, oBoardNodeInfoList);
        }
        return oBoardNodeInfoList;
    }

    private void createBoardTypeTree(Hashtable oBoardTypesTable, List oBoardNodeInfoList) {
        Set oKeyset = oBoardTypesTable.keySet();
        String[] arrBoardTypes = oKeyset.toArray(new String[0]);
        int noOfBoardTypes = arrBoardTypes.length;
        String strBoardTypeName = null;
        Integer oBoardTypeId = null;
        BoardNodeInfo oNodeInfo = null;
        for (int j = 0; j < noOfBoardTypes; ++j) {
            oBoardTypeId = Integer.valueOf(arrBoardTypes[j]);
            int iBoardTypeCode = oBoardTypeId;
            strBoardTypeName = this.m_oBoardTypeManager.getBoardTypeDescription(this.m_oDeviceTypeInfo.getDevTypeName(), this.m_oDeviceTypeInfo.getDevTypeVersionName(), iBoardTypeCode);
            oNodeInfo = new BoardNodeInfo();
            oNodeInfo.setBoardType(iBoardTypeCode);
            oNodeInfo.setBoardTypeName(strBoardTypeName);
            oNodeInfo.setSelected(true);
            if (oBoardNodeInfoList.contains(oNodeInfo)) continue;
            oBoardNodeInfoList.add(oNodeInfo);
        }
    }

    public List getSelectedBoardTypes() {
        ArrayList<Integer> oBoardTypeList = new ArrayList<Integer>(0);
        Enumeration<TreeNode> oBoardTypeNodes = this.m_oRoot.breadthFirstEnumeration();
        while (oBoardTypeNodes.hasMoreElements()) {
            BoardNodeInfo oNodeInfo;
            DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)oBoardTypeNodes.nextElement();
            if (null == oTreeNode || !(oTreeNode.getUserObject() instanceof BoardNodeInfo) || !(oNodeInfo = (BoardNodeInfo)oTreeNode.getUserObject()).isSelected()) continue;
            oBoardTypeList.add(oNodeInfo.getBoardType());
        }
        return oBoardTypeList;
    }

    public List getSelectedBoardNodeInfo() {
        ArrayList<BoardNodeInfo> oBoardNodeInfoList = new ArrayList<BoardNodeInfo>(0);
        Enumeration<TreeNode> oBoardNodeInfoEnum = this.m_oRoot.breadthFirstEnumeration();
        while (oBoardNodeInfoEnum.hasMoreElements()) {
            BoardNodeInfo oNodeInfo;
            DefaultMutableTreeNode oTreeNode = (DefaultMutableTreeNode)oBoardNodeInfoEnum.nextElement();
            if (null == oTreeNode || !(oTreeNode.getUserObject() instanceof BoardNodeInfo) || !(oNodeInfo = (BoardNodeInfo)oTreeNode.getUserObject()).isSelected()) continue;
            oBoardNodeInfoList.add(oNodeInfo);
        }
        return oBoardNodeInfoList;
    }

    public JTree getPatchTree() {
        return this.m_oPatchTree;
    }
}

