/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.patchmanagement.view;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfo;
import com.huawei.dc.common.asndatacenter.AsnDCDeviceSubmapNtfnInfoLst;
import com.huawei.dc.common.components.devicetreepanel.DeviceTreePanel;
import com.huawei.dc.common.components.dialog.ProgressDlg;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.event.DCDeviceTreeNodeSelectionEventObject;
import com.huawei.dc.common.framework.event.DCEventObject;
import com.huawei.dc.common.framework.interfaces.DCTreeEventListener;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.SubMapNodeInfo;
import com.huawei.dc.common.tree.TreeNodeInfo;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubMapInfo;
import com.huawei.dc.devicemanagement.patchmanagement.controller.IPatchSyncCommController;
import com.huawei.dc.devicemanagement.patchmanagement.controller.PatchSyncCommController;
import com.huawei.dc.devicemanagement.patchmanagement.event.IPatchNotificationListener;
import com.huawei.dc.devicemanagement.patchmanagement.event.PatchEvent;
import com.huawei.dc.devicemanagement.patchmanagement.event.PatchInfoNotifier;
import com.huawei.dc.devicemanagement.patchmanagement.model.GetPatchNotification;
import com.huawei.dc.devicemanagement.patchmanagement.model.IPatch;
import com.huawei.dc.devicemanagement.patchmanagement.model.IPatchDataModel;
import com.huawei.dc.devicemanagement.patchmanagement.model.PatchDataModel;
import com.huawei.dc.devicemanagement.patchmanagement.util.PatchDataModelUtil;
import com.huawei.dc.devicemanagement.patchmanagement.view.filterpatch.PatchFilterBasePanel;
import com.huawei.dc.devicemanagement.patchmanagement.view.patchtable.PatchTablePanel;
import com.huawei.dc.deviceoperation.deviceconfigchange.DeviceConfigEventReceiver;
import com.huawei.dc.deviceoperation.deviceconfigchange.IDeviceConfigChangeListener;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.model.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class PatchManagementPanel
extends JPanel
implements IPatchNotificationListener,
DCTreeEventListener,
IDeviceConfigChangeListener {
    private static final long serialVersionUID = 1L;
    private PatchFilterBasePanel m_oPatchFilterPanel;
    private PatchTablePanel m_oPatchTablePanel;
    private ProgressDlg m_oProgressDlg;
    private IPatchSyncCommController m_oSyncCommController;
    private IPatchDataModel m_oPatchDataModel = PatchDataModel.getInstance();
    private IDeviceInfoManager m_oDeviceInfoManager;

    public PatchManagementPanel(DeviceTreePanel oDeviceTreePanel) {
        this.m_oSyncCommController = PatchSyncCommController.getInstance();
        this.m_oDeviceInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
        this.createPatchTablePanel();
        this.createFilterPanel(oDeviceTreePanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_oPatchFilterPanel, "North");
        this.add((Component)this.m_oPatchTablePanel, "Center");
        this.registerForNotifications();
        this.setHelpKeyValue("HELP_TOPIC_PATCH_MANAGEMENT");
    }

    private void createFilterPanel(DeviceTreePanel oDeviceTreePanel) {
        this.m_oPatchFilterPanel = new PatchFilterBasePanel(this.m_oPatchTablePanel, oDeviceTreePanel);
    }

    private void createPatchTablePanel() {
        this.m_oPatchTablePanel = new PatchTablePanel();
    }

    private void registerForNotifications() {
        DeviceConfigEventReceiver.getInstance().resigterForConfigChangeEvent(this);
        PatchInfoNotifier.getInstance().addPatchNotificationListener(this);
    }

    public void unregisterForNotifications() {
        DeviceConfigEventReceiver.getInstance().unResigterForConfigChangeEvent(this);
        PatchInfoNotifier.getInstance().removePatchNotificationListener(this);
    }

    public void getPatchesForSelectedDevices(int[] iSelectedDevIds) {
        this.m_oPatchDataModel.clearPatches();
        this.m_oPatchTablePanel.clearTableData();
        this.refreshPanel();
        if (null == iSelectedDevIds || 0 == iSelectedDevIds.length) {
            return;
        }
        int[] arrSelectedDeviceIDs = new int[iSelectedDevIds.length];
        DeviceInfo[] arrSelectedDevices = new DeviceInfo[iSelectedDevIds.length];
        for (int i = 0; i < iSelectedDevIds.length; ++i) {
            arrSelectedDevices[i] = DeviceInfoManagerImpl.getInstance().getDevice(iSelectedDevIds[i]);
            arrSelectedDeviceIDs[i] = arrSelectedDevices[i].getDevId();
        }
        if (0 < arrSelectedDevices.length) {
            this.m_oPatchFilterPanel.updateSelectedDevType(arrSelectedDevices[0].getDeviceTypeInfo());
        }
        try {
            int iReqId = DCFrameWorkUtil.generateRequestId();
            this.initializeProgressDialog(arrSelectedDeviceIDs, iReqId);
            this.m_oSyncCommController.getPatches(iReqId, arrSelectedDevices);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PatchManagementPanel.this.m_oProgressDlg.setVisible(true);
                }
            });
        }
        catch (DCException oServerError) {
            if (null != this.m_oProgressDlg) {
                this.m_oProgressDlg.dispose();
            }
            DCDebugTracer.trace("get patch error");
            DCDebugTracer.trace(oServerError);
            return;
        }
    }

    public void initializeProgressDialog(int[] iArrdeviceIds, int iRequestID) {
        String[] columnNames = new String[]{ResourceManager.getInstance().getResString("RESOURCE_NAME"), ResourceManager.getInstance().getResString("OPERATE_RESULT"), ResourceManager.getInstance().getResString("ERROR_INFO")};
        this.m_oProgressDlg = new ProgressDlg(43834, iArrdeviceIds, columnNames){

            @Override
            protected void closeDialog() {
                PatchManagementPanel.this.setHelpKeyValue("HELP_TOPIC_PATCH_MANAGEMENT");
                super.closeDialog();
            }
        };
        this.m_oProgressDlg.setTitle(ResourceManager.getInstance().getResString("GET_PATCH_PROGRESS_TITLE"));
        this.m_oProgressDlg.setDefaultCloseOperation(2);
        this.m_oProgressDlg.setProgressDlgId(iRequestID);
        this.m_oProgressDlg.customizeTableForTelnetError();
        DCHelpManager.getInstance().enableF1HelpKey(this.m_oProgressDlg.getContentPane(), "HELP_TOPIC_PATCH_GET");
    }

    @Override
    public void onPatchNotification(PatchEvent oEvent) {
        if (null == oEvent || null == oEvent.getSource()) {
            return;
        }
        DCDebugTracer.trace("receive notification eventType=" + oEvent.getPatchEventType());
        switch (oEvent.getPatchEventType()) {
            case 0: {
                GetPatchNotification oPatchNtfn = (GetPatchNotification)oEvent.getSource();
                this.updateGetPatchProgress(oPatchNtfn);
                break;
            }
            case 2: {
                this.m_oPatchTablePanel.deletePatches((List)oEvent.getSource());
                this.refreshPanel();
                break;
            }
            case 3: {
                IPatch patchInfo = (IPatch)oEvent.getSource();
                this.m_oPatchTablePanel.refreshPathes(patchInfo);
                this.refreshPanel();
                break;
            }
        }
    }

    private void updateGetPatchProgress(GetPatchNotification oPatchNtfn) {
        if (!oPatchNtfn.isFinal()) {
            int iErrorCode = oPatchNtfn.getErrorCode();
            int iDeviceID = oPatchNtfn.getDeviceID();
            String strErrorMessage = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode));
            StringBuffer strDisplayName = new StringBuffer(0);
            strErrorMessage = this.appendInformationOnDisplayName(strErrorMessage, iDeviceID, strDisplayName);
            DCDebugTracer.trace("progressDlgID = " + this.m_oProgressDlg.getProgressDlgId());
            if (this.m_oProgressDlg.getProgressDlgId() == oPatchNtfn.getRequestID()) {
                this.m_oProgressDlg.setProgress(strDisplayName.toString(), strErrorMessage, oPatchNtfn.getNtfnProgress(), iDeviceID, oPatchNtfn.getErrorInfo());
            }
            if (0 == oPatchNtfn.getErrorCode()) {
                this.getPatchesAndAddToTable(oPatchNtfn);
            }
        }
        if (0 == this.m_oPatchTablePanel.getPatchInfoTable().getRowCount()) {
            this.m_oPatchFilterPanel.enableComponents(false);
        } else {
            this.m_oPatchFilterPanel.enableComponents(true);
        }
    }

    private String appendInformationOnDisplayName(String strErrorMessage, int iDeviceID, StringBuffer strDisplayName) {
        DeviceInfo oDeviceInfo = this.m_oDeviceInfoManager.getDevice(iDeviceID);
        if (null != oDeviceInfo) {
            strDisplayName.append(oDeviceInfo.getDevName());
            strDisplayName.append('(');
            strDisplayName.append(oDeviceInfo.getDevIPAddress());
            strDisplayName.append(')');
        } else {
            strDisplayName.append(ResourceManager.getInstance().getResString("TABLE_DEVICEID"));
            strDisplayName.append(':');
            strDisplayName.append(iDeviceID);
            strErrorMessage = ResourceManager.getInstance().getResString("DEVICE_DELETED");
        }
        return strErrorMessage;
    }

    private void getPatchesAndAddToTable(GetPatchNotification oPatchNtfn) {
        List oPatchList = this.m_oPatchDataModel.getPatchesForDevice(oPatchNtfn.getDeviceID());
        if (null == oPatchList || 0 == oPatchList.size()) {
            DCDebugTracer.trace("patch list is null");
            return;
        }
        int iPatchCount = oPatchList.size();
        for (int i = 0; i < iPatchCount; ++i) {
            IPatch oPatch = (IPatch)oPatchList.get(i);
            this.m_oPatchTablePanel.addPatchToTable(oPatch);
        }
    }

    @Override
    public void onTreeInit(DCEventObject oEventObject) {
    }

    @Override
    public void onTreeNodeSelection(DCEventObject oEventObject) {
        if (null == oEventObject || !(oEventObject instanceof DCDeviceTreeNodeSelectionEventObject) || !(oEventObject.getSource() instanceof TreeNodeInfo)) {
            return;
        }
        this.refreshTableForDeviceTreeEvent((TreeNodeInfo)oEventObject.getSource());
    }

    private void refreshTableForDeviceTreeEvent(TreeNodeInfo oTreeNodeInfo) {
        Resource oResource;
        List oPatchesToBeDisplayed = new ArrayList(0);
        if (3 == oTreeNodeInfo.m_iNodeType) {
            oPatchesToBeDisplayed = this.m_oPatchDataModel.getAllPatches();
        } else if (1 == oTreeNodeInfo.m_iNodeType) {
            DeviceTypeInfo oDeviceType = this.m_oPatchDataModel.getDeviceType();
            if (null != oDeviceType && oDeviceType.equals(oTreeNodeInfo.m_oDevType)) {
                oPatchesToBeDisplayed = this.m_oPatchDataModel.getAllPatches();
            }
        } else if (2 == oTreeNodeInfo.m_iNodeType) {
            oPatchesToBeDisplayed = PatchDataModelUtil.filterPatchesForDeviceVersion(oTreeNodeInfo.getDeviceTypeInfo(), oTreeNodeInfo.getVersion());
        } else if (0 == oTreeNodeInfo.m_iNodeType) {
            SubMapNodeInfo oSubMapNodeInfo = oTreeNodeInfo.m_oSubMapNodeInfo;
            oPatchesToBeDisplayed = this.getPatchListForSubmap(oSubMapNodeInfo.m_submapId);
        }
        this.m_oPatchTablePanel.clearTableData();
        int iPatchCount = oPatchesToBeDisplayed.size();
        for (int i = 0; i < iPatchCount; ++i) {
            IPatch oPatch = (IPatch)oPatchesToBeDisplayed.get(i);
            this.m_oPatchTablePanel.addPatchToTable(oPatch);
        }
        this.m_oPatchTablePanel.refreshTable();
        DeviceTypeInfo oDeviceTypeInfo = oTreeNodeInfo.getDeviceTypeInfo();
        if (null == oDeviceTypeInfo && !oPatchesToBeDisplayed.isEmpty() && null != (oResource = this.m_oPatchTablePanel.getPatchAtRow(this.m_oPatchTablePanel.getPatchInfoTable().getSelectedRow()).getResource())) {
            DeviceInfo oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(oResource.getDeviceID());
            if (oDeviceInfo != null) {
                oDeviceTypeInfo = oDeviceInfo.getDeviceTypeInfo();
            } else {
                this.m_oPatchTablePanel.clearTableData();
                DCFrameWorkUtil.updateUI(this.m_oPatchTablePanel);
            }
        }
        this.m_oPatchFilterPanel.updateSelectedDevType(oDeviceTypeInfo);
    }

    private List getPatchListForSubmap(String strSubmapId) {
        ArrayList oPatchList = new ArrayList(0);
        SubMapInfo oSubMapInfo = this.m_oDeviceInfoManager.getSubmapForID(strSubmapId);
        DeviceInfo[] arrDevices = this.m_oDeviceInfoManager.getDevicesRecursivelyInSubMap(oSubMapInfo);
        if (null == arrDevices || 0 == arrDevices.length) {
            return oPatchList;
        }
        for (int i = 0; i < arrDevices.length; ++i) {
            List oPatchesForDevice;
            if (null == arrDevices[i] || null == (oPatchesForDevice = this.m_oPatchDataModel.getPatchesForDevice(arrDevices[i].getDevId())) || 0 == oPatchesForDevice.size()) continue;
            oPatchList.addAll(oPatchesForDevice);
        }
        return oPatchList;
    }

    private void handleDeviceDeleteNotification(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        if (null == oDeviceInfoList || 0 == oDeviceInfoList.size()) {
            return;
        }
        ArrayList oPatchList = new ArrayList(0);
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        int iDeviceCount = oDeviceInfoList.size();
        for (int i = 0; i < iDeviceCount; ++i) {
            List oPatchesForDevice;
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            if (null == oAsnDeviceInfo.oDeviceInfo || null == (oPatchesForDevice = this.m_oPatchDataModel.getPatchesForDevice(oAsnDeviceInfo.oDeviceInfo.iDevId.intValue()))) continue;
            oPatchList.addAll(oPatchesForDevice);
            this.m_oPatchDataModel.removePatchesForDevice(oAsnDeviceInfo.oDeviceInfo.iDevId.intValue());
        }
        this.m_oPatchTablePanel.deletePatches(oPatchList);
        this.refreshPanel();
    }

    private void handleDeviceModifyNotification(AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        if (null == oDeviceInfoList || 0 == oDeviceInfoList.size()) {
            return;
        }
        List oResourceList = this.m_oPatchDataModel.getSelectedResources();
        int iResourceCountFromModel = oResourceList.size();
        AsnDCDeviceSubmapNtfnInfo oAsnDeviceInfo = null;
        int iDeviceCount = oDeviceInfoList.size();
        String strDeviceName = null;
        String strDeviceIP = null;
        int iRoleType = -1;
        for (int i = 0; i < iDeviceCount; ++i) {
            oAsnDeviceInfo = (AsnDCDeviceSubmapNtfnInfo)oDeviceInfoList.get(i);
            for (int j = 0; j < iResourceCountFromModel; ++j) {
                Resource oResource = (Resource)oResourceList.get(j);
                if (oAsnDeviceInfo.oDeviceInfo.iDevId.intValue() != oResource.getDeviceID()) continue;
                if (null != oAsnDeviceInfo.oDeviceInfo.strDevName) {
                    strDeviceName = new String(oAsnDeviceInfo.oDeviceInfo.strDevName);
                    oResource.setDeviceName(strDeviceName);
                }
                if (null != oAsnDeviceInfo.oDeviceInfo.strDevIPAddress) {
                    strDeviceIP = new String(oAsnDeviceInfo.oDeviceInfo.strDevIPAddress);
                    oResource.setDeviceIP(strDeviceIP);
                }
                if (null == oAsnDeviceInfo.oDeviceInfo.enRoleType) continue;
                iRoleType = oAsnDeviceInfo.oDeviceInfo.enRoleType.value;
                oResource.setRoleType(iRoleType);
            }
        }
    }

    public void refreshPanel() {
        if (0 >= this.m_oPatchDataModel.getSelectedResources().size()) {
            this.m_oPatchFilterPanel.enableComponents(false);
        } else {
            this.m_oPatchFilterPanel.enableComponents(true);
        }
        this.m_oPatchFilterPanel.updateUI();
        this.m_oPatchTablePanel.refreshTable();
    }

    public void cleanUp() {
        this.m_oDeviceInfoManager = null;
        this.m_oPatchDataModel = null;
        this.m_oProgressDlg = null;
        ((DCObjectDestructor)DCObjectDestructor.getInstance()).removeObjectForDestructor((PatchSyncCommController)this.m_oSyncCommController);
        ((PatchSyncCommController)this.m_oSyncCommController).setToNULL();
        this.m_oSyncCommController = null;
        ((DCObjectDestructor)DCObjectDestructor.getInstance()).removeObjectForDestructor((PatchInfoNotifier)PatchInfoNotifier.getInstance());
        ((PatchInfoNotifier)PatchInfoNotifier.getInstance()).setToNULL();
        this.m_oPatchTablePanel.clearTableData();
        this.m_oPatchTablePanel.cleanUp();
        this.m_oPatchTablePanel = null;
        this.m_oPatchFilterPanel.cleanUp();
        this.m_oPatchFilterPanel = null;
    }

    public void setHelpKeyValue(String resString) {
        this.m_oPatchFilterPanel.requestFocusInWindow();
        this.m_oPatchFilterPanel.grabFocus();
        this.m_oPatchFilterPanel.requestFocus();
        DCHelpManager.getInstance().enableF1HelpKey(this, resString);
    }

    @Override
    public void handleDeviceConfigNotification(int iEventType, AsnDCDeviceSubmapNtfnInfoLst oDeviceInfoList) {
        switch (iEventType) {
            case 1: {
                this.handleDeviceDeleteNotification(oDeviceInfoList);
                break;
            }
            case 2: {
                this.handleDeviceModifyNotification(oDeviceInfoList);
                break;
            }
        }
    }
}

