/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.patchmanagement.util;

import com.huawei.dc.common.tree.BoardNodeInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.patchmanagement.model.IPatch;
import com.huawei.dc.devicemanagement.patchmanagement.model.IPatchDataModel;
import com.huawei.dc.devicemanagement.patchmanagement.model.PatchDataModel;
import com.huawei.dc.devicemanagement.patchmanagement.model.PatchFilterCriteria;
import com.huawei.dc.taskmgmt.model.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PatchDataModelUtil {
    public static List filterPatchesForCriteria(PatchFilterCriteria oFilterCriteria) {
        List oCurrentPatches = PatchDataModel.getInstance().getAllPatches();
        List oPatchList = PatchDataModelUtil.createTempLst(oCurrentPatches);
        PatchDataModelUtil.checkForBoardCriteria(oPatchList, oFilterCriteria);
        PatchDataModelUtil.checkForPatchTypeCriteria(oPatchList, oFilterCriteria);
        PatchDataModelUtil.checkForPatchStatusCriteria(oPatchList, oFilterCriteria);
        PatchDataModelUtil.checkForPatchIdCriteria(oPatchList, oFilterCriteria);
        return oPatchList;
    }

    private static void checkForPatchIdCriteria(List oPatchList, PatchFilterCriteria oFilterCriteria) {
        if (-1 == oFilterCriteria.getPatchIDCriteria()) {
            return;
        }
        if (0 == oFilterCriteria.getPatchIDCriteria()) {
            PatchDataModelUtil.filterPatchWithMaxId(oPatchList);
        } else if (1 == oFilterCriteria.getPatchIDCriteria()) {
            PatchDataModelUtil.filterPatchWithMinId(oPatchList);
        }
    }

    private static void filterPatchWithMinId(List oPatchList) {
        int iSizeOfLst = oPatchList.size();
        if (0 == iSizeOfLst) {
            return;
        }
        IPatch oPatch = (IPatch)oPatchList.get(0);
        int iMinId = oPatch.getPatchId();
        ArrayList<IPatch> oTempPatchLst = new ArrayList<IPatch>(0);
        for (int i = 0; i < iSizeOfLst; ++i) {
            oPatch = (IPatch)oPatchList.get(i);
            if (iMinId > oPatch.getPatchId()) {
                iMinId = oPatch.getPatchId();
                oTempPatchLst.clear();
                oTempPatchLst.add(oPatch);
                continue;
            }
            if (iMinId != oPatch.getPatchId()) continue;
            oTempPatchLst.add(oPatch);
        }
        oPatchList.retainAll(oTempPatchLst);
    }

    private static void filterPatchWithMaxId(List oPatchList) {
        int iSizeOfLst = oPatchList.size();
        int iMaxId = -1;
        IPatch oPatch = null;
        ArrayList<IPatch> oTempPatchLst = new ArrayList<IPatch>(0);
        for (int i = 0; i < iSizeOfLst; ++i) {
            oPatch = (IPatch)oPatchList.get(i);
            if (iMaxId < oPatch.getPatchId()) {
                iMaxId = oPatch.getPatchId();
                oTempPatchLst.clear();
                oTempPatchLst.add(oPatch);
                continue;
            }
            if (iMaxId != oPatch.getPatchId()) continue;
            oTempPatchLst.add(oPatch);
        }
        oPatchList.retainAll(oTempPatchLst);
    }

    private static void checkForPatchStatusCriteria(List oPatchList, PatchFilterCriteria oFilterCriteria) {
        int iState = oFilterCriteria.getState();
        if (-1 == iState) {
            return;
        }
        int iSizeOfLst = oPatchList.size();
        IPatch oPatch = null;
        for (int i = iSizeOfLst - 1; i >= 0; --i) {
            oPatch = (IPatch)oPatchList.get(i);
            if (oPatch.getPatchState() == iState) continue;
            oPatchList.remove(i);
        }
    }

    private static void checkForPatchTypeCriteria(List oPatchList, PatchFilterCriteria oFilterCriteria) {
        int iPatchType = oFilterCriteria.getType();
        if (-1 == iPatchType) {
            return;
        }
        int iSizeOfLst = oPatchList.size();
        IPatch oPatch = null;
        for (int i = iSizeOfLst - 1; i >= 0; --i) {
            oPatch = (IPatch)oPatchList.get(i);
            if (oPatch.getType() == iPatchType) continue;
            oPatchList.remove(i);
        }
    }

    private static void checkForBoardCriteria(List oPatchList, PatchFilterCriteria oFilterCriteria) {
        List oBoardTypeList = oFilterCriteria.getBoardTypes();
        int iSizeOfBoardLst = oBoardTypeList.size();
        int iSizeOfPatchLst = oPatchList.size();
        boolean bIsPatchOfSelectedBoardType = false;
        IPatch oPatch = null;
        for (int i = iSizeOfPatchLst - 1; i >= 0; --i) {
            oPatch = (IPatch)oPatchList.get(i);
            bIsPatchOfSelectedBoardType = false;
            if (0 == iSizeOfBoardLst) {
                bIsPatchOfSelectedBoardType = true;
            } else {
                for (int j = 0; j < iSizeOfBoardLst; ++j) {
                    BoardNodeInfo oNodeInfo = (BoardNodeInfo)oBoardTypeList.get(j);
                    int iBordType = oNodeInfo.getBoardType();
                    if (iBordType != oPatch.getResource().getBoardType()) continue;
                    bIsPatchOfSelectedBoardType = true;
                    break;
                }
            }
            if (bIsPatchOfSelectedBoardType) continue;
            oPatchList.remove(i);
        }
    }

    private static List createTempLst(List oCurrentPatchesLst) {
        ArrayList<IPatch> oTempPatchList = new ArrayList<IPatch>(2);
        int iSizeLst = oCurrentPatchesLst.size();
        IPatch oPatch = null;
        for (int i = 0; i < iSizeLst; ++i) {
            oPatch = (IPatch)oCurrentPatchesLst.get(i);
            oTempPatchList.add(oPatch);
        }
        return oTempPatchList;
    }

    public static List filterPatchesForDeviceVersion(DeviceTypeInfo oTypeInfo, String strVersion) {
        ArrayList oPatches = new ArrayList(0);
        IPatchDataModel oDataModel = PatchDataModel.getInstance();
        DeviceTypeInfo oTypeFromModel = oDataModel.getDeviceType();
        if (null == oTypeFromModel || null == strVersion || !oTypeFromModel.equals(oTypeInfo)) {
            return oPatches;
        }
        List oCurrentResources = oDataModel.getSelectedResources();
        if (null == oCurrentResources || 0 == oCurrentResources.size()) {
            return oPatches;
        }
        int iResourceCount = oCurrentResources.size();
        Resource oResource = null;
        for (int i = 0; i < iResourceCount; ++i) {
            oResource = (Resource)oCurrentResources.get(i);
            if (null == oResource || !strVersion.equals(oResource.getDeviceVersion())) continue;
            oPatches.addAll(oDataModel.getPatchesForResource(oResource));
        }
        return oPatches;
    }

    public static List getAllPatchTypesFromModel() {
        ArrayList<Integer> oPatchTypeList = new ArrayList<Integer>(0);
        List oPatchList = PatchDataModel.getInstance().getAllPatches();
        if (null == oPatchList || 0 == oPatchList.size()) {
            return oPatchTypeList;
        }
        int iPatchCount = oPatchList.size();
        Integer oPatchType = null;
        for (int i = 0; i < iPatchCount; ++i) {
            oPatchType = ((IPatch)oPatchList.get(i)).getType();
            if (oPatchTypeList.contains(oPatchType)) continue;
            oPatchTypeList.add(oPatchType);
        }
        Collections.sort(oPatchTypeList);
        return oPatchTypeList;
    }
}

