/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.patchmanagement.model;

import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.DeviceModelAdapter;
import com.huawei.dc.devicemanagement.patchmanagement.model.IPatch;
import com.huawei.dc.devicemanagement.patchmanagement.model.IPatchDataModel;
import com.huawei.dc.taskmgmt.model.Resource;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PatchDataModel
implements IPatchDataModel,
IDCObjectDeallocator {
    private static PatchDataModel m_oInstance = null;
    private Map m_oPatchMap = new HashMap(0);

    private PatchDataModel() {
    }

    public static synchronized IPatchDataModel getInstance() {
        if (null == m_oInstance) {
            m_oInstance = new PatchDataModel();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oInstance);
        }
        return m_oInstance;
    }

    @Override
    public void addPatch(IPatch oPatch) {
        if (null == oPatch || null == oPatch.getResource()) {
            return;
        }
        Resource oResource = oPatch.getResource();
        ArrayList<IPatch> oPatchList = (ArrayList<IPatch>)this.m_oPatchMap.get(oResource);
        if (null == oPatchList) {
            oPatchList = new ArrayList<IPatch>(1);
            oPatchList.add(oPatch);
            this.m_oPatchMap.put(oResource, oPatchList);
            return;
        }
        if (!oPatchList.contains(oPatch)) {
            oPatchList.add(oPatch);
        }
    }

    @Override
    public IPatch getPatch(Resource oResource, String strPatchName) {
        if (null == oResource || null == strPatchName) {
            return null;
        }
        List oPatchList = (List)this.m_oPatchMap.get(oResource);
        if (null == oPatchList) {
            return null;
        }
        int iPatchCount = oPatchList.size();
        Collator oEquals = Collator.getInstance();
        for (int i = 0; i < iPatchCount; ++i) {
            IPatch oPatch = (IPatch)oPatchList.get(i);
            if (!oEquals.equals(strPatchName, oPatch.getName())) continue;
            return oPatch;
        }
        return null;
    }

    @Override
    public List getAllPatches() {
        ArrayList oAllPatches = new ArrayList(0);
        Iterator oKeyIterator = this.m_oPatchMap.keySet().iterator();
        while (oKeyIterator.hasNext()) {
            List oPatchList = (List)this.m_oPatchMap.get(oKeyIterator.next());
            if (null == oPatchList) continue;
            oAllPatches.addAll(oPatchList);
        }
        return oAllPatches;
    }

    @Override
    public void setToNULL() {
        m_oInstance = null;
        this.m_oPatchMap = null;
    }

    @Override
    public List getPatchesForResource(Resource oResource) {
        return (List)this.m_oPatchMap.get(oResource);
    }

    @Override
    public List getPatchesForDevice(int iDeviceId) {
        ArrayList oPatchListForDevice = new ArrayList(0);
        for (Resource oResource : this.m_oPatchMap.keySet()) {
            List oPatchList;
            if (iDeviceId != oResource.getDeviceID() || null == (oPatchList = (List)this.m_oPatchMap.get(oResource))) continue;
            oPatchListForDevice.addAll(oPatchList);
        }
        return oPatchListForDevice;
    }

    @Override
    public void addPatches(List oPatchList) {
        if (null == oPatchList || 0 == oPatchList.size()) {
            return;
        }
        int iPatchCount = oPatchList.size();
        for (int i = 0; i < iPatchCount; ++i) {
            if (!(oPatchList.get(i) instanceof IPatch)) continue;
            this.addPatch((IPatch)oPatchList.get(i));
        }
    }

    @Override
    public void clearPatches() {
        this.m_oPatchMap.clear();
    }

    @Override
    public List getSelectedResources() {
        return new ArrayList(this.m_oPatchMap.keySet());
    }

    @Override
    public int[] getDeviceIdLst() {
        ArrayList<Integer> oArrayList = new ArrayList<Integer>();
        List oCurrentResources = this.getSelectedResources();
        if (null == oCurrentResources || 0 == oCurrentResources.size()) {
            return null;
        }
        int iResourceCount = oCurrentResources.size();
        Resource oResource = null;
        for (int i = 0; i < iResourceCount; ++i) {
            oResource = (Resource)oCurrentResources.get(i);
            if (null == oResource) continue;
            oArrayList.add(oResource.getDeviceID());
        }
        int[] iDeviceIdlst = new int[oArrayList.size()];
        for (int i = 0; i < oArrayList.size(); ++i) {
            iDeviceIdlst[i] = (Integer)oArrayList.get(i);
        }
        return iDeviceIdlst;
    }

    @Override
    public void removePatch(Resource oResource, String strPatchID) {
        List oPatchesForResource = (List)this.m_oPatchMap.get(oResource);
        if (null == oPatchesForResource) {
            return;
        }
        int iPatchCount = oPatchesForResource.size();
        Collator oEquals = Collator.getInstance();
        for (int i = iPatchCount - 1; i >= 0; --i) {
            IPatch oPatch = (IPatch)oPatchesForResource.get(i);
            if (!oEquals.equals(strPatchID, oPatch.getName())) continue;
            oPatchesForResource.remove(oPatch);
            return;
        }
    }

    @Override
    public void removePatchesForResource(Resource oResource) {
        if (null != oResource && this.m_oPatchMap.containsKey(oResource)) {
            this.m_oPatchMap.remove(oResource);
        }
    }

    @Override
    public void removePatchesForDevice(int iDeviceID) {
        ArrayList oSelectedResources = new ArrayList(this.m_oPatchMap.keySet());
        int iResourceCount = oSelectedResources.size();
        for (int i = 0; i < iResourceCount; ++i) {
            Resource oResource = (Resource)oSelectedResources.get(i);
            if (iDeviceID != oResource.getDeviceID()) continue;
            this.removePatchesForResource(oResource);
        }
    }

    @Override
    public DeviceTypeInfo getDeviceType() {
        if (0 == this.m_oPatchMap.size()) {
            return null;
        }
        Iterator oPatchItr = this.m_oPatchMap.keySet().iterator();
        Resource oResource = (Resource)oPatchItr.next();
        return DeviceModelAdapter.getDeviceTypeForResource(oResource);
    }
}

