/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.patchmanagement.controller;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.asndatacenter.AsnDCSyncReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.asndatacenter.AsnPatchOperationReqLst;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.devicemanagement.patchmanagement.controller.IPatchAsyncCommController;
import com.huawei.dc.devicemanagement.patchmanagement.controller.IPatchSyncCommController;
import com.huawei.dc.devicemanagement.patchmanagement.controller.PatchAsyncCommController;
import com.huawei.dc.devicemanagement.patchmanagement.controller.PatchCommUtil;
import com.huawei.dc.framework.ErrorCodeReader;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.math.BigInteger;
import java.util.List;
import net.commustru.fstru.FStruct;

public class PatchSyncCommController
implements IPatchSyncCommController,
IDCObjectDeallocator {
    private static PatchSyncCommController m_oInstance = null;
    private IPatchAsyncCommController m_oAsyncCommController = PatchAsyncCommController.getInstance();

    private PatchSyncCommController() {
    }

    public static synchronized IPatchSyncCommController getInstance() {
        if (null == m_oInstance) {
            m_oInstance = new PatchSyncCommController();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oInstance);
        }
        return m_oInstance;
    }

    @Override
    public void getPatches(int iReqId, DeviceInfo[] arrDevices) throws DCException {
        if (null == arrDevices || 0 == arrDevices.length) {
            throw new DCException("No devices");
        }
        AsnDCSyncReq oAsnGetPatchReq = new AsnDCSyncReq();
        AsnDCSyncRsp oAsnRsp = new AsnDCSyncRsp();
        oAsnGetPatchReq.oReqID = BigInteger.valueOf(iReqId);
        for (int i = 0; i < arrDevices.length; ++i) {
            oAsnGetPatchReq.oDevIDLst.add((Object)BigInteger.valueOf(arrDevices[i].getDevId()));
        }
        DCFrameWorkUtil.getCommManager().addMessageListener(43834, (MSGListener)((PatchAsyncCommController)this.m_oAsyncCommController));
        int iErrorCode = DCFrameWorkUtil.getCommManager().sendSyncMsgWithSyncCommand(43834, (FStruct)oAsnGetPatchReq, (FStruct)oAsnRsp);
        if (iErrorCode != 0) {
            DCFrameWorkUtil.getCommManager().removeMessageListener(43834, (MSGListener)((PatchAsyncCommController)this.m_oAsyncCommController));
            throw new DCException(iErrorCode, ResourceManager.getInstance().getResString("SEND_FAIL"));
        }
        if (0 != oAsnRsp.oErrorInfo.iErrorNo.intValue()) {
            DCFrameWorkUtil.getCommManager().removeMessageListener(43834, (MSGListener)((PatchAsyncCommController)this.m_oAsyncCommController));
            throw new DCException(ErrorCodeReader.getInstance().getErrorDesc(oAsnRsp.oErrorInfo.iErrorNo));
        }
    }

    @Override
    public void setToNULL() {
        ((DCObjectDestructor)DCObjectDestructor.getInstance()).removeObjectForDestructor((PatchAsyncCommController)this.m_oAsyncCommController);
        m_oInstance = null;
        if (null != this.m_oAsyncCommController) {
            ((PatchAsyncCommController)this.m_oAsyncCommController).setToNULL();
            this.m_oAsyncCommController = null;
        }
    }

    @Override
    public int doPatchOperation(int iPatchOpId, List oSelecPatchLst) {
        int iRetCode = 0;
        final AsnPatchOperationReqLst oAsnPatchOpReqLst = new AsnPatchOperationReqLst();
        PatchCommUtil.fillPatchRequest(iPatchOpId, oSelecPatchLst, oAsnPatchOpReqLst);
        final AsnDCOpertionRsp oAsnDCOperationRsp = new AsnDCOpertionRsp();
        SyncCommand oSyncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int iErrorCode = DCFrameWorkUtil.getCommManager().sendSyncMsg(BaseCommManager.getMSGHead(43849), (FStruct)oAsnPatchOpReqLst, (FStruct)oAsnDCOperationRsp);
                return iErrorCode;
            }
        };
        oSyncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        iRetCode = null != oSyncCommand.getResult() ? (Integer)oSyncCommand.getResult() : -1;
        if (0 == iRetCode) {
            iRetCode = oAsnDCOperationRsp.oErrorInfo.iErrorNo.intValue();
        }
        return iRetCode;
    }
}

