/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.patchmanagement.controller;

import com.huawei.dc.common.asndatacenter.AsnBoardPatchInfo;
import com.huawei.dc.common.asndatacenter.AsnBoardPatchInfoLst;
import com.huawei.dc.common.asndatacenter.AsnBoardPatchOpInfo;
import com.huawei.dc.common.asndatacenter.AsnBoardPatchOpInfoLst;
import com.huawei.dc.common.asndatacenter.AsnGetPatchNotification;
import com.huawei.dc.common.asndatacenter.AsnPatchInfo;
import com.huawei.dc.common.asndatacenter.AsnPatchInfoLst;
import com.huawei.dc.common.asndatacenter.AsnPatchOpInfo;
import com.huawei.dc.common.asndatacenter.AsnPatchOperationReq;
import com.huawei.dc.common.asndatacenter.AsnPatchOperationReqLst;
import com.huawei.dc.common.asndatacenter.AsnPatchResultInfo;
import com.huawei.dc.common.asndatacenter.AsnPatchResultInfoLst;
import com.huawei.dc.devicemanagement.model.DeviceModelAdapter;
import com.huawei.dc.devicemanagement.patchmanagement.event.PatchEvent;
import com.huawei.dc.devicemanagement.patchmanagement.event.PatchInfoNotifier;
import com.huawei.dc.devicemanagement.patchmanagement.model.GetPatchNotification;
import com.huawei.dc.devicemanagement.patchmanagement.model.IPatch;
import com.huawei.dc.devicemanagement.patchmanagement.model.IPatchDataModel;
import com.huawei.dc.devicemanagement.patchmanagement.model.Patch;
import com.huawei.dc.devicemanagement.patchmanagement.model.PatchDataModel;
import com.huawei.dc.devicemanagement.patchmanagement.model.PatchProgressInfo;
import com.huawei.dc.taskmgmt.model.Resource;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class PatchCommUtil {
    public static GetPatchNotification populateDataObjFromGetPatchNtfn(AsnGetPatchNotification oAsnNotification) {
        if (null == oAsnNotification) {
            return null;
        }
        GetPatchNotification oPatchNtfn = new GetPatchNotification();
        oPatchNtfn.setFinal(oAsnNotification.bIsFinal);
        oPatchNtfn.setDeviceID(oAsnNotification.iDevId.intValue());
        oPatchNtfn.setNtfnProgress(oAsnNotification.oProgressInfo.iPercentageProgress.intValue());
        oPatchNtfn.setRequestID(oAsnNotification.oProgressInfo.oReqID.intValue());
        oPatchNtfn.setErrorCode(oAsnNotification.oErrorInfo.iErrorNo.intValue());
        oPatchNtfn.setErrorInfo(oAsnNotification.oErrorInfo);
        AsnBoardPatchInfoLst oAsnBoardPatchLst = oAsnNotification.oAsnBoardPatchInfoLst;
        if (null == oAsnBoardPatchLst || 0 == oAsnBoardPatchLst.size()) {
            return oPatchNtfn;
        }
        int iResourceCount = oAsnBoardPatchLst.size();
        Resource oResource = null;
        IPatchDataModel oPatchDataModel = PatchDataModel.getInstance();
        for (int i = 0; i < iResourceCount; ++i) {
            AsnBoardPatchInfo oAsnBoardPatch = (AsnBoardPatchInfo)oAsnBoardPatchLst.get(i);
            oResource = DeviceModelAdapter.populateResourceFromDeviceID(oAsnNotification.iDevId.intValue());
            if (null == oResource) break;
            oResource.setFrameId(oAsnBoardPatch.iFrameId.intValue());
            oResource.setSlotId(oAsnBoardPatch.iSlotId.intValue());
            oResource.setBoardType(oAsnBoardPatch.iBoardType.intValue());
            if (null != oAsnBoardPatch.strSlotName) {
                String boardTypeName = new String(oAsnBoardPatch.strSlotName);
                if (boardTypeName.equals("")) {
                    oResource.setBoardTypeName(DeviceModelAdapter.getBoardTypeName(oResource));
                } else {
                    oResource.setBoardTypeName(boardTypeName);
                }
            } else {
                oResource.setBoardTypeName(DeviceModelAdapter.getBoardTypeName(oResource));
            }
            if (null != oAsnBoardPatch.iSubSlotId) {
                oResource.setSubSlotId(oAsnBoardPatch.iSubSlotId.intValue());
            }
            List oPatchListFromRsp = PatchCommUtil.populatePatchListForAsnBoard(oAsnBoardPatch.oPatchInfoLst, oResource);
            oPatchDataModel.addPatches(oPatchListFromRsp);
        }
        return oPatchNtfn;
    }

    private static List populatePatchListForAsnBoard(AsnPatchInfoLst oAsnPatchInfoLst, Resource oResource) {
        if (null == oAsnPatchInfoLst) {
            return null;
        }
        int iPatchCount = oAsnPatchInfoLst.size();
        ArrayList<Patch> oPatchList = new ArrayList<Patch>(0);
        Patch oPatch = null;
        String strPatchName = null;
        String strPatchDesc = null;
        String strPatchRelyOn = null;
        String strPatchReliedOn = null;
        for (int i = 0; i < iPatchCount; ++i) {
            AsnPatchInfo oAsnPatch = (AsnPatchInfo)oAsnPatchInfoLst.get(i);
            oPatch = new Patch();
            strPatchName = new String(oAsnPatch.strPatchName);
            oPatch.setName(strPatchName);
            strPatchDesc = new String(oAsnPatch.strPatchDescription);
            oPatch.setDescription(strPatchDesc);
            oPatch.setResource(oResource);
            oPatch.setType(PatchCommUtil.getPatchTypeForAsnPatchType(oAsnPatch.oPatchType.value));
            if (null != oAsnPatch.strPatchVersion) {
                oPatch.setVersion(new String(oAsnPatch.strPatchVersion));
            }
            strPatchRelyOn = new String(oAsnPatch.strPatchRely);
            oPatch.setRelyOn(strPatchRelyOn);
            strPatchReliedOn = new String(oAsnPatch.strPatchRelied);
            oPatch.setReliedOn(strPatchReliedOn);
            oPatch.setPatchSate(PatchCommUtil.getPatchState(oAsnPatch.oPatchState.value));
            oPatch.getProgressInfo().setState(-1);
            oPatchList.add(oPatch);
        }
        return oPatchList;
    }

    public static int getPatchState(int iAsnPatchState) {
        int iPatchState = -1;
        switch (iAsnPatchState) {
            case 1: {
                iPatchState = 2;
                break;
            }
            case 2: {
                iPatchState = 1;
                break;
            }
            case 3: {
                iPatchState = 3;
                break;
            }
            case 5: {
                iPatchState = 4;
                break;
            }
            case 4: {
                iPatchState = 5;
                break;
            }
            case 6: {
                iPatchState = 6;
                break;
            }
        }
        return iPatchState;
    }

    public static int getPatchTypeForAsnPatchType(int iAsnPatchType) {
        switch (iAsnPatchType) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return -1;
    }

    public static int getPatchOpId(int iAsnPatchOpId) {
        int iPatchOpId = -1;
        switch (iAsnPatchOpId) {
            case 10: {
                iPatchOpId = 1;
                break;
            }
            case 14: {
                iPatchOpId = 2;
                break;
            }
            case 11: {
                iPatchOpId = 3;
                break;
            }
            case 15: {
                iPatchOpId = 4;
                break;
            }
        }
        return iPatchOpId;
    }

    public static void fillPatchRequest(int iPatchOpId, List oSelecPatchLst, AsnPatchOperationReqLst oAsnPatchOpReqLst) {
        IPatch oPatchInfo = null;
        Resource oResource = null;
        int iSizeofLst = oSelecPatchLst.size();
        AsnPatchOperationReq oAsnPatchOperationReq = null;
        AsnBoardPatchOpInfo oAsnBoardPatchOpInfo = null;
        for (int i = 0; i < iSizeofLst; ++i) {
            oPatchInfo = (IPatch)oSelecPatchLst.get(i);
            oResource = oPatchInfo.getResource();
            oAsnPatchOperationReq = PatchCommUtil.getPatchRequest(oResource, oAsnPatchOpReqLst);
            if (null == oAsnPatchOperationReq) {
                PatchCommUtil.createPatchRequest(oAsnPatchOpReqLst, oPatchInfo, iPatchOpId);
                continue;
            }
            if (!oAsnPatchOperationReq.bIsReboot && oPatchInfo.isRebootRequired()) {
                oAsnPatchOperationReq.bIsReboot = true;
            }
            if (null == (oAsnBoardPatchOpInfo = PatchCommUtil.getBordInfoRequest(oResource, oAsnPatchOperationReq))) {
                PatchCommUtil.createBoardPatchInfo(oPatchInfo, oAsnPatchOperationReq);
                continue;
            }
            AsnPatchOpInfo oAsnPatchOpInfo = new AsnPatchOpInfo();
            oAsnPatchOpInfo.strPatchName = oPatchInfo.getName().getBytes();
            oAsnBoardPatchOpInfo.oPatchInfoLst.add((Object)oAsnPatchOpInfo);
        }
    }

    private static void createBoardPatchInfo(IPatch oPatchInfo, AsnPatchOperationReq oAsnPatchOperationReq) {
        Resource oResource = oPatchInfo.getResource();
        AsnBoardPatchOpInfo oAsnBoardPatchOpInfo = new AsnBoardPatchOpInfo();
        oAsnBoardPatchOpInfo.iBoardType = BigInteger.valueOf(oResource.getBoardType());
        oAsnBoardPatchOpInfo.iFrameId = BigInteger.valueOf(oResource.getFrameId());
        oAsnBoardPatchOpInfo.iSlotId = BigInteger.valueOf(oResource.getSlotId());
        oAsnPatchOperationReq.oAsnBoardPatchInfoLst.add((Object)oAsnBoardPatchOpInfo);
        AsnPatchOpInfo oAsnPatchOpInfo = new AsnPatchOpInfo();
        oAsnPatchOpInfo.strPatchName = oPatchInfo.getName().getBytes();
        oAsnBoardPatchOpInfo.oPatchInfoLst.add((Object)oAsnPatchOpInfo);
    }

    private static AsnBoardPatchOpInfo getBordInfoRequest(Resource oResource, AsnPatchOperationReq oAsnPatchOperationReq) {
        AsnBoardPatchOpInfo oAsnBoardPatchInfo = null;
        AsnBoardPatchOpInfoLst oAsnBoardPatchInfoLst = oAsnPatchOperationReq.oAsnBoardPatchInfoLst;
        int iFrameId = oResource.getFrameId();
        int iSlotId = oResource.getSlotId();
        int iSizeOfLst = oAsnBoardPatchInfoLst.size();
        AsnBoardPatchOpInfo oTempAsnBoardPatchInfo = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            oTempAsnBoardPatchInfo = (AsnBoardPatchOpInfo)oAsnBoardPatchInfoLst.get(i);
            if (iFrameId != oTempAsnBoardPatchInfo.iFrameId.intValue() || iSlotId != oTempAsnBoardPatchInfo.iSlotId.intValue()) continue;
            oAsnBoardPatchInfo = oTempAsnBoardPatchInfo;
            break;
        }
        return oAsnBoardPatchInfo;
    }

    private static void createPatchRequest(AsnPatchOperationReqLst oAsnPatchOpReqLst, IPatch oPatchInfo, int iPatchOpId) {
        Resource oResource = oPatchInfo.getResource();
        AsnPatchOperationReq oAsnPatchReq = new AsnPatchOperationReq();
        oAsnPatchReq.iDevId = BigInteger.valueOf(oResource.getDeviceID());
        oAsnPatchReq.bIsReboot = oPatchInfo.isRebootRequired();
        oAsnPatchReq.oPatchState.value = PatchCommUtil.getPatchOpId(iPatchOpId);
        AsnBoardPatchOpInfo oAsnBoardPatchOpInfo = new AsnBoardPatchOpInfo();
        oAsnBoardPatchOpInfo.iBoardType = BigInteger.valueOf(oResource.getBoardType());
        oAsnBoardPatchOpInfo.iFrameId = BigInteger.valueOf(oResource.getFrameId());
        oAsnBoardPatchOpInfo.iSlotId = BigInteger.valueOf(oResource.getSlotId());
        oAsnPatchReq.oAsnBoardPatchInfoLst.add((Object)oAsnBoardPatchOpInfo);
        AsnPatchOpInfo oAsnPatchOpInfo = new AsnPatchOpInfo();
        oAsnPatchOpInfo.strPatchName = oPatchInfo.getName().getBytes();
        oAsnBoardPatchOpInfo.oPatchInfoLst.add((Object)oAsnPatchOpInfo);
        oAsnPatchOpReqLst.add((Object)oAsnPatchReq);
    }

    private static AsnPatchOperationReq getPatchRequest(Resource oResource, AsnPatchOperationReqLst oAsnPatchOpReqLst) {
        int iSizeOfList = oAsnPatchOpReqLst.size();
        AsnPatchOperationReq oAsnPatchOperationReq = null;
        int iDeviceId = oResource.getDeviceID();
        AsnPatchOperationReq oTempAsnPatchOperationReq = null;
        for (int i = 0; i < iSizeOfList; ++i) {
            oTempAsnPatchOperationReq = (AsnPatchOperationReq)oAsnPatchOpReqLst.get(i);
            if (iDeviceId != oTempAsnPatchOperationReq.iDevId.intValue()) continue;
            oAsnPatchOperationReq = oTempAsnPatchOperationReq;
            break;
        }
        return oAsnPatchOperationReq;
    }

    public static List processPatchOpStateUpdation(AsnBoardPatchInfoLst oAsnBoardPatchInfoLst, int iDeviceId) {
        List oDeletedPatchList = new ArrayList(0);
        if (null == oAsnBoardPatchInfoLst) {
            oDeletedPatchList = PatchDataModel.getInstance().getPatchesForDevice(iDeviceId);
            PatchDataModel.getInstance().removePatchesForDevice(iDeviceId);
            return oDeletedPatchList;
        }
        int iSizeOfLst = oAsnBoardPatchInfoLst.size();
        AsnBoardPatchInfo oAsnBoardPatchInfo = null;
        Resource oResource = null;
        List oPatchListFromRsp = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            oAsnBoardPatchInfo = (AsnBoardPatchInfo)oAsnBoardPatchInfoLst.get(i);
            oResource = DeviceModelAdapter.populateResourceFromDeviceID(iDeviceId);
            if (null == oResource) continue;
            oResource.setFrameId(oAsnBoardPatchInfo.iFrameId.intValue());
            oResource.setSlotId(oAsnBoardPatchInfo.iSlotId.intValue());
            oResource.setBoardType(oAsnBoardPatchInfo.iBoardType.intValue());
            oResource.setBoardTypeName(DeviceModelAdapter.getBoardTypeName(oResource));
            oPatchListFromRsp = PatchCommUtil.populatePatchListForAsnBoard(oAsnBoardPatchInfo.oPatchInfoLst, oResource);
            if (0 < i) {
                PatchCommUtil.updateDeletePatchList(oDeletedPatchList, oResource, oPatchListFromRsp);
                continue;
            }
            IPatchDataModel oPatchDataModel = PatchDataModel.getInstance();
            List oPatchListFromModel = oPatchDataModel.getPatchesForDevice(iDeviceId);
            if (null == oPatchListFromModel) continue;
            oDeletedPatchList.addAll(PatchCommUtil.updatePatchModelWithResponse(oPatchListFromModel, oPatchListFromRsp));
        }
        return oDeletedPatchList;
    }

    private static void updateDeletePatchList(List oDeletedPatchList, Resource oResource, List oPatchListFromRsp) {
        int iSizeOfLst = oDeletedPatchList.size();
        ArrayList oTempPatchLst = new ArrayList(0);
        ArrayList oTempToDeletePatches = new ArrayList(0);
        for (int i = iSizeOfLst - 1; i >= 0; --i) {
            IPatch oPatchInfo = (IPatch)oDeletedPatchList.get(i);
            if (!oPatchInfo.getResource().equals(oResource)) continue;
            oTempPatchLst.add(oDeletedPatchList.get(i));
            oDeletedPatchList.remove(i);
        }
        oTempToDeletePatches.addAll(oTempToDeletePatches.size(), PatchCommUtil.updatePatchModelWithResponse(oTempPatchLst, oPatchListFromRsp));
        if (0 < oTempToDeletePatches.size()) {
            oDeletedPatchList.addAll(oDeletedPatchList.size(), oTempToDeletePatches);
        }
    }

    private static List updatePatchModelWithResponse(List oPatchListFromModel, List oPatchListFromRsp) {
        ArrayList<IPatch> oDeletedPatchList = new ArrayList<IPatch>(0);
        int iPatchCountInModel = oPatchListFromModel.size();
        IPatch oPatchFromModel = null;
        if (null == oPatchListFromRsp || 0 == oPatchListFromRsp.size()) {
            for (int i = iPatchCountInModel - 1; i >= 0; --i) {
                oPatchFromModel = (IPatch)oPatchListFromModel.get(i);
                oDeletedPatchList.add(oPatchFromModel);
                oPatchListFromModel.remove(i);
            }
            return oDeletedPatchList;
        }
        int iPatchCountInRsp = oPatchListFromRsp.size();
        IPatch oPatchFromRsp = null;
        boolean isPresent = false;
        for (int i = iPatchCountInModel - 1; i >= 0; --i) {
            oPatchFromModel = (IPatch)oPatchListFromModel.get(i);
            isPresent = false;
            for (int j = 0; j < iPatchCountInRsp; ++j) {
                oPatchFromRsp = (IPatch)oPatchListFromRsp.get(j);
                if (!oPatchFromModel.equals(oPatchFromRsp)) continue;
                isPresent = true;
                oPatchFromModel.setPatchSate(oPatchFromRsp.getPatchState());
                oPatchFromModel.setIsRebootRequired(oPatchFromRsp.isRebootRequired());
                oPatchFromModel.setRelyOn(oPatchFromRsp.getRelyOn());
                oPatchFromModel.setReliedOn(oPatchFromRsp.getReliedOn());
                oPatchFromModel.setVersion(oPatchFromRsp.getVersion());
                oPatchFromModel.setType(oPatchFromRsp.getType());
                oPatchFromModel.setName(oPatchFromRsp.getName());
                oPatchFromModel.setDescription(oPatchFromRsp.getDescription());
                break;
            }
            if (isPresent) continue;
            oDeletedPatchList.add(oPatchFromModel);
        }
        return oDeletedPatchList;
    }

    public static void processPatchOpResultInfo(AsnPatchResultInfoLst oAsnPatchResult, int iDeviceId, AsnBoardPatchInfoLst oAsnBoardPatchInfoLst, List<IPatch> oDeletedPatches) {
        if (null == oAsnPatchResult) {
            return;
        }
        int iSizeOfLst = oAsnPatchResult.size();
        AsnPatchResultInfo oAsnPatchResultInfo = null;
        Resource oResource = null;
        IPatch oPatchFromModel = null;
        String strPatchName = null;
        for (int i = 0; i < iSizeOfLst; ++i) {
            oAsnPatchResultInfo = (AsnPatchResultInfo)oAsnPatchResult.get(i);
            oResource = DeviceModelAdapter.populateResourceFromDeviceID(iDeviceId);
            if (null == oResource) continue;
            oResource.setFrameId(oAsnPatchResultInfo.iFrameId.intValue());
            oResource.setSlotId(oAsnPatchResultInfo.iSlotId.intValue());
            if (null != oAsnPatchResultInfo.iBoardType) {
                oResource.setBoardType(oAsnPatchResultInfo.iBoardType.intValue());
                oResource.setBoardTypeName(DeviceModelAdapter.getBoardTypeName(oResource));
            }
            strPatchName = new String(oAsnPatchResultInfo.strPatchName);
            oPatchFromModel = PatchDataModel.getInstance().getPatch(oResource, strPatchName);
            if (null == oPatchFromModel) continue;
            PatchProgressInfo oPatchProgressInfo = oPatchFromModel.getProgressInfo();
            oPatchProgressInfo.setResult(oAsnPatchResultInfo.oErrorInfo.iErrorNo.intValue());
            oPatchProgressInfo.setErrorInfo(oAsnPatchResultInfo.oErrorInfo);
            oPatchProgressInfo.setProgress(-1);
            oPatchProgressInfo.setState(-1);
            if (null == oAsnBoardPatchInfoLst && 0 == oAsnPatchResultInfo.oErrorInfo.iErrorNo.intValue() && !oDeletedPatches.contains(oPatchFromModel)) {
                oDeletedPatches.add(oPatchFromModel);
            }
            PatchEvent oEvent = new PatchEvent(oPatchFromModel, 3);
            PatchInfoNotifier.getInstance().notifyPatchEvent(oEvent);
        }
    }
}

