/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.patchmanagement.controller;

import com.huawei.dc.common.asndatacenter.AsnBoardPatchInfo;
import com.huawei.dc.common.asndatacenter.AsnDCSyncReq;
import com.huawei.dc.common.asndatacenter.AsnDCSyncRsp;
import com.huawei.dc.common.asndatacenter.AsnGetPatchNotification;
import com.huawei.dc.common.asndatacenter.AsnPatchInfo;
import com.huawei.dc.common.asndatacenter.AsnPatchOperationRsp;
import com.huawei.dc.common.components.dialog.SimpleProgressDlg;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.ErrorInfo;
import com.huawei.dc.devicemanagement.patchmanagement.controller.IPatchAsyncCommController;
import com.huawei.dc.devicemanagement.patchmanagement.controller.PatchCommUtil;
import com.huawei.dc.devicemanagement.patchmanagement.event.PatchEvent;
import com.huawei.dc.devicemanagement.patchmanagement.event.PatchInfoNotifier;
import com.huawei.dc.devicemanagement.patchmanagement.model.GetPatchNotification;
import com.huawei.dc.devicemanagement.patchmanagement.model.IPatch;
import com.huawei.dc.devicemanagement.patchmanagement.model.Patch;
import com.huawei.dc.devicemanagement.patchmanagement.model.PatchDataModel;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.view.common.TaskOperationResultDialog;
import com.huawei.dc.taskmgmt.view.createtask.ViewCommandResultDialog;
import com.swimap.iview.communicate.MSGListener;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.communicate.MSGReceiver;
import java.awt.Component;
import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public class PatchAsyncCommController
extends MSGReceiver
implements IPatchAsyncCommController,
IDCObjectDeallocator {
    private static PatchAsyncCommController m_oInstance;
    private TaskOperationResultDialog oDlg = null;
    private static final int WAIT_TIME = 500;
    private static SimpleProgressDlg m_oValidationProgressDlg;

    private PatchAsyncCommController() {
        DCFrameWorkUtil.getCommManager().addMessageListener(43831, (MSGListener)this);
    }

    public static synchronized IPatchAsyncCommController getInstance() {
        if (null == m_oInstance) {
            m_oInstance = new PatchAsyncCommController();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oInstance);
        }
        return m_oInstance;
    }

    protected void processMessage(MSGPacketExt oPacketExt) {
        try {
            this.processAsynMessage(oPacketExt);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    protected synchronized void processAsynMessage(MSGPacketExt oPacketExt) {
        int iCmdCode = oPacketExt.mheader.cmdCode;
        DCDebugTracer.trace("receive asyn msg cmdCode=" + iCmdCode);
        switch (iCmdCode) {
            case 43834: {
                this.updatePatchinformation(oPacketExt);
                break;
            }
            case 43831: {
                this.updatePatchOperationResponse(oPacketExt);
                break;
            }
            case 44082: {
                this.updatePatchDetailInfo(oPacketExt);
                break;
            }
        }
    }

    private void updatePatchOperationResponse(MSGPacketExt oPacketExt) {
        try {
            this.wait(500L);
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace("ignore" + ex);
        }
        AsnPatchOperationRsp oAsnPatchOperationRsp = new AsnPatchOperationRsp();
        if (null == oPacketExt) {
            return;
        }
        int iDecodeErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnPatchOperationRsp, oPacketExt.getData(), false);
        if (0 != iDecodeErrorCode) {
            return;
        }
        List oDeletedPatches = PatchCommUtil.processPatchOpStateUpdation(oAsnPatchOperationRsp.oAsnBoardPatchInfoLst, oAsnPatchOperationRsp.iDevId.intValue());
        PatchCommUtil.processPatchOpResultInfo(oAsnPatchOperationRsp.oAsnPatchResult, oAsnPatchOperationRsp.iDevId.intValue(), oAsnPatchOperationRsp.oAsnBoardPatchInfoLst, oDeletedPatches);
        DCDebugTracer.trace("DC:: updatePatchOperationResponse->processPatchOpResultInfo end");
        this.updatePatchDataModel(oDeletedPatches);
        DCDebugTracer.trace("DC:: updatePatchOperationResponse->updatePatchDataModel end");
        ErrorInfo oErrorInfo = new ErrorInfo(oAsnPatchOperationRsp.oErrorInfo);
        this.displayMesage(oDeletedPatches, oErrorInfo);
        DCDebugTracer.trace("DC:: updatePatchOperationResponse->displayMesage end");
        PatchEvent oEvent = new PatchEvent(oDeletedPatches, 2);
        PatchInfoNotifier.getInstance().notifyPatchEvent(oEvent);
    }

    private void updatePatchDataModel(List oDeletedPatches) {
        int iSizeLst = oDeletedPatches.size();
        for (int i = 0; i < iSizeLst; ++i) {
            IPatch oPatch = (IPatch)oDeletedPatches.get(i);
            PatchDataModel.getInstance().removePatch(oPatch.getResource(), oPatch.getName());
        }
    }

    private void displayMesage(List<Patch> oDeletedPatches, ErrorInfo oErrorInfo) {
        ResourceManager oResMgmr = ResourceManager.getInstance();
        if (null == oDeletedPatches || 0 == oDeletedPatches.size()) {
            return;
        }
        String[] strColumnNames = new String[]{ResourceManager.getInstance().getResString("PATCH_TABLE_COLUMN_PATCH_NAME"), ResourceManager.getInstance().getResString("DETAILS_BUTTON")};
        if (this.oDlg == null || !this.oDlg.isVisible()) {
            this.oDlg = new TaskOperationResultDialog(oResMgmr.getResString("OPERATION_RESOULT_SUTO_PROGRESS"), 0, true, strColumnNames);
            this.oDlg.customizeTableForTelnetError();
        }
        this.oDlg.setMessage(oResMgmr.getResString("OPERTION_DETAILS"));
        int iSizeOfPatches = oDeletedPatches.size();
        String patchName = null;
        Vector<Object> oRowVct = null;
        for (int i = 0; i < iSizeOfPatches; ++i) {
            oRowVct = new Vector<Object>(2);
            Patch oPatch = oDeletedPatches.get(i);
            patchName = oPatch.getResource().getDeviceName() + "_" + oPatch.getName();
            oRowVct.add(patchName);
            oRowVct.add(oErrorInfo);
            this.oDlg.addRowInModel(oRowVct);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PatchAsyncCommController.this.oDlg.setVisible(true);
            }
        });
    }

    private void updatePatchinformation(MSGPacketExt oPacketExt) {
        AsnGetPatchNotification oAsnPatchNotification = new AsnGetPatchNotification();
        int iErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnPatchNotification, oPacketExt.getData());
        if (0 != iErrorCode) {
            return;
        }
        GetPatchNotification oGetPatchNtfn = PatchCommUtil.populateDataObjFromGetPatchNtfn(oAsnPatchNotification);
        DCDebugTracer.trace(oGetPatchNtfn.toString());
        if (oGetPatchNtfn.isFinal()) {
            DCFrameWorkUtil.getCommManager().removeMessageListener(43834, (MSGListener)this);
        }
        PatchEvent oEvent = new PatchEvent(oGetPatchNtfn, 0);
        PatchInfoNotifier.getInstance().notifyPatchEvent(oEvent);
    }

    public void timeout(int strArg0, Character strArg1) {
    }

    @Override
    public void setToNULL() {
        this.close();
        DCFrameWorkUtil.getCommManager().removeMessageListener(43831, (MSGListener)this);
        m_oInstance = null;
    }

    @Override
    public void getIPNePatchDetailInfo(final int iDevId) {
        m_oValidationProgressDlg = new SimpleProgressDlg(ResourceManager.getInstance().getResString("PATCH_DETAIL_TITLE_PROGRESS"), true, ResourceManager.getInstance().getResString("GETTING_PATCH_DETAIL_TITLE_PROGRESS")){
            private static final long serialVersionUID = 1L;

            @Override
            protected void cancelButtonActionPerformed() {
                this.dispose();
            }
        };
        new Thread(new Runnable(){

            @Override
            public void run() {
                int iReqId = DCFrameWorkUtil.generateRequestId();
                m_oValidationProgressDlg.setProgressDlgId(iReqId);
                AsnDCSyncReq oAsnGetPatchReq = new AsnDCSyncReq();
                oAsnGetPatchReq.oReqID = BigInteger.valueOf(iReqId);
                oAsnGetPatchReq.oDevIDLst.add((Object)BigInteger.valueOf(iDevId));
                DCFrameWorkUtil.getCommManager().addMessageListener(44082, (MSGListener)m_oInstance);
                AsnDCSyncRsp oAsnDCOperationRsp = new AsnDCSyncRsp();
                int iRetCode = DCFrameWorkUtil.getCommManager().sendSyncMsgWithSyncCommand(44082, (FStruct)oAsnGetPatchReq, (FStruct)oAsnDCOperationRsp);
                if (0 != iRetCode) {
                    PatchAsyncCommController.this.closeProgressDlg();
                    DCFrameWorkUtil.getCommManager().removeMessageListener(44082, (MSGListener)m_oInstance);
                    DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("SEND_FAIL"));
                    return;
                }
                if (null != oAsnDCOperationRsp.oErrorInfo && 0 != oAsnDCOperationRsp.oErrorInfo.iErrorNo.intValue()) {
                    PatchAsyncCommController.this.closeProgressDlg();
                    DCFrameWorkUtil.getCommManager().removeMessageListener(44082, (MSGListener)m_oInstance);
                    DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ErrorCodeReader.getInstance().getErrorDesc(oAsnDCOperationRsp.oErrorInfo.iErrorNo));
                    return;
                }
            }
        }).start();
        m_oValidationProgressDlg.setVisible(true);
    }

    private void updatePatchDetailInfo(MSGPacketExt oPacketExt) {
        AsnGetPatchNotification oAsnGetPatchNotification = new AsnGetPatchNotification();
        if (null == oPacketExt) {
            return;
        }
        this.closeProgressDlg();
        int iDecodeErrorCode = DCFrameWorkUtil.getCommManager().decodeAsn1Data((FStruct)oAsnGetPatchNotification, oPacketExt.getData());
        if (0 != iDecodeErrorCode) {
            DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iDecodeErrorCode)));
            return;
        }
        if (null != oAsnGetPatchNotification.oErrorInfo && 0 != oAsnGetPatchNotification.oErrorInfo.iErrorNo.intValue()) {
            if (999293098 == oAsnGetPatchNotification.oErrorInfo.iErrorNo.intValue()) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ErrorCodeReader.getInstance().getErrorDesc(oAsnGetPatchNotification.oErrorInfo.iErrorNo), ResourceManager.getInstance().getResString("INFORMATION"), 1);
            } else {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), ErrorCodeReader.getInstance().getErrorDesc(oAsnGetPatchNotification.oErrorInfo.iErrorNo));
            }
            return;
        }
        if (null == oAsnGetPatchNotification.oAsnBoardPatchInfoLst) {
            if (!oAsnGetPatchNotification.bIsFinal) {
                DCOptionPane.showErrorDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("PROGRAM_SELECTION_NO_PATCH_EXIST"));
            }
            return;
        }
        DCFrameWorkUtil.getCommManager().removeMessageListener(44082, (MSGListener)m_oInstance);
        AsnBoardPatchInfo oAsnBoardPatchInfo = (AsnBoardPatchInfo)oAsnGetPatchNotification.oAsnBoardPatchInfoLst.get(0);
        AsnPatchInfo oAsnPatchInfo = (AsnPatchInfo)oAsnBoardPatchInfo.oPatchInfoLst.get(0);
        ViewCommandResultDialog dialog = new ViewCommandResultDialog(new String(oAsnPatchInfo.strPatchDeatilInfo));
        dialog.setTitle(DCFrameWorkUtil.getLocalizedString("PATCH_DETAIL_TITLE"));
        dialog.getContentTextArea().setLineWrap(true);
        dialog.setVisible(true);
    }

    private void closeProgressDlg() {
        if (null != m_oValidationProgressDlg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    m_oValidationProgressDlg.dispose();
                }
            });
            try {
                Thread.sleep(600L);
            }
            catch (InterruptedException e) {
                DCDebugTracer.trace("Exception:" + e);
            }
        }
    }

    static {
        m_oValidationProgressDlg = null;
    }
}

