/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.model.xmlconfig;

import com.huawei.dc.devicemanagement.model.xmlconfig.IPatchConfig;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;

public class PatchConfig
implements IPatchConfig {
    private TIntObjectHashMap m_oPatchConfigMap = new TIntObjectHashMap(16);
    private TIntObjectHashMap m_oHotPathConfigMap = new TIntObjectHashMap(16);
    private TIntObjectHashMap m_oColdPatchConfigMap = new TIntObjectHashMap(16);
    private List m_oHotPatchStateIdLst = new ArrayList(4);
    private List m_oColdPatchStateIdLst = new ArrayList(4);
    private List m_oBothPatchStateIdLst = null;
    private List m_oPatchTypeLst = new ArrayList(2);
    private List m_oBothSuppPatchStatesLst = null;

    @Override
    public void addPatch(int iPatchType, int iPatchStateId, List oPatchOpList) {
        Integer oPatchStateId = iPatchStateId;
        switch (iPatchType) {
            case 0: 
            case 1: {
                this.addHotPatchTemp(iPatchType, oPatchOpList, oPatchStateId);
                break;
            }
            case 2: 
            case 3: {
                this.addColdPatchTemp(iPatchType, oPatchOpList, oPatchStateId);
                break;
            }
        }
    }

    private void addColdPatchTemp(int iPatchType, List oPatchOpList, Integer oPatchStateId) {
        if (!this.m_oColdPatchStateIdLst.contains(oPatchStateId)) {
            this.m_oColdPatchStateIdLst.add(oPatchStateId);
        }
        if (!this.m_oPatchTypeLst.contains(iPatchType)) {
            this.m_oPatchTypeLst.add(iPatchType);
        }
        this.m_oColdPatchConfigMap.put(oPatchStateId.intValue(), (Object)oPatchOpList);
        this.m_oPatchConfigMap.put(Integer.valueOf(iPatchType).intValue(), (Object)this.m_oColdPatchConfigMap);
    }

    private void addHotPatchTemp(int iPatchType, List oPatchOpList, Integer oPatchStateId) {
        if (!this.m_oHotPatchStateIdLst.contains(oPatchStateId)) {
            this.m_oHotPatchStateIdLst.add(oPatchStateId);
        }
        if (!this.m_oPatchTypeLst.contains(iPatchType)) {
            this.m_oPatchTypeLst.add(iPatchType);
        }
        this.m_oHotPathConfigMap.put(oPatchStateId.intValue(), (Object)oPatchOpList);
        this.m_oPatchConfigMap.put(Integer.valueOf(iPatchType).intValue(), (Object)this.m_oHotPathConfigMap);
    }

    @Override
    public List getPatchTypeList() {
        return this.m_oPatchTypeLst;
    }

    @Override
    public List getAllPatchSuppState(int iPatchState) {
        if (null != this.m_oBothSuppPatchStatesLst) {
            return this.m_oBothSuppPatchStatesLst;
        }
        List oColdPatchStatesLst = (List)this.m_oColdPatchConfigMap.get(Integer.valueOf(iPatchState).intValue());
        List oHotPatchStatesLst = (List)this.m_oHotPathConfigMap.get(Integer.valueOf(iPatchState).intValue());
        this.m_oBothSuppPatchStatesLst = new ArrayList(8);
        if (null == oColdPatchStatesLst || null == oHotPatchStatesLst) {
            return null;
        }
        int iSizeOfColdPatchLst = oColdPatchStatesLst.size();
        int iSizeOfHotPatchLst = oHotPatchStatesLst.size();
        for (int i = 0; i < iSizeOfColdPatchLst; ++i) {
            this.getBothStateSupPatchList(oColdPatchStatesLst, oHotPatchStatesLst, iSizeOfHotPatchLst, i);
        }
        return this.m_oBothSuppPatchStatesLst;
    }

    private void getBothStateSupPatchList(List oColdPatchStatesLst, List oHotPatchStatesLst, int iSizeOfHotPatchLst, int i) {
        Integer oColdPatchOpId = (Integer)oColdPatchStatesLst.get(i);
        for (int j = 0; j < iSizeOfHotPatchLst; ++j) {
            Integer oHotPatchOpId = (Integer)oHotPatchStatesLst.get(j);
            if (oColdPatchOpId.intValue() != oHotPatchOpId.intValue()) continue;
            this.m_oBothSuppPatchStatesLst.add(oColdPatchOpId);
            break;
        }
    }

    @Override
    public List getHotPatchStates() {
        return this.m_oHotPatchStateIdLst;
    }

    @Override
    public List getColdPatchStates() {
        return this.m_oColdPatchStateIdLst;
    }

    @Override
    public List getColdPatchSuppState(int iPatchState) {
        List oColdPatchStatesLst = (List)this.m_oColdPatchConfigMap.get(Integer.valueOf(iPatchState).intValue());
        return oColdPatchStatesLst;
    }

    @Override
    public List getHotPatchSuppState(int iPatchState) {
        List oHotPatchStatesLst = (List)this.m_oHotPathConfigMap.get(Integer.valueOf(iPatchState).intValue());
        return oHotPatchStatesLst;
    }

    @Override
    public List getAllPatchStates() {
        if (null != this.m_oBothPatchStateIdLst) {
            return this.m_oBothPatchStateIdLst;
        }
        this.m_oBothPatchStateIdLst = new ArrayList(4);
        int iColdPatchLstSize = this.m_oColdPatchStateIdLst.size();
        int iHotPatchLstSize = this.m_oHotPatchStateIdLst.size();
        for (int i = 0; i < iColdPatchLstSize; ++i) {
            this.comparePatchId(iHotPatchLstSize, i);
        }
        return this.m_oBothPatchStateIdLst;
    }

    private void comparePatchId(int iHotPatchLstSize, int i) {
        int iColdPatchStateId = (Integer)this.m_oColdPatchStateIdLst.get(i);
        for (int j = 0; j < iHotPatchLstSize; ++j) {
            int iHotPatchStateId = (Integer)this.m_oHotPatchStateIdLst.get(j);
            if (iColdPatchStateId != iHotPatchStateId) continue;
            this.m_oBothPatchStateIdLst.add(iColdPatchStateId);
            break;
        }
    }
}

