/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.model.xmlconfig;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.asndatacenter.AsnDevTypeVerXMLInfo;
import com.huawei.dc.common.asndatacenter.AsnVerInfo;
import com.huawei.dc.common.asndatacenter.AsnVerInfoLst;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ParamUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.deviceinfo.DeviceVersionInfo;
import com.huawei.dc.devicemanagement.controller.DeviceConfigModelCtrller;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IParaList;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceXMLConfigModel;
import com.huawei.dc.taskmgmt.controller.TaskAsynCommForSpecificConfInfoNotify;
import com.huawei.dc.taskmgmt.model.Resource;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class DeviceXMLConfigModel
implements IDeviceXMLConfigModel,
IDCObjectDeallocator {
    private static IDeviceXMLConfigModel m_oDeviceXMLConfigModel;
    private Hashtable m_oDeviceConfigDataModelTable = new Hashtable(10);
    private Vector<String> m_oServerCallRegister = new Vector();
    private boolean bIsBmsAndeMxuDev = false;
    private String strKeyDevVer = "";
    ArrayList<String> oDeviceTypeModelLst = new ArrayList();
    ArrayList<IDeviceTypeConfigModel> oDeviceTypeConfigModelLst = new ArrayList();

    private DeviceXMLConfigModel() {
    }

    @Override
    public void addDeviceTypeConfigModel(AsnDevTypeVerXMLInfo oAsnDevTypeVerXmlInfo, IDeviceTypeConfigModel oDevTypeConfigModel) {
        String strKey = oDevTypeConfigModel.getDeviceType() + oDevTypeConfigModel.getDeviceTypeVersion();
        this.addDeviceTypeConfigModel(strKey, oDevTypeConfigModel);
        DCDebugTracer.trace("DC: DeviceConfigModelCtrller#addDeviceTypeConfigModel--->strDevTypeName:" + oDevTypeConfigModel.getDeviceType() + "strDeviceTypeVersion=" + oDevTypeConfigModel.getDeviceTypeVersion());
        AsnVerInfoLst oAsnVerInfoLst = oAsnDevTypeVerXmlInfo.oAsnVerInfoLst;
        if (null != oAsnVerInfoLst && this.bIsBmsAndeMxuDev) {
            String strDevVerandPatchVerKey = "";
            String strDevVer = "";
            String strDevPatchVer = "";
            for (int i = 0; i < oAsnVerInfoLst.size(); ++i) {
                AsnVerInfo oAsnVerInfo = (AsnVerInfo)oAsnVerInfoLst.get(i);
                if (null != oAsnVerInfo.strDevVersion) {
                    strDevVer = new String(oAsnVerInfo.strDevVersion).intern();
                }
                if (null != oAsnVerInfo.strDevPatchVersion) {
                    strDevPatchVer = new String(oAsnVerInfo.strDevPatchVersion).intern();
                }
                if ((strDevVerandPatchVerKey = strKey + strDevVer + strDevPatchVer).length() <= 0) continue;
                DCDebugTracer.trace("DC: DeviceConfigModelCtrller#addDeviceTypeConfigModel--->BmsAllkey:" + strDevVerandPatchVerKey);
                this.addDeviceTypeConfigModel(strDevVerandPatchVerKey, oDevTypeConfigModel);
            }
        }
        DCDebugTracer.trace("DeviceXMLConfigModel#addDeviceTypeConfigModel:" + oDevTypeConfigModel.getDeviceType());
    }

    public void addDeviceTypeConfigModel(String strKey, IDeviceTypeConfigModel oDevTypeConfigModel) {
        if (this.m_oDeviceConfigDataModelTable.containsKey(strKey)) {
            this.m_oDeviceConfigDataModelTable.remove(strKey);
        }
        this.m_oDeviceConfigDataModelTable.put(strKey, oDevTypeConfigModel);
        if (this.m_oServerCallRegister.contains(strKey)) {
            this.m_oServerCallRegister.remove(strKey);
        }
        this.m_oServerCallRegister.add(strKey);
    }

    @Override
    public IDeviceTypeConfigModel getDeviceTypeConfigModel(DeviceType oDevType) {
        if (null == oDevType) {
            DCDebugTracer.trace("getDeviceTypeConfigModel devtype is null");
            return null;
        }
        int[] iDeviceIdLst = oDevType.getDeviceIdlst(oDevType);
        DeviceTypeInfo oDeviceTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(oDevType.getDeviceTypeID(), oDevType.getDeviceTypeVersionID());
        if (null == oDeviceTypeInfo) {
            oDeviceTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfoByDevId(iDeviceIdLst[0]);
        }
        if (null != iDeviceIdLst) {
            Resource oResource = oDevType.getResource(iDeviceIdLst[0]);
            if (oDeviceTypeInfo.isDMSDomain() && 0 != (oResource.getUpgradeMode() & 0x1000)) {
                oDeviceTypeInfo.setDevTypeVersionName(oDeviceTypeInfo.getDevTypeVersionName() + "_telnet");
            }
        }
        return this.getDeviceTypeConfigModel(oDeviceTypeInfo, iDeviceIdLst);
    }

    @Override
    public ArrayList<IDeviceTypeConfigModel> getDeviceTypeConfigModelOnlyExistsDev(String[] strDeviceTypeLst, String[] strDeviceTypeVersionLst, int[] iDeviceIdLst) {
        for (int i = 0; i < strDeviceTypeLst.length; ++i) {
            IDeviceTypeConfigModel oDeviceTypeConfigModel = (IDeviceTypeConfigModel)this.m_oDeviceConfigDataModelTable.get(strDeviceTypeLst[i] + StringUtils.removeRepeatPostfix(strDeviceTypeVersionLst[i], "_telnet"));
            if (null == oDeviceTypeConfigModel || this.oDeviceTypeModelLst.size() > 0 && this.oDeviceTypeModelLst.contains(strDeviceTypeLst[i]) || this.oDeviceTypeConfigModelLst.contains(oDeviceTypeConfigModel)) continue;
            this.oDeviceTypeModelLst.add(strDeviceTypeLst[i]);
            this.oDeviceTypeConfigModelLst.add(oDeviceTypeConfigModel);
        }
        return this.oDeviceTypeConfigModelLst;
    }

    @Override
    public IDeviceTypeConfigModel getDeviceTypeConfigModel(DeviceTypeInfo oDevTypeInfo, int[] iDeviceIdLst) {
        IDeviceTypeConfigModel oDeviceTypeConfigModel = null;
        boolean isTaskPanelActivate = true;
        String strKey = oDevTypeInfo.getDevTypeName() + StringUtils.removeRepeatPostfix(oDevTypeInfo.getDevTypeVersionName(), "_telnet");
        String strKeyForAllDomain = this.getStringKeyForAllDomain(oDevTypeInfo, iDeviceIdLst, strKey);
        oDeviceTypeConfigModel = (IDeviceTypeConfigModel)this.m_oDeviceConfigDataModelTable.get(strKeyForAllDomain);
        if (oDevTypeInfo.getDevDomain() == 2) {
            strKeyForAllDomain = oDevTypeInfo.getDevTypeName() + oDevTypeInfo.getDevTypeVersionName();
        }
        if (null == oDeviceTypeConfigModel) {
            try {
                if (!this.m_oServerCallRegister.contains(strKeyForAllDomain) || DCFrameWorkUtil.getIsNeedToSendCmdCode()) {
                    DeviceConfigModelCtrller.getInstance().getDeviceSpecificConfigInfo(oDevTypeInfo.getDevTypeName(), oDevTypeInfo.getDevTypeVersionName());
                    if (this.m_oServerCallRegister.contains(strKeyForAllDomain)) {
                        this.m_oServerCallRegister.remove(strKeyForAllDomain);
                    }
                    this.m_oServerCallRegister.add(strKeyForAllDomain);
                }
            }
            catch (DCException e) {
                if (this.m_oServerCallRegister.contains(strKeyForAllDomain)) {
                    this.m_oServerCallRegister.remove(strKeyForAllDomain);
                }
                this.m_oServerCallRegister.add(strKeyForAllDomain);
                DCDebugTracer.trace("DC: faild to get device type config info devcieType=" + oDevTypeInfo.getDevTypeName() + "strDeviceTypeVersion=" + oDevTypeInfo.getDevTypeVersionName() + e.getMessage());
                DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(0));
            }
            oDeviceTypeConfigModel = (IDeviceTypeConfigModel)this.m_oDeviceConfigDataModelTable.get(strKeyForAllDomain);
            if (null == oDeviceTypeConfigModel && oDevTypeInfo.isBMSDomain() && !oDevTypeInfo.getIscreateauto()) {
                DCDebugTracer.trace("DC: DeviceXMLConfigModel#getDeviceTypeConfigModel fail in" + strKeyForAllDomain + "->so use noraml XML Info");
                oDeviceTypeConfigModel = (IDeviceTypeConfigModel)this.m_oDeviceConfigDataModelTable.get(oDevTypeInfo.getDevTypeName() + oDevTypeInfo.getDevTypeVersionName());
                if (null != DCFrameWorkUtil.getTaskTablePanel() && DCFrameWorkUtil.getTaskTablePanel().isDevInTaskSubOperation()) {
                    DCFrameWorkUtil.getTaskTablePanel().setIsDevInTaskSubOperation(false);
                }
            }
            if (null == oDeviceTypeConfigModel && DCFrameWorkUtil.getIsNeedToSendCmdCode() && oDevTypeInfo.isBMSDomain() && null != DCFrameWorkUtil.getDCModuleManager() && null != DCFrameWorkUtil.getDCModuleManager().getTaskMgrMainPanel()) {
                isTaskPanelActivate = !DCFrameWorkUtil.getDCModuleManager().getTaskMgrMainPanel().isActivated();
                DCDebugTracer.trace("DC::DeviceXMLConfigModel#getDeviceTypeConfigModel" + isTaskPanelActivate);
            }
        }
        return oDeviceTypeConfigModel;
    }

    public IDeviceTypeConfigModel getDeviceTypeConfigModel(DeviceTypeInfo oDevTypeInfo, int[] iDeviceIdLst, boolean isLogDlg) {
        IDeviceTypeConfigModel oDeviceTypeConfigModel = null;
        String strKey = oDevTypeInfo.getDevTypeName() + StringUtils.removeRepeatPostfix(oDevTypeInfo.getDevTypeVersionName(), "_telnet");
        String strKeyForAllDomain = this.getStringKeyForAllDomain(oDevTypeInfo, iDeviceIdLst, strKey);
        oDeviceTypeConfigModel = (IDeviceTypeConfigModel)this.m_oDeviceConfigDataModelTable.get(strKeyForAllDomain);
        if (oDevTypeInfo.getDevDomain() == 2) {
            strKeyForAllDomain = oDevTypeInfo.getDevTypeName() + oDevTypeInfo.getDevTypeVersionName();
        }
        if (null == oDeviceTypeConfigModel) {
            try {
                if (!this.m_oServerCallRegister.contains(strKeyForAllDomain) || DCFrameWorkUtil.getIsNeedToSendCmdCode()) {
                    DeviceConfigModelCtrller.getInstance().getDeviceSpecificConfigInfo(oDevTypeInfo.getDevTypeName(), oDevTypeInfo.getDevTypeVersionName());
                    if (this.m_oServerCallRegister.contains(strKeyForAllDomain)) {
                        this.m_oServerCallRegister.remove(strKeyForAllDomain);
                    }
                    this.m_oServerCallRegister.add(strKeyForAllDomain);
                }
            }
            catch (DCException e) {
                if (this.m_oServerCallRegister.contains(strKeyForAllDomain)) {
                    this.m_oServerCallRegister.remove(strKeyForAllDomain);
                }
                this.m_oServerCallRegister.add(strKeyForAllDomain);
                DCDebugTracer.trace("DC: faild to get device type config info devcieType=" + oDevTypeInfo.getDevTypeName() + "strDeviceTypeVersion=" + oDevTypeInfo.getDevTypeVersionName() + e.getMessage());
                DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(0));
            }
            oDeviceTypeConfigModel = (IDeviceTypeConfigModel)this.m_oDeviceConfigDataModelTable.get(strKeyForAllDomain);
            if (null == oDeviceTypeConfigModel && oDevTypeInfo.isBMSDomain() && !oDevTypeInfo.getIscreateauto()) {
                DCDebugTracer.trace("DC: DeviceXMLConfigModel#getDeviceTypeConfigModel fail in" + strKeyForAllDomain + "->so use noraml XML Info");
                oDeviceTypeConfigModel = (IDeviceTypeConfigModel)this.m_oDeviceConfigDataModelTable.get(oDevTypeInfo.getDevTypeName() + oDevTypeInfo.getDevTypeVersionName());
                if (null != DCFrameWorkUtil.getTaskTablePanel() && DCFrameWorkUtil.getTaskTablePanel().isDevInTaskSubOperation()) {
                    DCFrameWorkUtil.getTaskTablePanel().setIsDevInTaskSubOperation(false);
                }
            }
            if (null == oDeviceTypeConfigModel && DCFrameWorkUtil.getIsNeedToSendCmdCode() && oDevTypeInfo.isBMSDomain()) {
                boolean isTaskPanelActivate = true;
                if (null != DCFrameWorkUtil.getDCModuleManager() && null != DCFrameWorkUtil.getDCModuleManager().getTaskMgrMainPanel()) {
                    boolean bl = isTaskPanelActivate = !DCFrameWorkUtil.getDCModuleManager().getTaskMgrMainPanel().isActivated();
                }
                if (isTaskPanelActivate && !isLogDlg) {
                    TaskAsynCommForSpecificConfInfoNotify.getInstance().showXMLNoFindDlg();
                    TaskAsynCommForSpecificConfInfoNotify.getInstance().setNotShowXMLDlg(false);
                }
            }
            DCFrameWorkUtil.setIsNeedToSendCmdCode(false);
        }
        return oDeviceTypeConfigModel;
    }

    public String getStringKeyForAllDomain(DeviceTypeInfo oDevTypeInfo, int[] iDeviceIdLst, String strKey) {
        ArrayList<DeviceInfo> oDevInfoLst = new ArrayList<DeviceInfo>();
        if (null != iDeviceIdLst) {
            for (int i = 0; i < iDeviceIdLst.length; ++i) {
                DeviceInfo oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDeviceIdLst[i]);
                oDevInfoLst.add(oDeviceInfo);
            }
        }
        this.bIsBmsAndeMxuDev = false;
        String strKeyForAllDomain = strKey;
        this.strKeyDevVer = strKey;
        String strDevVersion = null;
        String strPatchVersion = null;
        if (null != oDevTypeInfo && oDevTypeInfo.isBMSDomain() && oDevTypeInfo.getIscreateauto() && oDevInfoLst.size() > 0) {
            this.bIsBmsAndeMxuDev = true;
            DeviceInfo oDeviceInfo = (DeviceInfo)oDevInfoLst.get(0);
            if (null != oDeviceInfo) {
                DeviceVersionInfo oDeviceVersionInfo = oDeviceInfo.getDevVersion();
                if (null != oDeviceVersionInfo) {
                    strDevVersion = oDeviceVersionInfo.getDevVersion();
                    strPatchVersion = oDeviceVersionInfo.getPatchVersion();
                }
                if (null != strDevVersion) {
                    this.strKeyDevVer = strKeyForAllDomain = strKeyForAllDomain + strDevVersion;
                }
                if (null != strPatchVersion) {
                    strKeyForAllDomain = strKeyForAllDomain + strPatchVersion;
                }
            }
        }
        return strKeyForAllDomain;
    }

    public static synchronized IDeviceXMLConfigModel getInstance() {
        if (null == m_oDeviceXMLConfigModel) {
            m_oDeviceXMLConfigModel = new DeviceXMLConfigModel();
            DCObjectDestructor.getInstance().addObjectForDestructor((DeviceXMLConfigModel)m_oDeviceXMLConfigModel);
        }
        return m_oDeviceXMLConfigModel;
    }

    @Override
    public void setToNULL() {
        if (null != this.m_oDeviceConfigDataModelTable) {
            if (null != this.m_oServerCallRegister) {
                this.m_oServerCallRegister.clear();
            }
            if (null != this.m_oDeviceConfigDataModelTable) {
                this.m_oDeviceConfigDataModelTable.clear();
            }
            this.m_oDeviceConfigDataModelTable = null;
        }
        m_oDeviceXMLConfigModel = null;
    }

    @Override
    public IDeviceTypeConfigModel getDeviceTypeConfigModel(int deviceID) {
        DeviceTypeInfo oDeviceTypeInfo;
        IDeviceTypeConfigModel oDeviceXMLConfigModel = null;
        DeviceInfo oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(deviceID);
        if (null != oDeviceInfo && null != (oDeviceTypeInfo = oDeviceInfo.getDeviceTypeInfo())) {
            int[] iDeviceIdLst = new int[]{deviceID};
            oDeviceXMLConfigModel = this.getDeviceTypeConfigModel(oDeviceTypeInfo, iDeviceIdLst);
            if (null == oDeviceXMLConfigModel && DCFrameWorkUtil.getIsNeedToSendCmdCode() && oDeviceTypeInfo.isBMSDomain()) {
                TaskAsynCommForSpecificConfInfoNotify.getInstance().updateDeviceStatusToBusy(oDeviceInfo);
            } else {
                TaskAsynCommForSpecificConfInfoNotify.getInstance().clearDeviceStatusToIdle(oDeviceInfo);
            }
        }
        return oDeviceXMLConfigModel;
    }

    @Override
    public IDeviceTypeConfigModel getDeviceTypeConfigModel(int deviceID, boolean isLogDlg) {
        DeviceTypeInfo oDeviceTypeInfo;
        IDeviceTypeConfigModel oDeviceXMLConfigModel = null;
        DeviceInfo oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(deviceID);
        if (null != oDeviceInfo && null != (oDeviceTypeInfo = oDeviceInfo.getDeviceTypeInfo())) {
            int[] iDeviceIdLst = new int[]{deviceID};
            oDeviceXMLConfigModel = this.getDeviceTypeConfigModel(oDeviceTypeInfo, iDeviceIdLst, isLogDlg);
        }
        return oDeviceXMLConfigModel;
    }

    @Override
    public List getContentTypesFromXMLConfig(DeviceTypeInfo oDevTypeInfo, int iOperationID, int[] iDeviceIdLst) {
        List<Object> oContTypeLst = null;
        IDeviceTypeConfigModel deviceTypeConfigModel = this.getDeviceTypeConfigModel(oDevTypeInfo, iDeviceIdLst);
        if (null != deviceTypeConfigModel) {
            IOperation oOperationObj = deviceTypeConfigModel.getOperationObj(1, iOperationID);
            if (null == oOperationObj) {
                return null;
            }
            IParaList oGetoPerationParaList = oOperationObj.getoPerationParaList();
            Object[] arrParaVals = ParamUtil.getInstance().getContentTypeList(oGetoPerationParaList);
            if (null != arrParaVals) {
                oContTypeLst = Arrays.asList(arrParaVals);
            }
        }
        return oContTypeLst;
    }

    @Override
    public List getContentTypesFromXMLConfig(DeviceType oDeviceType, int iOperationID, int[] iDeviceIdLst) {
        List<Object> oContTypeLst = null;
        IDeviceTypeConfigModel deviceTypeConfigModel = this.getDeviceTypeConfigModel(oDeviceType.getDeviceTypeInfo(), iDeviceIdLst);
        if (null != deviceTypeConfigModel) {
            IOperation oOperationObj = deviceTypeConfigModel.getOperationObj(1, iOperationID);
            if (null == oOperationObj) {
                return null;
            }
            IParaList oGetoPerationParaList = oOperationObj.getoPerationParaList();
            Object[] arrParaVals = ParamUtil.getInstance().getContentTypeList(oGetoPerationParaList);
            if (null != arrParaVals) {
                oContTypeLst = Arrays.asList(arrParaVals);
            }
        }
        return oContTypeLst;
    }

    @Override
    public Vector<String> getServerCallRegister() {
        return this.m_oServerCallRegister;
    }

    public void setbIsBmsAndeMxuDev(boolean m_bIsBmsAndeMxuDev) {
        this.bIsBmsAndeMxuDev = m_bIsBmsAndeMxuDev;
    }

    public boolean getbIsBmsAndeMxuDev() {
        return this.bIsBmsAndeMxuDev;
    }
}

