/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.model.xmlconfig;

import com.huawei.dc.common.framework.utility.CloneUtil;
import com.huawei.dc.devicemanagement.deviceoperation.ICheckOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IOperation;
import com.huawei.dc.devicemanagement.deviceoperation.IOtherOperation;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.model.GUITempleteInfo;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IOperationConfig;
import com.huawei.dc.devicemanagement.model.xmlconfig.IPatchConfig;
import com.huawei.dc.devicemanagement.model.xmlconfig.ITaskTypeConfiguration;
import com.huawei.dc.devicemanagement.model.xmlconfig.IViewConfiguration;
import java.util.List;

public class DeviceTypeConfigModel
implements IDeviceTypeConfigModel {
    private String m_strDeviceType;
    private String m_strDeviceTypeVersion;
    private IOperationConfig m_oOperationConfig;
    private ITaskTypeConfiguration m_oTaskTypeConfiguration;
    private IViewConfiguration m_oViewConfiguration;
    private IPatchConfig m_oPatchConfig = null;
    private GUITempleteInfo strGuiTempleteInfo;

    @Override
    public String getDeviceType() {
        return this.m_strDeviceType;
    }

    @Override
    public String getDeviceTypeVersion() {
        return this.m_strDeviceTypeVersion;
    }

    @Override
    public IOperationConfig getOperationConfiguration() {
        return this.m_oOperationConfig;
    }

    @Override
    public IOperation getOperationObj(int iOperationType, int iOperationId) {
        IOperation oOperation = null;
        switch (iOperationType) {
            case 0: {
                oOperation = this.getDevOperation(iOperationId);
                break;
            }
            case 1: {
                oOperation = this.getTaskDevOperation(iOperationId);
                break;
            }
            case 5: {
                oOperation = this.getOtherOperation(iOperationId);
                break;
            }
            case 2: {
                oOperation = this.getPatchOperation(iOperationId);
                break;
            }
            case 6: {
                oOperation = this.getUpgradeOperation(iOperationId);
            }
        }
        return oOperation;
    }

    private IOperation getUpgradeOperation(int iOperationId) {
        return this.m_oOperationConfig.getUpgradeOperation(iOperationId);
    }

    @Override
    public IOperation getOperationObjFrmModel(int iOperationId) {
        IOperation oOperation = null;
        oOperation = this.getTaskDevOperation(iOperationId);
        if (null != oOperation) {
            return oOperation;
        }
        oOperation = this.getPatchOperation(iOperationId);
        if (null != oOperation) {
            return oOperation;
        }
        oOperation = this.getCheckOperObj(iOperationId);
        if (null != oOperation) {
            return oOperation;
        }
        oOperation = this.getUpgradeOperation(iOperationId);
        if (null != oOperation) {
            return oOperation;
        }
        return oOperation;
    }

    private IOperation getPatchOperation(int iOperationId) {
        return this.m_oOperationConfig.getPatchOperation(iOperationId);
    }

    private IDeviceOperation getDevOperation(int iOperationId) {
        return this.m_oOperationConfig.getDeviceOperation(iOperationId);
    }

    private ITaskDeviceOperation getTaskDevOperation(int iOperationId) {
        return this.m_oOperationConfig.getTaskOperation(iOperationId);
    }

    private IOtherOperation getOtherOperation(int iOperationID) {
        return this.m_oOperationConfig.getOtherOperation(iOperationID);
    }

    @Override
    public void setOperationConfiguration(IOperationConfig operationConfig) {
        this.m_oOperationConfig = operationConfig;
    }

    @Override
    public ITaskTypeConfiguration getTaskTaskTypeConfiguration() {
        return this.m_oTaskTypeConfiguration;
    }

    @Override
    public IViewConfiguration getViewConfiguration() {
        return this.m_oViewConfiguration;
    }

    @Override
    public void setViewConfiguration(IViewConfiguration viewConfiguration) {
        this.m_oViewConfiguration = viewConfiguration;
    }

    @Override
    public void setDeviceType(String strDeviceType) {
        this.m_strDeviceType = strDeviceType;
    }

    @Override
    public void setDeviceTypeVersion(String strDeviceTypeVersion) {
        this.m_strDeviceTypeVersion = strDeviceTypeVersion;
    }

    @Override
    public void setTaskTaskTypeConfiguration(ITaskTypeConfiguration oTaskTypeConfiguration) {
        this.m_oTaskTypeConfiguration = oTaskTypeConfiguration;
    }

    @Override
    public IPatchConfig getPatchConfiguration() {
        return this.m_oPatchConfig;
    }

    @Override
    public void setPatchConfiguration(IPatchConfig oPatchConfig) {
        this.m_oPatchConfig = oPatchConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        List lst = this.m_oOperationConfig.getTaskOperation();
        sb.append(" Task Configure information ");
        sb.append(this.m_strDeviceType);
        sb.append(this.m_strDeviceTypeVersion);
        if (null != lst) {
            for (ITaskDeviceOperation info : lst) {
                sb.append(System.getProperty("line.separator"));
                sb.append(info.getOperationName());
            }
        }
        return sb.toString();
    }

    @Override
    public IOperation getCloneOperationObj(int iOperationType, int iOperationId) {
        IOperation operationObj = this.getOperationObj(iOperationType, iOperationId);
        Object oClonedOperation = CloneUtil.getClone(operationObj);
        return (IOperation)oClonedOperation;
    }

    @Override
    public IOperation getCheckCloneOperObjForPatchTask(int iOperationId) {
        IOperation operationObj = this.getCheckOperObjForPatchTask(iOperationId);
        Object oClonedOperation = CloneUtil.getClone(operationObj);
        return (IOperation)oClonedOperation;
    }

    @Override
    public IOperation getCheckOperObjForPatchTask(int iOperationId) {
        return this.getCheckOperObj(iOperationId, true);
    }

    @Override
    public IOperation getCheckCloneOperObj(int iOperationId) {
        IOperation operationObj = this.getCheckOperObj(iOperationId);
        Object oClonedOperation = CloneUtil.getClone(operationObj);
        return (IOperation)oClonedOperation;
    }

    @Override
    public IOperation getCheckOperObj(int iOperationId) {
        return this.getCheckOperObj(iOperationId, false);
    }

    private IOperation getCheckOperObj(int iOperationId, boolean isPatch) {
        List checkOpeLst = this.m_oOperationConfig.getCheckOperationList();
        ICheckOperation checkOperation = null;
        if (null == checkOpeLst || 0 == checkOpeLst.size()) {
            return checkOperation;
        }
        int iSize = checkOpeLst.size();
        boolean isTaskTypeCorrect = false;
        for (int iIndex = 0; iIndex < iSize; ++iIndex) {
            ICheckOperation oCheckbject = (ICheckOperation)checkOpeLst.get(iIndex);
            if (iOperationId != oCheckbject.getOperationId()) continue;
            if (isPatch) {
                isTaskTypeCorrect = oCheckbject.getCheckTaskType() == 2;
            } else {
                boolean bl = isTaskTypeCorrect = oCheckbject.getCheckTaskType() != 2;
            }
            if (!isTaskTypeCorrect) continue;
            checkOperation = oCheckbject;
            break;
        }
        return checkOperation;
    }

    @Override
    public GUITempleteInfo getGuiTempleteInfo() {
        return this.strGuiTempleteInfo;
    }

    @Override
    public void setGuiTempleteInfo(GUITempleteInfo oGuiTempleteInfo) {
        this.strGuiTempleteInfo = oGuiTempleteInfo;
    }
}

