/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.model.deviceinfo;

import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.policy.model.DevicePolicyState;
import com.huawei.dc.policy.model.PolicyInfo;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntHashingStrategy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SubMapInfo
implements Serializable {
    private static final long serialVersionUID = 8564066089574431733L;
    public int m_iSubMapTypeID;
    public String m_strSubMapID;
    public String m_strSubMapDN;
    public String m_strSubMapName;
    public String m_strParentSubMapID = "";
    public LinkedList<SubMapInfo> m_SubMapList = new LinkedList();
    public TIntHashSet m_oSubMapDevIDLst = new TIntHashSet();
    private boolean m_bContainsOLT = false;

    public String toString() {
        return "SubMapInfo [m_SubMapList=" + this.m_SubMapList + ", m_iSubMapTypeID=" + this.m_iSubMapTypeID + ", m_oSubMapDevIDLst=" + this.printDevLst(this.m_oSubMapDevIDLst) + ", m_strParentSubMapID=" + this.m_strParentSubMapID + ", m_strSubMapID=" + this.m_strSubMapID + ", m_strSubMapName=" + this.m_strSubMapName + ", m_strSubMapDN=" + this.m_strSubMapDN + "]";
    }

    private String printDevLst(TIntHashSet m_oSubMapDevIDLst) {
        StringBuffer str = new StringBuffer();
        for (int i : m_oSubMapDevIDLst) {
            str.append("/");
            str.append(i);
            str.append("/");
        }
        return str.toString();
    }

    public SubMapInfo filterSubmapInfo(Set oDNSubMapIDLst) {
        if (null == oDNSubMapIDLst || oDNSubMapIDLst.size() < 1) {
            return this;
        }
        SubMapInfo subMapInfo = new SubMapInfo();
        subMapInfo.m_strSubMapID = this.m_strSubMapID;
        subMapInfo.m_strSubMapDN = this.m_strSubMapDN;
        subMapInfo.m_strSubMapName = this.m_strSubMapName;
        subMapInfo.m_iSubMapTypeID = this.m_iSubMapTypeID;
        subMapInfo.m_strParentSubMapID = this.m_strParentSubMapID;
        if (oDNSubMapIDLst.contains(this.m_strSubMapID) || subMapInfo.m_iSubMapTypeID == 10101) {
            subMapInfo.m_oSubMapDevIDLst = this.m_oSubMapDevIDLst;
        }
        SubMapInfo temp = null;
        for (int i = 0; i < this.m_SubMapList.size(); ++i) {
            temp = this.m_SubMapList.get(i).filterSubmapInfo(oDNSubMapIDLst);
            if (!oDNSubMapIDLst.contains(temp.m_strSubMapID)) {
                if (!temp.m_bContainsOLT) continue;
                subMapInfo.m_bContainsOLT = true;
                subMapInfo.m_SubMapList.add(temp);
                continue;
            }
            if (subMapInfo.m_iSubMapTypeID != 10101) continue;
            subMapInfo.m_bContainsOLT = true;
            subMapInfo.m_oSubMapDevIDLst.addAll(temp.m_oSubMapDevIDLst.toArray());
        }
        return subMapInfo;
    }

    public SubMapInfo filterMXUSubmapInfo(Set mxuSubMapIDLst) {
        if (null == mxuSubMapIDLst || mxuSubMapIDLst.size() < 1) {
            return this;
        }
        SubMapInfo subMapInfo = new SubMapInfo();
        subMapInfo.m_strSubMapID = this.m_strSubMapID;
        subMapInfo.m_strSubMapName = this.m_strSubMapName;
        subMapInfo.m_iSubMapTypeID = this.m_iSubMapTypeID;
        subMapInfo.m_strParentSubMapID = this.m_strParentSubMapID;
        for (int deviceID : this.m_oSubMapDevIDLst) {
            if (!mxuSubMapIDLst.contains(deviceID)) continue;
            subMapInfo.m_oSubMapDevIDLst.add(deviceID);
        }
        SubMapInfo temp = null;
        for (int i = 0; i < this.m_SubMapList.size(); ++i) {
            temp = this.m_SubMapList.get(i).filterMXUSubmapInfo(mxuSubMapIDLst);
            if (temp.m_oSubMapDevIDLst.size() <= 0 && temp.m_SubMapList.size() <= 0) continue;
            subMapInfo.m_SubMapList.add(temp);
        }
        return subMapInfo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_strParentSubMapID == null ? 0 : this.m_strParentSubMapID.hashCode());
        result = 31 * result + (this.m_strSubMapID == null ? 0 : this.m_strSubMapID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubMapInfo other = (SubMapInfo)obj;
        if (this.m_strParentSubMapID == null ? other.m_strParentSubMapID != null : !this.m_strParentSubMapID.equals(other.m_strParentSubMapID)) {
            return false;
        }
        return !(this.m_strSubMapID == null ? other.m_strSubMapID != null : !this.m_strSubMapID.equals(other.m_strSubMapID));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.m_oSubMapDevIDLst = new TIntHashSet();
        in.defaultReadObject();
    }

    public SubMapInfo cloneSubmap() {
        SubMapInfo oCloneSubmap = new SubMapInfo();
        oCloneSubmap.m_iSubMapTypeID = this.m_iSubMapTypeID;
        oCloneSubmap.m_strSubMapID = this.m_strSubMapID;
        oCloneSubmap.m_strSubMapDN = this.m_strSubMapDN;
        oCloneSubmap.m_strSubMapName = this.m_strSubMapName;
        oCloneSubmap.m_strParentSubMapID = this.m_strParentSubMapID;
        oCloneSubmap.m_SubMapList = new LinkedList();
        Iterator oSubmapItr = this.m_SubMapList.iterator();
        SubMapInfo tmpSubMapInfo = null;
        while (oSubmapItr.hasNext()) {
            tmpSubMapInfo = (SubMapInfo)oSubmapItr.next();
            if (null == tmpSubMapInfo) continue;
            oCloneSubmap.m_SubMapList.add(tmpSubMapInfo.cloneSubmap());
        }
        oCloneSubmap.m_oSubMapDevIDLst = new TIntHashSet((TIntHashingStrategy)this.m_oSubMapDevIDLst);
        oCloneSubmap.m_oSubMapDevIDLst = (TIntHashSet)this.m_oSubMapDevIDLst.clone();
        return oCloneSubmap;
    }

    public SubMapInfo getSubmapInfo(TIntHashSet oDevIDLst) {
        if (null == oDevIDLst || oDevIDLst.size() == 0) {
            return null;
        }
        SubMapInfo subMapInfo = new SubMapInfo();
        subMapInfo.m_strSubMapID = this.m_strSubMapID;
        subMapInfo.m_strSubMapDN = this.m_strSubMapDN;
        subMapInfo.m_strSubMapName = this.m_strSubMapName;
        subMapInfo.m_strParentSubMapID = this.m_strParentSubMapID;
        subMapInfo.m_oSubMapDevIDLst = this.m_oSubMapDevIDLst;
        SubMapInfo oTmpSubmap = null;
        for (SubMapInfo oSub : this.m_SubMapList) {
            boolean bContains;
            if (null == oSub || null == (oTmpSubmap = oSub.getSubmapInfo(oDevIDLst)) || !(bContains = oTmpSubmap.bContainsDevs(oDevIDLst))) continue;
            subMapInfo.m_SubMapList.add(oTmpSubmap);
        }
        return subMapInfo;
    }

    public SubMapInfo getSubmapInfo(PolicyInfo oPolicyInfo, TIntHashSet oDevIDLst) {
        if (null == oDevIDLst || oDevIDLst.size() == 0) {
            return null;
        }
        SubMapInfo subMapInfo = new SubMapInfo();
        subMapInfo.m_strSubMapID = this.m_strSubMapID;
        subMapInfo.m_strSubMapDN = this.m_strSubMapDN;
        subMapInfo.m_strSubMapName = this.m_strSubMapName;
        subMapInfo.m_strParentSubMapID = this.m_strParentSubMapID;
        subMapInfo.m_oSubMapDevIDLst = this.m_oSubMapDevIDLst;
        SubMapInfo oTmpSubmap = null;
        for (SubMapInfo oSub : this.m_SubMapList) {
            boolean bContains;
            if (null == oSub || null == (oTmpSubmap = oSub.getSubmapInfo(oPolicyInfo, oDevIDLst)) || !(bContains = oTmpSubmap.bContainsDevs(oPolicyInfo, oTmpSubmap.m_strSubMapID, oDevIDLst))) continue;
            subMapInfo.m_SubMapList.add(oTmpSubmap);
        }
        return subMapInfo;
    }

    public SubMapInfo getSubmapInfoByPoliyInfo(PolicyInfo oPolicyInfo) {
        DCDebugTracer.trace("Mark::SubMapInfo::getSubmapInfoBySubMapIDVec::begin");
        HashMap<String, TIntHashSet> oDevListForSubMap = oPolicyInfo.getDevListForEverySubnet();
        if (null == oDevListForSubMap || oDevListForSubMap.size() == 0) {
            return null;
        }
        SubMapInfo subMapInfo = new SubMapInfo();
        subMapInfo.m_strSubMapID = this.m_strSubMapID;
        subMapInfo.m_strSubMapDN = this.m_strSubMapDN;
        subMapInfo.m_strSubMapName = this.m_strSubMapName;
        subMapInfo.m_strParentSubMapID = this.m_strParentSubMapID;
        if (null != oDevListForSubMap.get(subMapInfo.m_strSubMapID)) {
            subMapInfo.m_oSubMapDevIDLst.addAll(oDevListForSubMap.get(subMapInfo.m_strSubMapID).toArray());
        }
        SubMapInfo oTmpSubmap = null;
        for (SubMapInfo oSub : this.m_SubMapList) {
            TIntHashSet oDevIDSet;
            if (null == oSub || null == (oTmpSubmap = oSub.getSubmapInfoByPoliyInfo(oPolicyInfo))) continue;
            if (oDevListForSubMap.containsKey(oTmpSubmap.m_strSubMapID)) {
                subMapInfo.m_SubMapList.add(oTmpSubmap);
                if (oTmpSubmap.m_oSubMapDevIDLst.size() <= 0) continue;
                subMapInfo.m_oSubMapDevIDLst.addAll(oTmpSubmap.m_oSubMapDevIDLst.toArray());
                if (null != oDevListForSubMap.get(subMapInfo.m_strSubMapID)) {
                    oDevListForSubMap.get(subMapInfo.m_strSubMapID).addAll(oTmpSubmap.m_oSubMapDevIDLst.toArray());
                    continue;
                }
                oDevIDSet = new TIntHashSet();
                oDevIDSet.addAll(oTmpSubmap.m_oSubMapDevIDLst.toArray());
                oDevListForSubMap.put(subMapInfo.m_strSubMapID, oDevIDSet);
                continue;
            }
            if (oTmpSubmap.m_SubMapList.size() <= 0) continue;
            subMapInfo.m_SubMapList.add(oTmpSubmap);
            if (oTmpSubmap.m_oSubMapDevIDLst.size() <= 0) continue;
            subMapInfo.m_oSubMapDevIDLst.addAll(oTmpSubmap.m_oSubMapDevIDLst.toArray());
            if (null != oDevListForSubMap.get(subMapInfo.m_strSubMapID)) {
                oDevListForSubMap.get(subMapInfo.m_strSubMapID).addAll(oTmpSubmap.m_oSubMapDevIDLst.toArray());
                continue;
            }
            oDevIDSet = new TIntHashSet();
            oDevIDSet.addAll(oTmpSubmap.m_oSubMapDevIDLst.toArray());
            oDevListForSubMap.put(subMapInfo.m_strSubMapID, oDevIDSet);
        }
        DCDebugTracer.trace("Mark::SubMapInfo::getSubmapInfoBySubMapIDVec::end");
        return subMapInfo;
    }

    public SubMapInfo getSubmapInfo2(TIntArrayList devIDLst) {
        DCDebugTracer.trace("DC::SubMapInfo::getSubmapInfo is start");
        long starttime = System.currentTimeMillis();
        IDeviceInfoManager iDeviceInfoManager = DeviceInfoManagerImpl.getInstance();
        SubMapInfo oMainSubmap = iDeviceInfoManager.getSubMapInfo();
        Map<Integer, SubMapInfo> subMap = iDeviceInfoManager.getSubMapList();
        SubMapInfo rtnSubMapInfo = new SubMapInfo();
        rtnSubMapInfo.m_strSubMapID = oMainSubmap.m_strSubMapID;
        rtnSubMapInfo.m_strSubMapDN = oMainSubmap.m_strSubMapDN;
        rtnSubMapInfo.m_strSubMapName = oMainSubmap.m_strSubMapName;
        rtnSubMapInfo.m_strParentSubMapID = oMainSubmap.m_strParentSubMapID;
        rtnSubMapInfo.m_oSubMapDevIDLst = oMainSubmap.m_oSubMapDevIDLst;
        if (null == subMap || subMap.isEmpty() || null == devIDLst || devIDLst.isEmpty()) {
            return null;
        }
        SubMapInfo tempSubMapInfo = null;
        ArrayList<String> parentMapIDlList = new ArrayList<String>();
        for (int i = 0; i < devIDLst.size(); ++i) {
            SubMapInfo parSubMap;
            boolean flag = false;
            SubMapInfo oDestSubMapInfo = subMap.get(devIDLst.get(i));
            if (null == oDestSubMapInfo) continue;
            String parentID = oDestSubMapInfo.m_strParentSubMapID;
            String mapId = oDestSubMapInfo.m_strSubMapID;
            if (parentMapIDlList.contains(mapId)) {
                parSubMap = iDeviceInfoManager.getSubmapForID(mapId, rtnSubMapInfo);
                if (null != parSubMap) {
                    parSubMap.getSubMapDevIDLst().add(devIDLst.get(i));
                    continue;
                }
                DCDebugTracer.trace("DC::SubMapInfo::getSubmapInfo is SubMapInfo null  mapID: " + mapId + "  devID:" + devIDLst.get(i));
            } else if (!parentMapIDlList.contains(mapId)) {
                parentMapIDlList.add(mapId);
            }
            if (parentMapIDlList.contains(parentID)) {
                parSubMap = iDeviceInfoManager.getSubmapForID(parentID, rtnSubMapInfo);
                if (null != parSubMap && !parSubMap.m_SubMapList.contains(oDestSubMapInfo)) {
                    parSubMap.m_SubMapList.add(oDestSubMapInfo);
                    continue;
                }
                DCDebugTracer.trace("parentID: " + parentID + " :: " + rtnSubMapInfo.toString());
                continue;
            }
            while (null != parentID && !"".equals(parentID)) {
                if (!parentMapIDlList.contains(parentID)) {
                    parentMapIDlList.add(parentID);
                }
                tempSubMapInfo = new SubMapInfo();
                SubMapInfo parSubMapInfo = iDeviceInfoManager.getParentSubmap(oMainSubmap, oDestSubMapInfo);
                tempSubMapInfo.m_strSubMapID = parSubMapInfo.m_strSubMapID;
                tempSubMapInfo.m_strSubMapDN = parSubMapInfo.m_strSubMapDN;
                tempSubMapInfo.m_strSubMapName = parSubMapInfo.m_strSubMapName;
                tempSubMapInfo.m_strParentSubMapID = parSubMapInfo.m_strParentSubMapID;
                tempSubMapInfo.m_oSubMapDevIDLst = parSubMapInfo.m_oSubMapDevIDLst;
                if (oDestSubMapInfo.m_SubMapList.size() > 0 && !"".equals(tempSubMapInfo.m_strParentSubMapID)) {
                    oDestSubMapInfo.m_SubMapList.clear();
                }
                if (!tempSubMapInfo.m_SubMapList.contains(oDestSubMapInfo)) {
                    tempSubMapInfo.m_SubMapList.add(oDestSubMapInfo);
                }
                parentID = parSubMapInfo.m_strParentSubMapID;
                oDestSubMapInfo = tempSubMapInfo;
                if (!parentMapIDlList.contains(parentID)) continue;
                SubMapInfo parSubMap2 = iDeviceInfoManager.getSubmapForID(parentID, rtnSubMapInfo);
                if (!parSubMap2.m_SubMapList.contains(oDestSubMapInfo)) {
                    parSubMap2.m_SubMapList.add(oDestSubMapInfo);
                }
                flag = true;
                break;
            }
            if (flag || rtnSubMapInfo.m_SubMapList.contains(tempSubMapInfo)) continue;
            rtnSubMapInfo.m_SubMapList.add(tempSubMapInfo);
        }
        long endtime = System.currentTimeMillis();
        DCDebugTracer.trace("DC::SubMapInfo::getSubmapInfo is time: " + (endtime - starttime));
        DCDebugTracer.trace("DC::SubMapInfo::getSubmapInfo is end");
        return rtnSubMapInfo;
    }

    public boolean bContainsDevs(TIntHashSet oDevIDLst) {
        boolean bCotains = false;
        int iDevID2 = 0;
        for (int iDevID2 : oDevIDLst) {
            if (!this.m_oSubMapDevIDLst.contains(iDevID2)) continue;
            return true;
        }
        for (SubMapInfo oSubmap : this.m_SubMapList) {
            boolean bContains;
            if (null == oSubmap || !(bContains = oSubmap.bContainsDevs(oDevIDLst))) continue;
            bCotains = true;
            break;
        }
        return bCotains;
    }

    public boolean bContainsDevs(PolicyInfo oPolicyInfo, String strSubMapId, TIntHashSet oDevIDLst) {
        boolean bCotains = false;
        int iDevID2 = 0;
        for (int iDevID2 : oDevIDLst) {
            if (!this.m_oSubMapDevIDLst.contains(iDevID2)) continue;
            DevicePolicyState oPolicyState = oPolicyInfo.getDevicePolicyState(iDevID2);
            if (null != oPolicyState) {
                oPolicyState.setSubMapId(strSubMapId);
            }
            return true;
        }
        for (SubMapInfo oSubmap : this.m_SubMapList) {
            boolean bContains;
            if (null == oSubmap || !(bContains = oSubmap.bContainsDevs(oDevIDLst))) continue;
            bCotains = true;
            break;
        }
        return bCotains;
    }

    public boolean bContainsSubMap(String strSubMapID) {
        boolean bCotains = false;
        if (this.m_strSubMapID.equals(strSubMapID)) {
            return true;
        }
        for (SubMapInfo oSubmap : this.m_SubMapList) {
            boolean bContains;
            if (null == oSubmap || !(bContains = oSubmap.bContainsSubMap(strSubMapID))) continue;
            bCotains = true;
            break;
        }
        return bCotains;
    }

    public TIntHashSet getSubMapDevIDLst() {
        return this.m_oSubMapDevIDLst;
    }

    public boolean bContainsDev(int iDevID) {
        boolean bCotains = false;
        if (this.m_oSubMapDevIDLst.contains(iDevID)) {
            return true;
        }
        for (SubMapInfo oSubmap : this.m_SubMapList) {
            boolean bContains;
            if (null == oSubmap || !(bContains = oSubmap.bContainsDev(iDevID))) continue;
            bCotains = true;
            break;
        }
        return bCotains;
    }

    public void getOltSubmapIDLst(List<String> oSubmapIDLSt) {
        if (this.m_iSubMapTypeID == 10101) {
            oSubmapIDLSt.add(this.m_strSubMapID);
        }
        for (SubMapInfo oSub : this.m_SubMapList) {
            oSub.getOltSubmapIDLst(oSubmapIDLSt);
        }
    }

    public void clear() {
        this.m_strSubMapID = null;
        this.m_strSubMapDN = null;
        this.m_strSubMapName = null;
        this.m_strParentSubMapID = null;
        if (null != this.m_SubMapList) {
            this.m_SubMapList.clear();
        }
        if (null != this.m_oSubMapDevIDLst) {
            this.m_oSubMapDevIDLst.clear();
        }
    }
}

