/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.devicemanagement.model;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.ContentTypeMgr;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DeviceType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_strDeviceTypeName = null;
    private int m_iDeviceTypeID = -1;
    private String m_strDeviceTypeVersionName = null;
    private int m_iDeviceTypeVersionID = -1;
    THashSet<Resource> m_oResourceList = new THashSet();
    private ContentTypeMgr m_oContentTypeMgr = null;
    private int m_iDeviceDomain = -1;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_iDeviceTypeID;
        result = 31 * result + this.m_iDeviceTypeVersionID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceType other = (DeviceType)obj;
        if (this.m_iDeviceTypeID != other.m_iDeviceTypeID) {
            return false;
        }
        return this.m_iDeviceTypeVersionID == other.m_iDeviceTypeVersionID;
    }

    public String getDeviceTypeName() {
        return this.m_strDeviceTypeName;
    }

    public void setDeviceTypeName(String deviceTypeName) {
        this.m_strDeviceTypeName = deviceTypeName;
    }

    public int getDeviceTypeID() {
        return this.m_iDeviceTypeID;
    }

    public void setDeviceTypeID(int deviceTypeID) {
        this.m_iDeviceTypeID = deviceTypeID;
        this.setDeviceDomain();
    }

    public String getDeviceTypeVersionName() {
        return this.m_strDeviceTypeVersionName;
    }

    public int[] getDeviceIdlst(DeviceType oDevType) {
        if (null == this.m_oResourceList || 0 == this.m_oResourceList.size()) {
            return null;
        }
        Iterator oResItor = this.m_oResourceList.iterator();
        Resource oResource = null;
        DeviceTypeInfo oDeviceTypeInfo = null;
        DeviceTypeInfo oDeviceTypeInfotmp = null;
        DeviceInfo oDeviceInfo = null;
        if (null != oDevType) {
            oDeviceTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(oDevType.getDeviceTypeID(), oDevType.getDeviceTypeVersionID());
        }
        int[] iDeviceIdLst = new int[this.m_oResourceList.size()];
        int i = 0;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            iDeviceIdLst[i] = oResource.getDeviceID();
            oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDeviceIdLst[i]);
            if (null != oDeviceInfo) {
                oDeviceTypeInfotmp = oDeviceInfo.getDeviceTypeInfo();
            }
            if (null != oDeviceTypeInfo && null != oDeviceTypeInfotmp && oDeviceTypeInfo.equals(oDeviceTypeInfotmp)) {
                iDeviceIdLst = new int[]{oResource.getDeviceID()};
                return iDeviceIdLst;
            }
            ++i;
        }
        return iDeviceIdLst;
    }

    public void setDeviceTypeVersionName(String deviceTypeVersionName) {
        DeviceTypeInfo oTypeInfo;
        if (null == deviceTypeVersionName) {
            DCDebugTracer.trace("DeviceType#setDeviceTypeVersionName:deviceTypeVersionName is null");
        }
        this.m_strDeviceTypeVersionName = ResourceManager.getInstance().getResString("DEVICE_TYPE_VERSION_ALL").equals(deviceTypeVersionName) ? StringUtils.removePostfix(StringUtils.removePostfix(StringUtils.removeRepeatPostfix(deviceTypeVersionName, "_telnet"), "_telnet"), "_telnet") : (this.getDeviceDomain() != 2 ? StringUtils.removePostfix(StringUtils.removePostfix(StringUtils.removeRepeatPostfix(deviceTypeVersionName, "_telnet"), "_telnet"), "_telnet") : (null != (oTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(this.m_iDeviceTypeID, this.m_iDeviceTypeVersionID)) && oTypeInfo.isSNMPType() ? StringUtils.removePostfix(deviceTypeVersionName, "_telnet") : deviceTypeVersionName));
    }

    public int getDeviceTypeVersionID() {
        return this.m_iDeviceTypeVersionID;
    }

    public void setDeviceTypeVersionID(int deviceTypeVersionID) {
        this.m_iDeviceTypeVersionID = deviceTypeVersionID;
        this.setDeviceDomain();
    }

    public synchronized THashSet<Resource> getResources() {
        return this.m_oResourceList;
    }

    public Resource getFirstResource() {
        Iterator oResItor = this.m_oResourceList.iterator();
        if (oResItor.hasNext()) {
            return (Resource)oResItor.next();
        }
        DCDebugTracer.trace("failed to get  first resource");
        return null;
    }

    public synchronized void setResources(THashSet<Resource> oResHs) {
        this.m_oResourceList = oResHs;
    }

    public synchronized void clearResources() {
        this.m_oResourceList = null;
        this.m_oResourceList = new THashSet();
    }

    public void addResource(Resource oResource) {
        if (null != oResource && !this.m_oResourceList.contains((Object)oResource)) {
            this.m_oResourceList.add((Object)oResource);
        }
    }

    public ContentTypeMgr getContentTypeMgr() {
        return this.m_oContentTypeMgr;
    }

    public void setContentTypeMgr(ContentTypeMgr contentTypeMgr) {
        this.m_oContentTypeMgr = contentTypeMgr;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public Resource getResource(int iDeviceID, int iFrameId, int iSlotId) {
        Resource oResource = null;
        Iterator oResItor = this.m_oResourceList.iterator();
        Resource oTempRes = null;
        while (oResItor.hasNext()) {
            oTempRes = (Resource)oResItor.next();
            if (oTempRes.getDeviceID() != iDeviceID || iFrameId != oTempRes.getFrameId() || oTempRes.getSlotId() != iSlotId) continue;
            oResource = oTempRes;
            break;
        }
        return oResource;
    }

    public Resource getResource(int iDeviceID) {
        Resource oResource = null;
        Iterator oResItor = this.m_oResourceList.iterator();
        Resource oTempRes = null;
        while (oResItor.hasNext()) {
            oTempRes = (Resource)oResItor.next();
            if (oTempRes.getDeviceID() != iDeviceID) continue;
            oResource = oTempRes;
            break;
        }
        return oResource;
    }

    public Resource getResource(int iDeviceID, int iStackID) {
        Resource oResource = null;
        Iterator oResItor = this.m_oResourceList.iterator();
        Resource oTempRes = null;
        while (oResItor.hasNext()) {
            oTempRes = (Resource)oResItor.next();
            if (oTempRes.getDeviceID() != iDeviceID || oTempRes.getStackId() != iStackID) continue;
            oResource = oTempRes;
            break;
        }
        return oResource;
    }

    public boolean isUpgradeModeSupportedByAllDevices(int iUpgradeMode) {
        boolean isUpgradeModeSupportedByAllDevices = true;
        Iterator oResItor = this.m_oResourceList.iterator();
        Resource oTempRes = null;
        int iSize = this.m_oResourceList.size();
        while (oResItor.hasNext()) {
            oTempRes = (Resource)oResItor.next();
            if (-1 != oTempRes.getUpgradeMode() && 0 != (oTempRes.getUpgradeMode() & iUpgradeMode)) continue;
            isUpgradeModeSupportedByAllDevices = false;
            break;
        }
        if (0 == iSize) {
            isUpgradeModeSupportedByAllDevices = false;
        }
        return isUpgradeModeSupportedByAllDevices;
    }

    public boolean isUpgradeModeSupportedByAnyOneOfDevice(int iUpgradeMode) {
        boolean isUpgradeModeSupportedByAnyOneOfDevice = false;
        Iterator oResItor = this.m_oResourceList.iterator();
        Resource oTempRes = null;
        while (oResItor.hasNext()) {
            oTempRes = (Resource)oResItor.next();
            if (0 == (oTempRes.getUpgradeMode() & iUpgradeMode)) continue;
            isUpgradeModeSupportedByAnyOneOfDevice = true;
            break;
        }
        return isUpgradeModeSupportedByAnyOneOfDevice;
    }

    public List<Resource> getNonsupportedResListForDowngradeTask() {
        ArrayList<Resource> oResList = new ArrayList<Resource>(0);
        Iterator oResItor = this.m_oResourceList.iterator();
        Resource oTempRes = null;
        while (oResItor.hasNext()) {
            oTempRes = (Resource)oResItor.next();
            if (0 != (oTempRes.getUpgradeMode() & 0x4000) || oResList.contains(oTempRes)) continue;
            oResList.add(oTempRes);
        }
        return oResList;
    }

    public int getDeviceDomain() {
        return this.m_iDeviceDomain;
    }

    public void setDeviceDomain() {
        DeviceTypeInfo oTypeInfo;
        if (-1 != this.m_iDeviceTypeID && -1 != this.m_iDeviceTypeVersionID && null != (oTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(this.m_iDeviceTypeID, this.m_iDeviceTypeVersionID))) {
            this.m_iDeviceDomain = oTypeInfo.getDevDomain();
        }
    }

    public Resource getResource(int iDeviceID, int iFrameId, int iSlotId, int iStackId) {
        Resource oResource = null;
        Iterator oResItor = this.m_oResourceList.iterator();
        Resource oTempRes = null;
        while (oResItor.hasNext()) {
            oTempRes = (Resource)oResItor.next();
            if (oTempRes.getDeviceID() != iDeviceID || iFrameId != oTempRes.getFrameId() || oTempRes.getSlotId() != iSlotId || oTempRes.getStackId() != iStackId) continue;
            oResource = oTempRes;
            return oResource;
        }
        DCDebugTracer.trace("DC::getResource is null,iDeviceID:" + iDeviceID + "|iFrameId:" + iFrameId + "|iSlotId:" + iSlotId + "|iStackId:" + iStackId);
        return null;
    }

    public String toString() {
        return "DeviceType [m_strDeviceTypeName=" + this.m_strDeviceTypeName + ", m_strDeviceTypeVersionName=" + this.m_strDeviceTypeVersionName + "]";
    }

    public DeviceTypeInfo getDeviceTypeInfo() {
        DeviceTypeInfo oDeviceTypeInfo = DCFrameWorkUtil.getDeviceInfoManager().getDeviceTypeInfo(this.getDeviceTypeID(), this.getDeviceTypeVersionID());
        oDeviceTypeInfo.setDevTypeVersionName(this.m_strDeviceTypeVersionName);
        oDeviceTypeInfo.setDevTypeName(this.m_strDeviceTypeName);
        return oDeviceTypeInfo;
    }
}

